/*
 *
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/*****************************************************************************
 * FILE PURPOSE: Convert a CCS data case
 *****************************************************************************
 * FILE NAME: ccsCase.c
 *
 * DESCRIPTION: Converts a CCS data from to upper case or lower case
 *
 *      usage:  ccsCase [-h] [-upper | -lower] [-in ccsInFile] [-out ccsOutFile]
 *
 *****************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"

#define UPPER   0
#define LOWER   1

int   ccase   = LOWER;
char *inName  = NULL;
char *outName = NULL;

int parseit (int ac, char *av[])
{
    int i;

    for (i = 1; i < ac; )  {

        if (!strcmp (av[i], "-h"))  {
            fprintf (stderr, "usage: %s [-h] [-upper | -lower] [-in ccsInFile] [-out ccsOutFile]\n", av[0]);
            return (-1);
        }

        if (!strcmp (av[i], "-upper"))  {
            ccase = UPPER;
            i = i + 1;
            continue;
        }

        if (!strcmp (av[i], "-lower"))  {
            ccase = LOWER;
            i = i + 1;
            continue;
        }

        if (!strcmp (av[i], "-in"))   {
            inName = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-out"))  {
            outName = av[i+1];
            i = i + 2;
            continue;
        }

        fprintf (stderr, "%s: %s not expected on command line\n", av[0], av[i]);
        return (-1);

    }

    return (0);

}



int main (int argc, char *argv[])
{
    FILE *str;
    unsigned int *d, addr;
    int n;

    if (parseit (argc, argv))
        return (-1);

    if (inName != NULL)  {

        str = fopen (inName, "r");
        if (str == NULL)  {
            fprintf (stderr, "%s: Error - failed to open input file %s\n", argv[0], inName);
            return (-1);
        }

    }  else  {
    
        str = stdin;

    }

    d = readCcsFile (str, &n, &addr);

    if (d == NULL)  {
        fprintf (stderr, "%s: Error reading CCS input data file\n", argv[0]);

        if (inName != NULL)
            fclose (str);

        return (-1);

    }

    if (inName != NULL)
        fclose (str);


    if (outName != NULL)  {

        str = fopen (outName, "w");
        if (str == NULL)  {
            fprintf (stderr, "%s: Error - failed to open output file %s\n", argv[0], outName);
            free (d);
            return (-1);
        }

    }  else  {

        str = stdout;

    }
    

    if (ccase == LOWER)
        writeCcsFile (str, d, n, addr);
    else
        writeCcsFileUp (str, d, n, addr);

    free (d);

    if (outName != NULL)
        fclose (str);

    return (0);

}
    


