/*
 *
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/*****************************************************************************
 * FILE PURPOSE: Catenate two CCS format boot table files
 *****************************************************************************
 * DESCRIPTION: Two boot tables are catenated. The entry point of the
 *              second table is lost.
 *
 *          usage:  ccsCatBtbl file1 file2 [-outfile outfile]
 *****************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"


char *file1 = NULL;
char *file2 = NULL;
char *outfile = NULL;


int parseit (int ac, char *av[])
{
    int i;

    if (ac == 0)  {
        fprintf (stderr, "usage: %s file1 file2 [-outfile outfile]\n", av[0]);
        return (-1);
    }

    for (i = 1; i < ac;  )  {

        if (!strcmp (av[i], "-outfile"))  {
            outfile = av[i+1];
            i = i + 2;
            continue;
        }

        if (file1 == NULL)  {
            file1 = av[i];
            i = i + 1;
            continue;
        }

        if (file2 == NULL)  {
            file2 = av[i];
            i = i + 1;
            continue;
        }

        fprintf (stderr, "%s: Error parsing argument %s\n", av[0], av[i]);
        return (-1);

    }

    if ((file1 == NULL) || (file2 == NULL)) {
        fprintf (stderr, "%s: two input files must be specified\n", av[0]);
        return (-1);
    }

    return (0);

}



int main (int argc, char *argv[])
{
    FILE *str;
    unsigned int *d1, *d2, *d3, addr, junk;
    int n1, n2, n3, i, p;

    if (parseit (argc, argv))
        return (-1);


    str = fopen (file1, "r");
    if (str == NULL)  {
        fprintf (stderr, "%s: Error opening input file %s\n", argv[0], file1);
        return (-1);
    }

    d1 = readCcsFile (str, &n1, &addr);
    fclose (str);


    str = fopen (file2, "r");
    if (str == NULL)  {
        fprintf (stderr, "%s: Error opening input file %s\n", argv[0], file2);
        free (d1);
        return (-1);
    }

    d2 = readCcsFile (str, &n2, &junk);
    fclose (str);


    /* Remove the last length field from the first table, and the entry point from the second */
    n3 = n1 + n2 - 2;
    d3 = malloc (n3 * sizeof (unsigned int));
    if (d3 == NULL)   {
        fprintf (stderr, "%s: malloc failed on %d ints\n", argv[0], d3);
        free (d1);
        free (d2);
        return (-1);
    }

    for (i = p = 0; i < n1 - 1; i++, p++)
        d3[p] = d1[i];

    for (i = 1; i < n2; i++, p++)
        d3[p] = d2[i];

    free (d1);
    free (d2);

    if (outfile != NULL)  {

        str = fopen (outfile, "w");
        if (str == NULL)  {
            fprintf (stderr, "%s: Error opening output file %s\n", argv[0], outfile);
            free (d3);
            return (-1);
        }

    }  else  {

        str = stdout;

    }


    writeCcsFile (str, d3, n3, addr);

    if (outfile != NULL)
        fclose (str);

    free (d3);

    return (0);

}




