/*********************************************************************************
 * FILE PURPOSE: Create a boot table that describes a ccs block
 *********************************************************************************
 * FILE NAME: ccsDescBlock.c
 *
 * DESRIPTION: Creates the data needed for secure boot through secure host.
 *			   The secure host takes a size and start address. This 
 *			   utility reads the size and start address of a ccs formatted
 *			   data file and creates the entries for the secure host table
 *
 *
 *		usage: ccsDescBlock [-h] -addr secHostAddr [-infile infile] [-outfile outfile]
 *
 **********************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ccsutil.h"


unsigned int addr = 0xffffffff;
char *inname  = NULL;
char *outname = NULL;

unsigned int outData[8];  /* output size is actually 6 words, but add some pad */


unsigned int readInt (char *c)
{
    unsigned int v;

    if ((c[0] == '0') && (c[1] == 'x'))  
        sscanf (&c[2], "%x", &v);

    else
        sscanf (c, "%d", &v);

    return (v);

}

int usage (int ac, char *av[])
{
    fprintf (stderr, "usage: %s [-h] -addr secHostAddr [-infile infile] [-outfile outfile]\n", av[0]);
    return (-1);

}

int parseit (int ac, char *av[])
{
    int i; 

    for (i = 1; i < ac;  )  {

        if (!strcmp (av[i], "-h"))
            return (usage (ac, av));

        if (!strcmp (av[i], "-addr"))  {
            addr = readInt (av[i+1]);
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-infile"))  {
            inname = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile"))  {
            outname = av[i+1];
            i = i + 2;
            continue;
        }

        fprintf (stderr, "%s: unknown argument: %s", av[0], av[i]);
        return (-1);

    }

    if (addr == 0xffffffff)
        return (usage (ac, av));

    return (0);

}
            
            



int main (int argc, char *argv[])
{
    unsigned int nwords;
    unsigned int daddr;
    unsigned int *data;
    
    if (parseit (argc, argv))
        return (-1);


    if (inname == NULL)
        data = readCcsFile (stdin, &nwords, &daddr);
    else
        data = openReadCloseCcsFile (inname, &nwords, &daddr);


    if (data == NULL)  {
        fprintf (stderr, "%s: Error reading input data\n", argv[0]);
        return (-1);
    }

    free (data);  /* the data is not actually used */

    /* Format the output file */
    outData[0] = 0;          /* Program entry point */
    outData[1] = 8;          /* Section size, in bytes */
    outData[2] = addr;       /* Section address */
    outData[3] = daddr;      /* Data address (of the data blob) */
    outData[4] = nwords * 4; /* Data size in bytes */
    outData[5] = 0;          /* Termination entry */


    if (outname == NULL)
        writeCcsFile (stdout, outData, 6, 0);
    else
        openWriteCloseCcsFile (outname, outData, 6, 0);

    return (0);

}
        
        




