/* Take an arbitrary input hex string and create a CCS data file from it.
 *
 *   usage:  ccsFileFromString [-le] <-infile infile>|<string> [-outfile outfile]
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ccsutil.h"


char          *string     = NULL;
unsigned int  *data;
int            dataLen32;
char          *outf       = NULL;
int            le         = 0;
char           iline[132];


int parseit (int ac, char *av[])
{
    int  i;
    FILE *str;
    char *nl;
    unsigned int addr;

    if (ac == 1)  {
        fprintf (stderr, "usage: %s [-le] <-infile infile>|<string> [-outfile outfile]\n", av[0]);
        return (-1);
    }

    for (i = 1; i < ac;  )   {
        
        if (!strcmp (av[i], "-le"))  {
            le = 1;
            i = i + 1;
            continue;
        }

        if (!strcmp (av[i], "-infile"))  {

            str = fopen (av[i+1], "r");
            if (str == NULL)  {
                fprintf (stderr, "%s: Could not open input file %s\n", av[0], av[i+1]);
                return (-1);
            }

            fgets (iline, 132, str);
            fclose (str);

            nl = strchr (iline, 13);
            if (nl != NULL)
                *nl = '\0';

            nl = strchr (iline, 10);
            if (nl != NULL)
                *nl = '\0';

            string = iline;

            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile"))  {
            outf = av[i+1];
            i = i + 2;
            continue;
        }

        if (string == NULL)  {
            string = av[i];
            i = i + 1;
            continue;
        }

        fprintf (stderr, "%s: Uknown argument %s\n", av[i]);
        return (-1);

    }

    if (string == NULL)  {
        fprintf (stderr, "%s: Input string not specified\n", av[0]);
        return (-1);
    }

    return (0);

}

        




int main (int argc, char *argv[])
{
    char tmp[9];
    int i, j, k, l;
    FILE *str;

    if (parseit (argc, argv))
        return (-1);


    dataLen32 = (strlen(string) +7) / 8;

    data = malloc (dataLen32 * sizeof (unsigned int));
    if (data == NULL)  {
        fprintf (stderr, "%s: malloc failed on %d unsigned ints\n", argv[0], dataLen32);
        return (-1);
    }

    for (i = j = 0; i < dataLen32; i++, j+=8)  {

        for (k = 0; k < 8; k++)
            tmp[k] = string[k+j];
        tmp[8] = '\0';

        sscanf (tmp, "%x", &data[i]);

    }

    if (outf != NULL)  {

        str = fopen (outf, "w");
        if (str == NULL)  {
            fprintf (stderr, "%s: Failed to open %s for writing\n", argv[0], outf);
            free (data);
            return (-1);
        }

    }  else  {
        str = stdout;
    }

    if (le != 0)
        ccsEndianSwap (data, dataLen32);

    writeCcsFile (str, data, dataLen32, 0x10000);

    if (outf != NULL)
        fclose (str);

    free (data);

    return (0);

}
    


    

