/******************************************************************************************
 * FILE PURPOSE: Convert a gp header format data file into a boot table data file
 ******************************************************************************************
 * FILE NAME: ccsGpToBtbl.c
 *
 * DESCRIPTION: The gp header format file is converted to a boot table data file by
 *				simply adding the entry point at the top of the file
 *
 *  usage: ccsGpToBtbl [-entry entryAddr] infile outfile
 *
 ******************************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ccsutil.h"

char *infile  = NULL;
char *outfile = NULL;
unsigned int entry = 0xffffffff;

unsigned int parseInt (char *s)
{
    unsigned int v;

    if ((s[0] == '0') && (s[1] == 'x'))
        sscanf (&s[2], "%x", &v);
    else
        sscanf (s, "%d", &v);


    return (v);

}

int parseit (int ac, char *av[])
{
    int i;

    if (ac < 3)  {
        fprintf (stderr, "usage: %s [-entry entryAddr] infile outfile\n", av[0]);
        return (-1);
    }

    for (i = 1; i < ac;  )   {

        if (!strcmp (av[i], "-entry"))  {
            entry = parseInt (av[i+1]);
            i = i + 2;
            continue;
        }

        if (infile == NULL)  {
            infile = av[i];
            i = i + 1;
            continue;
        }

        if (outfile == NULL)  {
            outfile = av[i];
            i = i + 1;
            continue;
        }

        fprintf (stderr, "%s: uknown command line argument %s\n", av[0], av[i]);
        return (-1);
    }

    return (0);

}
        




int main (int argc, char *argv[])
{

    unsigned int *data, *datab;
    unsigned int addr;
    int size;

    if (parseit (argc, argv))
        return (-1);
    

    data = openReadCloseCcsFile (infile, &size, &addr);

    if (data == NULL)  {
        fprintf (stderr, "%s: Failed to open input file %s\n", argv[0], infile);
        return (-1);
    }

    if (entry == 0xffffffff)
        entry = addr;

    /* Just need to add the entry point as the first entry */
    datab = malloc ((size+1) * sizeof(unsigned int));
    if (datab == NULL)  {
        fprintf (stderr, "%s: Failed on malloc of %d ints\n", argv[0], size+1);
        return (-1);
    }


    memcpy (&datab[1], data, size * sizeof(unsigned int));
    datab[0] = entry;

    openWriteCloseCcsFile (outfile, datab, size+1, addr);

    free (datab);
    free (data);

    return (0);

}
    



    










