/*****************************************************************************************
 * FILE PURPOSE: Swap the size words in a secure master table
 *****************************************************************************************
 * FILE NAME: ccsMastertblToBlockedSec.c
 *
 * DESCRIPTION: The master table format uses a 32 bit length field. To convert to 
 *			    boot table blocked the 2 16 bit words in the header are just swapped.
 *			    The checksum is not added here.
 *
 *      usage: ccsMastertblToBlockedSec [-h] [-infile inname] [-outfile outname]
 *
 *****************************************************************************************/
#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"


char *inName  = NULL;
char *outName = NULL;

int usage (int ac, char *av[])
{
    fprintf (stderr, "usage: %s [-h] [-infile inname] [-outfile outname]\n", av[0]);
    return (-1);

}

int parseit (int ac, char *av[])
{
    int i;

    for (i = 1; i < ac; )  {

        if (!strcmp (av[i], "-h"))
            return (usage (ac, av));

        if (!strcmp (av[i], "-infile"))  {
            inName = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile")) {
            outName = av[i+1];
            i = i + 2;
            continue;
        }

        fprintf (stderr, "%s: unkown option %s\n", av[0], av[i]);
        return (-1);

    }

    return (0);

}



int main (int argc, char *argv[])
{
    unsigned int *data;
    unsigned int  dsize;
    unsigned int  addr;
    unsigned int  v, w, idx;

    if (parseit (argc, argv))
        return (-1);

    if (inName == NULL)
        data = readCcsFile (stdin, &dsize, &addr);
    else
        data = openReadCloseCcsFile (inName, &dsize, &addr);

    if (data == NULL)  {
        fprintf (stderr, "%s: error reading input file\n", argv[0]);
        return (-1);
    }

    
    for (idx = 0; idx < dsize;  )  {

        /* Move the lower 16 bits to the upper 16 bits */
        v = data[idx];
        w = v << 16;
        data[idx] = w;

        /* move to the next idx */
        idx = idx + (v >> 2);

    }

    if (outName == NULL)
        writeCcsFile (stdout, data, dsize, addr);
    else
        openWriteCloseCcsFile (outName, data, dsize, addr);

    free (data);

    return (0);

}
    
    
        










