/* Swap 2 bytes in 16 in a ccs data file
 *
 *  usage ccsSwapBytesIn16 [-infile infile] [-outfile outfile]
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "ccsutil.h"

char *infile  = NULL;
char *outfile = NULL;


unsigned int swap16 (unsigned int v)
{
    v = (((v >> 24) & 0xff) << 16)  |
        (((v >> 16) & 0xff) << 24)  |
        (((v >>  8) & 0xff) <<  0)  |
        (((v >>  0) & 0xff) <<  8)  ;

    return (v);

}


int parseit (int ac, char *av[])
{
    int i;

    for (i = 1; i < ac;  )  {

        if (!strcmp (av[i], "-infile"))  {
            infile = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile"))  {
            outfile = av[i+1];
            i = i + 2;
            continue;
        }

        fprintf (stderr, "usage: %s [-infile infile] [-outfile outfile]\n");
        return (-1);
    }

    return (0);

}
    


int main (int argc, char *argv[])
{

    int i;
    unsigned int *data, addr;
    int dlen;

    if (parseit (argc, argv))
        return (-1);


    if (infile == NULL)
        data = readCcsFile (stdin, &dlen, &addr);
    else
        data = openReadCloseCcsFile (infile, &dlen, &addr);

    if (data == NULL)  {
        fprintf (stderr, "%s: Data read error\n", argv[0]);
        return (-1);
    }


    for (i = 0; i < dlen; i++) 
       data[i] = swap16(data[i]);


    if (outfile == NULL)
        writeCcsFile (stdout, data, dlen, addr);
    else
        openWriteCloseCcsFile (outfile, data, dlen, addr);

    free (data);

    return (0);

}

    
        





