/* Convert a ccs file into a text string. Used for interfacing to the openssl command line functions 
 *
 *  usage:  ccsToString [ccsfile] [-le | -be]
 *
 *  output is to stdout
 */


#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ccsutil.h"

int endian  = 1;     /* little endian by default */
char *fname = NULL;


int parseit (int ac, char *av[])
{
    int i;

    if (ac == 0)  {
        fprintf (stderr, "usage: %s [ccsfile] [-le | -be]\n", av[0]);
        return (-1);
    }

    for (i = 1; i < ac;  )  {
    
        if (!strcmp (av[i], "-le"))  {
            endian = 1;
            i = i + 1;
            continue;
        }

        if (!strcmp (av[i], "-be"))  {
            endian = 0;
            i = i + 1;
            continue;

        }

        if (fname != NULL)  {
            fprintf (stderr, "%s: unknown argument %s\n", av[0], av[i]);
            return (-1);
        }

        fname = av[i];
        i = i + 1;

    }

    return (0);

}
        

int main (int argc, char *argv[])
{
    unsigned int *data, addr;
    int dataLenWords;
    int i;

    if (parseit (argc, argv))
        return (-1);


    if (fname != NULL)
        data = openReadCloseCcsFile (fname, &dataLenWords, &addr);
    else
        data = readCcsFile (stdin, &dataLenWords, &addr);

    if (data == NULL)  {
        fprintf (stderr, "%s: Failed to read input data\n", argv[0]);
        return (-1);
    }

    for (i = 0; i < dataLenWords; i++)  {

        if (endian == 0)  {

            fprintf (stdout, "%02x", (data[i] >> 24) & 0xff);
            fprintf (stdout, "%02x", (data[i] >> 16) & 0xff);
            fprintf (stdout, "%02x", (data[i] >>  8) & 0xff);
            fprintf (stdout, "%02x", (data[i] >>  0) & 0xff);

        }  else  {

            fprintf (stdout, "%02x", (data[i] >>  0) & 0xff);
            fprintf (stdout, "%02x", (data[i] >>  8) & 0xff);
            fprintf (stdout, "%02x", (data[i] >> 16) & 0xff);
            fprintf (stdout, "%02x", (data[i] >> 24) & 0xff);
        }

    }

    free (data);

    return (0);

}





