/* Pre Pad a ccs data file to a certain length. The length is in number of lines
 *
 *  usage: ccs_pre_pad infile outfile pattern length 
 */

#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"

unsigned int readArg (char *a)
{
    unsigned int v;

    if ((a[0] == '0') && (a[1] == 'x'))
        sscanf (&a[2], "%x", &v);
    else
        sscanf (a, "%d", &v);

    return (v);

}


int main (int argc, char *argv[])
{
    unsigned int *data1, *data2;
    unsigned int  len1,   len2;
    unsigned int  pattern;
    unsigned int  i, j, addr;


    if (argc != 5)  {
        fprintf (stderr, "usage: %s infile outfile pattern length\n", argv[0]);
        return (-1);
    }


    pattern = readArg (argv[3]);
    len2    = readArg (argv[4]);


    data1 = openReadCloseCcsFile (argv[1], &len1, &addr);
    if (data1 == NULL)  {
        fprintf (stderr, "%s: Failed to open and read input file\n", argv[0]);
        return (-1);
    }

    data2 = malloc ((len2+len1) * sizeof (unsigned int));
    if (data2 == NULL)  {
        fprintf (stderr, "%s: Malloc failed on %d unsigned ints\n", argv[0], len2);
        free (data1);
        return (-1);
    }

    for (i = 0  ; i < len2; i++)
        data2[i] = pattern;

    for (j=0; j < len1; j++)
        data2[i+j] = data1[j];

    free (data1);

    openWriteCloseCcsFile (argv[2], data2, len2+len1, addr);

    free (data2);

    return (0);

}
    


