/*  I2C Block a ccs data file
 *
 *  usage:  ccsi2cblock blockSizeBytes [-infile infile] [-outfile outfile]
 *
 *  The i2c header is 4 bytes, 2 bytes are length, 2 bytes of ones complement checksum
 *
 *  The blockSizeBytes must be a multiple of 4
 *
 */
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "ccsutil.h"


char *infile  = NULL;
char *outfile = NULL;
int   blockSizeBytes = 0;

unsigned int *inData  = NULL;
unsigned int *outData = NULL;


unsigned int onesComplementAdd (unsigned int value1, unsigned int value2)
{
  unsigned int result;

  result = (unsigned int)value1 + (unsigned int)value2;

  result = (result >> 16) + (result & 0xFFFF); /* add in carry   */
  result += (result >> 16);                    /* maybe one more */
  result = (result & 0xffff);
  return (unsigned int)result;

}


void addChkSum (unsigned int *block)
{
    unsigned int chksum;

    int lb, lw;
    int i;

    lb = block[0] >> 16;
    lw = lb / 4;

    chksum = 0;

    for (i = 0; i < lw; i++)  {
        chksum = onesComplementAdd (chksum, (block[i] >> 16) & 0xffff); 
        chksum = onesComplementAdd (chksum, (block[i] >>  0) & 0xffff); 
    }

    block[0] = block[0] | (~chksum & 0xffff);

}


void cleanUp (void)
{
    if (inData != NULL)
        free (inData);

    if (outData != NULL)
        free (outData);

}


unsigned int readArg (char *c)
{
    unsigned int v;

    if ((c[0] == '0') && (c[1] == 'x'))
        sscanf (&c[2], "%x", &v);
    else
        sscanf (c, "%d", &v);

    return (v);

}

int parseit (int ac, char *av[])
{
    int i;

    for (i = 1; i < ac;  )  {

        if (!strcmp (av[i], "-infile")) {
            infile = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile"))  {
            outfile = av[i+1];
            i = i + 2;
            continue;
        }

        blockSizeBytes = readArg (av[i]);
        i = i + 1;
    }


    if (blockSizeBytes == 0)  {
        fprintf (stderr, "usage: %s blockSizeBytes [-infile infile] [-outfile outfile]\n", av[0]);
        return (-1);
    }

    if ((blockSizeBytes & 0x3) != 0)  {
        fprintf (stderr, "%s: blocSizeBytes must be a multiple of 4 bytes\n", av[0]);
        return (-1);
    }

    return (0);

}
        


int main (int argc, char *argv[])
{

    int inLengthWords;
    int outLengthWords;
    int nblocks;
    int sp, dp, bp;
    int i, j;
    unsigned int addr;


    if (parseit (argc, argv))
        return (-1);


    /* Read the input data */
    if (infile == NULL)  
        inData = readCcsFile (stdin, &inLengthWords, &addr);
    else
        inData = openReadCloseCcsFile (infile, &inLengthWords, &addr);

    if (inData == NULL)  {
        fprintf (stderr, "%s: Failed to read input data\n", argv[0]);
        cleanUp ();
        return (-1);
    }

    /* Determine the size of the output file */
    nblocks        = ((inLengthWords * 4) + blockSizeBytes - 4 - 1) / (blockSizeBytes - 4);
    outLengthWords = nblocks * blockSizeBytes / 4; 

    outData = malloc (outLengthWords * sizeof (unsigned int));

    for (i = sp = dp = 0; i < nblocks; i++)  {

        bp = dp;
        outData[dp++] = blockSizeBytes << 16;

        for (j = 1; j < blockSizeBytes/4; j++)
            outData[dp++] = inData[sp++];

        addChkSum (&outData[bp]);

    }


    if (outfile == NULL)
        writeCcsFile (stdout, outData, outLengthWords, addr);
    else
        openWriteCloseCcsFile (outfile, outData, outLengthWords, addr);

    cleanUp ();

    return (0);

}


    

        





