/* Convert a ccs data format file into a header style C array, without
 * the identifier:
 *   {  value0, value1, ... value n }
 *
 *  usage: ccstoh [-h] [-varName varName] [-const] [-infile infile] [-outfile outfile]
 */

#include <stdio.h>
#include <string.h>
#include "ccsutil.h"

char *inName  = NULL;
char *outName = NULL;
char *varName = NULL;

unsigned int *data = NULL;
FILE         *str  = NULL;
int           nwords;
int           iconst = 0;

void cleanUp (void)
{
    if (data != NULL)
        free (data);

    if (str != NULL)
        fclose (str);

}

int parseit (int ac, char *av[])
{
    int i;

    for (i = 1; i < ac;  )  {

        if (!strcmp (av[i], "-h"))  {
            fprintf (stderr, "usage: %s [-h] [-varName varName] [-infile infile] [-outfile outfile]\n", av[0]);
            return (-1);
        }

        if (!strcmp (av[i], "-varName"))  {
            varName = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-infile"))  {
            inName = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-outfile"))  {
            outName = av[i+1];
            i = i + 2;
            continue;
        }

        if (!strcmp (av[i], "-const"))  {
            iconst = 1;
            i = i + 1;
            continue;
        }

        fprintf (stderr, "%s: Unknown argument- %s\n", av[0], av[i]);
        return (-1);

    }

    return (0);

}


           
    


int main (int argc, char *argv[])
{
    int           i;
    unsigned int addr;

    if (parseit (argc, argv))
        return (-1);

    if (inName == NULL)
        data = readCcsFile (stdin, &nwords, &addr);
    else
        data = openReadCloseCcsFile (inName, &nwords, &addr);

    if (data == NULL)  {
        fprintf (stderr, "%s: Error reading input data\n", argv[0]);
        cleanUp();
        return (-1);
    }

    if (outName != NULL)  {
        str = fopen (outName, "w");
        if (str == NULL)  {
            fprintf (stderr, "%s: Error opening output file %s\n", argv[0], outName);
            cleanUp ();
            return (-1);
        }
    }  else  {
        str = stdout;
    }

    if (varName == NULL)
        varName = "ccsData";

    if (iconst == 0)
        fprintf (str, "unsigned int %s[] = { \n", varName);
    else
        fprintf (str, "const unsigned int %s[] = { \n", varName);

    for (i = 0; i < nwords - 1; i++)
        fprintf (str, "    0x%08x,\n", data[i]);

    fprintf (str, "    0x%08x };\n", data[i]);

    cleanUp ();

    return (0);

}
