/************************************************************************************
 * Secsplit.c
 *
 *  Splits up a single sectable file (created with secmastermcv into individual
 *  files. This is used so the mac header utility can be used for qt tests
 *
 *  usage: secsplit [-in infile] [-out outprefix] [-swap16]
 *
 *  The input file is a ccs format data file. The data is blocked, with the 1st 32
 *  bit value indicating the length of the block, including the block header
 *
 ************************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"


char *inname  = NULL;
char *outname = "pkt";
int   swap16  = 0;


int parseit (int ac, char *av[])
{
	int i;

	for (i = 1; i < ac;  )  {

		if (!strcmp (av[i], "-in"))  {
			inname = av[i+1];
			i += 2;
			continue;
		}

		if (!strcmp (av[i], "-out"))  {
			outname = av[i+1];
			i = i + 2;
			continue;
		}

        if (!strcmp (av[i], "-swap16"))  {
            swap16 = 1;
            i = i + 1;
            continue;
        }

		fprintf (stderr, "%s: unrecognized options %s\n", av[0], av[i]);
		return (-1);

	}

    return (0);

}

void doSwap16 (unsigned int *data, int nwords)
{
    int i;

    for (i = 0; i < nwords; i++)
        data[i] =  ((data[i] >> 16) & 0xffff) << 0  |
                   ((data[i] >>  0) & 0xffff) << 16 ;

}



int main (int argc, char *argv[])
{
	int i;
	int idx;
	char outst[132];

    unsigned int *inData, addr;
	int   inLen;

	unsigned int   segLen;

	if (parseit (argc, argv))
		return (-1);


	if (inname == NULL)  
		inData = readCcsFile (stdin, &inLen, &addr);
	else
		inData = openReadCloseCcsFile (inname, &inLen, &addr);

	if (inData == NULL)  {
		fprintf (stderr, "%s: Error reading input data\n", argv[0]);
		return (-1);
	}

	idx = 0;
	i   = 0;

    do  {

		segLen = inData[idx];

		sprintf (outst, "%s%02d.ccs", outname, i);

        if (swap16)
            doSwap16 (&inData[idx+1], (segLen-1)/4);

		openWriteCloseCcsFile (outst, &inData[idx+1], (segLen - 1) / 4, addr);

		idx = idx + (segLen / 4);
        i = i + 1;

	} while (idx < inLen);

	free (inData);

	return (0);

}
		



		




