/***************************************************************************************
 * FILE PURPOSE: Swap the data in a boot table data file
 ***************************************************************************************
 * FILE NAME: swapBtblDat.c
 *
 * DESCRIPTION: The data in a boot table file is swapped. The headers are left unswapped
 *
 *      usage: swapBtblDat infile outfile
 *
 ***************************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"


char *inname  = NULL;
char *outname = NULL;


int parseit (int ac, char *av[])
{
    if (ac != 3)  {

        fprintf (stderr, "usage: %s infile outfile\n", av[0]);
        return (-1);

    }


    inname  = av[1];
    outname = av[2];

    return (0);

}


int main (int argc, char *argv[])
{
    unsigned int *data;
    unsigned int n, addr;
    unsigned int p, v, w, i;
    unsigned int secSizeWords;

    if (parseit (argc, argv))
        return (-1);


    data = openReadCloseCcsFile (inname, &n, &addr);


    /* Run through each section and swap the data */
    for (p = 1; data[p] != 0; p = p + secSizeWords + 2)  {

        secSizeWords = (data[p] + 3) >> 2;

        for (i = 0; i < secSizeWords; i++)  {

            v = data[p + 2 + i];

            w = (((v >> 24) & 0xff) <<  0)  |
                (((v >> 16) & 0xff) <<  8)  |
                (((v >>  8) & 0xff) << 16)  |
                (((v >>  0) & 0xff) << 24)  ;

            data[p+2+i] = w;

        }

    }


    /* Write out the data file */
    openWriteCloseCcsFile (outname, data, n, addr);

    free (data);

    return (0);

}

    


    



