/***************************************************************************************
 * FILE PURPOSE: Swap the magic address in a boot table data file
 ***************************************************************************************
 * FILE NAME: swapBtblMagic.c
 *
 * DESCRIPTION: The magic address in a boot table file is byte swapped. 
 *
 *      usage: swapBtblMagic infile outfile
 *
 ***************************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include "ccsutil.h"


char *inname  = NULL;
char *outname = NULL;


int parseit (int ac, char *av[])
{
    if (ac != 3)  {

        fprintf (stderr, "usage: %s infile outfile\n", av[0]);
        return (-1);

    }


    inname  = av[1];
    outname = av[2];

    return (0);

}


int main (int argc, char *argv[])
{
    unsigned int *data;
    unsigned int n, addr;
    unsigned int v, w;

    if (parseit (argc, argv))
        return (-1);


    data = openReadCloseCcsFile (inname, &n, &addr);

    v = data[0];

    w = (((v >> 24) & 0xff) <<  0)  |
        (((v >> 16) & 0xff) <<  8)  |
        (((v >>  8) & 0xff) << 16)  |
        (((v >>  0) & 0xff) << 24)  ;

    data[0] = w;


    /* Write out the data file */
    openWriteCloseCcsFile (outname, data, n, addr);

    free (data);

    return (0);

}

    


    



