#include <stdio.h>
#include <string.h>
#include <stdint.h>
#include "tiboot.h"
#include "platform.h"

#pragma  DATA_SECTION (emif4Cfg, ".emif4Cfg")
const BOOT_EMIF4_TBL_T  emif4Cfg =  {

    BOOT_EMIF4_ENABLE_MSW_pllCtl          | \
    BOOT_EMIF4_ENABLE_MSW_sdRamTiming1    | \
    BOOT_EMIF4_ENABLE_MSW_sdRamTiming2    | \
    BOOT_EMIF4_ENABLE_MSW_sdRamTiming3    | \
    BOOT_EMIF4_ENABLE_MSW_ddrPhyCtl1      | \
    BOOT_EMIF4_ENABLE_MSW_sdRamRefreshCtl | \
	BOOT_EMIF4_ENABLE_MSW_sdRamOutImpdedCalCfg | \
	BOOT_EMIF4_ENABLE_MSW_sdRamConfig,

    BOOT_EMIF_ENABLE_SLSW_config0 | \
	BOOT_EMIF_ENABLE_SLSW_config6 | \
	BOOT_EMIF_ENABLE_SLSW_config7 | \
	BOOT_EMIF_ENABLE_SLSW_config8 | \
	BOOT_EMIF_ENABLE_SLSW_config9 | \
	BOOT_EMIF_ENABLE_SLSW_config10 | \
	BOOT_EMIF_ENABLE_SLSW_config18 | \
	BOOT_EMIF_ENABLE_SLSW_config19 | \
	BOOT_EMIF_ENABLE_SLSW_config20 | \
	BOOT_EMIF_ENABLE_SLSW_config22 | \
	BOOT_EMIF_ENABLE_SLSW_config12 | \
	BOOT_EMIF_ENABLE_SLSW_config23 | \
	BOOT_EMIF_ENABLE_SLSW_config21,      /* Config select slsw */
    0,      /* Config select lsw  */
    
    3,      /* pllPrediv  */
    40,     /* pllMult    */
    2,      /* pllPostDiv */

    0x62477AB2,  /* sdRamConfig */
    0,           /* sdRamConfig2, dont care*/
    0x0000144F,  /* sdRamRefreshCtl  */
    0x1333780C,  /* sdRamTiming1 */
    0x30717FE3,  /* sdRamTiming2 */
    0x559F86AF,  /* sdRamTiming3 */

    0,           /* lpDdrNvmTiming, dont care */
    0,           /* powerManageCtl, dont care */
    0,           /* iODFTTestLogic, dont care */
    0,           /* performCountCfg, dont care */
    0,           /* performCountMstRegSel, dont care */
    0,           /* readIdleCtl, dont care */
    0,           /* sysVbusmIntEnSet, dont care */
    0x70074c1f,  /* sdRamOutImpdedCalCfg, dont care */
    0,           /* tempAlterCfg, dont care */

    0x0010010F,  /* ddrPhyCtl1 */

    0,           /* ddrPhyCtl2, dont care */
    0,           /* priClassSvceMap, dont care */
    0,           /* mstId2ClsSvce1Map, dont care */
    0,           /* mstId2ClsSvce2Map, dont care */
    0,           /* eccCtl, dont care */
    0,           /* eccRange1, dont care */
    0,           /* eccRange2, dont care */
    0,           /* rdWrtExcThresh, dont care */

    0x87A0047F, 0, 0, 0, 0, 0, 0x33, 0x3A,
    0x2C, 0x2C, 0x21, 0, 0xAF00002, 0, 0, 0,
    0, 0, 0xB7, 0xB1, 0xA4, 0xA4, 0x98, 0x200,
    0, 0, 0, 0, 0, 0, 0, 0,
    
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
};
	
void main(void)
{
	asm("	IDLE");
}
	
