/*******************************************************************************
 * Copyright 2004-2005 - Software Design Solutions, Inc.  All rights reserved.
 *
 * Portions of this work have been provided under license with Texas 
 * Instruments Inc.
 * 
 * $RCSfile: BlinkDSK6713.c,v $
 * $Revision: 1.2 $
 * 
 * Description: Blink example for FlashBurn Application Demo
 *
 * Assumptions:
 *     6713 DSK
 *     CPLD connected to CE1
 *     AMD29LV400BT flash connected to CE1
 *     SDRAM connected to CE0
 ******************************************************************************/
#include "c6713dsk.h"
#include "cpld.h"
#include "timer.h"
#include "emif.h"


/**
 *  Main function, initializes and loops, blinking the LEDs
 */
void main( void )
{   
    int i;
    
    CSL_init();
        
    /* DSP initialization */
    IRQ_globalDisable();
    for(i = 0; i < 32; i++)
    {
        IRQ_disable(i);   /* Disable and clear all IRQ events    */
        IRQ_clear(i);     /* except reset and NMI interrupts     */
    }

    PLL_Init();
    EMIF_Init();
    TIMER_Init();
    
    CPLD_LedOff( LED_ALL );
    TIMER_DelayMsec( 100 );
    CPLD_LedOn( LED_ALL );
    TIMER_DelayMsec( 500 );
    
    /* Very simple Led test.  Turn them all off then on */
    /* one at a time, then off one at a time. */
    CPLD_LedOff( LED_ALL );
    
    for( ; ; )
    {
        for(i = 0; i < LED_AVAILABLE; i++)
        {
            CPLD_LedOn( LED_0 << i );
            TIMER_DelayMsec( 100 );
        }
            
        for(i = 0; i < LED_AVAILABLE; i++)
        {
            CPLD_LedOff( LED_0 << i );
            TIMER_DelayMsec( 100 );             
        }
        
        TIMER_DelayMsec( 500 );         
    }
}
