/*
 * K2G EVM: Pinmux configuration
 *
 * (C) Copyright 2015
 *     Texas Instruments Incorporated, <www.ti.com>
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */

#include "board.h"
#include <asm/arch/hardware.h>
#include <asm/arch/mux-k2g.h>
#include <asm/io.h>
#include <common.h>

struct pin_cfg k2g_pin_cfg[] = {
    /* MCASP0 */
    {173, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO14.MCASP0_ACLKX */
    {174, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO15.MCASP0_AFSX */
    {170, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO11.MCASP0_ACLKR */
    {171, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO12.MCASP0_AFSR */
    {176, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO17.MCASP0_AXR0 */
    {177, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO18.MCASP0_AXR1 */
    {178, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO19.MCASP0_AXR2 */
    {179, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_MDIO_DATA.MCASP0_AXR3 */
    {180, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_MDIO_MDCLK.MCASP0_AXR4 */
    {181, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO0.MCASP0_AXR5 */
    {182, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO1.MCASP0_AXR6 */
    {183, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO2.MCASP0_AXR7 */
    {184, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO3.MCASP0_AXR8 */
    {185, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO4.MCASP0_AXR9 */
    {186, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO5.MCASP0_AXR10 */
    {187, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO6.MCASP0_AXR11 */
    {188, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO7.MCASP0_AXR12 */
    {189, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO8.MCASP0_AXR13 */
    {190, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO9.MCASP0_AXR14 */
    {191, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_PRU0_GPO10.MCASP0_AXR15 */
    {169, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO10.MCASP0_AMUTE */

    /* MCASP1 */
    {155, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU0_GPO16.MCASP1_ACLKX */
    {156, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU0_GPO17.MCASP1_AFSX */
    {152, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU0_GPO13.MCASP1_ACLKR */
    {153, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU0_GPO14.MCASP1_AFSR */
    {159, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO0.MCASP1_AXR0 */
    {160, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO1.MCASP1_AXR1 */
    {161, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO2.MCASP1_AXR2 */
    {162, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO3.MCASP1_AXR3 */
    {163, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO4.MCASP1_AXR4 */
    {164, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO5.MCASP1_AXR5 */
    {165, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO6.MCASP1_AXR6 */
    {166, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO7.MCASP1_AXR7 */
    {167, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO8.MCASP1_AXR8 */
    {168, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU1_GPO9.MCASP1_AXR9 */
    {158, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR0_PRU0_GPO19.MCASP1_AMUTE */

    /* GPIO1 */
    {199, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU0_GPO18.GPIO1_24 */
    {200, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU0_GPO19.GPIO1_25 */
    {201, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO0.GPIO1_26 */
    {202, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO1.GPIO1_27 */
    {203, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO2.GPIO1_28 */
    {205, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO4.GPIO1_30 */
    {206, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO5.GPIO1_31 */
    {208, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO7.GPIO1_33 */
    {209, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO8.GPIO1_34 */
    {210, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO9.GPIO1_35 */
    {211, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO10.GPIO1_36 */
    {213, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO12.GPIO1_38 */
    {214, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO13.GPIO1_39 */
    {216, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR1_PRU1_GPO15.GPIO1_41 */
    {121,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* UART1_CTSn.GPIO1_50 */
    {122,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* UART1_RTSn.GPIO1_51 */
    {125,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* UART2_CTSn.GPIO1_54 */
    {126,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* UART2_RTSn.GPIO1_55 */

    /* GPIO0 */
    {10,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD10.GPIO0_10 */
    {11,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD11.GPIO0_11 */
    {12,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD12.GPIO0_12 */
    {24, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_WPn.GPIO0_24 */
    {26,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_CSn0.GPIO0_26 */
    {29,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_CSn3.GPIO0_29 */
    {30,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA23.GPIO0_30 */
    {31,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA22.GPIO0_31 */
    {32,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA21.GPIO0_32 */
    {33,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA20.GPIO0_33 */
    {34,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA19.GPIO0_34 */
    {35,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA18.GPIO0_35 */
    {36,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA17.GPIO0_36 */
    {37,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA16.GPIO0_37 */
    {38,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA15.GPIO0_38 */
    {39,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA14.GPIO0_39 */
    {40,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA13.GPIO0_40 */
    {41,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA12.GPIO0_41 */
    {42,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA11.GPIO0_42 */
    {43,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA10.GPIO0_43 */
    {44,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA9.GPIO0_44 */
    {45,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA8.GPIO0_45 */
    {46,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA7.GPIO0_46 */
    {47,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)},    /* DSS_DATA6.GPIO0_47 */
    {48, BUFFER_CLASS_B | PIN_PTU | PIN_IEN | MODE(3)}, /* DSS_DATA5.GPIO0_48 */
    {49, BUFFER_CLASS_B | PIN_PTU | PIN_IEN | MODE(3)}, /* DSS_DATA4.GPIO0_49 */
    {50,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA3.GPIO0_50 */
    {51,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DATA2.GPIO0_51 */
    {54,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_VSYNC.GPIO0_54 */
    {55,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_HSYNC.GPIO0_55 */
    {57, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_DE.GPIO0_57 */
    {58, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* DSS_FID.GPIO0_58 */
    {62,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* MMC1_DAT4.GPIO0_62 */
    {73,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* eHRPWM3_A.GPIO0_73 */
    {74,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* eHRPWM3_B.GPIO0_74 */
    {75, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
             MODE(3)}, /* eHRPWM3_SYNCI.GPIO0_75 */
    {76, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
             MODE(3)}, /* eHRPWM3_SYNCO.GPIO0_76 */
    {83, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* MII_COL.GPIO0_83 */
    {96, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* MII_TXER.GPIO0_96 */
    {139, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO0.GPIO0_108 */
    {140, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO1.GPIO0_109 */
    {141, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO2.GPIO0_110 */
    {142, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO3.GPIO0_111 */
    {143, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO4.GPIO0_112 */
    {145, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO6.GPIO0_114 */
    {146, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO7.GPIO0_115 */
    {148, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO9.GPIO0_117 */
    {149, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO10.GPIO0_118 */
    {151, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(3)}, /* PR0_PRU0_GPO12.GPIO0_120 */
    {0, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD0.GPIO0_00 */
    {1, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD1.GPIO0_01 */
    {2, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD2.GPIO0_02 */
    {3, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD3.GPIO0_03 */
    {4, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD4.GPIO0_04 */
    {5, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD5.GPIO0_05 */
    {6, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD6.GPIO0_06 */
    {7, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD7.GPIO0_07 */
    {8, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD8.GPIO0_08 */
    {9, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(3)}, /* GPMC_AD9.GPIO0_09 */

    /* UART0 */
    {115,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART0_RXD.UART0_RXD */
    {116,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART0_TXD.UART0_TXD */

    /* UART1 */
    {119,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART1_RXD.UART1_RXD */
    {120,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART1_TXD.UART1_TXD */

    /* UART2 */
    {123,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART2_RXD.UART2_RXD */
    {124,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* UART2_TXD.UART2_TXD */

    /* MMC0 */
    {196, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO15.MMC0_CLK */
    {197, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO16.MMC0_CMD */
    {195, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO14.MMC0_DAT0 */
    {194, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO13.MMC0_DAT1 */
    {193, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO12.MMC0_DAT2 */
    {192, BUFFER_CLASS_D | PIN_PTU | PIN_IEN |
              MODE(2)}, /* PR1_PRU0_GPO11.MMC0_DAT3 */

    /* EMAC */
    {79,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXD1.RGMII_RXD1 */
    {78,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXD2.RGMII_RXD2 */
    {77,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXD3.RGMII_RXD3 */
    {80,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXD0.RGMII_RXD0 */
    {94,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXD0.RGMII_TXD0 */
    {93,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXD1.RGMII_TXD1 */
    {92,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXD2.RGMII_TXD2 */
    {91,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXD3.RGMII_TXD3 */
    {85,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXCLK.RGMII_TXC */
    {95,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_TXEN.RGMII_TXCTL */
    {72,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXCLK.RGMII_RXC */
    {81,
     BUFFER_CLASS_D | PIN_PDIS | PIN_IEN | MODE(1)}, /* MII_RXDV.RGMII_RXCTL */

    /* MDIO */
    {99, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* MDIO_CLK.MDIO_CLK */
    {98,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* MDIO_DATA.MDIO_DATA */

    /* SPI0 */
    {102,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI0_CLK.SPI0_CLK */
    {103,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI0_SOMI.SPI0_SOMI */
    {104,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI0_SIMO.SPI0_SIMO */
    {100,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI0_SCSn0.SPI0_SCSn0 */
    {101,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI0_SCSn1.SPI0_SCSn1 */

    /* SPI1 */
    {107,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI1_CLK.SPI1_CLK */
    {108,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI1_SOMI.SPI1_SOMI */
    {109,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI1_SIMO.SPI1_SIMO */
    {105,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI1_SCSn0.SPI1_SCSn0 */
    {106,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI1_SCSn1.SPI1_SCSn1 */

    /* SPI2 */
    {112,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI2_CLK.SPI2_CLK */
    {113,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI2_SOMI.SPI2_SOMI */
    {114,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI2_SIMO.SPI2_SIMO */
    {110,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI2_SCSn0.SPI2_SCSn0 */
    {111,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SPI2_SCSn1.SPI2_SCSn1 */

    /* SPI3 */
    {88, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* SPI3_CLK.SPI3_CLK */
    {89,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* SPI3_SOMI.SPI3_SOMI */
    {90,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* SPI3_SIMO.SPI3_SIMO */
    {86,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* SPI3_SCSn0.SPI3_SCSn0 */
    {87,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* SPI3_SCSn1.SPI3_SCSn1 */

    /* USB0 */
    {258, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(0)}, /* USB0_DRVVBUS.USB0_DRVVBUS */

    /* SYSTEM */
    {136, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(1)}, /* QSPI_CSn1.CLKOUT */
    {237,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* SYSCLKOUT.SYSCLKOUT */
    {230, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* LRESETn.LRESETn */
    {231, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(0)}, /* LRESETNMIENn.LRESETNMIENn */
    {235,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* RESETSTATn.RESETSTATn */
    {229, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* NMIn.NMIn */
    {236, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(0)}, /* BOOTCOMPLETE.BOOTCOMPLETE */

    /* I2C0 */
    {223,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C0_SCL.I2C0_SCL */
    {224,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C0_SDA.I2C0_SDA */

    /* I2C1 */
    {225,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C1_SCL.I2C1_SCL */
    {226,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C1_SDA.I2C1_SDA */

    /* I2C2 */
    {227,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C2_SCL.I2C2_SCL */
    {228,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* I2C2_SDA.I2C2_SDA */

    /* QSPI */
    {129,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_CLK.QSPI_CLK */
    {130,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_RCLK.QSPI_RCLK */
    {135,
     BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_CSn0.QSPI_CSn0 */
    {131, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_D0.QSPI_D0 */
    {132, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_D1.QSPI_D1 */
    {133, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_D2.QSPI_D2 */
    {134, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN | MODE(0)}, /* QSPI_D3.QSPI_D3 */

    /* ECAP_1 */
    {222, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_MDIO_MDCLK.eCAP1_IN_APWM1_OUT */

    /* ECAP_0 */
    {221, BUFFER_CLASS_B | PIN_PDIS | PIN_IEN |
              MODE(4)}, /* PR1_MDIO_DATA.eCAP0_IN_APWM0_OUT */

    {
        MAX_PIN_N,
    }};

void k2g_mux_config(void) {
  // if (!board_ti_was_eeprom_read()) {
  configure_pin_mux(k2g_pin_cfg);
  // } else if (board_is_k2g_gp() || board_is_k2g_g1()) {
  // 	configure_pin_mux(k2g_evm_pin_cfg);
  // } else if (board_is_k2g_ice()) {
  // 	configure_pin_mux(k2g_ice_evm_pin_cfg);
  // } else {
  // 	puts("Unknown board, cannot configure pinmux.");
  // 	hang();
  // }
}
