;****************************************************************************
;* FILE PURPOSE: Code a simple endian independent example
;****************************************************************************
;* FILE NAME: Simple.s
;*
;* DESCRIPTION: This program is part of the Himalaya I2C boot test plan.
;*              It is a simple program that defines two initialized
;*              sections, text and data, and performs a simple
;*              execution with a self check on the results in register a0.
;*
;*              The code is also designed to be relocatable, so it will
;*              function in the himsim program running on the DM642.
;*
;*****************************************************************************

;*****************************************************************************
;*  Initialized data
;*****************************************************************************
   .data
   .def     someData
someData   .word   01234ABCDh

    .def  byte1
	.sect ".byte1"
byte1:	.byte 0x12

	.def byte2
	.sect ".byte2"
byte2:	.byte 0x12, 0x34

;*****************************************************************************
;*  code
;*****************************************************************************
   .text
   .def _c_int00
   
myConst    .equ    011223344h
   
_c_int00:

   MVKL.S1     myConst, A1
   MVKH.S1     myConst, A1

   MVKL.S1     byte1, A2
   MVKH.S1     byte1, A2
   LDB.D1	   *A2, B2

   MVKL.S1     byte2, A3
   MVKH.S1     byte2, A3
   LDB.D1	   *A3++, B3
   LDB.D1      *A3,   B4
   
   
etrap:

   BNOP.S1 etrap, 5
   
   
   





