#ifndef TIDLRT_C_EXAMPLE
#define TIDLRT_C_EXAMPLE

#include <string>

struct Settings {
  bool verbose = false;
  bool accel = false;
  bool device_mem = false;
  bool input_floating = false;
  bool profiling = false;
  bool allow_fp16 = false;
  bool gl_backend = false;
  bool hexagon_delegate = false;
  int loop_count = 1;
  float input_mean = 0;
  float input_std = 1;
  std::string artifact_path = "";
  std::string input_image_name = "./grace_hopper.bmp";
  std::string labels_file_name = "./labels.txt";
  std::string input_layer_type = "uint8_t";
  int number_of_threads = 4;
  int number_of_results = 5;
  int max_profiling_buffer_entries = 1024;
  int number_of_warmup_runs = 2;
};

#endif   //TIDLRT_C_EXAMPLE
