#!/bin/sh

if [ "${#}" -lt 2 ]; then
echo -e "Usage: \n ${0##*/} <size of file> <number of files>\n"
exit 1
fi

size_of_file=${1}
number_of_file=${2}

DIR="${PWD}/files"

if [ ! -d "${DIR}" ]; then
	mkdir -p "${DIR}"
fi

count=1

while [ "${count}" -le "${number_of_file}" ]
do
	echo ""
	echo "----Creating file${count}_${size_of_file}file-----"
	echo ""
	count=$((count + 1))
	dd if=/dev/urandom of="${DIR}/file${count}_${size_of_file}file" bs=${size_of_file} count=1
done
