

#include "uart_config.h"
#include <linux/ioctl.h>

static int set_opt(int fd,int nSpeed, int nBits, char nEvent, int nStop)
{
	struct termios newtio,oldtio;
	if  ( tcgetattr( fd,&oldtio)  !=  0) {
		perror("SetupSerial 1");
		return -1;
	}
	bzero( &newtio, sizeof( newtio ) );
	newtio.c_cflag  |=  CLOCAL | CREAD; //CLOCAL:忽略modem控制线  CREAD：打开接受者
	newtio.c_cflag &= ~CSIZE; //字符长度掩码。取值为：CS5，CS6，CS7或CS8

	switch( nBits )
	{
		case 7:
			newtio.c_cflag |= CS7;
		break;
		case 8:
			newtio.c_cflag |= CS8;
		break;
	}
 
	switch( nEvent )
	{
		case 'O':
			newtio.c_cflag |= PARENB; //允许输出产生奇偶信息以及输入到奇偶校验
			newtio.c_cflag |= PARODD;  //输入和输出是奇及校验
			newtio.c_iflag |= (INPCK | ISTRIP); // INPACK:启用输入奇偶检测；ISTRIP：去掉第八位
		break;
		case 'E':
			newtio.c_iflag |= (INPCK | ISTRIP);
			newtio.c_cflag |= PARENB;
			newtio.c_cflag &= ~PARODD;
		break;
		case 'N': 
			newtio.c_cflag &= ~PARENB;
		break;
	}
 
	speed_t baudrate = 0;
	switch( nSpeed ) {
	case 4800:
		baudrate = B4800;
		break;
	case 9600:
		baudrate = B9600;
		break;
	case 19200:
		baudrate = B19200;
		break;
	case 38400:
		baudrate = B38400;
		break;
	case 57600:
		baudrate = B57600;
		break;
	case 115200:// x1
		baudrate = B115200;
		break;
	case 230400:// x2
		baudrate = B230400;
		break;
	case 460800:// x4
		baudrate = B460800;
		break;
	case 500000:
		baudrate = B500000;
		break;
	case 576000: // x5
		baudrate = B576000;
		break;
	case 921600: // x8
		baudrate = B921600;
		break;
	case 1000000:
		baudrate = B1000000;
		break;
	case 1152000: // x10
		baudrate = B1152000;
		break;
	case 1500000:
		baudrate = B1500000;
		break;
	case 2000000:
		baudrate = B2000000;
		break;
	case 2500000:
		baudrate = B2500000;
		break;
	case 3000000:
		baudrate = B3000000;
		break;
	case 4000000:
		baudrate = B4000000;
		break;
	default:
		baudrate = B115200;
		printf("use default baudrate 115200\n");
		break;
	}
	
	if(cfsetispeed(&newtio, baudrate) || cfsetospeed(&newtio, baudrate)) {
		printf("set baudrate %d err\n", baudrate);
		return -1;
	}
 
	if( nStop == 1 )
		newtio.c_cflag &=  ~CSTOPB; //CSTOPB:设置两个停止位，而不是一个
	else if ( nStop == 2 )
		newtio.c_cflag |=  CSTOPB;

	// 关闭硬件流控
	newtio.c_cflag &= ~CRTSCTS;

	// 关闭软件流控
	newtio.c_iflag &= ~(IXON | IXOFF | IXANY);
	
	// 配置xmit fifo
	struct serial_struct serial;  
	int ret = ioctl(fd, TIOCGSERIAL, &serial);  
	if (ret != 0) 
		return -2;
	serial.xmit_fifo_size = 1024*1024; //1M  
	ret = ioctl(fd, TIOCSSERIAL, &serial); 
	
	newtio.c_cc[VTIME]  = 0; //VTIME:非cannoical模式读时的延时，以十分之一秒位单位
	newtio.c_cc[VMIN] = 0; //VMIN:非canonical模式读到最小字符数
	tcflush(fd,TCIFLUSH); // 改变在所有写入 fd 引用的对象的输出都被传输后生效，所有已接受但未读入的输入都在改变发生前丢弃。
	if((tcsetattr(fd,TCSANOW,&newtio))!=0) //TCSANOW:改变立即发生
	{
		perror("com set error");
		return -1;
	}
	
	printf("set baudrate %d %d done!\n\r", baudrate, nSpeed);
	return 0;
}

int open_serial_port(const char *device, int baudrate) {
	//O_NOCTTY ：该参数不会使打开的文件成为该进程的控制终端。如果没有指定这个标志，那么任何一个 输入都将会影响用户的进程。
	//O_NDELAY ：这个程序不关心DCD信号线所处的状态,端口的另一端是否激活或者停止。如果用户不指定了这个标志，则进程将会一直处在睡眠状态，直到DCD信号线被激活。
    int fd = open(device, O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd == -1) {
        perror("Unable to open serial port");
        return -1;
    }
	
    // 配置串口
	int ret = set_opt(fd, baudrate, 8, 'N', 1);
	if(ret < 0){
		perror("configure serial port error");
		return -1;
	}

    return fd;
}