/****************************************************************************/
/*  OMAPL138.cmd                                                            */
/*  Copyright (c) 2010 Texas Instruments Incorporated                       */
/*  Author: Rafael de Souza                                                 */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an OMAPL138           */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific          */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/*    Usage:       The map below contains the local memory for each core    */
/*                 Use the linker option --define=DSP_CORE=n                */
/*                 Where n defines the core used: DSP (n=1) or ARM (n=0)    */
/*                                                                          */
/****************************************************************************/

SECTIONS
{
    .userBoot > mDDR_Boot
	.text:_c_int00 > 0xC0000100

    .text          >  mDDR
    .stack         >  mDDR
    .bss           >  mDDR
    .cio           >  mDDR
    .const         >  mDDR
    .data          >  mDDR
    .switch        >  mDDR
    .sysmem        >  mDDR
    .far           >  mDDR
    .args          >  mDDR
    .ppinfo        >  mDDR
    .ppdata        >  mDDR

    /* TI-ABI or COFF sections */
    .pinit         >  mDDR
    .cinit         >  mDDR

    /* EABI sections */
    .binit         >  mDDR
    .init_array    >  mDDR
    .neardata      >  mDDR
    .fardata       >  mDDR
    .rodata        >  mDDR
    .c6xabi.exidx  >  mDDR
    .c6xabi.extab  >  mDDR

}
