/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>

#include "cslr.h"
#include "cslr_syscfg0_OMAPL138.h"
#include "soc_OMAPL138.h"
#define SYS_BASE           0x01C14000
#define KICK0Ra             *(unsigned int*)(SYS_BASE + 0x038)
#define KICK1Ra             *(unsigned int*)(SYS_BASE + 0x03c)

CSL_SyscfgRegsOvly SYS_REGS = (CSL_SyscfgRegsOvly)CSL_SYSCFG_0_REGS;
CSL_PscRegsOvly psc0Regs = (CSL_PscRegsOvly) CSL_PSC_0_REGS;

extern void _c_int00();

#pragma CODE_SECTION(myBootFunction,".userBoot");
void myBootFunction()
{
	unsigned int * breadcrumb;
	breadcrumb = (unsigned int *)0x80001000;

	*breadcrumb = 0xABCD;

    _c_int00();

}

/*
 *  ======== main ========
 */
#pragma CODE_SECTION(main,".userBoot");
Int main()
{ 
	unsigned int * breadcrumb;
	breadcrumb = (unsigned int *)0x80001004;

	*breadcrumb = 0xDEADBEEF;

	// Open Permissions to SYSCFG Registers (Not required for PG2.0 silicon and above)
	KICK0Ra = 0x83e70b13;
	KICK1Ra = 0x95A4F1E0;

	/* Set DSP boot address vector to entry point of DSP program
	This must be aligned to 1KB boundaries */
	//SYS_REGS->HOST1CFG = 0x80010000;   This does not work.
	//SYS_REGS->HOST1CFG = 0x11800400;  This is for the sensor.  It is the correct value
	SYS_REGS->HOST1CFG = 0xC0000000;

	/* Wake up the DSP */
	CSL_FINST(psc0Regs->MDCTL[CSL_PSC_DSP], PSC_MDCTL_NEXT, ENABLE);
	CSL_FINST(psc0Regs->PTCMD, PSC_PTCMD_GO1, SET);
	while(CSL_FEXT(psc0Regs->PTSTAT, PSC_PTSTAT_GOSTAT1)==CSL_PSC_PTSTAT_GOSTAT1_IN_TRANSITION);
	CSL_FINST(psc0Regs->MDCTL[CSL_PSC_DSP], PSC_MDCTL_LRST, DEASSERT);

	breadcrumb = (unsigned int *)0x80001008;

	*breadcrumb = 0xABBAD0D0;

	while(1);
}
