/****************************************************************************/
/*  OMAPL138.cmd                                                            */
/*  Copyright (c) 2010 Texas Instruments Incorporated                       */
/*  Author: Rafael de Souza                                                 */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an OMAPL138           */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific          */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/*    Usage:       The map below contains the local memory for each core    */
/*                 Use the linker option --define=DSP_CORE=n                */
/*                 Where n defines the core used: DSP (n=1) or ARM (n=0)    */
/*                                                                          */
/****************************************************************************/

MEMORY
{
    SHDSPL2ROM   o = 0x11700000  l = 0x00100000  /* 1MB L2 Shared Internal ROM */          
    SHDSPL2RAM   o = 0x11800000  l = 0x00040000  /* 256kB L2 Shared Internal RAM */       
    SHDSPL1PRAM  o = 0x11E00000  l = 0x00008000  /* 32kB L1 Shared Internal Program RAM */
    SHDSPL1DRAM  o = 0x11F00000  l = 0x00008000  /* 32kB L1 Shared Internal Data RAM */       
    SHRAM        o = 0x80000000  l = 0x00010000  /* 64kB Shared RAM */
    SHRAM1       o = 0x80010000  l = 0x00010000  /* 64kB Shared RAM */
    DDR2         o = 0xC0000000  l = 0x04000000  /* 512Mb mDDR Data */
}

SECTIONS
{
    .text          >  SHRAM1
    .stack         >  SHRAM1
    .bss           >  SHRAM1
    .cio           >  SHRAM1
    .const         >  SHRAM1
    .data          >  SHRAM1
    .switch        >  SHRAM1
    .sysmem        >  SHRAM1
    .far           >  SHRAM1
    .args          >  SHRAM1
    .ppinfo        >  SHRAM1
    .ppdata        >  SHRAM1
    
    /* TI-ABI or COFF sections */
    .pinit         >  SHRAM1
    .cinit         >  SHRAM1
    
    /* EABI sections */
    .binit         >  SHRAM1
    .init_array    >  SHRAM1
    .neardata      >  SHRAM1
    .fardata       >  SHRAM1
    .rodata        >  SHRAM1
    .c6xabi.exidx  >  SHRAM1
    .c6xabi.extab  >  SHRAM1
}
