/****************************************************************************/
/*  OMAPL138.cmd                                                            */
/*  Copyright (c) 2010 Texas Instruments Incorporated                       */
/*  Author: Rafael de Souza                                                 */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an OMAPL138           */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific          */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/*    Usage:       The map below contains the local memory for each core    */
/*                 Use the linker option --define=DSP_CORE=n                */
/*                 Where n defines the core used: DSP (n=1) or ARM (n=0)    */
/*                                                                          */
/****************************************************************************/

MEMORY
{
    SHDSPL2ROM   o = 0x11700000  l = 0x00100000  /* 1MB L2 Shared Internal ROM */          
    SHDSPL2RAM   o = 0x11800000  l = 0x00040000  /* 256kB L2 Shared Internal RAM */       
    SHDSPL1PRAM  o = 0x11E00000  l = 0x00008000  /* 32kB L1 Shared Internal Program RAM */
    SHDSPL1DRAM  o = 0x11F00000  l = 0x00008000  /* 32kB L1 Shared Internal Data RAM */       
    SHRAM        o = 0x80000000  l = 0x00010000  /* 128kB Shared RAM */
    SHRAM1       o = 0x80010000  l = 0x00010000  /* 128kB Shared RAM */
    mDDR_Boot    o = 0xC0000000  l = 0x00001000  /* 4kB mDDR Data */
    mDDR         o = 0xC0001000  l = 0x03FFF000  /* 64MB - 4kB mDDR Data */

}

SECTIONS
{
	.userBoot > mDDR_Boot

	.text:_c_int00 > 0xC0000100

    .text          >  mDDR
    .stack         >  mDDR
    .bss           >  mDDR
    .cio           >  mDDR
    .const         >  mDDR
    .data          >  mDDR
    .switch        >  mDDR
    .sysmem        >  mDDR
    .far           >  mDDR
    .args          >  mDDR
    .ppinfo        >  mDDR
    .ppdata        >  mDDR
    
    /* TI-ABI or COFF sections */
    .pinit         >  mDDR
    .cinit         >  mDDR
    
    /* EABI sections */
    .binit         >  mDDR
    .init_array    >  mDDR
    .neardata      >  mDDR
    .fardata       >  mDDR
    .rodata        >  mDDR
    .c6xabi.exidx  >  mDDR
    .c6xabi.extab  >  mDDR
}
