
/* ============================================================================
 *
 *            TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *  Property of Texas Instruments
 *  For Unrestricted Internal Use Only
 *  Unauthorized reproduction and/or distribution is strictly prohibited.
 *  This product is protected under copyright law and trade secret law
 *  as an unpublished work.
 *  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
 *
 */

/**
 *  @Component:   CM
 *
 *  @Filename:    ../../CredDataBase/prcmCRED/cm_wkup_cred.h
 *
 ============================================================================ */


#ifndef _HW_CM_WKUP_H_
#define _HW_CM_WKUP_H_


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CM_WKUP_CLKSTCTRL   (0x0)
#define CM_WKUP_CONTROL_CLKCTRL   (0x4)
#define CM_WKUP_GPIO0_CLKCTRL   (0x8)
#define CM_WKUP_L4WKUP_CLKCTRL   (0xc)
#define CM_WKUP_TIMER0_CLKCTRL   (0x10)
#define CM_WKUP_DEBUGSS_CLKCTRL   (0x14)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL   (0x18)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU   (0x1c)
#define CM_WKUP_CM_IDLEST_DPLL_MPU   (0x20)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_MPU   (0x24)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_MPU   (0x28)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU   (0x2c)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR   (0x30)
#define CM_WKUP_CM_IDLEST_DPLL_DDR   (0x34)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DDR   (0x38)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DDR   (0x3c)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR   (0x40)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP   (0x44)
#define CM_WKUP_CM_IDLEST_DPLL_DISP   (0x48)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DISP   (0x4c)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DISP   (0x50)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP   (0x54)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE   (0x58)
#define CM_WKUP_CM_IDLEST_DPLL_CORE   (0x5c)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_CORE   (0x60)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_CORE   (0x64)
#define CM_WKUP_CM_CLKSEL_DPLL_CORE   (0x68)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER   (0x6c)
#define CM_WKUP_CM_IDLEST_DPLL_PER   (0x70)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_PER   (0x74)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_PER   (0x78)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER   (0x7c)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE   (0x80)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE   (0x84)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU   (0x88)
#define CM_WKUP_CM_CLKMODE_DPLL_PER   (0x8c)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE   (0x90)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR   (0x94)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP   (0x98)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH   (0x9c)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR   (0xa0)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP   (0xa4)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU   (0xa8)
#define CM_WKUP_CM_DIV_M2_DPLL_PER   (0xac)
#define CM_WKUP_WKUP_M3_CLKCTRL   (0xb0)
#define CM_WKUP_UART0_CLKCTRL   (0xb4)
#define CM_WKUP_I2C0_CLKCTRL   (0xb8)
#define CM_WKUP_ADC_TSC_CLKCTRL   (0xbc)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL   (0xc0)
#define CM_WKUP_TIMER1_CLKCTRL   (0xc4)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL   (0xc8)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL   (0xcc)
#define CM_WKUP_WDT0_CLKCTRL   (0xd0)
#define CM_WKUP_WDT1_CLKCTRL   (0xd4)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE   (0xd8)

/**************************************************************************
 * Field Definition Macros
 **************************************************************************/

/* CLKSTCTRL */
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_ADC_FCLK   (0x00004000u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_ADC_FCLK_SHIFT   (0x0000000Eu)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_ADC_FCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_ADC_FCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_GPIO0_GDBCLK   (0x00000100u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_GPIO0_GDBCLK_SHIFT   (0x00000008u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_GPIO0_GDBCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_GPIO0_GDBCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_I2C0_GFCLK   (0x00000800u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_I2C0_GFCLK_SHIFT   (0x0000000Bu)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_I2C0_GFCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_I2C0_GFCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_L4_WKUP_GCLK   (0x00000004u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_L4_WKUP_GCLK_SHIFT   (0x00000002u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_L4_WKUP_GCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_L4_WKUP_GCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_SR_SYSCLK   (0x00000008u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_SR_SYSCLK_SHIFT   (0x00000003u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_SR_SYSCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_SR_SYSCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER0_GCLK   (0x00000400u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER0_GCLK_SHIFT   (0x0000000Au)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER0_GCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER0_GCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER1_GCLK   (0x00002000u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER1_GCLK_SHIFT   (0x0000000Du)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER1_GCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_TIMER1_GCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_UART0_GFCLK   (0x00001000u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_UART0_GFCLK_SHIFT   (0x0000000Cu)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_UART0_GFCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_UART0_GFCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT0_GCLK   (0x00000200u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT0_GCLK_SHIFT   (0x00000009u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT0_GCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT0_GCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT1_GCLK   (0x00000010u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT1_GCLK_SHIFT   (0x00000004u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT1_GCLK_ACT   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKACTIVITY_WDT1_GCLK_INACT   (0x0u)

#define CM_WKUP_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_WKUP_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_WKUP_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_WKUP_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_WKUP_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_WKUP_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* CONTROL_CLKCTRL */
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_CONTROL_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_CONTROL_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* GPIO0_CLKCTRL */
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_GPIO0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_GPIO0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_WKUP_GPIO0_CLKCTRL_OPTFCLKEN_GPIO0_GDBCLK   (0x00040000u)
#define CM_WKUP_GPIO0_CLKCTRL_OPTFCLKEN_GPIO0_GDBCLK_SHIFT   (0x00000012u)
#define CM_WKUP_GPIO0_CLKCTRL_OPTFCLKEN_GPIO0_GDBCLK_FCLK_DIS   (0x0u)
#define CM_WKUP_GPIO0_CLKCTRL_OPTFCLKEN_GPIO0_GDBCLK_FCLK_EN   (0x1u)


/* L4WKUP_CLKCTRL */
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_L4WKUP_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_L4WKUP_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_L4WKUP_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_L4WKUP_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_L4WKUP_CLKCTRL_MODULEMODE_DISABLE  (0x0u)


/* TIMER0_CLKCTRL */
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_TIMER0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_TIMER0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* DEBUGSS_CLKCTRL */
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_DEBUGSS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_DEBUGSS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_WKUP_DEBUGSS_CLKCTRL_OPTCLK_DEBUG_CLKA   (0x40000000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_OPTCLK_DEBUG_CLKA_SHIFT   (0x0000001Eu)

#define CM_WKUP_DEBUGSS_CLKCTRL_OPTFCLKEN_DBGSYSCLK   (0x00080000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_OPTFCLKEN_DBGSYSCLK_SHIFT   (0x00000013u)
#define CM_WKUP_DEBUGSS_CLKCTRL_OPTFCLKEN_DBGSYSCLK_FCLK_DIS   (0x0u)
#define CM_WKUP_DEBUGSS_CLKCTRL_OPTFCLKEN_DBGSYSCLK_FCLK_EN   (0x1u)

#define CM_WKUP_DEBUGSS_CLKCTRL_STBYST   (0x00040000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_WKUP_DEBUGSS_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_WKUP_DEBUGSS_CLKCTRL_STBYST_STANDBY   (0x1u)

#define CM_WKUP_DEBUGSS_CLKCTRL_STM_PMD_CLKDIVSEL   (0x38000000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_STM_PMD_CLKDIVSEL_SHIFT   (0x0000001Bu)

#define CM_WKUP_DEBUGSS_CLKCTRL_STM_PMD_CLKSEL   (0x00C00000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_STM_PMD_CLKSEL_SHIFT   (0x00000016u)

#define CM_WKUP_DEBUGSS_CLKCTRL_TRC_PMD_CLKDIVSEL   (0x07000000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_TRC_PMD_CLKDIVSEL_SHIFT   (0x00000018u)

#define CM_WKUP_DEBUGSS_CLKCTRL_TRC_PMD_CLKSEL   (0x00300000u)
#define CM_WKUP_DEBUGSS_CLKCTRL_TRC_PMD_CLKSEL_SHIFT   (0x00000014u)


/* CM_L3_AON_CLKSTCTRL */
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DBGSYSCLK   (0x00000004u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DBGSYSCLK_SHIFT   (0x00000002u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DBGSYSCLK_ACT   (0x1u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DBGSYSCLK_INACT   (0x0u)

#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DEBUG_CLKA   (0x00000010u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_DEBUG_CLKA_SHIFT   (0x00000004u)

#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_L3_AON_GCLK   (0x00000008u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_L3_AON_GCLK_SHIFT   (0x00000003u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_L3_AON_GCLK_ACT   (0x1u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKACTIVITY_L3_AON_GCLK_INACT   (0x0u)

#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_WKUP_CM_L3_AON_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* CM_AUTOIDLE_DPLL_MPU */
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE   (0x00000007u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_SHIFT   (0x00000000u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_AUTO_CTL_DISABLE   (0x0u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_AUTO_LP_BYP   (0x5u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_AUTO_LP_STOP   (0x1u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_RESERVED2   (0x2u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_RESERVED3   (0x3u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_RESERVED4   (0x4u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_RESERVED6   (0x6u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_MPU_AUTO_DPLL_MODE_RESERVED7   (0x7u)


/* CM_IDLEST_DPLL_MPU */
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_DPLL_CLK   (0x00000001u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_DPLL_CLK_SHIFT   (0x00000000u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_DPLL_CLK_DPLL_LOCKED   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_DPLL_CLK_DPLL_UNLOCKED   (0x0u)

#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_MN_BYPASS   (0x00000100u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_MN_BYPASS_SHIFT   (0x00000008u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_MN_BYPASS_MN_BYPASS   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_MPU_ST_MN_BYPASS_NO_MNBYPASS   (0x0u)


/* CM_SSC_DELTAMSTEP_DPLL_MPU */
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_MPU_DELTAMSTEP   (0x000FFFFFu)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_MPU_DELTAMSTEP_SHIFT   (0x00000000u)


/* CM_SSC_MODFREQDIV_DPLL_MPU */
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_MPU_MODFREQDIV_EXPONENT   (0x00000700u)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_MPU_MODFREQDIV_EXPONENT_SHIFT   (0x00000008u)

#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_MPU_MODFREQDIV_MANTISSA   (0x0000007Fu)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_MPU_MODFREQDIV_MANTISSA_SHIFT   (0x00000000u)


/* CM_CLKSEL_DPLL_MPU */
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_BYP_CLKSEL   (0x00800000u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_BYP_CLKSEL_SHIFT   (0x00000017u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_BYP_CLKSEL_SEL0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_BYP_CLKSEL_SEL1   (0x1u)

#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_DIV   (0x0000007Fu)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_DIV_SHIFT   (0x00000000u)

#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_MULT   (0x0007FF00u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_MULT_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_MULT_0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_MPU_DPLL_MULT_1   (0x1u)


/* CM_AUTOIDLE_DPLL_DDR */
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE   (0x00000007u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_SHIFT   (0x00000000u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_AUTO_CTL_DISABLE   (0x0u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_AUTO_LP_BYP   (0x5u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_AUTO_LP_STOP   (0x1u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_RESERVED2   (0x2u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_RESERVED3   (0x3u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_RESERVED4   (0x4u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_RESERVED6   (0x6u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DDR_AUTO_DPLL_MODE_RESERVED7   (0x7u)


/* CM_IDLEST_DPLL_DDR */
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_DPLL_CLK   (0x00000001u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_DPLL_CLK_SHIFT   (0x00000000u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_DPLL_CLK_DPLL_LOCKED   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_DPLL_CLK_DPLL_UNLOCKED   (0x0u)

#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_MN_BYPASS   (0x00000100u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_MN_BYPASS_SHIFT   (0x00000008u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_MN_BYPASS_MN_BYPASS   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_DDR_ST_MN_BYPASS_NO_MNBYPASS   (0x0u)


/* CM_SSC_DELTAMSTEP_DPLL_DDR */
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DDR_DELTAMSTEP   (0x000FFFFFu)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DDR_DELTAMSTEP_SHIFT   (0x00000000u)


/* CM_SSC_MODFREQDIV_DPLL_DDR */
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DDR_MODFREQDIV_EXPONENT   (0x00000700u)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DDR_MODFREQDIV_EXPONENT_SHIFT   (0x00000008u)

#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DDR_MODFREQDIV_MANTISSA   (0x0000007Fu)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DDR_MODFREQDIV_MANTISSA_SHIFT   (0x00000000u)


/* CM_CLKSEL_DPLL_DDR */
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_BYP_CLKSEL   (0x00800000u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_BYP_CLKSEL_SHIFT   (0x00000017u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_BYP_CLKSEL_SEL0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_BYP_CLKSEL_SEL1   (0x1u)

#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_DIV   (0x0000007Fu)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_DIV_SHIFT   (0x00000000u)

#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_MULT   (0x0007FF00u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_MULT_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_MULT_0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_DDR_DPLL_MULT_1   (0x1u)


/* CM_AUTOIDLE_DPLL_DISP */
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE   (0x00000007u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_SHIFT   (0x00000000u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_AUTO_CTL_DISABLE   (0x0u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_AUTO_LP_BYP   (0x5u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_AUTO_LP_STOP   (0x1u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_RESERVED2   (0x2u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_RESERVED3   (0x3u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_RESERVED4   (0x4u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_RESERVED6   (0x6u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_DISP_AUTO_DPLL_MODE_RESERVED7   (0x7u)


/* CM_IDLEST_DPLL_DISP */
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_DPLL_CLK   (0x00000001u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_DPLL_CLK_SHIFT   (0x00000000u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_DPLL_CLK_DPLL_LOCKED   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_DPLL_CLK_DPLL_UNLOCKED   (0x0u)

#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_MN_BYPASS   (0x00000100u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_MN_BYPASS_SHIFT   (0x00000008u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_MN_BYPASS_MN_BYPASS   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_DISP_ST_MN_BYPASS_NO_MNBYPASS   (0x0u)


/* CM_SSC_DELTAMSTEP_DPLL_DISP */
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DISP_DELTAMSTEP   (0x000FFFFFu)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_DISP_DELTAMSTEP_SHIFT   (0x00000000u)


/* CM_SSC_MODFREQDIV_DPLL_DISP */
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DISP_MODFREQDIV_EXPONENT   (0x00000700u)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DISP_MODFREQDIV_EXPONENT_SHIFT   (0x00000008u)

#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DISP_MODFREQDIV_MANTISSA   (0x0000007Fu)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_DISP_MODFREQDIV_MANTISSA_SHIFT   (0x00000000u)


/* CM_CLKSEL_DPLL_DISP */
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_BYP_CLKSEL   (0x00800000u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_BYP_CLKSEL_SHIFT   (0x00000017u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_BYP_CLKSEL_SEL0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_BYP_CLKSEL_SEL1   (0x1u)

#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_DIV   (0x0000007Fu)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_DIV_SHIFT   (0x00000000u)

#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_MULT   (0x0007FF00u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_MULT_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_MULT_0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_DISP_DPLL_MULT_1   (0x1u)


/* CM_AUTOIDLE_DPLL_CORE */
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE   (0x00000007u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_SHIFT   (0x00000000u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_AUTO_CTL_DISABLE   (0x0u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_AUTO_LP_BYP   (0x5u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_AUTO_LP_STOP   (0x1u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_RESERVED2   (0x2u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_RESERVED3   (0x3u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_RESERVED4   (0x4u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_RESERVED6   (0x6u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_CORE_AUTO_DPLL_MODE_RESERVED7   (0x7u)


/* CM_IDLEST_DPLL_CORE */
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_DPLL_CLK   (0x00000001u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_DPLL_CLK_SHIFT   (0x00000000u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_DPLL_CLK_DPLL_LOCKED   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_DPLL_CLK_DPLL_UNLOCKED   (0x0u)

#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_MN_BYPASS   (0x00000100u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_MN_BYPASS_SHIFT   (0x00000008u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_MN_BYPASS_MN_BYPASS   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_CORE_ST_MN_BYPASS_NO_MNBYPASS   (0x0u)


/* CM_SSC_DELTAMSTEP_DPLL_CORE */
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_CORE_DELTAMSTEP   (0x000FFFFFu)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_CORE_DELTAMSTEP_SHIFT   (0x00000000u)


/* CM_SSC_MODFREQDIV_DPLL_CORE */
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_CORE_MODFREQDIV_EXPONENT   (0x00000700u)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_CORE_MODFREQDIV_EXPONENT_SHIFT   (0x00000008u)

#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_CORE_MODFREQDIV_MANTISSA   (0x0000007Fu)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_CORE_MODFREQDIV_MANTISSA_SHIFT   (0x00000000u)


/* CM_CLKSEL_DPLL_CORE */
#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_DIV   (0x0000007Fu)
#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_DIV_SHIFT   (0x00000000u)

#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_MULT   (0x0007FF00u)
#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_MULT_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_MULT_RESERVED_0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_CORE_DPLL_MULT_RESERVED_1   (0x1u)


/* CM_AUTOIDLE_DPLL_PER */
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE   (0x00000007u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_SHIFT   (0x00000000u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_AUTO_CTL_DISABLE   (0x0u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_AUTO_LP_BYP   (0x5u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_AUTO_LP_STOP   (0x1u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_RESERVED2   (0x2u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_RESERVED3   (0x3u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_RESERVED4   (0x4u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_RESERVED6   (0x6u)
#define CM_WKUP_CM_AUTOIDLE_DPLL_PER_AUTO_DPLL_MODE_RESERVED7   (0x7u)


/* CM_IDLEST_DPLL_PER */
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_DPLL_CLK   (0x00000001u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_DPLL_CLK_SHIFT   (0x00000000u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_DPLL_CLK_DPLL_LOCKED   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_DPLL_CLK_DPLL_UNLOCKED   (0x0u)

#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_MN_BYPASS   (0x00000100u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_MN_BYPASS_SHIFT   (0x00000008u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_MN_BYPASS_MN_BYPASS   (0x1u)
#define CM_WKUP_CM_IDLEST_DPLL_PER_ST_MN_BYPASS_NO_MNBYPASS   (0x0u)


/* CM_SSC_DELTAMSTEP_DPLL_PER */
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_PER_DELTAMSTEP   (0x000FFFFFu)
#define CM_WKUP_CM_SSC_DELTAMSTEP_DPLL_PER_DELTAMSTEP_SHIFT   (0x00000000u)


/* CM_SSC_MODFREQDIV_DPLL_PER */
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_PER_MODFREQDIV_EXPONENT   (0x00000700u)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_PER_MODFREQDIV_EXPONENT_SHIFT   (0x00000008u)

#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_PER_MODFREQDIV_MANTISSA   (0x0000007Fu)
#define CM_WKUP_CM_SSC_MODFREQDIV_DPLL_PER_MODFREQDIV_MANTISSA_SHIFT   (0x00000000u)


/* CM_CLKDCOLDO_DPLL_PER */
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_PWDN   (0x00001000u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_PWDN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_PWDN_ALWAYS_ACTIVE   (0x0u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_DPLL_CLKDCOLDO_PWDN_AUTO_PWDN   (0x1u)

#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_ST_DPLL_CLKDCOLDO   (0x00000200u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_ST_DPLL_CLKDCOLDO_SHIFT   (0x00000009u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_ST_DPLL_CLKDCOLDO_CLK_ENABLED   (0x0u)
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_ST_DPLL_CLKDCOLDO_CLK_GATED   (0x1u)


/* CM_DIV_M4_DPLL_CORE */
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_PWDN   (0x00001000u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_PWDN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_PWDN_ALWAYS_ACTIVE   (0x0u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_HSDIVIDER_CLKOUT1_PWDN_AUTO_PWDN   (0x1u)

#define CM_WKUP_CM_DIV_M4_DPLL_CORE_ST_HSDIVIDER_CLKOUT1   (0x00000200u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_ST_HSDIVIDER_CLKOUT1_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_ST_HSDIVIDER_CLKOUT1_CLK_ENABLED   (0x0u)
#define CM_WKUP_CM_DIV_M4_DPLL_CORE_ST_HSDIVIDER_CLKOUT1_CLK_GATED   (0x1u)


/* CM_DIV_M5_DPLL_CORE */
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_PWDN   (0x00001000u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_PWDN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_PWDN_ALWAYS_ACTIVE   (0x0u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_HSDIVIDER_CLKOUT2_PWDN_AUTO_PWDN   (0x1u)

#define CM_WKUP_CM_DIV_M5_DPLL_CORE_ST_HSDIVIDER_CLKOUT2   (0x00000200u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_ST_HSDIVIDER_CLKOUT2_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_ST_HSDIVIDER_CLKOUT2_CLK_ENABLED   (0x0u)
#define CM_WKUP_CM_DIV_M5_DPLL_CORE_ST_HSDIVIDER_CLKOUT2_CLK_GATED   (0x1u)


/* CM_CLKMODE_DPLL_MPU */
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_DRIFTGUARD_EN   (0x00000100u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_DRIFTGUARD_EN_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_DRIFTGUARD_EN_DIASBLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_DRIFTGUARD_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN   (0x00000007u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_SHIFT   (0x00000000u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_DPLL_FR_BYP_MODE   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_DPLL_LOCK_MODE   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_DPLL_LP_BYP_MODE   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_DPLL_MN_BYP_MODE   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_RESERVED1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_RESERVED2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_EN_RESERVED3   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_LPMODE_EN   (0x00000400u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_LPMODE_EN_SHIFT   (0x0000000Au)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_LPMODE_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_LPMODE_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL   (0x00000018u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL_SHIFT   (0x00000003u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL_RAMP_ALGO1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL_RAMP_ALGO2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL_RAMP_DISABLE   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_LEVEL_RESERVED   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE   (0x000000E0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_SHIFT   (0x00000005u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX128   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX16   (0x3u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX2   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX32   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX4   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX512   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX64   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RAMP_RATE_REFCLKX8   (0x2u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_REGM4XEN   (0x00000800u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_REGM4XEN_SHIFT   (0x0000000Bu)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_REGM4XEN_DISABLED   (0x0u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RELOCK_RAMP_EN   (0x00000200u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_RELOCK_RAMP_EN_SHIFT   (0x00000009u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_ACK   (0x00002000u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_ACK_SHIFT   (0x0000000Du)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_ACK_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_ACK_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_DOWNSPREAD   (0x00004000u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_DOWNSPREAD_SHIFT   (0x0000000Eu)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_DOWNSPREAD_FULL_SPREAD   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_DOWNSPREAD_LOW_SPREAD   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_EN   (0x00001000u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_EN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_TYPE   (0x00008000u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_TYPE_SHIFT   (0x0000000Fu)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_TYPE_SQUARE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_MPU_DPLL_SSC_TYPE_TRIANGULAR   (0x0u)


/* CM_CLKMODE_DPLL_PER */
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN   (0x00000007u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_SHIFT   (0x00000000u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_DPLL_LOCK_MODE   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_DPLL_LP_BYP_MODE   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_DPLL_LP_STP_MODE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_DPLL_MN_BYP_MODE   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_RESERVED2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_RESERVED3   (0x3u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_EN_RESERVED6   (0x6u)

#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_ACK   (0x00002000u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_ACK_SHIFT   (0x0000000Du)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_ACK_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_ACK_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_DOWNSPREAD   (0x00004000u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_DOWNSPREAD_SHIFT   (0x0000000Eu)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_DOWNSPREAD_FULL_SPREAD   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_DOWNSPREAD_LOW_SPREAD   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_EN   (0x00001000u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_EN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_TYPE   (0x00008000u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_TYPE_SHIFT   (0x0000000Fu)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_TYPE_SQUARE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_PER_DPLL_SSC_TYPE_TRIANGULAR   (0x0u)


/* CM_CLKMODE_DPLL_CORE */
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_DRIFTGUARD_EN   (0x00000100u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_DRIFTGUARD_EN_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_DRIFTGUARD_EN_DIASBLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_DRIFTGUARD_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN   (0x00000007u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_SHIFT   (0x00000000u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_DPLL_FR_BYP_MODE   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_DPLL_LOCK_MODE   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_DPLL_LP_BYP_MODE   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_DPLL_MN_BYP_MODE   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_RESERVED1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_RESERVED2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_EN_RESERVED3   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_LPMODE_EN   (0x00000400u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_LPMODE_EN_SHIFT   (0x0000000Au)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_LPMODE_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_LPMODE_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL   (0x00000018u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL_SHIFT   (0x00000003u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL_RAMP_ALGO1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL_RAMP_ALGO2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL_RAMP_DISABLE   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_LEVEL_RESERVED   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE   (0x000000E0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_SHIFT   (0x00000005u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX128   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX16   (0x3u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX2   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX32   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX4   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX512   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX64   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RAMP_RATE_REFCLKX8   (0x2u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_REGM4XEN   (0x00000800u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_REGM4XEN_SHIFT   (0x0000000Bu)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_REGM4XEN_DISABLED   (0x0u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RELOCK_RAMP_EN   (0x00000200u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_RELOCK_RAMP_EN_SHIFT   (0x00000009u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_ACK   (0x00002000u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_ACK_SHIFT   (0x0000000Du)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_ACK_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_ACK_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_DOWNSPREAD   (0x00004000u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_DOWNSPREAD_SHIFT   (0x0000000Eu)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_DOWNSPREAD_FULL_SPREAD   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_DOWNSPREAD_LOW_SPREAD   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_EN   (0x00001000u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_EN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_TYPE   (0x00008000u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_TYPE_SHIFT   (0x0000000Fu)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_TYPE_SQUARE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_CORE_DPLL_SSC_TYPE_TRIANGULAR   (0x0u)


/* CM_CLKMODE_DPLL_DDR */
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_DRIFTGUARD_EN   (0x00000100u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_DRIFTGUARD_EN_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_DRIFTGUARD_EN_DIASBLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_DRIFTGUARD_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN   (0x00000007u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_SHIFT   (0x00000000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_DPLL_FR_BYP_MODE   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_DPLL_LOCK_MODE   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_DPLL_LP_BYP_MODE   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_DPLL_MN_BYP_MODE   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_RESERVED1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_RESERVED2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_EN_RESERVED3   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_LPMODE_EN   (0x00000400u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_LPMODE_EN_SHIFT   (0x0000000Au)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_LPMODE_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_LPMODE_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL   (0x00000018u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL_SHIFT   (0x00000003u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL_RAMP_ALGO1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL_RAMP_ALGO2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL_RAMP_DISABLE   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_LEVEL_RESERVED   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE   (0x000000E0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_SHIFT   (0x00000005u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX128   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX16   (0x3u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX2   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX32   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX4   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX512   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX64   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RAMP_RATE_REFCLKX8   (0x2u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_REGM4XEN   (0x00000800u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_REGM4XEN_SHIFT   (0x0000000Bu)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_REGM4XEN_DISABLED   (0x0u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RELOCK_RAMP_EN   (0x00000200u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_RELOCK_RAMP_EN_SHIFT   (0x00000009u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_ACK   (0x00002000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_ACK_SHIFT   (0x0000000Du)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_ACK_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_ACK_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_DOWNSPREAD   (0x00004000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_DOWNSPREAD_SHIFT   (0x0000000Eu)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_DOWNSPREAD_FULL_SPREAD   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_DOWNSPREAD_LOW_SPREAD   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_EN   (0x00001000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_EN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_TYPE   (0x00008000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_TYPE_SHIFT   (0x0000000Fu)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_TYPE_SQUARE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DDR_DPLL_SSC_TYPE_TRIANGULAR   (0x0u)


/* CM_CLKMODE_DPLL_DISP */
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_DRIFTGUARD_EN   (0x00000100u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_DRIFTGUARD_EN_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_DRIFTGUARD_EN_DIASBLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_DRIFTGUARD_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN   (0x00000007u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_SHIFT   (0x00000000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_DPLL_FR_BYP_MODE   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_DPLL_LOCK_MODE   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_DPLL_LP_BYP_MODE   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_DPLL_MN_BYP_MODE   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_RESERVED1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_RESERVED2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_EN_RESERVED3   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_LPMODE_EN   (0x00000400u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_LPMODE_EN_SHIFT   (0x0000000Au)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_LPMODE_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_LPMODE_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL   (0x00000018u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL_SHIFT   (0x00000003u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL_RAMP_ALGO1   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL_RAMP_ALGO2   (0x2u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL_RAMP_DISABLE   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_LEVEL_RESERVED   (0x3u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE   (0x000000E0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_SHIFT   (0x00000005u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX128   (0x6u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX16   (0x3u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX2   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX32   (0x4u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX4   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX512   (0x7u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX64   (0x5u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RAMP_RATE_REFCLKX8   (0x2u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_REGM4XEN   (0x00000800u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_REGM4XEN_SHIFT   (0x0000000Bu)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_REGM4XEN_DISABLED   (0x0u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RELOCK_RAMP_EN   (0x00000200u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_RELOCK_RAMP_EN_SHIFT   (0x00000009u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_ACK   (0x00002000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_ACK_SHIFT   (0x0000000Du)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_ACK_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_ACK_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_DOWNSPREAD   (0x00004000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_DOWNSPREAD_SHIFT   (0x0000000Eu)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_DOWNSPREAD_FULL_SPREAD   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_DOWNSPREAD_LOW_SPREAD   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_EN   (0x00001000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_EN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_EN_DISABLED   (0x0u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_EN_ENABLED   (0x1u)

#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_TYPE   (0x00008000u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_TYPE_SHIFT   (0x0000000Fu)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_TYPE_SQUARE   (0x1u)
#define CM_WKUP_CM_CLKMODE_DPLL_DISP_DPLL_SSC_TYPE_TRIANGULAR   (0x0u)


/* CM_CLKSEL_DPLL_PERIPH */
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_DIV   (0x000000FFu)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_DIV_SHIFT   (0x00000000u)

#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_MULT   (0x000FFF00u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_MULT_SHIFT   (0x00000008u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_MULT_0   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_MULT_1   (0x1u)

#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_SD_DIV   (0xFF000000u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_SD_DIV_SHIFT   (0x00000018u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_SD_DIV_RESERVED   (0x0u)
#define CM_WKUP_CM_CLKSEL_DPLL_PERIPH_DPLL_SD_DIV_RESERVED1   (0x1u)


/* CM_DIV_M2_DPLL_DDR */
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_DPLL_CLKOUT_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M2_DPLL_DDR_ST_DPLL_CLKOUT   (0x00000200u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_ST_DPLL_CLKOUT_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_ST_DPLL_CLKOUT_CLK_ENABLED   (0x1u)
#define CM_WKUP_CM_DIV_M2_DPLL_DDR_ST_DPLL_CLKOUT_CLK_GATED   (0x0u)


/* CM_DIV_M2_DPLL_DISP */
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_DPLL_CLKOUT_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M2_DPLL_DISP_ST_DPLL_CLKOUT   (0x00000200u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_ST_DPLL_CLKOUT_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_ST_DPLL_CLKOUT_CLK_ENABLED   (0x1u)
#define CM_WKUP_CM_DIV_M2_DPLL_DISP_ST_DPLL_CLKOUT_CLK_GATED   (0x0u)


/* CM_DIV_M2_DPLL_MPU */
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_DPLL_CLKOUT_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M2_DPLL_MPU_ST_DPLL_CLKOUT   (0x00000200u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_ST_DPLL_CLKOUT_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_ST_DPLL_CLKOUT_CLK_ENABLED   (0x1u)
#define CM_WKUP_CM_DIV_M2_DPLL_MPU_ST_DPLL_CLKOUT_CLK_GATED   (0x0u)


/* CM_DIV_M2_DPLL_PER */
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_DIV   (0x0000007Fu)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_DIVCHACK   (0x00000080u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_DIVCHACK_SHIFT   (0x00000007u)

#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_DPLL_CLKOUT_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M2_DPLL_PER_ST_DPLL_CLKOUT   (0x00000200u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_ST_DPLL_CLKOUT_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_ST_DPLL_CLKOUT_CLK_ENABLED   (0x1u)
#define CM_WKUP_CM_DIV_M2_DPLL_PER_ST_DPLL_CLKOUT_CLK_GATED   (0x0u)


/* WKUP_M3_CLKCTRL */
#define CM_WKUP_WKUP_M3_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_WKUP_M3_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_WKUP_M3_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_WKUP_M3_CLKCTRL_MODULEMODE_DISABLE  (0x0u)

#define CM_WKUP_WKUP_M3_CLKCTRL_STBYST   (0x00040000u)
#define CM_WKUP_WKUP_M3_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_WKUP_WKUP_M3_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_WKUP_WKUP_M3_CLKCTRL_STBYST_STANDBY   (0x1u)


/* UART0_CLKCTRL */
#define CM_WKUP_UART0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_UART0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_UART0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_UART0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_UART0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_UART0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_UART0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_UART0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_UART0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_UART0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_UART0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_UART0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* I2C0_CLKCTRL */
#define CM_WKUP_I2C0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_I2C0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_I2C0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_WKUP_I2C0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_I2C0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_I2C0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_I2C0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* ADC_TSC_CLKCTRL */
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_ADC_TSC_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_ADC_TSC_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* SMARTREFLEX0_CLKCTRL */
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_SMARTREFLEX0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER1_CLKCTRL */
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_TIMER1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_TIMER1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* SMARTREFLEX1_CLKCTRL */
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_SMARTREFLEX1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* CM_L4_WKUP_AON_CLKSTCTRL */
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKACTIVITY_L4_WKUP_AON_GCLK   (0x00000004u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKACTIVITY_L4_WKUP_AON_GCLK_SHIFT   (0x00000002u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKACTIVITY_L4_WKUP_AON_GCLK_ACT   (0x1u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKACTIVITY_L4_WKUP_AON_GCLK_INACT   (0x0u)

#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL_SW_WKUP    (0x2u)
#define CM_WKUP_CM_L4_WKUP_AON_CLKSTCTRL_CLKTRCTRL_HW_AUTO    (0x3u)

/* WDT0_CLKCTRL */
#define CM_WKUP_WDT0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_WDT0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_WDT0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_WDT0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_WDT0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_WDT0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_WDT0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* WDT1_CLKCTRL */
#define CM_WKUP_WDT1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_WKUP_WDT1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_WKUP_WDT1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_WKUP_WDT1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_WKUP_WDT1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_WKUP_WDT1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_WKUP_WDT1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* CM_DIV_M6_DPLL_CORE */
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_DIV   (0x0000001Fu)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_DIV_SHIFT   (0x00000000u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_DIV_RESERVED   (0x0u)

#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_DIVCHACK   (0x00000020u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_DIVCHACK_SHIFT   (0x00000005u)

#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_GATE_CTRL   (0x00000100u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_GATE_CTRL_SHIFT   (0x00000008u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_GATE_CTRL_CLK_AUTOGATE   (0x0u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_GATE_CTRL_CLK_ENABLE   (0x1u)

#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_PWDN   (0x00001000u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_PWDN_SHIFT   (0x0000000Cu)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_PWDN_ALWAYS_ACTIVE   (0x0u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_HSDIVIDER_CLKOUT3_PWDN_AUTO_PWDN   (0x1u)

#define CM_WKUP_CM_DIV_M6_DPLL_CORE_ST_HSDIVIDER_CLKOUT3   (0x00000200u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_ST_HSDIVIDER_CLKOUT3_SHIFT   (0x00000009u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_ST_HSDIVIDER_CLKOUT3_CLK_ENABLED   (0x0u)
#define CM_WKUP_CM_DIV_M6_DPLL_CORE_ST_HSDIVIDER_CLKOUT3_CLK_GATED   (0x1u)



#endif
