/*
    main.c

 */

/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

/* TI-RTOS Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/UART.h>

/* Example/Board Header files */
#include "Board.h"

/*
 * idle task
 */
int doIdle()
{
    System_printf("idle started!\n");
    System_flush();
	while(1)
	{
		Task_sleep(500);
		GPIO_toggle(Board_LED0);
	}
}

/*
 *  ======== main ========
 */
int main(void)
{
    /* Call board init functions */
    Board_initGeneral();
    Board_initGPIO();
    Board_initUART();

    /* Turn on user LED */
    GPIO_write(Board_LED0, Board_LED_ON);

    System_printf("Go!\n");
    System_flush();

    /* Start BIOS */
    BIOS_start();

    return (0);
}
