import os
import onnx
import onnxruntime as ort
import numpy as np

optional_options = {
    "platform": "J7",

    "tensor_bits": 8,
    "debug_level": 2,
    "accuracy_level": 1,

    "deny_list:layer_type": "MaxPool", 
    "deny_list:layer_name": "",

    "advanced_options:inference_mode" : 0,
    "advanced_options:num_cores" : 1,

    
    "advanced_options:calibration_frames": 1,
    "advanced_options:calibration_iterations": 1,
    "advanced_options:output_feature_16bit_names_list" : "",
    "advanced_options:params_16bit_names_list" : "",
    "advanced_options:mixed_precision_factor" :  -1,

    "advanced_options:quantization_scale_type": 0,
    "advanced_options:high_resolution_optimization": 0,
    "advanced_options:add_data_convert_ops": 3,
    "advanced_options:network_name": "test",
    "model_type": "", #OD
    "ti_internal_nc_flag": 1601,
}

required_options = {
    "tidl_tools_path":'/home/root/edgeai-tidl-tools/tidl_tools',
    "artifacts_folder":'/home/root/host/model_infer/test/model-artifacts'
}

if __name__ == "__main__":

    model_path = "test/test.onnx"
    onnx.shape_inference.infer_shapes_path(model_path, model_path)

    delegate_options = {}
    delegate_options.update(required_options)
    delegate_options.update(optional_options)
    os.makedirs(delegate_options['artifacts_folder'], exist_ok=True)
    for root, dirs, files in os.walk(delegate_options['artifacts_folder'], topdown=False):
        [os.remove(os.path.join(root, f)) for f in files]
        [os.rmdir(os.path.join(root, d)) for d in dirs]
    
    so = ort.SessionOptions()

    EP_list = ['TIDLCompilationProvider','CPUExecutionProvider']
    sess = ort.InferenceSession(model_path ,providers=EP_list, provider_options=[delegate_options, {}], sess_options=so)
    
    image = np.zeros((1, 3, 256, 256), dtype=np.float32)

    blobs = sess.run(None, {"input": image})

    pass
