#include<stdio.h>
#include<string.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <errno.h>

#define BLK_16K 1000
#define OCMC_RAM_BASE 0x40400000

int main(void){
  volatile int *addrPtr = NULL;
  int shMemFd = 0;
  int i =0;	
  shMemFd = open("/dev/mem",O_RDWR| O_SYNC);
  if(shMemFd > 0)
  {
    addrPtr = mmap(NULL,BLK_16K,PROT_READ|PROT_WRITE,MAP_FILE
        |MAP_SHARED,shMemFd,OCMC_RAM_BASE);
    if (addrPtr == MAP_FAILED)
    {
      printf("SHMEM: Memory map failed::%s\n",strerror(errno));
      close(shMemFd);
      addrPtr = NULL;
    }else{
      printf("SHMEM: Virtual addr=%p Phy addr=%p\n",addrPtr,OCMC_RAM_BASE);

    }
  }
  else
  {
    printf("SHMEM: Memory device open fail::%s\n",strerror(errno));
  }
  //	memset(addrPtr,'A',BLK_16K);
  //printf("addrPtr[0] = %c addrPtr[32] =%c\n",*(addrPtr),*(addrPtr +32 ));

  for(i=0;i<250;i++){
    printf("address=%p,value=%x\n",(addrPtr+i),*(addrPtr+i));
//    if(i%16 == 0){
//      printf("\n");
//    }
  }
  printf("\n");
  printf("Memory is being written with constant value\n");  
//  memset(addrPtr,100,BLK_16K);
  if(0 == munmap((void *)addrPtr,BLK_16K)){
    printf("SHMEM: Memory unmap\n");
  }else{
    printf("SHMEM: Memory unmap fail::%s\n",strerror(errno));

  }

}
