/****************************************************************************/
/*                                                                          */
/*              EDMA3 һά                                          */
/*                                                                          */
/*              20140724                                              */
/*                                                                          */
/****************************************************************************/
#include "hw_types.h"
#include "hw_psc_C6748.h"
#include "soc_C6748.h"
#include "edma.h"
#include "psc.h"
#include "uartStdio.h"

#include <ti/sysbios/hal/Hwi.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/family/c64p/Cache.h>

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
//  ACOUNT
#define MAX_ACOUNT        (10u)

//  BCOUNT
#define MAX_BCOUNT        (10u)

//  CCOUNT
#define MAX_CCOUNT        (1u)

#define MAX_BUFFER_SIZE   (MAX_ACOUNT * MAX_BCOUNT * MAX_CCOUNT)

/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
volatile int irqRaised;

// 
unsigned int chType     = EDMA3_CHANNEL_TYPE_DMA;
unsigned int chNum      = 0;
unsigned int tccNum     = 0;
unsigned int edmaTC     = 0;
unsigned int syncType   = EDMA3_SYNC_A;
unsigned int trigMode   = EDMA3_TRIG_MODE_MANUAL;
unsigned int evtQ       = 0; // ʹõ¼

volatile char _srcBuff[MAX_BUFFER_SIZE];
volatile char _dstBuff[MAX_BUFFER_SIZE];

volatile char *srcBuff;
volatile char *dstBuff;

/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/
// ص
void (*cb_Fxn[EDMA3_NUM_TCC])(unsigned int tcc, unsigned int status, void *appData);

/****************************************************************************/
/*                                                                          */
/*              ص                                                    */
/*                                                                          */
/****************************************************************************/
void callback(unsigned int tccNum, unsigned int status, void *appData)
{
    (void)tccNum;
    (void)appData;
    
    if(EDMA3_XFER_COMPLETE == status)
    {
		// ɹ
        irqRaised = 1;
    }

    else if(EDMA3_CC_DMA_EVT_MISS == status)
    {
		// 䵼 DMA ¼ʧ
		irqRaised = -1;
    }
     
    else if(EDMA3_CC_QDMA_EVT_MISS == status)
    {
    	// 䵼 QDMA ¼ʧ
		irqRaised = -2;
    }

    irqRaised = 1;
}

/****************************************************************************/
/*                                                                          */
/*              PSC ʼ                                                  */
/*                                                                          */
/****************************************************************************/
void PSCInit(void)
{
    // ʹ EDMA3CC_0
    PSCModuleControl(SOC_PSC_0_REGS, 0, 0, PSC_MDCTL_NEXT_ENABLE);

    // ʹ EDMA3TC_0
    PSCModuleControl(SOC_PSC_0_REGS, 1, 0, PSC_MDCTL_NEXT_ENABLE);
}

/****************************************************************************/
/*                                                                          */
/*              EDMA3                                                   */
/*                                                                          */
/****************************************************************************/
unsigned int EDMA3Test()
{
    volatile unsigned int index = 0;
    volatile unsigned int count = 0;

    EDMA3CCPaRAMEntry paramSet;

    unsigned char data = 0u;
    unsigned int retVal = 0u;
    unsigned int Istestpassed = 0u;
    unsigned int numenabled = 0u;
    unsigned int acnt = MAX_ACOUNT;
    unsigned int bcnt = MAX_BCOUNT;
    unsigned int ccnt = MAX_CCOUNT;

    srcBuff = (char *)_srcBuff;
    dstBuff = (char *)_dstBuff;

    // ʼԴĿ껺
    for(count = 0u; count < (acnt*bcnt*ccnt); count++)
    {
    	srcBuff[count] = data++;
    }

    //  DMA ͨ TCC
    retVal = EDMA3RequestChannel(SOC_EDMA30CC_0_REGS, chType, chNum, tccNum, evtQ);

    // עص
    cb_Fxn[tccNum] = &callback;

    if(TRUE == retVal)
    {
        //  RAM ֵ
        paramSet.srcAddr  = (unsigned int)(srcBuff);
        paramSet.destAddr = (unsigned int)(dstBuff);
    
        paramSet.aCnt = (unsigned short)acnt;
        paramSet.bCnt = (unsigned short)bcnt;
        paramSet.cCnt = (unsigned short)ccnt;

        //  SRC / DES 
        paramSet.srcBIdx = (short)acnt;
        paramSet.destBIdx = (short)acnt;

        if(syncType == EDMA3_SYNC_A)
        {
			// A Sync ģʽ
			paramSet.srcCIdx = (short)acnt;
			paramSet.destCIdx = (short)acnt;
        }
        else
        {
			// AB Sync ģʽ
			paramSet.srcCIdx = ((short)acnt * (short)bcnt);
            paramSet.destCIdx = ((short)acnt * (short)bcnt);
        }

        paramSet.linkAddr = (unsigned short)0xFFFFu;
        paramSet.bCntReload = (unsigned short)0u;
        paramSet.opt = 0u;
        // Src  Dest ʹ INCR ģʽ
        paramSet.opt &= 0xFFFFFFFCu;
        //  TCC
        paramSet.opt |= ((tccNum << EDMA3CC_OPT_TCC_SHIFT) & EDMA3CC_OPT_TCC);

        // ʹ Intermediate & Final ж
        paramSet.opt |= (1 << EDMA3CC_OPT_ITCINTEN_SHIFT);
        paramSet.opt |= (1 << EDMA3CC_OPT_TCINTEN_SHIFT);

        if(syncType == EDMA3_SYNC_A)
		{
        	paramSet.opt &= 0xFFFFFFFBu;
		}
        else
		{
		    // AB Sync ģʽ
        	paramSet.opt |= (1 << EDMA3CC_OPT_SYNCDIM_SHIFT);
		}

        // д RAM
        EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, chNum, &paramSet);
    }

    if(TRUE == retVal)
    {
        if (syncType == EDMA3_SYNC_A)
		{
        	numenabled = bcnt * ccnt;
		}
        else
		{
			// AB Sync ģʽ
			numenabled = ccnt;
		}
    
        for(index = 0; index < numenabled; index++)
		{
			irqRaised = 0;
			// 
			Cache_wbInv(&_srcBuff, MAX_BUFFER_SIZE, Cache_Type_ALLD, true);
			// ռĴʹܴ
			retVal = EDMA3EnableTransfer(SOC_EDMA30CC_0_REGS, chNum, EDMA3_TRIG_MODE_MANUAL);
			// 
			Cache_wbInv(&_dstBuff, MAX_BUFFER_SIZE, Cache_Type_ALLD, true);
			if(TRUE != retVal)
			{
				UARTPuts("edma3Test: EDMA3EnableTransfer Failed.\r\n", -1);
				break;
			}

			// ȴжϷִ
			while(irqRaised == 0u)
			{

			}

			// ⴫״̬
			if(irqRaised < 0)
			{
				// ʱֹ
				UARTPuts("\r\nedma3Test: Event Miss Occured!!!\r\n", -1);

				// ־λ
				EDMA3ClearErrorBits(SOC_EDMA30CC_0_REGS, chNum, evtQ);
				break;
			}
		}
    }

    // У
    if(TRUE == retVal)
    {
        for (index = 0; index < (acnt*bcnt*ccnt); index++)
        {
            if (srcBuff[index] != dstBuff[index])
            {
                Istestpassed = 0u;
                UARTPuts("edma3Test: Data write-read matching FAILED.\r\n", -1);
                UARTPuts("The mismatch happened at index : ", -1);
                UARTPutNum((int)index + 1);
                UARTPuts("\r\n", -1);
                break;
            }
        }

        if(index == (acnt*bcnt*ccnt))
        {
            Istestpassed = 1u;
            UARTPuts("edma3Test: Data write-read matching PASSED.\r\n", -1);
        }
    
        // ͷǰͨ
        retVal = EDMA3FreeChannel(SOC_EDMA30CC_0_REGS, EDMA3_CHANNEL_TYPE_DMA, chNum, EDMA3_TRIG_MODE_MANUAL, tccNum, evtQ);
        
        // ȡעص
        cb_Fxn[tccNum] = NULL;

        if (TRUE != retVal)
        {
            UARTPuts("edma3Test: EDMA3_DRV_freeChannel() FAILED.\r\n", -1); 
        }
    }

    if(Istestpassed == 1u)
    {
        UARTPuts("edma3Test PASSED.\r\n", -1);
        retVal = TRUE;
    }
    else
    {
        UARTPuts("edma3Test FAILED\r\n", -1);
        retVal = FALSE;
    }

    return retVal;
}

/****************************************************************************/
/*                                                                          */
/*              EDMA3 жɷ                                      */
/*                                                                          */
/****************************************************************************/
Void EDMA3CCComplIsr(UArg arg)
{
    volatile unsigned int pendingIrqs;
    volatile unsigned int isIPR = 0;

    unsigned int indexl;
    unsigned int Cnt = 0;
    indexl = 1u;

    isIPR = EDMA3GetIntrStatus(SOC_EDMA30CC_0_REGS);
    if(isIPR)
    {
        while ((Cnt < EDMA3CC_COMPL_HANDLER_RETRY_COUNT)&& (indexl != 0u))
		{
			indexl = 0u;
			pendingIrqs = EDMA3GetIntrStatus(SOC_EDMA30CC_0_REGS);
			while (pendingIrqs)
			{
				if(TRUE == (pendingIrqs & 1u))
				{
					// ûָص ޷ IPR Ӧλ
					// д ICR  IPR Ӧλ
					EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, indexl);
					(*cb_Fxn[indexl])(indexl, EDMA3_XFER_COMPLETE, NULL);
				}

				++indexl;
				pendingIrqs >>= 1u;
			}

			Cnt++;
		}
    }
}

/****************************************************************************/
/*                                                                          */
/*              EDMA3 жϴ                                      */
/*                                                                          */
/****************************************************************************/
Void EDMA3CCErrIsr(UArg arg)
{
    volatile unsigned int pendingIrqs;
    unsigned int Cnt = 0u;
    unsigned int index;
    unsigned int evtqueNum = 0;  // ¼Ŀ

    pendingIrqs = 0u;
    index = 1u;

    if((EDMA3GetErrIntrStatus(SOC_EDMA30CC_0_REGS) != 0 )
        || (EDMA3QdmaGetErrIntrStatus(SOC_EDMA30CC_0_REGS) != 0)
        || (EDMA3GetCCErrStatus(SOC_EDMA30CC_0_REGS) != 0))
    {
        // ѭ EDMA3CC_ERR_HANDLER_RETRY_COUNT 
    	// ֱûеȴежʱֹ
        while ((Cnt < EDMA3CC_ERR_HANDLER_RETRY_COUNT) && (index != 0u))
        {
            index = 0u;
            pendingIrqs = EDMA3GetErrIntrStatus(SOC_EDMA30CC_0_REGS);

            while (pendingIrqs)
            {
				// ִеȴеж
				if(TRUE == (pendingIrqs & 1u))
				{
					//  SER
					EDMA3ClrMissEvt(SOC_EDMA30CC_0_REGS, index);
				}
					++index;
					pendingIrqs >>= 1u;
			}

			index = 0u;
			pendingIrqs = EDMA3QdmaGetErrIntrStatus(SOC_EDMA30CC_0_REGS);

			while (pendingIrqs)
			{
				// ִеȴеж
				if(TRUE == (pendingIrqs & 1u))
				{
					//  SER
					EDMA3QdmaClrMissEvt(SOC_EDMA30CC_0_REGS, index);
				}
				++index;
				pendingIrqs >>= 1u;
			}

			index = 0u;
			pendingIrqs = EDMA3GetCCErrStatus(SOC_EDMA30CC_0_REGS);

			if (pendingIrqs != 0u)
			{
				// ִеȴе CC ж
				// ¼ ڴ
				for (evtqueNum = 0u; evtqueNum < SOC_EDMA3_NUM_EVQUE; evtqueNum++)
				{
					if((pendingIrqs & (1u << evtqueNum)) != 0u)
					{
						// ж
						EDMA3ClrCCErr(SOC_EDMA30CC_0_REGS, (1u << evtqueNum));
					}
				}

				// ɴ
				if ((pendingIrqs & (1 << EDMA3CC_CCERR_TCCERR_SHIFT)) != 0u)
				{
					EDMA3ClrCCErr(SOC_EDMA30CC_0_REGS, (0x01u << EDMA3CC_CCERR_TCCERR_SHIFT));
				}

				++index;
			}

			Cnt++;
        }
    }    
}

/****************************************************************************/
/*                                                                          */
/*                                                                      */
/*                                                                          */
/****************************************************************************/
Void smain(UArg a0, UArg a1)
{
    EDMA3Init(SOC_EDMA30CC_0_REGS, evtQ);

    volatile unsigned int status = FALSE;
    status = EDMA3Test();

    EDMA3Deinit(SOC_EDMA30CC_0_REGS, evtQ);

    if (TRUE == status)
    {
        UARTPuts("\r\nEDMA/QDMA application is successfully completed.\r\n", -1);
    }
    else
    {
        UARTPuts("\r\nEDMA/QDMA application is unsuccessful.\r\n", -1);
    }
}

/****************************************************************************/
/*                                                                          */
/*                                                                    */
/*                                                                          */
/****************************************************************************/
int main(void)
{
	// ʹ
	PSCInit();

	// ն˳ʼ
   	UARTStdioInit();

   	UARTPuts("Tronlong EDMA / QDMA Application......\r\n\r\n", -1);

    //  SYS/BIOS ϵͳ
    BIOS_start();

    return(0);
}
