/****************************************************************************/
/*  C6745.cmd                                                               */
/*  Copyright (c) 2012  Texas Instruments Incorporated                      */
/*  Author: Rafael de Souza                                                 */
/*                                                                          */
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an C6745              */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific          */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/****************************************************************************/
-c
-heap  0x1000
-stack 0x1000

MEMORY
{
    DSPL2ROM     o = 0x00700000  l = 0x00100000     /* 1MB L2 Internal ROM */                
    DSPL2RAM     o = 0x00800000  l = 0x00040000     /* 256kB L2 Internal RAM */              
    DSPL1PRAM    o = 0x00E00000  l = 0x00008000     /* 32kB L1 Internal Program RAM */        
    DSPL1DRAM    o = 0x00F00000  l = 0x00008000     /* 32kB L1 Internal Data RAM */           
    SHDSPL2ROM   o = 0x11700000  l = 0x00100000     /* 1MB L2 Shared Internal ROM */
    SHDSPL2RAM   o = 0x11800000  l = 0x00040000     /* 256kB L2 Shared Internal RAM */
    SHDSPL1PRAM  o = 0x11E00000  l = 0x00008000     /* 32kB L1 Shared Internal Program RAM */
    SHDSPL1DRAM  o = 0x11F00000  l = 0x00008000     /* 32kB L1 Shared Internal Data RAM */
    EMIFACS2     o = 0x60000000  l = 0x02000000     /* 32MB Async Data (CS2) */              
    //EMIFACS3     o = 0x62000000  l = 0x02000000     /* 32MB Async Data (CS3) */
    //EMIFACS4     o = 0x64000000  l = 0x02000000     /* 32MB Async Data (CS4) */
    //EMIFACS5     o = 0x66000000  l = 0x02000000     /* 32MB Async Data (CS5) */
    //EMIFBSDRAM   o = 0xC0000000  l = 0x10000000     /* 256MB SDRAM Data */
}                                                                       

SECTIONS
{
	.text          >  DSPL2RAM
    .text:_c_int00: align=1024        >       0x00800000

    .stack         >  DSPL2RAM
    .bss           >  DSPL2RAM
    .cio           >  DSPL2RAM
    .const         >  DSPL2RAM
    .data          >  DSPL2RAM
    .switch        >  DSPL2RAM
    .sysmem        >  DSPL2RAM
    .far           >  DSPL2RAM
    .args          >  DSPL2RAM
    .ppinfo        >  DSPL2RAM
    .ppdata        >  DSPL2RAM
  
    /* COFF sections */
    .pinit         >  DSPL2RAM
    .cinit         >  DSPL2RAM
  
    /* EABI sections */
    .binit         >  DSPL2RAM
    .init_array    >  DSPL2RAM
    .neardata      >  DSPL2RAM
    .fardata       >  DSPL2RAM
    .rodata        >  DSPL2RAM
    .c6xabi.exidx  >  DSPL2RAM
    .c6xabi.extab  >  DSPL2RAM

    .vecs align=1024         >  DSPL2RAM
}
