#include <stdio.h>

#include <c6x.h>
#include <soc_C6747.h>
#include <csl.h>
#include <cslr_syscfg_C6747.h>
#include <cslr_psc_C6747.h>
#include <cslr_gpio.h>
#include <cslr_dspintc.h>

/*----------------------------------------------------------------------*/

extern void intcVectorTable(void);
void setup_System (void);
int setup_GPIO (void);
void ctr_PIN(Bool out_state);

/*----------------------------------------------------------------------*/

int main(void)
{
	uint32_t k;

	setup_System();
	setup_GPIO();

	while(1)
	{

		ctr_PIN(FALSE);
    	k=10000;
    	while(k--);

    	ctr_PIN(TRUE);
    	k=10000;
    	while(k--);

	}
}
/*----------------------------------------------------------------------*/
void ctr_PIN(Bool out_state)
{
	/* Gpio register overlay */
	CSL_GpioRegsOvly     gpioRegs = (CSL_GpioRegsOvly)(CSL_GPIO_0_REGS);

	if(out_state==TRUE)
	{
		gpioRegs->BANK[GP3].SET_DATA |= GP3P1;
		asm("	 nop 2");
	}
	else
	{
		gpioRegs->BANK[GP3].CLR_DATA |= GP3P1;
		asm("	 nop 2");
	}
}
/*----------------------------------------------------------------------*/
int setup_GPIO (void)
{
    volatile int pscTimeoutCount = 10240;
    volatile Uint32 temp = 0;

	/* sys config registers overlay */
	CSL_SyscfgRegsOvly   sysRegs  = (CSL_SyscfgRegsOvly)(CSL_SYSCFG_0_REGS);
	/* Psc register overlay */
	CSL_PscRegsOvly      psc1Regs = (CSL_PscRegsOvly)(CSL_PSC_1_REGS);

    /* Key to be written to enable the pin mux registers to be written        */
    sysRegs->KICK0R = 0x83e70b13;
    sysRegs->KICK1R = 0x95A4F1E0;

	//GPIO
	sysRegs->PINMUX10  = (
			(CSL_SYSCFG_PINMUX10_PINMUX10_7_4_GPIO3_0   << CSL_SYSCFG_PINMUX10_PINMUX10_7_4_SHIFT) |
			(CSL_SYSCFG_PINMUX10_PINMUX10_11_8_GPIO3_1  << CSL_SYSCFG_PINMUX10_PINMUX10_11_8_SHIFT)
			);

    /* Bring the GPIO module out of sleep state                                 */
     /* Configure the GPIO Module to Enable state */
     psc1Regs->MDCTL[CSL_PSC_GPIO] =
                                 ( (psc1Regs->MDCTL[CSL_PSC_GPIO] & 0xFFFFFFE0) | \
                                    CSL_PSC_MDSTAT_STATE_ENABLE );

     /* Kick start the Enable Command */
     temp = psc1Regs->PTCMD;
     temp = ( (temp & CSL_PSC_PTCMD_GO0_MASK) |
              (CSL_PSC_PTCMD_GO0_SET << CSL_PSC_PTCMD_GO0_SHIFT) );
     psc1Regs->PTCMD |= temp;

     /*Wait for the power state transition to occur */
     pscTimeoutCount = 10240u;
     while ( ((psc1Regs->PTSTAT & (CSL_PSC_PTSTAT_GOSTAT0_IN_TRANSITION)) != 0)
                        && (pscTimeoutCount>0) )
     {
         pscTimeoutCount--;
     }

     /* Check if PSC state transition timed out */
     if(pscTimeoutCount == 0)
     {
         //printf("PSC transition to ON state timed out\n");
         return -1;
     }

 	/* Gpio register overlay */
 	CSL_GpioRegsOvly     gpioRegs = (CSL_GpioRegsOvly)(CSL_GPIO_0_REGS);

 	/* Configure GPIO3_0 (GPIO3_0_PIN) as an input */
 	CSL_FINS(gpioRegs->BANK[GP3].DIR,GPIO_DIR_DIR0,CSL_GPIO_DIR_DIR_IN);

 	/* Configure GPIO3_1 (GPIO3_1_PIN) as an output */
 	CSL_FINS(gpioRegs->BANK[GP3].DIR,GPIO_DIR_DIR1,CSL_GPIO_DIR_DIR_OUT);

 	/* Configure GPIO3 to generate interrupt */
 	//CSL_FINST(gpioRegs->BINTEN,GPIO_BINTEN_EN3,ENABLE);

    sysRegs->KICK0R = 0;
    sysRegs->KICK1R = 0;

    return 0;
}
/*----------------------------------------------------------------------*/
void setup_System (void)
{
	/* set ISTP to point to the vector table address                            */
	ISTP = (unsigned int)intcVectorTable;

	/* clear all interrupts, bits 4 thru 15                                     */
	ICR = 0xFFF0;

	/* enable the bits for non maskable interrupt and CPUINT4                   */
	IER |= 0x12;

	/* enable interrupts, set GIE bit                                           */
	_enable_interrupts();

	asm("	 swe");
}
/*----------------------------------------------------------------------*/
