

#include <ti/csl/csl_tmr.h>



static unsigned int ReadTime32(void)
{
    unsigned int timeVal;

    __asm__ __volatile__ ("MRC p15,0,%0,c9,c13,0\t\n" : "=r"(timeVal));

    return timeVal;


}

void CycleDelay(unsigned int iCount)
{
    if(iCount <=0)
    {
        return;
    }
    unsigned int start = ReadTime32();

    while((ReadTime32() - start) < iCount);
}




#define CSL_GPIO_CFG_REGS   0x0260BF00
#define CSL_GPIO_DIR        (*(unsigned int*)(CSL_GPIO_CFG_REGS + 0x010))
#define GPIO_SET_DATA       (*(unsigned int*)(CSL_GPIO_CFG_REGS + 0x018))
#define GPIO_CLEAR_DATA     (*(unsigned int*)(CSL_GPIO_CFG_REGS + 0x01C))



int main(void)
{
    int i;



    CSL_GPIO_DIR = 0xFFFE;

    while(1)
    {
        GPIO_SET_DATA = 0x1;
        CycleDelay(1000);
        GPIO_CLEAR_DATA = 0x1;
        for (i=0;i<100;i++);
    }



	return 0;
}


