/*
* module name       : c7x_cellSum_4x4
*
* module descripton : Computes 4x4 non-overlapping cell sums
*
* Copyright (C) 2015-2019 Texas Instruments Incorporated - http://www.ti.com/
*
* ALL RIGHTS RESERVED
*/

--heap_size  0x2000
--stack_size 0x2000

MEMORY
{
	L2SRAM_CINIT	: org = 0x64800000, len = 0x0000000100
	L2SRAM (RWX)	: org = 0x64800100, len = 0x000007FF00
	L1DSRAM (RWX)	: org = 0x64E00000, len = 0x0000004000
	MSMCSRAM (RWX)	: org = 0x70000000, len = 0x0000800000
	INT_VECTOR_SS	: org = 0x80100000, len = 0x0000100000
	INT_VECTOR_S	: org = 0x81000000, len = 0x0000100000
	INT_VECTOR_GS	: org = 0x82000000, len = 0x0000100000
	INT_ECQ_SS		: org = 0x83000000, len = 0x0000100000
	INT_ECQ_S		: org = 0x84000000, len = 0x0000100000
	INT_ECQ_GS		: org = 0x85000000, len = 0x0000100000
	INT_ECQ_TCSP	: org = 0x86000000, len = 0x0000100000
	INT_STACK_SS	: org = 0x87000000, len = 0x0000100000
	INT_STACK_S		: org = 0x88000000, len = 0x0000100000
	INT_STACK_GS	: org = 0x89000000, len = 0x0000100000
	EXTMEM (RWX)	: org = 0x8A000000, len = 0x0076000000
}

SECTIONS
{
  .text:_c_int00:   > L2SRAM_CINIT
  .text:            > L2SRAM
  .text:touch:      > L2SRAM
  .neardata:        > L2SRAM
  .rodata:          > L2SRAM
  .bss:             > L2SRAM
  .init_array:      > L2SRAM
  .far:             > L2SRAM
  .fardata:         > L2SRAM
  .neardata         > L2SRAM
  .rodata           > L2SRAM
  .data:            > L2SRAM
  .switch:          > L2SRAM
  .stack:           > L2SRAM
  .args:            > L2SRAM align = 0x4, fill = 0 {_argsize = 0x200; }
  .sysmem:          > L2SRAM
  .cinit:           > L2SRAM
  .const:           > L2SRAM START(const_start) SIZE(const_size)
  .pinit:           > L2SRAM
  .cio:             > L2SRAM
  .stack:           > L2SRAM
  .locMatData       > L2SRAM
  .hogRefData       > L2SRAM
  .hogOutData       > L2SRAM
  .tmp1Data         > L2SRAM
  .tmp2Data         > L2SRAM
  .pOutSum          > L2SRAM
  .profile          > L2SRAM
  .pOutData         > L2SRAM
  .pBlock           > L2SRAM
   xdc.meta:        > L2SRAM, type = COPY

	.ss_vectors		> INT_VECTOR_SS
	.ss_evtstack	> INT_STACK_SS
	.ss_evtecq		> INT_ECQ_SS
	.s_vectors		> INT_VECTOR_S
	.s_evtstack		> INT_STACK_S
	.s_evtecq		> INT_ECQ_S
	.gs_vectors		> INT_VECTOR_GS
	.gs_evtstack	> INT_STACK_GS
	.gs_evtecq		> INT_ECQ_GS
	.tcsp_evtecq	> INT_ECQ_TCSP
}
