#include <c7x.h>
#include <stdio.h>


extern __cregister volatile unsigned long __GTSC;
extern "C" uint64_t drvReadGTSC();
extern "C" uint64_t drvResetTimer();

int main()
{
	uint64_t* pTimer = (uint64_t*)0x00A90000;	// GTC0_GTC_CFG1
	*pTimer = 1;

	uint64_t globalTime0 = __GTSC;
	uint64_t shadowTime0 = __STSC;
	uint64_t localTime0 = __TSC;

	uint64_t globalTime1 = drvReadGTSC();
	uint64_t shadowTime1 = __STSC;
	uint64_t localTime1 = __TSC;

	drvResetTimer();

	uint64_t shadowTime2 = __STSC;
	uint64_t globalTime2 = __GTSC;
	uint64_t localTime2 = __TSC;

	printf("===============\r\n");
	printf("GTSC(0):0x%016llx\r\n", globalTime0);
	printf("STSC(0):0x%016llx\r\n", shadowTime0);
	printf("TSC(0):0x%016llx\r\n", localTime0);
	printf("===============\r\n");
	printf("GTSC(1):0x%016llx\r\n", globalTime1);
	printf("STSC(1):0x%016llx\r\n", shadowTime1);
	printf("TSC(1):0x%016llx\r\n", localTime1);
	printf("===============\r\n");
	printf("GTSC(2):0x%016llx\r\n", globalTime2);
	printf("STSC(2):0x%016llx\r\n", shadowTime2);
	printf("TSC(2):0x%016llx\r\n", localTime2);

	return 0;
}
