/*
*
* Copyright (c) {2015 - 2017} Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#ifndef TIDL_IMPORT_COMMONH_
#define TIDL_IMPORT_COMMONH_ 1

#include "perfsim.h"

int32_t TIDL_QuantizeUnsignedMax(uint8_t * params, float * data, int32_t dataSize, float min, float max, int32_t weightsElementSizeInBits);

int32_t TIDL_normalize(float data, float min, float max);

bool TIDL_readProtoFromTextFile(const char* fileName, Message* proto);

bool TIDL_readProtoFromBinaryFile(const char* fileName, Message* proto);

int32_t TIDL_getDataID(sTIDL_DataParams_t *data,
sTIDL_OrgNetwork_t * pOrgTIDLNetStructure,
int32_t            numLayer,
int8_t             *bufName);

int32_t TIDL_isDataBufUsed(int32_t           dataId,
sTIDL_Network_t   *pTIDLNetStructure,
int32_t           numLayer);
int32_t TIDL_isInputConv2D(sTIDL_OrgNetwork_t   *pOrgTIDLNetStruct,
int32_t              numLayer,
const char           *bufName);
void TIDL_UpdateInDataBuff(sTIDL_OrgNetwork_t * pOrgTIDLNetStructure,
uint32_t numLayers, sTIDL_DataParams_t dataBuf);

void TIDL_findRange(float * data, int32_t dataSize, float * minOut, float * maxOut, float scale);
int64_t TIDL_roundSat(int64_t val, uint8_t bits, int64_t min, int64_t max);
int32_t TIDL_findSymQ(float  min, float max);
int32_t TIDL_alignParamsWrite(FILE *fp, sBuffer_t * buf, uint32_t *totalParamSize, uint32_t numBytes);
int32_t TIDL_writeModel(sTIDL_Network_t * tIDLNetStructure, sTIDL_OrgNetwork_t * orgTIDLNetStructure, const char * name, uint32_t numLayers);

void  TIDL_fillDataBufPadRequirements(sTIDL_Network_t * tIDLNetStructure);
void * my_malloc(int size);
void my_free(void *ptr);
int32_t TIDL_writeInfo(sTIDL_Network_t * tIDLNetStructure, sTIDL_OrgNetwork_t * orgTIDLNetStructure, const char * name, uint32_t numLayers, uint32_t currLayersGroupId, sPerfSim_t * perfSimInfo);

#define NUM_WHGT_BITS   (gParams.numParamBits)
#define NUM_BIAS_BITS   (8)
#define PRINT_TENSOR_MINMAX (0)
#define LAYER_INFO_FILENAME "layer_info.txt"

template <class Tout>
float TIDL_QuantizeSignedMax(Tout * params, float * data, int32_t dataSize, float min, float max, int32_t weightsElementSizeInBits);
int32_t TIDL_getLayerIdx(sTIDL_OrgNetwork_t * pOrgTIDLNetStructure, int32_t numLayer, const char *bufName);
typedef struct {
  int32_t layerType;
  int32_t(*tidl_tfOutReshape)(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure,
    int32_t              layerIndex);
}sTIDL_tfOutRehapeMap_t;
extern sTIDL_tfOutRehapeMap_t sTIDL_tfOutRehapeTable[];

typedef struct {
  char           *layerName;
  char           *layerOpsString;
  uint32_t       NumOps;
} TIDL_TFLayerMapping_t;

#define TIDL_MAX_HEADS_TF_SSD   (16)
#define TIDL_MAX_AR_PER_HEAD    (16)
#define TIDL_MAX_TF_SSD_LAYERS  (4)
#define TIDL_MAX_TF_FASTER_RCNN_LAYERS  (4)
typedef struct {
  int32_t  num_classes;
  int32_t  num_keypoints;
  int32_t  num_aspect_ratios;
  int32_t  num_layers;
  int32_t  max_detections_per_class;
  int32_t  max_total_detections;
  int32_t  score_converter;
  float    y_scale;
  float    x_scale;
  float    height_scale;
  float    width_scale;
  float    scales[TIDL_MAX_HEADS_TF_SSD + 1];
  float    aspect_ratios[TIDL_MAX_AR_PER_HEAD];
  float    interpolated_scale_aspect_ratio;
  float    reduce_boxes_in_lowest_layer;
  float    base_anchor_height;
  float    base_anchor_width;
  float    height_stride[TIDL_MAX_HEADS_TF_SSD];
  float    width_stride[TIDL_MAX_HEADS_TF_SSD];
  float    height_offset[TIDL_MAX_HEADS_TF_SSD];
  float    width_offset[TIDL_MAX_HEADS_TF_SSD];
  float    score_threshold;
  float    iou_threshold;
} TIDL_TFSSDConfig_t;


extern int32_t gloab_data_format;

typedef struct {
  //:TODO: Rename macros to RCNN
  int32_t num_scales;
  int32_t num_aspect_ratios;
  int32_t max_proposals;
  float    scales[TIDL_MAX_HEADS_TF_SSD + 1];
  float    aspect_ratios[TIDL_MAX_AR_PER_HEAD];
  float    height_stride;/*Anchor stride in height dimension in pixels */
  float    width_stride;/*Anchor stride in width dimension in pixels.*/
  float    height_offset;/*Anchor height offset in pixels.*/
  float    width_offset;/*Anchor width offset in pixels */
  float    width;/*Anchor width in pixels */
  float    height;/*Anchor height in pixels */
  float    nms_score_threshold;
  float    nms_iou_threshold;
} TIDL_TFFasterRCNNFirstStageConfig_t;

typedef struct {
  int32_t max_total_detections;
  int32_t max_detections_per_class;
  float    nms_score_threshold;
  float    nms_iou_threshold;
} TIDL_TFFasterRCNNSecondStageConfig_t;


typedef struct {
  int32_t  number_of_stages;
  int32_t  num_classes;
  int32_t initial_crop_size;
  int32_t maxpool_kernel_size;
  int32_t maxpool_stride;
  TIDL_TFFasterRCNNFirstStageConfig_t firstStageConfig;
  TIDL_TFFasterRCNNSecondStageConfig_t secondStageConfig;
} TIDL_TFFasterRCNNConfig_t;

int32_t TIDL_tfOutReshapeDataLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeConvLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapePoolingLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeIdentity(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeBN(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeRelu(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapePRelu(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeSoftmax(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeIPLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeDeConvLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeConcatLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeSliceLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeCropLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeFlattenLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeArgmaxLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapePadLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeDetOutLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeRoiPoolingLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeOdPostProcessingLayer(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
// add by Ted
int32_t TIDL_tfOutCustomIdentity(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);

int32_t TIDL_getTfOpParamMapId(const char  * name);
int32_t tidl_linkInputTensors(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_linkOutputTensors(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_isAllInsAvailable(sTIDL_LayerPC_t  *orgLayer, sTIDL_OrgNetwork_t  *ptempTIDLNetStructure, int32_t layerIndex);
int32_t tidl_sortLayersInProcOrder(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, sTIDL_OrgNetwork_t  *ptempTIDLNetStructure, int32_t layerIndex);
int32_t tidl_removeMergedLayersFromNet(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, sTIDL_OrgNetwork_t  *ptempTIDLNetStructure, int32_t layerIndex);
int32_t tidl_upateAInDataId(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex, int32_t oldId, int32_t currId);
int32_t tidl_sortDataIds(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_makeDataIdLayerIdSame(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_updateOutDataShape(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t startIdx, int32_t layerIndex, sTIDL_tfOutRehapeMap_t * sTIDL_tfOutRehapeTable);
int32_t tidl_getInLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, int32_t dataId);
int32_t tidl_getOutLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, int32_t dataId);
int32_t tidl_mergeFalttenLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeBiasLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergePadLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeBNLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeReluLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_convertConv2DToIpLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, sTIDL_tfOutRehapeMap_t * sTIDL_tfOutRehapeTable);
int32_t tidl_copyPCNetToDeviceNet(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, sTIDL_Network_t  &tIDLNetStructure, int32_t layerIndex);
int32_t tidl_addOutDataLayer(sTIDL_Network_t  &tIDLNetStructure, int32_t tiLayerIndex);
int32_t tidl_fillInDataLayerShape(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, tidl_import_config * params, int32_t tiLayerIndex);
void TIDL_importQuantLayerParams(sTIDL_OrgNetwork_t   &pOrgTIDLNetStructure, int32_t layerIndex);
void TIDL_convertDeconv2DtoConv(sTIDL_OrgNetwork_t   &pOrgTIDLNetStructure, int32_t layerIndex);
void TIDL_thresholdParams(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_addInDataLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, int32_t * dataIndex);
int32_t tidl_mergeDropoutLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_merge1x1MaxPoolingLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergePoolingLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_duplicateSliceLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t& layerIndex);
int32_t tidl_mergeDetectionoutLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeSplitLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeReshapeLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, sTIDL_tfOutRehapeMap_t * sTIDL_tfOutRehapeTable);
int32_t TIDL_tfOutReshapeResize(sTIDL_OrgNetwork_t   *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_addNormLayerToInData(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, int32_t * dataIndex, tidl_import_config * params);
int32_t tidl_convertIpLayerInputShape(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_convertSoftMaxLayerInputShape(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tf_getLayreTypeMapIdx(char* layerName, TIDL_TFLayerMapping_t* TIDL_TFLayerMap, int32_t tblSize);
int32_t tf_isLayerType(char* layerName, int32_t  startLayer, sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, TIDL_TFLayerMapping_t* TIDL_TFLayerMap, int32_t tblSize);
int32_t tidl_convertRelUToBNLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_getStringsFromList(char *list, char * names, int strLen);
int32_t tidl_mergePreBNLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeFlattenLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_getElementType(int32_t sign);
const char* TIDL_getOutDataName(sTIDL_OrgNetwork_t * pOrgTIDLNetStructure, int32_t dataId);
int32_t tidl_addMetaArchLayersTONet(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex, int32_t * dataIndex, tidl_import_config * params);
void tf_metaArch_import(tidl_import_config * params);
void tidl_metaArch_import(tidl_import_config * params);

extern uint32_t TIDL_kernelReshape(float * param, uint32_t w, uint32_t h, uint32_t ci, uint32_t co);
extern int32_t tidl_FindFlattenLayer(sTIDL_OrgNetwork_t  &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeClipLayer(sTIDL_OrgNetwork_t &pOrgTIDLNetStructure, int32_t layerIndex);
int32_t TIDL_tfOutReshapeClip(sTIDL_OrgNetwork_t *pOrgTIDLNetStructure, int32_t layerIndex);
int32_t tidl_mergeMinimumLayer(sTIDL_OrgNetwork_t &pOrgTIDLNetStructure, int32_t layerIndex);
void tidl_replaceInTensorName(sTIDL_OrgNetwork_t  *pOrgTIDLNetStructure, int32_t layerIndex, char * orgTensorName, char * newTensorName);
int32_t tidltb_isInDataBuff(sTIDL_Network_t * pTIDLNetStructure, int32_t dataId, int32_t layersGroupId);
int32_t tidltb_isOutDataBuff(sTIDL_Network_t *pTIDLNetStructure, int32_t dataId, int32_t layersGroupId);
void TIDL_caffeReorderDeconvFilters(sBuffer_t &buf, int32_t gno, int32_t gni, int32_t gr, int32_t k);

#define TILD_MAX_DATA_NAME (300)

extern char inDataNames[TIDL_MAX_ALG_IN_BUFS][TILD_MAX_DATA_NAME];
extern char outDataNames[TIDL_MAX_ALG_OUT_BUFS][TILD_MAX_DATA_NAME];
extern int32_t numNetInData;
extern int32_t numNetOutData;

void tfLite_import(tidl_import_config * params);
#endif /*TIDL_IMPORT_COMMONH_ */

