/*
*
* Copyright (c) {2015 - 2017} Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#pragma CHECK_MISRA ("none")
#include <stdio.h>
#include <stdint.h>
extern "C"
{
#include "configparser.h"
}
#include "tidl_import_config.h"
#pragma RESET_MISRA ("required")


tidl_import_config gParams;

sTokenStringSubst booleanSubst[] = {
	{"true",  {1, 0.0f}},
	{"false", {0, 0.0f}},
	{NULL,    {0, 0.0f}},
};

sTokenStringSubst modelTypeSubst[] = {
	{"caffe",      {0, 0.0f}},
	{"tensorflow", {1, 0.0f}},
	{"onnx",       {2, 0.0f}},
	{"tflite",     {3, 0.0f}},
	{NULL,         {0, 0.0f}},
};

sTokenStringSubst postProcTypeSubst[] = {
	{"disabled",       {0, 0.0f}},
	{"classification", {1, 0.0f}},
	{"detection",      {2, 0.0f}},
	{"segmentation",   {3, 0.0f}},
	{NULL,             {0, 0.0f}},
};

sTokenMapping gsTokenMap_tidl_import_config[MAX_ITEMS_TO_PARSE] =
{
        {(char* )"randParams",             &gParams.randParams            , INT_32, SINGLE, false, false, NULL,
          "Use random model weights and values: 1 = true / 0 = false (default)", NULL},
        {(char *)"modelType",              &gParams.modelType             , INT_32, SINGLE, false, false, &modelTypeSubst[0],
          "Model type: see --help-modelType",
          "Model type to be imported. The following types are currently supported\n"
          "    0 : Caffe (.caffemodel and .prototxt files)\n"
          "    1 : Tensorflow (.pb files)\n"
          "    2 : ONNX (.onnx files)\n"
          "    3 : tfLite (.tflite files)\n"
          "\n"
          "This parameter accepts an integer (0, 1, 2 or 3) indicating which\n"
          "model type is being imported\n"
          "\n"
          "The default value is \"0\" (Caffe models)\n"},
        {(char *)"quantizationStyle",      &gParams.quantizationStyle     , INT_32, SINGLE, false, false, NULL,
          "Quantization method: see --help-quantizationStyle",
          "Quantization method used for quantizing parameters. The following types are currently supported\n"
          "    0 : Caffe-jacinto specific\n"
          "    1 : Dynamic\n"
          "    2 : Fixed\n"
          "    3 : Power-of-2 Dynamic\n"
          "\n"
          "This parameter accepts an integer (0, 1, 2 or 3) indicating which\n"
          "quantization type to be used\n"
          "\n"
          "The default value is \"2\" (Fixed)\n"},
        {(char *)"quantRoundAdd",          &gParams.quantRoundAdd         , INT_32, SINGLE, false, false, NULL,
          "Percentage roll-off to be added for rounding (during quantization): default (50) minimum (0) maximum (100)", NULL},
        {(char *)"numParamBits",           &gParams.numParamBits          , INT_32, SINGLE, false, false, NULL,
          "Bit-depth for model parameters (weights and bias): default (8), minimum (0), maximux (16)", NULL},
        {(char *)"numFeatureBits",         &gParams.numFeatureBits        , INT_32, SINGLE, false, false, NULL,
          "Bit-depth for layer activation: default (8), minimum (0), maximum (16)", NULL},
        {(char *)"preProcType",            &gParams.preProcType           , INT_32, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inFileFormat",           &gParams.inFileFormat          , INT_32, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"postProcType",           &gParams.postProcType          , INT_32, SINGLE, false, false, &postProcTypeSubst[0],
          "Type of post-processing: see --help-postProcType",
          "Post-processing on output tensor. The following types are currently supported:\n"
          "    0 : No post-processing\n"
          "    1 : Classification (TOP-1 and TOP-5 accuracy)\n"
          "    2 : Object detection (Draw bounding-boxes around detected objects)\n"
          "    3 : Semantic segmentation (Per-pixel color blending)\n"
          "\n"
          "This parameter accepts an integer (0, 1, 2 or 3) indicating which\n"
          "type of post-processing to be applied on the output tensor\n"
          "\n"
          "The default value is \"0\" (No post-processing)\n"},
        {(char *)"postProcDataId",         &gParams.postProcDataId        , INT_32, SINGLE, false, false, NULL,
          "Output tensor index for post processing: minimum (0) default (0) maximum (number of output tensors)", NULL},
        {(char *)"numFrames",              &gParams.numFrames             , INT_32, SINGLE, false, false, NULL,
          "Number of input frames: see --help-numFrames",
          "Number of input frames for validating import. This value can be set to -1\n"
          "for auto-detecting the number of frames\n"
          "\n"
          "The default value is \"-1\"\n"},
        {(char *)"foldBnInConv2D",         &gParams.foldBnInConv2D        , INT_32, SINGLE, false, false, &booleanSubst[0],
          "Flag to merge batch-normalization into previous Conv2D : 1 = true (default) / 0 = false ", NULL},
        {(char *)"foldEltWiseInConv2D",    &gParams.foldEltWiseInConv2D   , INT_32, SINGLE, false, false, &booleanSubst[0],
          "Flag to merge element-wise into previous Conv2D : 1 = true / 0 = false (default)",
          "Boolean flag to merge element-wise operations in previous\n"
          "convolution layer (if possible)\n"
          "\n"
          "This feature is currently not supported. Must be set to \"0\"\n"},
        {(char *)"foldMaxPoolInConv2D",    &gParams.foldMaxPoolInConv2D   , INT_32, SINGLE, false, false, NULL,
          "Flag to merge max-pool operation into previous Conv2D : 1 = true / 0 = false (default)",
          "Boolean flag to merge max-pool operations in previous convolution\n"
          "layer (if possible)\n"
          "\n"
          "This feature is currently not supported. Must be set to \"0\"\n"},
        {(char *)"metaArchType",           &gParams.metaArchType          , INT_32, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"foldPreBnConv2D",        &gParams.foldPreBnConv2D       , INT_32, SINGLE, false, false, NULL,
          "Flag to merge batch-normalization into previous Conv2D : 1 = true (default) / 0 = false", NULL},
        {(char *)"debugTraceLevel",        &gParams.debugTraceLevel       , INT_32, SINGLE, false, false, NULL,
          "Trace level: minimum (0) default (0) maximum (2)", NULL},
        {(char *)"writeTraceLevel",        &gParams.writeTraceLevel       , INT_32, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"compileConstraintsFlag", &gParams.compileConstraintsFlag, INT_32, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"executeNetworkCompiler", &gParams.executeNetworkCompiler, INT_32, SINGLE, false, false, NULL,
          "Flag to execute network-compiler after import: 1 = true (default) / 0 = false", NULL},
        {(char *)"quantRangeUpdateFactor", &gParams.quantRangeUpdateFactor, FLOAT,  SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inElementType",          &gParams.inElementType[0]      , INT_32, MULTI,  false, false, NULL,
          "Format of each input feature (multi-param): see --help-inElementType",
          "Format of each input feature. The following types are currently supported:"
          "    0 : unsigned char\n"
          "    1 : signed char\n"
          "    2 : unsigned short\n"
          "    3 : signed short\n"
          "\n"
          "This parameter accepts an integer (0, 1, 2 or 3) indicating the type as described above\n"
          "\n"
          "The default value is \"0\" (unsigned char)"
        },
        {(char *)"inQuantFactor",          &gParams.inQuantFactor[0]      , FLOAT,  MULTI,  false, false, NULL,
          "Scale factor for each input feature (multi-param): default (1.0)", NULL},
        {(char *)"inDataNorm",             &gParams.inDataNorm[0]         , INT_32, MULTI,  false, false, NULL,
          "Data normalization flag for each input feature (multi-param): 1 = true / 0 = false (default)", NULL},
        {(char *)"inMean",                 &gParams.inMean[0]             , FLOAT,  MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inScale",                &gParams.inScale[0]            , FLOAT,  MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inWidth",                &gParams.inWidth[0]            , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inHeight",               &gParams.inHeight[0]           , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inNumChannels",          &gParams.inNumChannels[0]      , INT_32, MULTI,  false, false, NULL,
          "Number of channel for each input feature (multi-param)", NULL},
        {(char *)"numRoi",                 &gParams.numRoi[0]             , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inDataFormat",           &gParams.inDataFormat[0]       , INT_32, MULTI,  false, false, NULL,
          "Color format for each input feature (multi-param): 0 = BGR planar / 1 = RGB planar (default)", NULL},
        {(char *)"inResizeType",           &gParams.inResizeType[0]       , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"resizeWidth",            &gParams.resizeWidth[0]        , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"resizeHeight",           &gParams.resizeHeight[0]       , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"reserved",               &gParams.reserved[0]           , INT_32, MULTI,  false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inData",                 &gParams.inData                , STRING, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"inDataNamesList",        &gParams.inDataNamesList       , STRING, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"outDataNamesList",       &gParams.outDataNamesList      , STRING, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"metaLayersNamesList",    &gParams.metaLayersNamesList   , STRING, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"perfSimTool",            &gParams.perfSimTool           , STRING, SINGLE, false, false, NULL,
          "Path to network compiler tool (path-param): default ${TIDL_INSTALL_PATH}/ti_dl/utils/perfsim/ti_cnnperfsim.out", NULL},
        {(char *)"graphVizTool",           &gParams.graphVizTool          , STRING, SINGLE, false, false, NULL,
          "Path to graph visualisation tool (path-param): default ${TIDL_INSTALL_PATH}/ti_dl/utils/tidlModelGraphviz/out/tidl_graphVisualiser.out", NULL},
        {(char *)"perfSimConfig",          &gParams.perfSimConfig         , STRING, SINGLE, false, false, NULL,
          "Path to configuration file for network compiler tool (path-param): see --help-perfSimConfig",
          "Path to configuration file for network compiler tool\n"
          "\n"
          "If none provided, The default config at ${TIDL_INSTALL_PATH}/ti_dl/test/testvecs/config/import/perfsim_base.cfg\n"
          "is used. The user must provide a different set of settings if required\n"},
        {(char *)"tidlStatsTool",          &gParams.tidlStatsTool         , STRING, SINGLE, false, false, NULL,
          "Path to statistics and range collection tool (path-param): default ${TIDL_INSTALL_PATH}/ti_dl/test/tidl_quant_stats_tool.out", NULL},
        {(char *)"inputNetFile",           &gParams.inputNetFile          , STRING, SINGLE, false, false, NULL,
          "Path to input model network definition file (path-param)", NULL},
        {(char *)"inputParamsFile",        &gParams.inputParamsFile       , STRING, SINGLE, false, false, NULL,
          "Path to input model parameters file for caffe networks (path-param)", NULL},
        {(char *)"outputNetFile",          &gParams.outputNetFile         , STRING, SINGLE, false, false, NULL,
          "Path to output TIDL model file (path-param)", NULL},
        {(char *)"fileNameGrpInfo",        &gParams.fileNameGrpInfo       , STRING, SINGLE, false, false, NULL,
          "HELP TBD", NULL},
        {(char *)"outputParamsFile",       &gParams.outputParamsFile      , STRING, SINGLE, false, false, NULL,
          "Path to output TIDL buffer descriptor file (path-param)", NULL},
        {(char *)"executeQuantsTool",      &gParams.executeQuantsTool     ,INT_32,  SINGLE, false, false, NULL,
          "Flag to execute quantization tool after import: 1 = true (default) / 0 = false", NULL},
} ;





