/*
*
* Copyright (c) {2015 - 2017} Texas Instruments Incorporated
*
* All rights reserved not granted herein.
*
* Limited License.
*
* Texas Instruments Incorporated grants a world-wide, royalty-free, non-exclusive
* license under copyrights and patents it now or hereafter owns or controls to make,
* have made, use, import, offer to sell and sell ("Utilize") this software subject to the
* terms herein.  With respect to the foregoing patent license, such license is granted
* solely to the extent that any such patent is necessary to Utilize the software alone.
* The patent license shall not apply to any combinations which include this software,
* other than combinations with devices manufactured by or for TI ("TI Devices").
* No hardware patent is licensed hereunder.
*
* Redistributions must preserve existing copyright notices and reproduce this license
* (including the above copyright notice and the disclaimer and (if applicable) source
* code license limitations below) in the documentation and/or other materials provided
* with the distribution
*
* Redistribution and use in binary form, without modification, are permitted provided
* that the following conditions are met:
*
* *       No reverse engineering, decompilation, or disassembly of this software is
* permitted with respect to any software provided in binary form.
*
* *       any redistribution and use are licensed by TI for use only with TI Devices.
*
* *       Nothing shall obligate TI to provide you with source code for the software
* licensed and provided to you in object code.
*
* If software source code is provided to you, modification and redistribution of the
* source code are permitted provided that the following conditions are met:
*
* *       any redistribution and use of the source code, including any resulting derivative
* works, are licensed by TI for use only with TI Devices.
*
* *       any redistribution and use of any object code compiled from the source code
* and any resulting derivative works, are licensed by TI for use only with TI Devices.
*
* Neither the name of Texas Instruments Incorporated nor the names of its suppliers
*
* may be used to endorse or promote products derived from this software without
* specific prior written permission.
*
* DISCLAIMER.
*
* THIS SOFTWARE IS PROVIDED BY TI AND TI'S LICENSORS "AS IS" AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL TI AND TI'S LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
* OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

#include <google/protobuf/io/coded_stream.h>
#include <google/protobuf/io/zero_copy_stream_impl.h>
#include <google/protobuf/message.h>
#include <google/protobuf/text_format.h>
//#include <io.h>
#include <fcntl.h>
#include <stdint.h>
#include <stdio.h>
#include <float.h>
#include <cmath>

#include "ti_dl.h"
#include "tidl_meta_arch.pb.h"
#include "tidl_import_config.h"

using namespace std;
using namespace tidl_meta_arch;
using ::google::protobuf::Message;
using ::google::protobuf::io::FileInputStream;
using ::google::protobuf::io::FileOutputStream;
using ::google::protobuf::io::ZeroCopyInputStream;
using ::google::protobuf::io::CodedInputStream;
using ::google::protobuf::io::ZeroCopyOutputStream;
using ::google::protobuf::io::CodedOutputStream;

#include "tidl_import_common.h"

extern char outMetaLayerNames[TIDL_MAX_ALG_OUT_BUFS][TILD_MAX_DATA_NAME];
sTIDL_DetectOutputParams_t tidl_OdPostProc[TIDL_MAX_TF_SSD_LAYERS];
float *tidlPriorPtrs[TIDL_MAX_TF_SSD_LAYERS] = {0};
extern int32_t numTFMetaLayers;
uint8_t tidl_OdBoxInputNames[TIDL_MAX_TF_SSD_LAYERS][TIDL_MAX_ALG_OUT_BUFS][TIDL_STRING_SIZE];
uint8_t tidl_OdClassInputNames[TIDL_MAX_TF_SSD_LAYERS][TIDL_MAX_ALG_OUT_BUFS][TIDL_STRING_SIZE];
uint8_t tidl_OdOutputNames[TIDL_MAX_TF_SSD_LAYERS][TIDL_STRING_SIZE];


void TIDL_metaArchImportDetectionOutputParams(TIDLOdPostProc& detection_output_param,
sTIDL_DetectOutputParams_t & detectOutParams)
{
  int32_t  status;
  int32_t  id;
  int32_t  j, num_classes, num_priors;
  int32_t  num_loc_classes;
  int32_t  background_label_id;
  int32_t  code_type;
  float    confidence_threshold;
  float    nms_threshold, eta;
  int32_t  top_k, keep_top_k;
  bool     share_location, clip_detectOutParamsdetectOutParamsbbox;
  bool     variance_encoded_in_target;

  detectOutParams.metaArchType = TIDL_metaArchCaffeJacinto;

  detectOutParams.numKeypoints = detection_output_param.num_keypoint();
  detectOutParams.numClasses   = detection_output_param.num_classes();
  detectOutParams.shareLocation = detection_output_param.share_location();
  detectOutParams.backgroundLabelId = detection_output_param.background_label_id();
  detectOutParams.codeType = detection_output_param.code_type();
  detectOutParams.varianceEncoded =  detection_output_param.variance_encoded_in_target();
  detectOutParams.keepTopK = detection_output_param.keep_top_k();
  detectOutParams.confThreshold = detection_output_param.has_confidence_threshold() ? detection_output_param.confidence_threshold() : -FLT_MAX;
  detectOutParams.nmsThreshold = detection_output_param.nms_param().nms_threshold();
  detectOutParams.eta = detection_output_param.nms_param().eta();
  detectOutParams.topK = detection_output_param.nms_param().has_top_k() ? detection_output_param.nms_param().top_k() : -1;

}


void TIDL_metaArchimportPriorBoxParams(PriorBoxParameter& prior_box_param,
float               **pPrioData,
int32_t              *priorDataSize,
int32_t               imWidth,
int32_t               imHeight)
{
  int32_t     status;
  int32_t id;
  int32_t j, img_height, img_width, num_priors;
  float step_h, step_w;

   int32_t aspect_ratios_size = prior_box_param.aspect_ratio_size();
  float  * aspect_ratios   = (float *)my_malloc((aspect_ratios_size*3)*sizeof(float));
  bool flip = prior_box_param.flip();
  int ptr_offset = 0;
  aspect_ratios[ptr_offset++] = 1.0;
  for (int idx = 0; idx < aspect_ratios_size; idx++)
  {
   float ar = prior_box_param.aspect_ratio(idx);
     bool already_exist = false;
     for (int j = 0; j < ptr_offset; ++j)
   {
       if (fabs(ar - aspect_ratios[j]) < 1e-6)
     {
         already_exist = true;
         break;
       }
     }
     if (!already_exist)
   {
       aspect_ratios[ptr_offset++] = ar;
       if (flip)
     {
         aspect_ratios[ptr_offset++] = (1./ar);
       }
     }
  }
  aspect_ratios_size = ptr_offset;

  int32_t min_sizes_size = prior_box_param.min_size_size();
  float  * min_sizes   = (float *)my_malloc(min_sizes_size*sizeof(float));
  for (int idx = 0; idx < min_sizes_size; idx++)
  {
     min_sizes[idx] = prior_box_param.min_size(idx);
  }

  int32_t max_sizes_size = prior_box_param.max_size_size();
  float  * max_sizes   = (float *)my_malloc(max_sizes_size*sizeof(float));
  num_priors = aspect_ratios_size * min_sizes_size;
  for (int idx = 0; idx < max_sizes_size; idx++)
  {
     max_sizes[idx] = prior_box_param.max_size(idx);
   num_priors += 1;
  }
  float offset = prior_box_param.offset();
  bool  clip = prior_box_param.clip();

  if (prior_box_param.has_img_h() || prior_box_param.has_img_w())
  {
    img_height = prior_box_param.img_h();
    img_width = prior_box_param.img_w();
  }
  else if (prior_box_param.has_img_size())
  {
    int32_t img_size = prior_box_param.img_size();
    img_height = img_size;
    img_width = img_size;
  }
  else
  {
    img_height = imHeight;
    img_width  = imWidth;
  }

  if (prior_box_param.has_step_h() || prior_box_param.has_step_w())
  {
    step_h = prior_box_param.step_h();
    step_w = prior_box_param.step_w();
  }
  else if (prior_box_param.has_step())
  {
    float step = prior_box_param.step();
    step_h = step;
    step_w = step;
  }
  else // Step Not found prototext need to find from inout layer
  {
    printf("step shall be set \n");
    exit(0);
    step_h = -1;
    step_w = -1;
  }

  int32_t num_keypoint;
  if (prior_box_param.has_num_keypoint())
  {
    num_keypoint = prior_box_param.num_keypoint();
  }
  else
  {
    num_keypoint = 0;
  }

  int32_t variance_size = prior_box_param.variance_size();
  float  * variance   = (float *)my_malloc((variance_size+1)*sizeof(float));
  if(variance_size)
  {
    for (int idx = 0; idx < variance_size; idx++)
    {
       variance[idx] = prior_box_param.variance(idx);
    }
    if (variance_size != (4 + 2 * num_keypoint))
    {
      printf("variance_size is not matching with the expected size exciting...\n");
      exit(-1);
    }
  }
  else
  {
    // Set default to 0.1.
    variance_size = 1;
    variance[0] = 1.0;
  }

  sTIDL_AnchorBoxParams_t* anchorBox = (sTIDL_AnchorBoxParams_t*)my_malloc(sizeof(sTIDL_AnchorBoxParams_t));
  anchorBox->numAnchors = num_priors;
  anchorBox->numKeyPoints = num_keypoint;
  anchorBox->headWidth = img_width/step_w;
  anchorBox->headHeight = img_height/step_h;
  anchorBox->strideW = step_w;
  anchorBox->strideH = step_h;
  anchorBox->offsetH = offset;
  anchorBox->offsetW = offset;

  for (int j = 0; j < 4; ++j)
  {
    if (variance_size == 1)
    {
      anchorBox->boxScales[j] =variance[0];
    }
    else
    {
      anchorBox->boxScales[j] =variance[j];
    }
  }
  for (int j = 0; j < num_keypoint; ++j)
  {
    if (variance_size == 1)
    {
      anchorBox->kpScales[j*2] = variance[0];
      anchorBox->kpScales[j*2 + 1] = variance[0];
    }
    else
    {
      anchorBox->kpScales[j*2] =variance[4 + j*2];
      anchorBox->kpScales[j*2 + 1] =variance[4 + j*2 + 1];
    }
  }

  float box_width, box_height;
  int32_t box_counter = 0;
  for (int s = 0; s < min_sizes_size; ++s)
  {
      int min_size = min_sizes[s];
      // first prior: aspect_ratio = 1, size = min_size
      box_width = box_height = min_size;
      anchorBox->boxWidth[box_counter] = box_width;
      // ymin
      anchorBox->boxHeight[box_counter] = box_height;
      box_counter++; 

      if (max_sizes_size > 0)
      {
        int max_size = max_sizes[s];
        float size  = min_size * max_size;
        // second prior: aspect_ratio = 1, size = sqrt(min_size * max_size)
        box_width = box_height = sqrt(size);
        anchorBox->boxWidth[box_counter] = box_width;
        // ymin
        anchorBox->boxHeight[box_counter] = box_height;
        box_counter++;
      }

      // rest of priors
      for (int r = 0; r < aspect_ratios_size; ++r)
      {
        float ar = aspect_ratios[r];
        if (fabs(ar - 1.) < 1e-6)
        {
          continue;
        }
        box_width = min_size * sqrt(ar);
        box_height = min_size / sqrt(ar);
        // xmin
        anchorBox->boxWidth[box_counter] = box_width;
        // ymin
        anchorBox->boxHeight[box_counter] = box_height;
        box_counter++;
        

      }
    }

  *pPrioData = (float *)anchorBox;
  *priorDataSize = sizeof(sTIDL_AnchorBoxParams_t)/sizeof(float);
  my_free(aspect_ratios);
  my_free(min_sizes);
  my_free(max_sizes);
  my_free(variance);
}

#define TIDL_MA_MAX_SSD_HEAD (32)

void tidl_metaArch_import(tidl_import_config * params)
{
  int32_t  i, j, k, l;
  TIDLMetaArch           tidlMetaArch;

  if (strcmp((char*)params->metaLayersNamesList, "") != 0)
  {
    numTFMetaLayers = tidl_getStringsFromList((char *)params->metaLayersNamesList, (char*)outMetaLayerNames, TILD_MAX_DATA_NAME);
  }
  else
  {
    printf("INFO : No Mata Arch Layer to parse\n");
    return;
  }
  if(numTFMetaLayers > 1)
  {
    printf("ERROR : tidl_metaArch proto text shall be only one\n");
    return;
  }

  printf("TIDL Meta PipeLine (Proto) File  : %s  \n", (const char *)outMetaLayerNames[0]);
  TIDL_readProtoFromTextFile((const char *)outMetaLayerNames[0], &tidlMetaArch);
    
  numTFMetaLayers = tidlMetaArch.caffe_ssd_size();
  
  printf("%s\n",tidlMetaArch.name().c_str());
  for (j = 0; j < tidlMetaArch.caffe_ssd_size(); j++)
  {
    printf("%s\n",tidlMetaArch.caffe_ssd(j).name().c_str());
    float *priorPtrs[TIDL_MA_MAX_SSD_HEAD] = {0};
    int32_t priosSize[TIDL_MA_MAX_SSD_HEAD] = {0};
    int32_t imWidth = tidlMetaArch.caffe_ssd(j).in_width();
    int32_t imHeight = tidlMetaArch.caffe_ssd(j).in_height();
    
    for(k =0; k < tidlMetaArch.caffe_ssd(j).box_input_size(); k++)
    {
      strcpy((char *)tidl_OdBoxInputNames[j][k],tidlMetaArch.caffe_ssd(j).box_input(k).c_str());
      strcat((char *)params->outDataNamesList,",");
      strcat((char *)params->outDataNamesList,(char *)tidl_OdBoxInputNames[j][k]);
    }
    
    for(k =0; k < tidlMetaArch.caffe_ssd(j).class_input_size(); k++)
    {
      strcpy((char *)tidl_OdClassInputNames[j][k],tidlMetaArch.caffe_ssd(j).class_input(k).c_str());
      strcat((char *)params->outDataNamesList,",");
      strcat((char *)params->outDataNamesList,(char *)tidl_OdClassInputNames[j][k]);
    }

    for(k =0; k < tidlMetaArch.caffe_ssd(j).prior_box_param_size(); k++)
    {
      auto p = tidlMetaArch.caffe_ssd(j).prior_box_param(k);
      TIDL_metaArchimportPriorBoxParams(p,&priorPtrs[k],&priosSize[k], imWidth, imHeight);
    }
      auto d = tidlMetaArch.caffe_ssd(j).detection_output_param();
    TIDL_metaArchImportDetectionOutputParams(d,tidl_OdPostProc[j]);
    tidl_OdPostProc[j].numHeads = tidlMetaArch.caffe_ssd(j).prior_box_param_size();
    tidl_OdPostProc[j].imWidth  = imWidth;
    tidl_OdPostProc[j].imHeight = imHeight;

    int32_t totalPriorSize = 1;
    for(k =0; k < tidlMetaArch.caffe_ssd(j).prior_box_param_size(); k++)
    {
      totalPriorSize+= priosSize[k];
    }
    tidlPriorPtrs[j] = (float*)my_malloc(tidl_OdPostProc[j].numHeads*sizeof(sTIDL_AnchorBoxParams_t));

    for(k =0; k < tidlMetaArch.caffe_ssd(j).prior_box_param_size(); k++)
    {
      float *priorData = priorPtrs[k];
      memcpy((tidlPriorPtrs[j] + (k*sizeof(sTIDL_AnchorBoxParams_t)/sizeof(float))), priorData, sizeof(sTIDL_AnchorBoxParams_t));
      my_free(priorData);
    }
    tidl_OdPostProc[j].priorBoxSize = tidl_OdPostProc[j].numHeads*sizeof(sTIDL_AnchorBoxParams_t)/sizeof(float);
  }
}
