// Import the DSS packages into our namespace to save on typing
importPackage(Packages.com.ti.debug.engine.scripting)
importPackage(Packages.com.ti.ccstudio.scripting.environment)
importPackage(Packages.java.lang)
importPackage(Packages.java.io)

// Configurable Parameters
var deviceCCXMLFile = "ccs_config/am62a_sk_diag_ddr_test.ccxml";
var bytesRead;

var programToLoad = arguments[0];

// Create our scripting environment object - which is the main entry point into any script and
// the factory for creating other Scriptable servers and Sessions
var script = ScriptingEnvironment.instance();

// Create a debug server
var ds = script.getServer( "DebugServer.1" );

// Set the device ccxml
ds.setConfig( deviceCCXMLFile );

//print("\nOpening Debug Session...");
// Open a debug session
//debugSession_TIFS = ds.openSession("Texas Instruments XDS110 USB Debug Probe_0/SMS0_TIFS_0");

//print("\nConnecting Target...\n");
//debugSession_TIFS.target.connect();

//debugSession.expression.evaluate("Start Up->Configure_Maxwell()");
print("\nAM62x GEL Init Successful!\n");

debugSession_MPU = ds.openSession("Texas Instruments XDS110 USB Debug Probe_0/A53SS0_CORE0_0");

debugSession_MPU.target.connect();
print("\nConnected to MPU Core\n");

debugSession_MPU.target.reset();

print("Running the Program. Check UART console for the Log!!\n");
// Load the program
debugSession_MPU.memory.loadProgram( "/ccs_test_bins/"+programToLoad );
//debugSession_MPU.memory.loadProgram( "/ccs_test_bins_auto_run/"+programToLoad );

print("Program Run Begin\n");

// Run the program
debugSession_MPU.target.runAsynch();

