//
// ethernet routines
//
.syntax unified
.data
CPSW_MII_SEL_MODE          = 0x00
CPSW_MDIO_SEL_MODE         = 0x00
LEN_MAC_ADDR               = 0x06
OFFSET_MAC_ADDR            = 0x30

SOC_PRCM_REGS                                      = 0x44E00000
CM_PER_CPGMAC0_CLKCTRL                             = 0x14
CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_ENABLE           = 0x2
CM_PER_CPGMAC0_CLKCTRL_IDLEST                      = 0x00030000
CM_PER_CPSW_CLKSTCTRL                              = 0x144
CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_SW_WKUP            = 0x2
CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK = 0x10

SOC_CONTROL_REGS           = 0x44E10000
CONTROL_CONF_MII1_COL      = 0x908
CONTROL_CONF_MII1_CRS      = 0x90c
CONTROL_CONF_MII1_RXERR    = 0x910
CONTROL_CONF_MII1_TXEN     = 0x914
CONTROL_CONF_MII1_RXDV     = 0x918
CONTROL_CONF_MII1_TXD3     = 0x91c
CONTROL_CONF_MII1_TXD2     = 0x920
CONTROL_CONF_MII1_TXD1     = 0x924
CONTROL_CONF_MII1_TXD0     = 0x928
CONTROL_CONF_MII1_TXCLK    = 0x92c
CONTROL_CONF_MII1_RXCLK    = 0x930
CONTROL_CONF_MII1_RXD3     = 0x934
CONTROL_CONF_MII1_RXD2     = 0x938
CONTROL_CONF_MII1_RXD1     = 0x93c
CONTROL_CONF_MII1_RXD0     = 0x940
CONTROL_CONF_MDIO_DATA     = 0x948
CONTROL_CONF_MDIO_CLK      = 0x94c
CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RXACTIVE = 0x20
CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RXACTIVE   = 0x20
CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RXACTIVE = 0x20
CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RXACTIVE = 0x20
CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RXACTIVE   = 0x20
CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RXACTIVE   = 0x20
CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RXACTIVE   = 0x20
CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RXACTIVE   = 0x20
CONTROL_CONF_MII1_COL_CONF_MII1_COL_RXACTIVE     = 0x20
CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RXACTIVE     = 0x20
CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RXACTIVE   = 0x20
CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUTYPESEL  = 0x10
CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUTYPESEL    = 0x10
CONTROL_GMII_SEL                                 = 0x650

.text
//
// ethernet module init
//
// @return   0=success or 1=fail
//
.global eth_init
eth_init:
    push {r4, lr}
// CPSW pinmux for MII mode
    ldr r0, =SOC_CONTROL_REGS
    mov r1, CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXERR]
    mov r1, CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_TXEN]
    mov r1, CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXDV]
    mov r1, CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_TXD3]
    str r1, [r0, CONTROL_CONF_MII1_TXD2]
    str r1, [r0, CONTROL_CONF_MII1_TXD1]
    str r1, [r0, CONTROL_CONF_MII1_TXD0]
    mov r1, CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_TXCLK]
    mov r1, CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXCLK]
    mov r1, CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXD3]
    mov r1, CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXD2]
    mov r1, CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXD1]
    mov r1, CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_RXD0]
    mov r1, CONTROL_CONF_MII1_COL_CONF_MII1_COL_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_COL]
    mov r1, CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RXACTIVE | CPSW_MII_SEL_MODE
    str r1, [r0, CONTROL_CONF_MII1_CRS]
    mov r1, CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RXACTIVE | CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUTYPESEL | CPSW_MDIO_SEL_MODE
    str r1, [r0, CONTROL_CONF_MDIO_DATA]
    mov r1, CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUTYPESEL | CPSW_MDIO_SEL_MODE
    str r1, [r0, CONTROL_CONF_MDIO_CLK]

// enab CPSW clocks
    ldr r0, =SOC_PRCM_REGS
    mov r1, CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_ENABLE
    str r1, [r0, CM_PER_CPGMAC0_CLKCTRL]
1:  ldr r1, [r0, CM_PER_CPGMAC0_CLKCTRL]
    tst r1, CM_PER_CPGMAC0_CLKCTRL_IDLEST  // wait for IDLEST=0 spruh73n tab 8-33
    bne 1b

    mov r1, CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_SW_WKUP
    str r1, [r0, CM_PER_CPSW_CLKSTCTRL]    // s/w forced wake-up
1:  ldr r1, [r0, CM_PER_CPSW_CLKSTCTRL]    // wait for CLKACT=1 spruh73n tab 8-84
    tst r1, CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK
    beq 1b

// set MII mode on both ports
    ldr r0, =SOC_CONTROL_REGS
    mov r1, 0x0  // unnecessary def=0x0  spruh73n tab 9-40
    str r1, [r0, CONTROL_GMII_SEL]

    mov r0, 0x0
eth_init_exit:
    pop {r4, pc}

//
// read a register - generic version
//
// @param addr  - uint32, absolute address
//
// @return   r0 - uint32, value at that address
//
.global read_reg
read_reg:
    ldr	r0, [r0, 0x0]
    bx lr
