//
//  Multi Media Card User Interface  - prototypes
//  

#define CMDLINE_BAD_CMD         (-1)  // return value for cmd not found
#define CMDLINE_TOO_MANY_ARGS   (-2)  // return value for too many args
#define CMD_BUF_SIZE    512
extern char CmdBuf[CMD_BUF_SIZE];
extern unsigned char CmdBufIdx;

typedef int (*pfnCmdLine)(int argc, char *argv[]);  // Cmd line function callback type

typedef struct {  // struct for entries in cmd list table
    const char *pcCmd;  // ptr to string of cmd name
    pfnCmdLine pfnCmd;  // func ptr to actual cmd func
    const char *pcHelp;  // ptr to string of help info of cmd
} tCmdLineEntry;

extern tCmdLineEntry CmdTable[];  // cmd table provided by uif application
extern int CmdLineParse(char *pcCmdLine);
extern void char_collect(unsigned char KeyStroke);
