//
//  DMA Transmission Complete Registers  -  prototypes
//  

#ifndef _HW_DMATC_H_
#define _HW_DMATC_H_

/**************************************************************************\
* Register Offsets
\**************************************************************************/
#define DMATC_REVID		(0x0)
#define DMATC_TCCFG		(0x4)
#define DMATC_SYSCONFIG       (0x10)
#define DMATC_TCSTAT		(0x100)
#define DMATC_ERRSTAT		(0x120)
#define DMATC_ERREN		(0x124)
#define DMATC_ERRCLR		(0x128)
#define DMATC_ERRDET		(0x12C)
#define DMATC_ERRCMD		(0x130)
#define DMATC_RDRATE		(0x140)
#define DMATC_SAOPT		(0x240)
#define DMATC_SASRC		(0x244)
#define DMATC_SACNT		(0x248)
#define DMATC_SADST		(0x24C)
#define DMATC_SABIDX		(0x250)
#define DMATC_SAMPPRXY	(0x254)
#define DMATC_SACNTRLD	(0x258)
#define DMATC_SASRCBREF	(0x25C)
#define DMATC_SADSTBREF	(0x260)
#define DMATC_DFCNTRLD	(0x280)
#define DMATC_DFSRCBREF	(0x284)
#define DMATC_DFDSTBREF	(0x288)
#define DMATC_DFOPT(n)	(0x300 + (0x40 * 0))
#define DMATC_DFSRC(n)	(0x304 + (0x40 * 0))
#define DMATC_DFCNT		(0x308 + (0x40 * 0))
#define DMATC_DFDST		(0x30C + (0x40 * 0))
#define DMATC_DFBIDX		(0x310 + (0x40 * 0))
#define DMATC_DFMPPRXY	(0x314 + (0x40 * 0))

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DFOPT */
#define DMATC_DFOPT_TCCHEN (0x00400000u)
#define DMATC_DFOPT_TCCHEN_SHIFT (0x00000016u)
#define DMATC_DFOPT_TCINTEN (0x00100000u)
#define DMATC_DFOPT_TCINTEN_SHIFT (0x00000014u)
#define DMATC_DFOPT_TCC (0x0003F000u)
#define DMATC_DFOPT_TCC_SHIFT (0x0000000Cu)
#define DMATC_DFOPT_FWID (0x00000700u)
#define DMATC_DFOPT_FWID_SHIFT (0x00000008u)
/*----FWID Tokens----*/
#define DMATC_DFOPT_FWID_8BIT (0x00000000u)
#define DMATC_DFOPT_FWID_16BIT (0x00000001u)
#define DMATC_DFOPT_FWID_32BIT (0x00000002u)
#define DMATC_DFOPT_FWID_64BIT (0x00000003u)
#define DMATC_DFOPT_FWID_128BIT (0x00000004u)
#define DMATC_DFOPT_FWID_256BIT (0x00000005u)
#define DMATC_DFOPT_PRI (0x00000070u)
#define DMATC_DFOPT_PRI_SHIFT (0x00000004u)
#define DMATC_DFOPT_PRI_PRI0 (0x00000000u)
#define DMATC_DFOPT_PRI_PRI1 (0x00000001u)
#define DMATC_DFOPT_PRI_PRI2 (0x00000002u)
#define DMATC_DFOPT_PRI_PRI3 (0x00000003u)
#define DMATC_DFOPT_PRI_PRI4 (0x00000004u)
#define DMATC_DFOPT_PRI_PRI5 (0x00000005u)
#define DMATC_DFOPT_PRI_PRI6 (0x00000006u)
#define DMATC_DFOPT_PRI_PRI7 (0x00000007u)
#define DMATC_DFOPT_DAM (0x00000002u)
#define DMATC_DFOPT_DAM_SHIFT (0x00000001u)
#define DMATC_DFOPT_SAM (0x00000001u)
#define DMATC_DFOPT_SAM_SHIFT (0x00000000u)

/* DFSRC */

#define DMATC_DFSRC_SADDR (0xFFFFFFFFu)
#define DMATC_DFSRC_SADDR_SHIFT (0x00000000u)


/* DFCNT */

#define DMATC_DFCNT_BCNT (0xFFFF0000u)
#define DMATC_DFCNT_BCNT_SHIFT (0x00000010u)

#define DMATC_DFCNT_ACNT (0x0000FFFFu)
#define DMATC_DFCNT_ACNT_SHIFT (0x00000000u)


/* DFDST */

#define DMATC_DFDST_DADDR (0xFFFFFFFFu)
#define DMATC_DFDST_DADDR_SHIFT (0x00000000u)


/* DFBIDX */

#define DMATC_DFBIDX_DSTBIDX (0xFFFF0000u)
#define DMATC_DFBIDX_DSTBIDX_SHIFT (0x00000010u)

#define DMATC_DFBIDX_SRCBIDX (0x0000FFFFu)
#define DMATC_DFBIDX_SRCBIDX_SHIFT (0x00000000u)


/* DFMPPRXY */


#define DMATC_DFMPPRXY_PRIV (0x00000100u)
#define DMATC_DFMPPRXY_PRIV_SHIFT (0x00000008u)
#define DMATC_DFMPPRXY_PRIVID (0x0000000Fu)
#define DMATC_DFMPPRXY_PRIVID_SHIFT (0x00000000u)
/*----PRIVID Tokens----*/
#define DMATC_DFMPPRXY_PRIVID_ARM   (0x00000000u)
#define DMATC_DFMPPRXY_PRIVID_DSP   (0x00000001u)
#define DMATC_DFMPPRXY_PRIVID_DMAX  (0x00000002u)
#define DMATC_DFMPPRXY_PRIVID_HPI   (0x00000003u)
#define DMATC_DFMPPRXY_PRIVID_EMAC  (0x00000004u)
#define DMATC_DFMPPRXY_PRIVID_USB1  (0x00000005u)
#define DMATC_DFMPPRXY_PRIVID_USB0  (0x00000006u)
#define DMATC_DFMPPRXY_PRIVID_LCDC  (0x00000007u)


/* PID */

#define DMATC_PID_PID (0xFFFFFFFFu)
#define DMATC_PID_PID_SHIFT (0x00000000u)


/* TCCFG */


#define DMATC_TCCFG_DREGDEPTH (0x00000300u)
#define DMATC_TCCFG_DREGDEPTH_SHIFT (0x00000008u)
/*----DREGDEPTH Tokens----*/
#define DMATC_TCCFG_DREGDEPTH_1ENTRY (0x00000000u)
#define DMATC_TCCFG_DREGDEPTH_2ENTRY (0x00000001u)
#define DMATC_TCCFG_DREGDEPTH_4ENTRY (0x00000002u)


#define DMATC_TCCFG_BUSWIDTH (0x00000030u)
#define DMATC_TCCFG_BUSWIDTH_SHIFT (0x00000004u)
/*----BUSWIDTH Tokens----*/
#define DMATC_TCCFG_BUSWIDTH_32BIT (0x00000000u)
#define DMATC_TCCFG_BUSWIDTH_64BIT (0x00000001u)
#define DMATC_TCCFG_BUSWIDTH_128BIT (0x00000002u)


#define DMATC_TCCFG_FIFOSIZE (0x00000007u)
#define DMATC_TCCFG_FIFOSIZE_SHIFT (0x00000000u)
/*----FIFOSIZE Tokens----*/
#define DMATC_TCCFG_FIFOSIZE_32BYTE (0x00000000u)
#define DMATC_TCCFG_FIFOSIZE_64BYTE (0x00000001u)
#define DMATC_TCCFG_FIFOSIZE_128BYTE (0x00000002u)
#define DMATC_TCCFG_FIFOSIZE_256BYTE (0x00000003u)
#define DMATC_TCCFG_FIFOSIZE_512BYTE (0x00000004u)


/* TCSTAT */


#define DMATC_TCSTAT_DFSTRTPTR (0x00001800u)
#define DMATC_TCSTAT_DFSTRTPTR_SHIFT (0x0000000Bu)
#define DMATC_TCSTAT_DSTACTV (0x00000070u)
#define DMATC_TCSTAT_DSTACTV_SHIFT (0x00000004u)
#define DMATC_TCSTAT_DSTACTV_EMPTY (0x00000000u)
#define DMATC_TCSTAT_DSTACTV_1TR (0x00000001u)
#define DMATC_TCSTAT_DSTACTV_2TR (0x00000002u)
#define DMATC_TCSTAT_DSTACTV_3TR (0x00000003u)
#define DMATC_TCSTAT_DSTACTV_4TR (0x00000004u)


#define DMATC_TCSTAT_WSACTV (0x00000004u)
#define DMATC_TCSTAT_WSACTV_SHIFT (0x00000002u)
#define DMATC_TCSTAT_SRCACTV (0x00000002u)
#define DMATC_TCSTAT_SRCACTV_SHIFT (0x00000001u)
#define DMATC_TCSTAT_PROGBUSY (0x00000001u)
#define DMATC_TCSTAT_PROGBUSY_SHIFT (0x00000000u)

/* ERRSTAT */


#define DMATC_ERRSTAT_MMRAERR (0x00000008u)
#define DMATC_ERRSTAT_MMRAERR_SHIFT (0x00000003u)
#define DMATC_ERRSTAT_TRERR (0x00000004u)
#define DMATC_ERRSTAT_TRERR_SHIFT (0x00000002u)
#define DMATC_ERRSTAT_BUSERR (0x00000001u)
#define DMATC_ERRSTAT_BUSERR_SHIFT (0x00000000u)

/* ERREN */


#define DMATC_ERREN_MMRAERR (0x00000008u)
#define DMATC_ERREN_MMRAERR_SHIFT (0x00000003u)
#define DMATC_ERREN_TRERR (0x00000004u)
#define DMATC_ERREN_TRERR_SHIFT (0x00000002u)
#define DMATC_ERREN_BUSERR (0x00000001u)
#define DMATC_ERREN_BUSERR_SHIFT (0x00000000u)


/* ERRCLR */


#define DMATC_ERRCLR_MMRAERR (0x00000008u)
#define DMATC_ERRCLR_MMRAERR_SHIFT (0x00000003u)
#define DMATC_ERRCLR_TRERR (0x00000004u)
#define DMATC_ERRCLR_TRERR_SHIFT (0x00000002u)
#define DMATC_ERRCLR_BUSERR (0x00000001u)
#define DMATC_ERRCLR_BUSERR_SHIFT (0x00000000u)

/* ERRDET */


#define DMATC_ERRDET_TCCHEN (0x00020000u)
#define DMATC_ERRDET_TCCHEN_SHIFT (0x00000011u)

#define DMATC_ERRDET_TCINTEN (0x00010000u)
#define DMATC_ERRDET_TCINTEN_SHIFT (0x00000010u)


#define DMATC_ERRDET_TCC (0x00003F00u)
#define DMATC_ERRDET_TCC_SHIFT (0x00000008u)


#define DMATC_ERRDET_STAT (0x0000000Fu)
#define DMATC_ERRDET_STAT_SHIFT (0x00000000u)
/*----STAT Tokens----*/
#define DMATC_ERRDET_STAT_NONE (0x00000000u)
#define DMATC_ERRDET_STAT_READ_ADDRESS (0x00000001u)
#define DMATC_ERRDET_STAT_READ_PRIVILEGE (0x00000002u)
#define DMATC_ERRDET_STAT_READ_TIMEOUT (0x00000003u)
#define DMATC_ERRDET_STAT_READ_DATA (0x00000004u)
#define DMATC_ERRDET_STAT_READ_EXCLUSIVE (0x00000007u)
#define DMATC_ERRDET_STAT_WRITE_ADDRESS (0x00000009u)
#define DMATC_ERRDET_STAT_WRITE_PRIVILEGE (0x0000000Au)
#define DMATC_ERRDET_STAT_WRITE_TIMEOUT (0x0000000Bu)
#define DMATC_ERRDET_STAT_WRITE_DATA (0x0000000Cu)
#define DMATC_ERRDET_STAT_WRITE_EXCLUSIVE (0x0000000Fu)


/* ERRCMD */


#define DMATC_ERRCMD_EVAL (0x00000001u)
#define DMATC_ERRCMD_EVAL_SHIFT (0x00000000u)

/* RDRATE */


#define DMATC_RDRATE_RDRATE (0x00000007u)
#define DMATC_RDRATE_RDRATE_SHIFT (0x00000000u)
/*----RDRATE Tokens----*/
#define DMATC_RDRATE_RDRATE_AFAP (0x00000000u)
#define DMATC_RDRATE_RDRATE_4CYCLE (0x00000001u)
#define DMATC_RDRATE_RDRATE_8CYCLE (0x00000002u)
#define DMATC_RDRATE_RDRATE_16CYCLE (0x00000003u)
#define DMATC_RDRATE_RDRATE_32CYCLE (0x00000004u)


/* SAOPT */


#define DMATC_SAOPT_TCCHEN (0x00400000u)
#define DMATC_SAOPT_TCCHEN_SHIFT (0x00000016u)
#define DMATC_SAOPT_TCINTEN (0x00100000u)
#define DMATC_SAOPT_TCINTEN_SHIFT (0x00000014u)
#define DMATC_SAOPT_TCC (0x0003F000u)
#define DMATC_SAOPT_TCC_SHIFT (0x0000000Cu)
#define DMATC_SAOPT_FWID (0x00000700u)
#define DMATC_SAOPT_FWID_SHIFT (0x00000008u)
/*----FWID Tokens----*/
#define DMATC_SAOPT_FWID_8BIT (0x00000000u)
#define DMATC_SAOPT_FWID_16BIT (0x00000001u)
#define DMATC_SAOPT_FWID_32BIT (0x00000002u)
#define DMATC_SAOPT_FWID_64BIT (0x00000003u)
#define DMATC_SAOPT_FWID_128BIT (0x00000004u)
#define DMATC_SAOPT_FWID_256BIT (0x00000005u)


#define DMATC_SAOPT_PRI (0x00000070u)
#define DMATC_SAOPT_PRI_SHIFT (0x00000004u)
#define DMATC_SAOPT_PRI_PRI0 (0x00000000u)
#define DMATC_SAOPT_PRI_PRI1 (0x00000001u)
#define DMATC_SAOPT_PRI_PRI2 (0x00000002u)
#define DMATC_SAOPT_PRI_PRI3 (0x00000003u)
#define DMATC_SAOPT_PRI_PRI4 (0x00000004u)
#define DMATC_SAOPT_PRI_PRI5 (0x00000005u)
#define DMATC_SAOPT_PRI_PRI6 (0x00000006u)
#define DMATC_SAOPT_PRI_PRI7 (0x00000007u)


#define DMATC_SAOPT_DAM (0x00000002u)
#define DMATC_SAOPT_DAM_SHIFT (0x00000001u)
#define DMATC_SAOPT_SAM (0x00000001u)
#define DMATC_SAOPT_SAM_SHIFT (0x00000000u)

/* SASRC */

#define DMATC_SASRC_SADDR (0xFFFFFFFFu)
#define DMATC_SASRC_SADDR_SHIFT (0x00000000u)


/* SACNT */

#define DMATC_SACNT_BCNT (0xFFFF0000u)
#define DMATC_SACNT_BCNT_SHIFT (0x00000010u)

#define DMATC_SACNT_ACNT (0x0000FFFFu)
#define DMATC_SACNT_ACNT_SHIFT (0x00000000u)


/* SADST */

#define DMATC_SADST_DADDR (0xFFFFFFFFu)
#define DMATC_SADST_DADDR_SHIFT (0x00000000u)


/* SABIDX */

#define DMATC_SABIDX_DSTBIDX (0xFFFF0000u)
#define DMATC_SABIDX_DSTBIDX_SHIFT (0x00000010u)

#define DMATC_SABIDX_SRCBIDX (0x0000FFFFu)
#define DMATC_SABIDX_SRCBIDX_SHIFT (0x00000000u)


/* SAMPPRXY */


#define DMATC_SAMPPRXY_PRIV (0x00000100u)
#define DMATC_SAMPPRXY_PRIV_SHIFT (0x00000008u)
#define DMATC_SAMPPRXY_PRIVID (0x0000000Fu)
#define DMATC_SAMPPRXY_PRIVID_SHIFT (0x00000000u)
/*----PRIVID Tokens----*/
#define DMATC_SAMPPRXY_PRIVID_ARM   (0x00000000u)
#define DMATC_SAMPPRXY_PRIVID_DSP   (0x00000001u)
#define DMATC_SAMPPRXY_PRIVID_DMAX  (0x00000002u)
#define DMATC_SAMPPRXY_PRIVID_HPI   (0x00000003u)
#define DMATC_SAMPPRXY_PRIVID_EMAC  (0x00000004u)
#define DMATC_SAMPPRXY_PRIVID_USB1  (0x00000005u)
#define DMATC_SAMPPRXY_PRIVID_USB0  (0x00000006u)
#define DMATC_SAMPPRXY_PRIVID_LCDC  (0x00000007u)


/* SACNTRLD */


#define DMATC_SACNTRLD_ACNTRLD (0x0000FFFFu)
#define DMATC_SACNTRLD_ACNTRLD_SHIFT (0x00000000u)


/* SASRCBREF */

#define DMATC_SASRCBREF_SADDRBREF (0xFFFFFFFFu)
#define DMATC_SASRCBREF_SADDRBREF_SHIFT (0x00000000u)


/* SADSTBREF */

#define DMATC_SADSTBREF_DADDRBREF (0xFFFFFFFFu)
#define DMATC_SADSTBREF_DADDRBREF_SHIFT (0x00000000u)


/* DFCNTRLD */


#define DMATC_DFCNTRLD_ACNTRLD (0x0000FFFFu)
#define DMATC_DFCNTRLD_ACNTRLD_SHIFT (0x00000000u)


/* DFSRCBREF */

#define DMATC_DFSRCBREF_SADDRBREF (0xFFFFFFFFu)
#define DMATC_DFSRCBREF_SADDRBREF_SHIFT (0x00000000u)


/* DFDSTBREF */

#define DMATC_DFDSTBREF_DADDRBREF (0xFFFFFFFFu)
#define DMATC_DFDSTBREF_DADDRBREF_SHIFT (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif

