//
//  MMC Hardware  -  prototypes
//  
#ifndef _HW_MMC_H_
#define _HW_MMC_H_

#define MMC_HL_REV   (0x0)
#define MMC_HL_HWINFO   (0x4)
#define MMC_HL_SYSCONFIG   (0x10)
#define MMC_SYSCONFIG   (0x110)
#define MMC_SYSSTATUS   (0x114)
#define MMC_CSRE   (0x124)
#define MMC_SYSTEST   (0x128)
#define MMC_CON   (0x12C)
#define MMC_PWCNT   (0x130)
#define MMC_SDMASA   (0x200)
#define MMC_BLK   (0x204)
#define MMC_ARG   (0x208)
#define MMC_CMD   (0x20C)
#define MMC_RSP(n)   (0x210 + (n * 4))
#define MMC_DATA   (0x220)
#define MMC_PSTATE   (0x224)
#define MMC_HCTL   (0x228)
#define MMC_SYSCTL   (0x22C)
#define MMC_STAT   (0x230)
#define MMC_IE   (0x234)
#define MMC_ISE   (0x238)
#define MMC_AC12   (0x23C)
#define MMC_CAPA   (0x240)
#define MMC_CUR_CAPA   (0x248)
#define MMC_FE   (0x250)
#define MMC_ADMAES   (0x254)
#define MMC_ADMASAL   (0x258)
#define MMC_REV   (0x2FC)

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* HL_REV */
#define MMC_HL_REV_REVISION   (0xFFFFFFFFu)
#define MMC_HL_REV_REVISION_SHIFT   (0x00000000u)


/* HL_HWINFO */
#define MMC_HL_HWINFO_MADMA_EN   (0x00000001u)
#define MMC_HL_HWINFO_MADMA_EN_SHIFT   (0x00000000u)
#define MMC_HL_HWINFO_MADMA_EN_NOMASTERDMA   (0x0u)
#define MMC_HL_HWINFO_MADMA_EN_SUPPORTADMA   (0x1u)

#define MMC_HL_HWINFO_MEM_SIZE   (0x0000003Cu)
#define MMC_HL_HWINFO_MEM_SIZE_SHIFT   (0x00000002u)
#define MMC_HL_HWINFO_MEM_SIZE_MEM_1024   (0x2u)
#define MMC_HL_HWINFO_MEM_SIZE_MEM_2048   (0x4u)
#define MMC_HL_HWINFO_MEM_SIZE_MEM_4096   (0x8u)
#define MMC_HL_HWINFO_MEM_SIZE_MEM_512   (0x1u)

#define MMC_HL_HWINFO_MERGE_MEM   (0x00000002u)
#define MMC_HL_HWINFO_MERGE_MEM_SHIFT   (0x00000001u)
#define MMC_HL_HWINFO_MERGE_MEM_SINGLEMEMBUFFER   (0x1u)
#define MMC_HL_HWINFO_MERGE_MEM_TWOMEMBUFFER   (0x0u)

#define MMC_HL_HWINFO_RETMODE   (0x00000040u)
#define MMC_HL_HWINFO_RETMODE_SHIFT   (0x00000006u)
#define MMC_HL_HWINFO_RETMODE_RETDISABLED   (0x0u)
#define MMC_HL_HWINFO_RETMODE_RETENABLED   (0x1u)


/* HL_SYSCONFIG */
#define MMC_HL_SYSCONFIG_FREEEMU   (0x00000002u)
#define MMC_HL_SYSCONFIG_FREEEMU_SHIFT   (0x00000001u)
#define MMC_HL_SYSCONFIG_FREEEMU_EMUDIS   (0x1u)
#define MMC_HL_SYSCONFIG_FREEEMU_EMUEN   (0x0u)

#define MMC_HL_SYSCONFIG_IDLEMODE   (0x0000000Cu)
#define MMC_HL_SYSCONFIG_IDLEMODE_SHIFT   (0x00000002u)
#define MMC_HL_SYSCONFIG_IDLEMODE_FORCEIDLE   (0x0u)
#define MMC_HL_SYSCONFIG_IDLEMODE_NOIDLE   (0x1u)
#define MMC_HL_SYSCONFIG_IDLEMODE_SMARTIDLE   (0x2u)
#define MMC_HL_SYSCONFIG_IDLEMODE_SMARTIDLEWAKEUP   (0x3u)

#define MMC_HL_SYSCONFIG_SOFTRESET   (0x00000001u)
#define MMC_HL_SYSCONFIG_SOFTRESET_SHIFT   (0x00000000u)
#define MMC_HL_SYSCONFIG_SOFTRESET_NOACTION   (0x0u)
#define MMC_HL_SYSCONFIG_SOFTRESET_RESETDONE   (0x0u)
#define MMC_HL_SYSCONFIG_SOFTRESET_RESETONGOING   (0x1u)
#define MMC_HL_SYSCONFIG_SOFTRESET_SOFTRESET   (0x1u)

#define MMC_HL_SYSCONFIG_STANDBYMODE   (0x00000030u)
#define MMC_HL_SYSCONFIG_STANDBYMODE_SHIFT   (0x00000004u)
#define MMC_HL_SYSCONFIG_STANDBYMODE_FORCESTANDBY   (0x0u)
#define MMC_HL_SYSCONFIG_STANDBYMODE_NOSTANDBY   (0x1u)
#define MMC_HL_SYSCONFIG_STANDBYMODE_SMARTSTANDBY   (0x2u)
#define MMC_HL_SYSCONFIG_STANDBYMODE_SMARTSTANDBYWAKEUP   (0x3u)


/* SYSCONFIG */
#define MMC_SYSCONFIG_AUTOIDLE   (0x00000001u)
#define MMC_SYSCONFIG_AUTOIDLE_SHIFT   (0x00000000u)
#define MMC_SYSCONFIG_AUTOIDLE_OFF   (0x0u)
#define MMC_SYSCONFIG_AUTOIDLE_ON   (0x1u)

#define MMC_SYSCONFIG_CLOCKACTIVITY   (0x00000300u)
#define MMC_SYSCONFIG_CLOCKACTIVITY_SHIFT   (0x00000008u)
#define MMC_SYSCONFIG_CLOCKACTIVITY_BOTH   (0x3u)
#define MMC_SYSCONFIG_CLOCKACTIVITY_FUNC   (0x2u)
#define MMC_SYSCONFIG_CLOCKACTIVITY_NONE   (0x0u)
#define MMC_SYSCONFIG_CLOCKACTIVITY_OCP   (0x1u)

#define MMC_SYSCONFIG_ENAWAKEUP   (0x00000004u)
#define MMC_SYSCONFIG_ENAWAKEUP_SHIFT   (0x00000002u)
#define MMC_SYSCONFIG_ENAWAKEUP_DISABLED   (0x0u)
#define MMC_SYSCONFIG_ENAWAKEUP_ENABLED   (0x1u)

#define MMC_SYSCONFIG_SIDLEMODE   (0x00000018u)
#define MMC_SYSCONFIG_SIDLEMODE_SHIFT   (0x00000003u)
#define MMC_SYSCONFIG_SIDLEMODE_FORCE   (0x0u)
#define MMC_SYSCONFIG_SIDLEMODE_NOIDLE   (0x1u)
#define MMC_SYSCONFIG_SIDLEMODE_SMART   (0x2u)
#define MMC_SYSCONFIG_SIDLEMODE_SMARTWAKE   (0x3u)

#define MMC_SYSCONFIG_SOFTRESET   (0x00000002u)
#define MMC_SYSCONFIG_SOFTRESET_SHIFT   (0x00000001u)
#define MMC_SYSCONFIG_SOFTRESET_NORESET   (0x0u)
#define MMC_SYSCONFIG_SOFTRESET_ONRESET   (0x1u)
#define MMC_SYSCONFIG_SOFTRESET_ST_RST   (0x1u)
#define MMC_SYSCONFIG_SOFTRESET_ST_UN   (0x0u)

#define MMC_SYSCONFIG_STANDBYMODE   (0x00003000u)
#define MMC_SYSCONFIG_STANDBYMODE_SHIFT   (0x0000000Cu)
#define MMC_SYSCONFIG_STANDBYMODE_FORCE   (0x0u)
#define MMC_SYSCONFIG_STANDBYMODE_NOIDLE   (0x1u)
#define MMC_SYSCONFIG_STANDBYMODE_SMART   (0x2u)
#define MMC_SYSCONFIG_STANDBYMODE_SMARTWAKE   (0x3u)


/* SYSSTATUS */
#define MMC_SYSSTATUS_RESETDONE   (0x00000001u)
#define MMC_SYSSTATUS_RESETDONE_SHIFT   (0x00000000u)
#define MMC_SYSSTATUS_RESETDONE_DONE   (0x1u)
#define MMC_SYSSTATUS_RESETDONE_ONGOING   (0x0u)


/* CSRE */
#define MMC_CSRE_CSRE   (0xFFFFFFFFu)
#define MMC_CSRE_CSRE_SHIFT   (0x00000000u)


/* SYSTEST */
#define MMC_SYSTEST_CDAT   (0x00000004u)
#define MMC_SYSTEST_CDAT_SHIFT   (0x00000002u)
#define MMC_SYSTEST_CDAT_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_CDAT_DRIVELOW   (0x0u)

#define MMC_SYSTEST_CDIR   (0x00000002u)
#define MMC_SYSTEST_CDIR_SHIFT   (0x00000001u)
#define MMC_SYSTEST_CDIR_IN   (0x1u)
#define MMC_SYSTEST_CDIR_OUT   (0x0u)

#define MMC_SYSTEST_D0D   (0x00000010u)
#define MMC_SYSTEST_D0D_SHIFT   (0x00000004u)
#define MMC_SYSTEST_D0D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D0D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D1D   (0x00000020u)
#define MMC_SYSTEST_D1D_SHIFT   (0x00000005u)
#define MMC_SYSTEST_D1D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D1D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D2D   (0x00000040u)
#define MMC_SYSTEST_D2D_SHIFT   (0x00000006u)
#define MMC_SYSTEST_D2D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D2D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D3D   (0x00000080u)
#define MMC_SYSTEST_D3D_SHIFT   (0x00000007u)
#define MMC_SYSTEST_D3D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D3D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D4D   (0x00000100u)
#define MMC_SYSTEST_D4D_SHIFT   (0x00000008u)
#define MMC_SYSTEST_D4D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D4D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D5D   (0x00000200u)
#define MMC_SYSTEST_D5D_SHIFT   (0x00000009u)
#define MMC_SYSTEST_D5D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D5D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D6D   (0x00000400u)
#define MMC_SYSTEST_D6D_SHIFT   (0x0000000Au)
#define MMC_SYSTEST_D6D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D6D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_D7D   (0x00000800u)
#define MMC_SYSTEST_D7D_SHIFT   (0x0000000Bu)
#define MMC_SYSTEST_D7D_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_D7D_DRIVELOW   (0x0u)

#define MMC_SYSTEST_DDIR   (0x00000008u)
#define MMC_SYSTEST_DDIR_SHIFT   (0x00000003u)
#define MMC_SYSTEST_DDIR_IN   (0x1u)
#define MMC_SYSTEST_DDIR_OUT   (0x0u)

#define MMC_SYSTEST_MCKD   (0x00000001u)
#define MMC_SYSTEST_MCKD_SHIFT   (0x00000000u)
#define MMC_SYSTEST_MCKD_DRIVEHIGH   (0x1u)
#define MMC_SYSTEST_MCKD_DRIVELOW   (0x0u)

#define MMC_SYSTEST_OBI   (0x00010000u)
#define MMC_SYSTEST_OBI_SHIFT   (0x00000010u)
#define MMC_SYSTEST_OBI_DRIVENHIGH   (0x1u)
#define MMC_SYSTEST_OBI_DRIVENLOW   (0x0u)

#define MMC_SYSTEST_SDCD   (0x00008000u)
#define MMC_SYSTEST_SDCD_SHIFT   (0x0000000Fu)
#define MMC_SYSTEST_SDCD_DRIVENHIGH   (0x1u)
#define MMC_SYSTEST_SDCD_DRIVENLOW   (0x0u)

#define MMC_SYSTEST_SDWP   (0x00004000u)
#define MMC_SYSTEST_SDWP_SHIFT   (0x0000000Eu)
#define MMC_SYSTEST_SDWP_DRIVENHIGH   (0x1u)
#define MMC_SYSTEST_SDWP_DRIVENLOW   (0x0u)

#define MMC_SYSTEST_SSB   (0x00001000u)
#define MMC_SYSTEST_SSB_SHIFT   (0x0000000Cu)
#define MMC_SYSTEST_SSB_CLEAR   (0x0u)
#define MMC_SYSTEST_SSB_SETTHEMALL   (0x1u)

#define MMC_SYSTEST_WAKD   (0x00002000u)
#define MMC_SYSTEST_WAKD_SHIFT   (0x0000000Du)
#define MMC_SYSTEST_WAKD_DRIVENHIGH   (0x1u)
#define MMC_SYSTEST_WAKD_DRIVENLOW   (0x0u)


/* CON */
#define MMC_CON_BOOT_ACK   (0x00020000u)
#define MMC_CON_BOOT_ACK_SHIFT   (0x00000011u)
#define MMC_CON_BOOT_ACK_BOOTACK   (0x1u)
#define MMC_CON_BOOT_ACK_BOOTNOACK   (0x0u)

#define MMC_CON_BOOT_CF0   (0x00040000u)
#define MMC_CON_BOOT_CF0_SHIFT   (0x00000012u)
#define MMC_CON_BOOT_CF0_CMDFORCED   (0x1u)
#define MMC_CON_BOOT_CF0_CMDFORCEREQ   (0x1u)
#define MMC_CON_BOOT_CF0_CMDRELEASED   (0x0u)
#define MMC_CON_BOOT_CF0_NOCMDFORCE   (0x0u)

#define MMC_CON_CDP   (0x00000080u)
#define MMC_CON_CDP_SHIFT   (0x00000007u)
#define MMC_CON_CDP_ACTIVEHIGH   (0x0u)
#define MMC_CON_CDP_ACTIVELOW   (0x1u)

#define MMC_CON_CEATA   (0x00001000u)
#define MMC_CON_CEATA_SHIFT   (0x0000000Cu)
#define MMC_CON_CEATA_CEATAMODE   (0x1u)
#define MMC_CON_CEATA_NORMALMODE   (0x0u)

#define MMC_CON_CLKEXTFREE   (0x00010000u)
#define MMC_CON_CLKEXTFREE_SHIFT   (0x00000010u)
#define MMC_CON_CLKEXTFREE_AUTOGATING   (0x0u)
#define MMC_CON_CLKEXTFREE_FREERUNNING   (0x1u)

#define MMC_CON_CTPL   (0x00000800u)
#define MMC_CON_CTPL_SHIFT   (0x0000000Bu)
#define MMC_CON_CTPL_MMC_SD   (0x0u)
#define MMC_CON_CTPL_SDIO   (0x1u)

#define MMC_CON_DDR   (0x00080000u)
#define MMC_CON_DDR_SHIFT   (0x00000013u)
#define MMC_CON_DDR_DDRMODE   (0x1u)
#define MMC_CON_DDR_NORMALMODE   (0x0u)

#define MMC_CON_DMA_MNS   (0x00100000u)
#define MMC_CON_DMA_MNS_SHIFT   (0x00000014u)
#define MMC_CON_DMA_MNS_MASTERDMADIS   (0x0u)
#define MMC_CON_DMA_MNS_MASTERDMAEN   (0x1u)

#define MMC_CON_DVAL   (0x00000600u)
#define MMC_CON_DVAL_SHIFT   (0x00000009u)
#define MMC_CON_DVAL_1MSDEBOUNCE   (0x2u)
#define MMC_CON_DVAL_231USDEBOUNCE   (0x1u)
#define MMC_CON_DVAL_33USDEBOUNCE   (0x0u)
#define MMC_CON_DVAL_8_4MSDEBOUNCE   (0x3u)

#define MMC_CON_DW8   (0x00000020u)
#define MMC_CON_DW8_SHIFT   (0x00000005u)
#define MMC_CON_DW8_1_4BITMODE   (0x0u)
#define MMC_CON_DW8_8BITMODE   (0x1u)

#define MMC_CON_HR   (0x00000004u)
#define MMC_CON_HR_SHIFT   (0x00000002u)
#define MMC_CON_HR_HOSTRESP   (0x1u)
#define MMC_CON_HR_NOHOSTRESP   (0x0u)

#define MMC_CON_INIT   (0x00000002u)
#define MMC_CON_INIT_SHIFT   (0x00000001u)
#define MMC_CON_INIT_INITSTREAM   (0x1u)
#define MMC_CON_INIT_NOINIT   (0x0u)

#define MMC_CON_MIT   (0x00000040u)
#define MMC_CON_MIT_SHIFT   (0x00000006u)
#define MMC_CON_MIT_CTO   (0x0u)
#define MMC_CON_MIT_NO_CTO   (0x1u)

#define MMC_CON_MODE   (0x00000010u)
#define MMC_CON_MODE_SHIFT   (0x00000004u)
#define MMC_CON_MODE_FUNC   (0x0u)
#define MMC_CON_MODE_SYSTEST   (0x1u)

#define MMC_CON_OBIE   (0x00004000u)
#define MMC_CON_OBIE_SHIFT   (0x0000000Eu)
#define MMC_CON_OBIE_NORMALMODE   (0x0u)
#define MMC_CON_OBIE_OBINTMODE   (0x1u)

#define MMC_CON_OBIP   (0x00002000u)
#define MMC_CON_OBIP_SHIFT   (0x0000000Du)
#define MMC_CON_OBIP_ACTIVEHIGH   (0x0u)
#define MMC_CON_OBIP_ACTIVELOW   (0x1u)

#define MMC_CON_OD   (0x00000001u)
#define MMC_CON_OD_SHIFT   (0x00000000u)
#define MMC_CON_OD_NOOPENDRAIN   (0x0u)
#define MMC_CON_OD_OPENDRAIN   (0x1u)

#define MMC_CON_PADEN   (0x00008000u)
#define MMC_CON_PADEN_SHIFT   (0x0000000Fu)
#define MMC_CON_PADEN_DISABLE   (0x0u)
#define MMC_CON_PADEN_ENABLE   (0x1u)

#define MMC_CON_SDMA_LNE   (0x00200000u)
#define MMC_CON_SDMA_LNE_SHIFT   (0x00000015u)
#define MMC_CON_SDMA_LNE_EARLYDEASSERT   (0x0u)
#define MMC_CON_SDMA_LNE_LATEDEASSERT   (0x1u)

#define MMC_CON_STR   (0x00000008u)
#define MMC_CON_STR_SHIFT   (0x00000003u)
#define MMC_CON_STR_BLOCK   (0x0u)
#define MMC_CON_STR_STREAM   (0x1u)

#define MMC_CON_WPP   (0x00000100u)
#define MMC_CON_WPP_SHIFT   (0x00000008u)
#define MMC_CON_WPP_ACTIVEHIGH   (0x0u)
#define MMC_CON_WPP_ACTIVELOW   (0x1u)


/* PWCNT */
#define MMC_PWCNT_PWRCNT   (0x0000FFFFu)
#define MMC_PWCNT_PWRCNT_SHIFT   (0x00000000u)
#define MMC_PWCNT_PWRCNT_1CYCLES   (0x1u)
#define MMC_PWCNT_PWRCNT_2CYCLES   (0x2u)
#define MMC_PWCNT_PWRCNT_65534CYCLES   (0xFFFEu)
#define MMC_PWCNT_PWRCNT_65535CYCLES   (0xFFFFu)
#define MMC_PWCNT_PWRCNT_NODELAY   (0x0u)


/* SDMASA */
#define MMC_SDMASA_PWRCNT   (0x0000FFFFu)
#define MMC_SDMASA_PWRCNT_SHIFT   (0x00000000u)
#define MMC_SDMASA_PWRCNT_1CYCLES   (0x1u)
#define MMC_SDMASA_PWRCNT_2CYCLES   (0x2u)
#define MMC_SDMASA_PWRCNT_65534CYCLES   (0xFFFEu)
#define MMC_SDMASA_PWRCNT_65535CYCLES   (0xFFFFu)
#define MMC_SDMASA_PWRCNT_NODELAY   (0x0u)


/* BLK */
#define MMC_BLK_BLEN   (0x00000FFFu)
#define MMC_BLK_BLEN_SHIFT   (0x00000000u)
#define MMC_BLK_BLEN_1024BYTESLEN   (0x400u)
#define MMC_BLK_BLEN_1BYTELEN   (0x1u)
#define MMC_BLK_BLEN_2BYTESLEN   (0x2u)
#define MMC_BLK_BLEN_3BYTESLEN   (0x3u)
#define MMC_BLK_BLEN_511BYTESLEN   (0x1FFu)
#define MMC_BLK_BLEN_512BYTESLEN   (0x200u)
#define MMC_BLK_BLEN_NOTRANSFER   (0x0u)

#define MMC_BLK_NBLK   (0xFFFF0000u)
#define MMC_BLK_NBLK_SHIFT   (0x00000010u)
#define MMC_BLK_NBLK_1BLK   (0x1u)
#define MMC_BLK_NBLK_2BLKS   (0x2u)
#define MMC_BLK_NBLK_65535BLKS   (0xFFFFu)
#define MMC_BLK_NBLK_STPCNT   (0x0u)


/* ARG */
#define MMC_ARG_ARG   (0xFFFFFFFFu)
#define MMC_ARG_ARG_SHIFT   (0x00000000u)


/* CMD */
#define MMC_CMD_ACEN   (0x00000004u)
#define MMC_CMD_ACEN_SHIFT   (0x00000002u)
#define MMC_CMD_ACEN_DISABLE   (0x0u)
#define MMC_CMD_ACEN_ENABLE   (0x1u)

#define MMC_CMD_BCE   (0x00000002u)
#define MMC_CMD_BCE_SHIFT   (0x00000001u)
#define MMC_CMD_BCE_DISABLE   (0x0u)
#define MMC_CMD_BCE_ENABLE   (0x1u)

#define MMC_CMD_CCCE   (0x00080000u)
#define MMC_CMD_CCCE_SHIFT   (0x00000013u)
#define MMC_CMD_CCCE_CHECK   (0x1u)
#define MMC_CMD_CCCE_NOCHECK   (0x0u)

#define MMC_CMD_CICE   (0x00100000u)
#define MMC_CMD_CICE_SHIFT   (0x00000014u)
#define MMC_CMD_CICE_CHECK   (0x1u)
#define MMC_CMD_CICE_NOCHECK   (0x0u)

#define MMC_CMD_CMD_TYPE   (0x00C00000u)
#define MMC_CMD_CMD_TYPE_SHIFT   (0x00000016u)
#define MMC_CMD_CMD_TYPE_ABORT   (0x3u)
#define MMC_CMD_CMD_TYPE_FUNC_SELECT   (0x2u)
#define MMC_CMD_CMD_TYPE_NORMAL   (0x0u)
#define MMC_CMD_CMD_TYPE_SUSPEND   (0x1u)

#define MMC_CMD_DDIR   (0x00000010u)
#define MMC_CMD_DDIR_SHIFT   (0x00000004u)
#define MMC_CMD_DDIR_READ   (0x1u)
#define MMC_CMD_DDIR_WRITE   (0x0u)

#define MMC_CMD_DE   (0x00000001u)
#define MMC_CMD_DE_SHIFT   (0x00000000u)
#define MMC_CMD_DE_DISABLE   (0x0u)
#define MMC_CMD_DE_ENABLE   (0x1u)

#define MMC_CMD_DP   (0x00200000u)
#define MMC_CMD_DP_SHIFT   (0x00000015u)
#define MMC_CMD_DP_DATA   (0x1u)
#define MMC_CMD_DP_NODATA   (0x0u)

#define MMC_CMD_INDX   (0x3F000000u)
#define MMC_CMD_INDX_SHIFT   (0x00000018u)
#define MMC_CMD_INDX_CMD0   (0x0u)
#define MMC_CMD_INDX_CMD1   (0x1u)
#define MMC_CMD_INDX_CMD10   (0xAu)
#define MMC_CMD_INDX_CMD11   (0xBu)
#define MMC_CMD_INDX_CMD12   (0xCu)
#define MMC_CMD_INDX_CMD13   (0xDu)
#define MMC_CMD_INDX_CMD14   (0xEu)
#define MMC_CMD_INDX_CMD15   (0xFu)
#define MMC_CMD_INDX_CMD16   (0x10u)
#define MMC_CMD_INDX_CMD17   (0x11u)
#define MMC_CMD_INDX_CMD18   (0x12u)
#define MMC_CMD_INDX_CMD19   (0x13u)
#define MMC_CMD_INDX_CMD2   (0x2u)
#define MMC_CMD_INDX_CMD20   (0x14u)
#define MMC_CMD_INDX_CMD21   (0x15u)
#define MMC_CMD_INDX_CMD22   (0x16u)
#define MMC_CMD_INDX_CMD23   (0x17u)
#define MMC_CMD_INDX_CMD24   (0x18u)
#define MMC_CMD_INDX_CMD25   (0x19u)
#define MMC_CMD_INDX_CMD26   (0x1Au)
#define MMC_CMD_INDX_CMD27   (0x1Bu)
#define MMC_CMD_INDX_CMD28   (0x1Cu)
#define MMC_CMD_INDX_CMD29   (0x1Du)
#define MMC_CMD_INDX_CMD3   (0x3u)
#define MMC_CMD_INDX_CMD30   (0x1Eu)
#define MMC_CMD_INDX_CMD31   (0x1Fu)
#define MMC_CMD_INDX_CMD32   (0x20u)
#define MMC_CMD_INDX_CMD33   (0x21u)
#define MMC_CMD_INDX_CMD34   (0x22u)
#define MMC_CMD_INDX_CMD35   (0x23u)
#define MMC_CMD_INDX_CMD36   (0x24u)
#define MMC_CMD_INDX_CMD37   (0x25u)
#define MMC_CMD_INDX_CMD38   (0x26u)
#define MMC_CMD_INDX_CMD39   (0x27u)
#define MMC_CMD_INDX_CMD4   (0x4u)
#define MMC_CMD_INDX_CMD40   (0x28u)
#define MMC_CMD_INDX_CMD41   (0x29u)
#define MMC_CMD_INDX_CMD42   (0x2Au)
#define MMC_CMD_INDX_CMD43   (0x2Bu)
#define MMC_CMD_INDX_CMD44   (0x2Cu)
#define MMC_CMD_INDX_CMD45   (0x2Du)
#define MMC_CMD_INDX_CMD46   (0x2Eu)
#define MMC_CMD_INDX_CMD47   (0x2Fu)
#define MMC_CMD_INDX_CMD48   (0x30u)
#define MMC_CMD_INDX_CMD49   (0x31u)
#define MMC_CMD_INDX_CMD5   (0x5u)
#define MMC_CMD_INDX_CMD50   (0x32u)
#define MMC_CMD_INDX_CMD51   (0x33u)
#define MMC_CMD_INDX_CMD52   (0x34u)
#define MMC_CMD_INDX_CMD53   (0x35u)
#define MMC_CMD_INDX_CMD54   (0x36u)
#define MMC_CMD_INDX_CMD55   (0x37u)
#define MMC_CMD_INDX_CMD56   (0x38u)
#define MMC_CMD_INDX_CMD57   (0x39u)
#define MMC_CMD_INDX_CMD58   (0x3Au)
#define MMC_CMD_INDX_CMD59   (0x3Bu)
#define MMC_CMD_INDX_CMD6   (0x6u)
#define MMC_CMD_INDX_CMD60   (0x3Cu)
#define MMC_CMD_INDX_CMD61   (0x3Du)
#define MMC_CMD_INDX_CMD62   (0x3Eu)
#define MMC_CMD_INDX_CMD63   (0x3Fu)
#define MMC_CMD_INDX_CMD7   (0x7u)
#define MMC_CMD_INDX_CMD8   (0x8u)
#define MMC_CMD_INDX_CMD9   (0x9u)

#define MMC_CMD_MSBS   (0x00000020u)
#define MMC_CMD_MSBS_SHIFT   (0x00000005u)
#define MMC_CMD_MSBS_MULTIBLK   (0x1u)
#define MMC_CMD_MSBS_SGLEBLK   (0x0u)

#define MMC_CMD_RSP_TYPE   (0x00030000u)
#define MMC_CMD_RSP_TYPE_SHIFT   (0x00000010u)
#define MMC_CMD_RSP_TYPE_136BITS   (0x1u)
#define MMC_CMD_RSP_TYPE_48BITS    (0x2u)
#define MMC_CMD_RSP_TYPE_48BITS_BUSY (0x3u)
#define MMC_CMD_RSP_TYPE_NORSP   (0x0u)


/* RSP10 */
#define MMC_RSP10_RSP0   (0x0000FFFFu)
#define MMC_RSP10_RSP0_SHIFT   (0x00000000u)

#define MMC_RSP10_RSP1   (0xFFFF0000u)
#define MMC_RSP10_RSP1_SHIFT   (0x00000010u)


/* RSP32 */
#define MMC_RSP32_RSP2   (0x0000FFFFu)
#define MMC_RSP32_RSP2_SHIFT   (0x00000000u)

#define MMC_RSP32_RSP3   (0xFFFF0000u)
#define MMC_RSP32_RSP3_SHIFT   (0x00000010u)


/* RSP54 */
#define MMC_RSP54_RSP4   (0x0000FFFFu)
#define MMC_RSP54_RSP4_SHIFT   (0x00000000u)

#define MMC_RSP54_RSP5   (0xFFFF0000u)
#define MMC_RSP54_RSP5_SHIFT   (0x00000010u)


/* RSP76 */
#define MMC_RSP76_RSP6   (0x0000FFFFu)
#define MMC_RSP76_RSP6_SHIFT   (0x00000000u)

#define MMC_RSP76_RSP7   (0xFFFF0000u)
#define MMC_RSP76_RSP7_SHIFT   (0x00000010u)


/* DATA */
#define MMC_DATA_DATA   (0xFFFFFFFFu)
#define MMC_DATA_DATA_SHIFT   (0x00000000u)


/* PSTATE */
#define MMC_PSTATE_BRE   (0x00000800u)
#define MMC_PSTATE_BRE_SHIFT   (0x0000000Bu)
#define MMC_PSTATE_BRE_RDDISABLE   (0x0u)
#define MMC_PSTATE_BRE_RDENABLE   (0x1u)

#define MMC_PSTATE_BWE   (0x00000400u)
#define MMC_PSTATE_BWE_SHIFT   (0x0000000Au)
#define MMC_PSTATE_BWE_WRDISABLE   (0x0u)
#define MMC_PSTATE_BWE_WRENABLE   (0x1u)

#define MMC_PSTATE_CDPL   (0x00040000u)
#define MMC_PSTATE_CDPL_SHIFT   (0x00000012u)
#define MMC_PSTATE_CDPL_PINLEVELVAL_0   (0x1u)
#define MMC_PSTATE_CDPL_PINLEVELVAL_1   (0x0u)

#define MMC_PSTATE_CINS   (0x00010000u)
#define MMC_PSTATE_CINS_SHIFT   (0x00000010u)
#define MMC_PSTATE_CINS_ONE   (0x1u)
#define MMC_PSTATE_CINS_ZERO   (0x0u)

#define MMC_PSTATE_CLEV   (0x01000000u)
#define MMC_PSTATE_CLEV_SHIFT   (0x00000018u)
#define MMC_PSTATE_CLEV_ONE   (0x1u)
#define MMC_PSTATE_CLEV_ZERO   (0x0u)

#define MMC_PSTATE_CMDI   (0x00000001u)
#define MMC_PSTATE_CMDI_SHIFT   (0x00000000u)
#define MMC_PSTATE_CMDI_CMDDIS   (0x1u)
#define MMC_PSTATE_CMDI_CMDEN   (0x0u)

#define MMC_PSTATE_CSS   (0x00020000u)
#define MMC_PSTATE_CSS_SHIFT   (0x00000011u)
#define MMC_PSTATE_CSS_DEBOUNCING   (0x0u)
#define MMC_PSTATE_CSS_STABLE   (0x1u)

#define MMC_PSTATE_DATI   (0x00000002u)
#define MMC_PSTATE_DATI_SHIFT   (0x00000001u)
#define MMC_PSTATE_DATI_CMDDIS   (0x1u)
#define MMC_PSTATE_DATI_CMDEN   (0x0u)

#define MMC_PSTATE_DLA   (0x00000004u)
#define MMC_PSTATE_DLA_SHIFT   (0x00000002u)
#define MMC_PSTATE_DLA_ACTIVE   (0x1u)
#define MMC_PSTATE_DLA_INACTIVE   (0x0u)

#define MMC_PSTATE_DLEV   (0x00F00000u)
#define MMC_PSTATE_DLEV_SHIFT   (0x00000014u)

#define MMC_PSTATE_RTA   (0x00000200u)
#define MMC_PSTATE_RTA_SHIFT   (0x00000009u)
#define MMC_PSTATE_RTA_NOTRANSFER   (0x0u)
#define MMC_PSTATE_RTA_TRANSFER   (0x1u)

#define MMC_PSTATE_WP   (0x00080000u)
#define MMC_PSTATE_WP_SHIFT   (0x00000013u)
#define MMC_PSTATE_WP_ONE   (0x1u)
#define MMC_PSTATE_WP_ZERO   (0x0u)

#define MMC_PSTATE_WTA   (0x00000100u)
#define MMC_PSTATE_WTA_SHIFT   (0x00000008u)
#define MMC_PSTATE_WTA_NOTRANSFER   (0x0u)
#define MMC_PSTATE_WTA_TRANSFER   (0x1u)


/* HCTL */
#define MMC_HCTL_CDSS   (0x00000080u)
#define MMC_HCTL_CDSS_SHIFT   (0x00000007u)
#define MMC_HCTL_CDSS_CDTLSEL   (0x1u)
#define MMC_HCTL_CDSS_SDCDSEL   (0x0u)

#define MMC_HCTL_CDTL   (0x00000040u)
#define MMC_HCTL_CDTL_SHIFT   (0x00000006u)
#define MMC_HCTL_CDTL_CARDINS   (0x1u)
#define MMC_HCTL_CDTL_NOCARD   (0x0u)

#define MMC_HCTL_CR   (0x00020000u)
#define MMC_HCTL_CR_SHIFT   (0x00000011u)
#define MMC_HCTL_CR_NONE   (0x0u)
#define MMC_HCTL_CR_RESTART   (0x1u)

#define MMC_HCTL_DMAS   (0x00000018u)
#define MMC_HCTL_DMAS_SHIFT   (0x00000003u)
#define MMC_HCTL_DMAS_ADMA2   (0x2u)
#define MMC_HCTL_DMAS_RESERVED   (0x0u)
#define MMC_HCTL_DMAS_RESERVED1   (0x1u)
#define MMC_HCTL_DMAS_RESERVED2   (0x3u)

#define MMC_HCTL_DTW   (0x00000002u)
#define MMC_HCTL_DTW_SHIFT   (0x00000001u)
#define MMC_HCTL_DTW_1_BITMODE   (0x0u)
#define MMC_HCTL_DTW_4_BITMODE   (0x1u)

#define MMC_HCTL_HSPE   (0x00000004u)
#define MMC_HCTL_HSPE_SHIFT   (0x00000002u)
#define MMC_HCTL_HSPE_HIGHSPEED   (0x1u)
#define MMC_HCTL_HSPE_NORMALSPEED   (0x0u)

#define MMC_HCTL_IBG   (0x00080000u)
#define MMC_HCTL_IBG_SHIFT   (0x00000013u)
#define MMC_HCTL_IBG_ITDIABLE   (0x0u)
#define MMC_HCTL_IBG_ITENABLE   (0x1u)

#define MMC_HCTL_INS   (0x02000000u)
#define MMC_HCTL_INS_SHIFT   (0x00000019u)
#define MMC_HCTL_INS_DISABLE   (0x0u)
#define MMC_HCTL_INS_ENABLE   (0x1u)

#define MMC_HCTL_IWE   (0x01000000u)
#define MMC_HCTL_IWE_SHIFT   (0x00000018u)
#define MMC_HCTL_IWE_DISABLE   (0x0u)
#define MMC_HCTL_IWE_ENABLE   (0x1u)

#define MMC_HCTL_OBWE   (0x08000000u)
#define MMC_HCTL_OBWE_SHIFT   (0x0000001Bu)
#define MMC_HCTL_OBWE_DISABLE   (0x0u)
#define MMC_HCTL_OBWE_ENABLE   (0x1u)

#define MMC_HCTL_REM   (0x04000000u)
#define MMC_HCTL_REM_SHIFT   (0x0000001Au)
#define MMC_HCTL_REM_DISABLE   (0x0u)
#define MMC_HCTL_REM_ENABLE   (0x1u)

#define MMC_HCTL_RWC   (0x00040000u)
#define MMC_HCTL_RWC_SHIFT   (0x00000012u)
#define MMC_HCTL_RWC_NORW   (0x0u)
#define MMC_HCTL_RWC_RW   (0x1u)

#define MMC_HCTL_SBGR   (0x00010000u)
#define MMC_HCTL_SBGR_SHIFT   (0x00000010u)
#define MMC_HCTL_SBGR_STPBLK   (0x1u)
#define MMC_HCTL_SBGR_TRANSFER   (0x0u)

#define MMC_HCTL_SDBP   (0x00000100u)
#define MMC_HCTL_SDBP_SHIFT   (0x00000008u)
#define MMC_HCTL_SDBP_PWROFF   (0x0u)
#define MMC_HCTL_SDBP_PWRON   (0x1u)

#define MMC_HCTL_SDVS   (0x00000E00u)
#define MMC_HCTL_SDVS_SHIFT   (0x00000009u)
#define MMC_HCTL_SDVS_1V8   (0x5u)
#define MMC_HCTL_SDVS_3V0   (0x6u)
#define MMC_HCTL_SDVS_3V3   (0x7u)


/* SYSCTL */
#define MMC_SYSCTL_CEN   (0x00000004u)
#define MMC_SYSCTL_CEN_SHIFT   (0x00000002u)
#define MMC_SYSCTL_CEN_DISABLE   (0x0u)
#define MMC_SYSCTL_CEN_ENABLE   (0x1u)

#define MMC_SYSCTL_CLKD   (0x0000FFC0u)
#define MMC_SYSCTL_CLKD_SHIFT   (0x00000006u)
#define MMC_SYSCTL_CLKD_BYPASS0   (0x0u)
#define MMC_SYSCTL_CLKD_BYPASS1   (0x1u)
#define MMC_SYSCTL_CLKD_DIV1023   (0x3FFu)
#define MMC_SYSCTL_CLKD_DIV2   (0x2u)
#define MMC_SYSCTL_CLKD_DIV3   (0x3u)

#define MMC_SYSCTL_DTO   (0x000F0000u)
#define MMC_SYSCTL_DTO_SHIFT   (0x00000010u)
#define MMC_SYSCTL_DTO_15THDTO   (0xEu)
#define MMC_SYSCTL_DTO_1STDTO   (0x0u)
#define MMC_SYSCTL_DTO_2NDDTO   (0x1u)
#define MMC_SYSCTL_DTO_RSVD   (0xFu)

#define MMC_SYSCTL_ICE   (0x00000001u)
#define MMC_SYSCTL_ICE_SHIFT   (0x00000000u)
#define MMC_SYSCTL_ICE_OSCILLATE   (0x1u)
#define MMC_SYSCTL_ICE_STOP   (0x0u)

#define MMC_SYSCTL_ICS   (0x00000002u)
#define MMC_SYSCTL_ICS_SHIFT   (0x00000001u)
#define MMC_SYSCTL_ICS_NOTREADY   (0x0u)
#define MMC_SYSCTL_ICS_READY   (0x1u)

#define MMC_SYSCTL_SRA   (0x01000000u)
#define MMC_SYSCTL_SRA_SHIFT   (0x00000018u)
#define MMC_SYSCTL_SRA_RSTCOMPLETED   (0x0u)
#define MMC_SYSCTL_SRA_RSTFORALLDESIGN   (0x1u)

#define MMC_SYSCTL_SRC   (0x02000000u)
#define MMC_SYSCTL_SRC_SHIFT   (0x00000019u)
#define MMC_SYSCTL_SRC_RSTCOMPLETED   (0x0u)
#define MMC_SYSCTL_SRC_RSTFORCMD   (0x1u)

#define MMC_SYSCTL_SRD   (0x04000000u)
#define MMC_SYSCTL_SRD_SHIFT   (0x0000001Au)
#define MMC_SYSCTL_SRD_RSTCOMPLETED   (0x0u)
#define MMC_SYSCTL_SRD_RSTFORDAT   (0x1u)


/* STAT */
#define MMC_STAT_ACE   (0x01000000u)
#define MMC_STAT_ACE_SHIFT   (0x00000018u)
#define MMC_STAT_ACE_CMD12ERROR   (0x1u)
#define MMC_STAT_ACE_NOERROR   (0x0u)
#define MMC_STAT_ACE_STS_CLEAR   (0x1u)

#define MMC_STAT_ADMAE   (0x02000000u)
#define MMC_STAT_ADMAE_SHIFT   (0x00000019u)

#define MMC_STAT_BADA   (0x20000000u)
#define MMC_STAT_BADA_SHIFT   (0x0000001Du)
#define MMC_STAT_BADA_BADACCESS   (0x1u)
#define MMC_STAT_BADA_NOERROR   (0x0u)
#define MMC_STAT_BADA_STS_CLEAR   (0x1u)

#define MMC_STAT_BGE   (0x00000004u)
#define MMC_STAT_BGE_SHIFT   (0x00000002u)

#define MMC_STAT_BRR   (0x00000020u)
#define MMC_STAT_BRR_SHIFT   (0x00000005u)
#define MMC_STAT_BRR_NOTREADY   (0x0u)
#define MMC_STAT_BRR_READYTOREAD   (0x1u)
#define MMC_STAT_BRR_STS_CLEAR   (0x1u)

#define MMC_STAT_BSR   (0x00000400u)
#define MMC_STAT_BSR_SHIFT   (0x0000000Au)
#define MMC_STAT_BSR_BOOTSTSRCVD   (0x1u)
#define MMC_STAT_BSR_NOERROR   (0x0u)
#define MMC_STAT_BSR_STS_CLEAR   (0x1u)

#define MMC_STAT_BWR   (0x00000010u)
#define MMC_STAT_BWR_SHIFT   (0x00000004u)
#define MMC_STAT_BWR_NOTREADY   (0x0u)
#define MMC_STAT_BWR_READYTOWRITE   (0x1u)
#define MMC_STAT_BWR_STS_CLEAR   (0x1u)

#define MMC_STAT_CC   (0x00000001u)
#define MMC_STAT_CC_SHIFT   (0x00000000u)

#define MMC_STAT_CCRC   (0x00020000u)
#define MMC_STAT_CCRC_SHIFT   (0x00000011u)
#define MMC_STAT_CCRC_CCRCERROR   (0x1u)
#define MMC_STAT_CCRC_NOERROR   (0x0u)
#define MMC_STAT_CCRC_STS_CLEAR   (0x1u)

#define MMC_STAT_CEB   (0x00040000u)
#define MMC_STAT_CEB_SHIFT   (0x00000012u)
#define MMC_STAT_CEB_CEBERROR   (0x1u)
#define MMC_STAT_CEB_NOERROR   (0x0u)
#define MMC_STAT_CEB_STS_CLEAR   (0x1u)

#define MMC_STAT_CERR   (0x10000000u)
#define MMC_STAT_CERR_SHIFT   (0x0000001Cu)
#define MMC_STAT_CERR_CARDERROR   (0x1u)
#define MMC_STAT_CERR_NOERROR   (0x0u)
#define MMC_STAT_CERR_STS_CLEAR   (0x1u)

#define MMC_STAT_CIE   (0x00080000u)
#define MMC_STAT_CIE_SHIFT   (0x00000013u)
#define MMC_STAT_CIE_CMDINDEXERROR   (0x1u)
#define MMC_STAT_CIE_NOERROR   (0x0u)
#define MMC_STAT_CIE_STS_CLEAR   (0x1u)

#define MMC_STAT_CINS   (0x00000040u)
#define MMC_STAT_CINS_SHIFT   (0x00000006u)
#define MMC_STAT_CINS_CARDINSERT   (0x1u)
#define MMC_STAT_CINS_CARDSTABLE_DEBOUNCE   (0x0u)
#define MMC_STAT_CINS_STS_CLEAR   (0x1u)

#define MMC_STAT_CIRQ   (0x00000100u)
#define MMC_STAT_CIRQ_SHIFT   (0x00000008u)
#define MMC_STAT_CIRQ_GENCARDINT   (0x1u)
#define MMC_STAT_CIRQ_NOCARDINT   (0x0u)

#define MMC_STAT_CREM   (0x00000080u)
#define MMC_STAT_CREM_SHIFT   (0x00000007u)
#define MMC_STAT_CREM_CARDREMOVED   (0x1u)
#define MMC_STAT_CREM_CARDSTABLE_DEBOUNCE   (0x0u)
#define MMC_STAT_CREM_STS_CLEAR   (0x1u)
#define MMC_STAT_CREM_ST_UN   (0x0u)

#define MMC_STAT_CTO   (0x00010000u)
#define MMC_STAT_CTO_SHIFT   (0x00000010u)
#define MMC_STAT_CTO_NOERROR   (0x0u)
#define MMC_STAT_CTO_STS_CLEAR   (0x1u)
#define MMC_STAT_CTO_TIMEOUT   (0x1u)

#define MMC_STAT_DCRC   (0x00200000u)
#define MMC_STAT_DCRC_SHIFT   (0x00000015u)
#define MMC_STAT_DCRC_DCRCERROR   (0x1u)
#define MMC_STAT_DCRC_NOERROR   (0x0u)
#define MMC_STAT_DCRC_STS_CLEAR   (0x1u)

#define MMC_STAT_DEB   (0x00400000u)
#define MMC_STAT_DEB_SHIFT   (0x00000016u)
#define MMC_STAT_DEB_DEBERROR   (0x1u)
#define MMC_STAT_DEB_NOERROR   (0x0u)
#define MMC_STAT_DEB_STS_CLEAR   (0x1u)

#define MMC_STAT_DMA   (0x00000008u)
#define MMC_STAT_DMA_SHIFT   (0x00000003u)
#define MMC_STAT_DMA_DMAINTDETECT   (0x0u)
#define MMC_STAT_DMA_NODMAINT   (0x1u)
#define MMC_STAT_DMA_STS_CLEAR   (0x1u)

#define MMC_STAT_DTO   (0x00100000u)
#define MMC_STAT_DTO_SHIFT   (0x00000014u)
#define MMC_STAT_DTO_NOERROR   (0x0u)
#define MMC_STAT_DTO_STS_CLEAR   (0x1u)
#define MMC_STAT_DTO_TIMEOUT   (0x1u)

#define MMC_STAT_ERRI   (0x00008000u)
#define MMC_STAT_ERRI_SHIFT   (0x0000000Fu)
#define MMC_STAT_ERRI_ERRINTEVNT   (0x1u)
#define MMC_STAT_ERRI_NOERROR   (0x0u)
#define MMC_STAT_ERRI_STS_CLEAR   (0x1u)

#define MMC_STAT_OBI   (0x00000200u)
#define MMC_STAT_OBI_SHIFT   (0x00000009u)
#define MMC_STAT_OBI_NOERROR   (0x0u)
#define MMC_STAT_OBI_OBIINT   (0x1u)
#define MMC_STAT_OBI_STS_CLEAR   (0x1u)

#define MMC_STAT_TC   (0x00000002u)
#define MMC_STAT_TC_SHIFT   (0x00000001u)


/* IE */
#define MMC_IE_ACE_ENABLE   (0x01000000u)
#define MMC_IE_ACE_ENABLE_SHIFT   (0x00000018u)
#define MMC_IE_ACE_ENABLE_ENABLED   (0x1u)
#define MMC_IE_ACE_ENABLE_MASKED   (0x0u)

#define MMC_IE_ADMAE_ENABLE   (0x02000000u)
#define MMC_IE_ADMAE_ENABLE_SHIFT   (0x00000019u)
#define MMC_IE_ADMAE_ENABLE_ENABLED   (0x1u)
#define MMC_IE_ADMAE_ENABLE_MASKED   (0x0u)

#define MMC_IE_BADA_ENABLE   (0x20000000u)
#define MMC_IE_BADA_ENABLE_SHIFT   (0x0000001Du)
#define MMC_IE_BADA_ENABLE_ENABLED   (0x1u)
#define MMC_IE_BADA_ENABLE_MASKED   (0x0u)

#define MMC_IE_BGE_ENABLE   (0x00000004u)
#define MMC_IE_BGE_ENABLE_SHIFT   (0x00000002u)
#define MMC_IE_BGE_ENABLE_ENABLED   (0x1u)
#define MMC_IE_BGE_ENABLE_MASKED   (0x0u)

#define MMC_IE_BRR_ENABLE   (0x00000020u)
#define MMC_IE_BRR_ENABLE_SHIFT   (0x00000005u)
#define MMC_IE_BRR_ENABLE_ENABLED   (0x1u)
#define MMC_IE_BRR_ENABLE_MASKED   (0x0u)

#define MMC_IE_BSR_ENABLE   (0x00000400u)
#define MMC_IE_BSR_ENABLE_SHIFT   (0x0000000Au)
#define MMC_IE_BSR_ENABLE_ENABLED   (0x1u)
#define MMC_IE_BSR_ENABLE_MASKED   (0x0u)

#define MMC_IE_BWR_ENABLE   (0x00000010u)
#define MMC_IE_BWR_ENABLE_SHIFT   (0x00000004u)
#define MMC_IE_BWR_ENABLE_ENABLED   (0x1u)
#define MMC_IE_BWR_ENABLE_MASKED   (0x0u)

#define MMC_IE_CCRC_ENABLE   (0x00020000u)
#define MMC_IE_CCRC_ENABLE_SHIFT   (0x00000011u)
#define MMC_IE_CCRC_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CCRC_ENABLE_MASKED   (0x0u)

#define MMC_IE_CC_ENABLE   (0x00000001u)
#define MMC_IE_CC_ENABLE_SHIFT   (0x00000000u)
#define MMC_IE_CC_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CC_ENABLE_MASKED   (0x0u)

#define MMC_IE_CEB_ENABLE   (0x00040000u)
#define MMC_IE_CEB_ENABLE_SHIFT   (0x00000012u)
#define MMC_IE_CEB_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CEB_ENABLE_MASKED   (0x0u)

#define MMC_IE_CERR_ENABLE   (0x10000000u)
#define MMC_IE_CERR_ENABLE_SHIFT   (0x0000001Cu)
#define MMC_IE_CERR_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CERR_ENABLE_MASKED   (0x0u)

#define MMC_IE_CIE_ENABLE   (0x00080000u)
#define MMC_IE_CIE_ENABLE_SHIFT   (0x00000013u)
#define MMC_IE_CIE_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CIE_ENABLE_MASKED   (0x0u)

#define MMC_IE_CINS_ENABLE   (0x00000040u)
#define MMC_IE_CINS_ENABLE_SHIFT   (0x00000006u)
#define MMC_IE_CINS_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CINS_ENABLE_MASKED   (0x0u)

#define MMC_IE_CIRQ_ENABLE   (0x00000100u)
#define MMC_IE_CIRQ_ENABLE_SHIFT   (0x00000008u)
#define MMC_IE_CIRQ_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CIRQ_ENABLE_MASKED   (0x0u)

#define MMC_IE_CREM_ENABLE   (0x00000080u)
#define MMC_IE_CREM_ENABLE_SHIFT   (0x00000007u)
#define MMC_IE_CREM_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CREM_ENABLE_MASKED   (0x0u)

#define MMC_IE_CTO_ENABLE   (0x00010000u)
#define MMC_IE_CTO_ENABLE_SHIFT   (0x00000010u)
#define MMC_IE_CTO_ENABLE_ENABLED   (0x1u)
#define MMC_IE_CTO_ENABLE_MASKED   (0x0u)

#define MMC_IE_DCRC_ENABLE   (0x00200000u)
#define MMC_IE_DCRC_ENABLE_SHIFT   (0x00000015u)
#define MMC_IE_DCRC_ENABLE_ENABLED   (0x1u)
#define MMC_IE_DCRC_ENABLE_MASKED   (0x0u)

#define MMC_IE_DEB_ENABLE   (0x00400000u)
#define MMC_IE_DEB_ENABLE_SHIFT   (0x00000016u)
#define MMC_IE_DEB_ENABLE_ENABLED   (0x1u)
#define MMC_IE_DEB_ENABLE_MASKED   (0x0u)

#define MMC_IE_DMA_ENABLE   (0x00000008u)
#define MMC_IE_DMA_ENABLE_SHIFT   (0x00000003u)
#define MMC_IE_DMA_ENABLE_ENABLED   (0x1u)
#define MMC_IE_DMA_ENABLE_MASKED   (0x0u)

#define MMC_IE_DTO_ENABLE   (0x00100000u)
#define MMC_IE_DTO_ENABLE_SHIFT   (0x00000014u)
#define MMC_IE_DTO_ENABLE_ENABLED   (0x1u)
#define MMC_IE_DTO_ENABLE_MASKED   (0x0u)

#define MMC_IE_NULL   (0x00008000u)
#define MMC_IE_NULL_SHIFT   (0x0000000Fu)

#define MMC_IE_OBI_ENABLE   (0x00000200u)
#define MMC_IE_OBI_ENABLE_SHIFT   (0x00000009u)
#define MMC_IE_OBI_ENABLE_ENABLED   (0x1u)
#define MMC_IE_OBI_ENABLE_MASKED   (0x0u)

#define MMC_IE_TC_ENABLE   (0x00000002u)
#define MMC_IE_TC_ENABLE_SHIFT   (0x00000001u)
#define MMC_IE_TC_ENABLE_ENABLED   (0x1u)
#define MMC_IE_TC_ENABLE_MASKED   (0x0u)


/* ISE */
#define MMC_ISE_ACE_SIGEN   (0x01000000u)
#define MMC_ISE_ACE_SIGEN_SHIFT   (0x00000018u)
#define MMC_ISE_ACE_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_ACE_SIGEN_MASKED   (0x0u)

#define MMC_ISE_ADMAE_SIGEN   (0x02000000u)
#define MMC_ISE_ADMAE_SIGEN_SHIFT   (0x00000019u)
#define MMC_ISE_ADMAE_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_ADMAE_SIGEN_MASKED   (0x0u)

#define MMC_ISE_BADA_SIGEN   (0x20000000u)
#define MMC_ISE_BADA_SIGEN_SHIFT   (0x0000001Du)
#define MMC_ISE_BADA_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_BADA_SIGEN_MASKED   (0x0u)

#define MMC_ISE_BGE_SIGEN   (0x00000004u)
#define MMC_ISE_BGE_SIGEN_SHIFT   (0x00000002u)
#define MMC_ISE_BGE_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_BGE_SIGEN_MASKED   (0x0u)

#define MMC_ISE_BRR_SIGEN   (0x00000020u)
#define MMC_ISE_BRR_SIGEN_SHIFT   (0x00000005u)
#define MMC_ISE_BRR_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_BRR_SIGEN_MASKED   (0x0u)

#define MMC_ISE_BSR_SIGEN   (0x00000400u)
#define MMC_ISE_BSR_SIGEN_SHIFT   (0x0000000Au)
#define MMC_ISE_BSR_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_BSR_SIGEN_MASKED   (0x0u)

#define MMC_ISE_BWR_SIGEN   (0x00000010u)
#define MMC_ISE_BWR_SIGEN_SHIFT   (0x00000004u)
#define MMC_ISE_BWR_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_BWR_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CCRC_SIGEN   (0x00020000u)
#define MMC_ISE_CCRC_SIGEN_SHIFT   (0x00000011u)
#define MMC_ISE_CCRC_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CCRC_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CC_SIGEN   (0x00000001u)
#define MMC_ISE_CC_SIGEN_SHIFT   (0x00000000u)
#define MMC_ISE_CC_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CC_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CEB_SIGEN   (0x00040000u)
#define MMC_ISE_CEB_SIGEN_SHIFT   (0x00000012u)
#define MMC_ISE_CEB_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CEB_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CERR_SIGEN   (0x10000000u)
#define MMC_ISE_CERR_SIGEN_SHIFT   (0x0000001Cu)
#define MMC_ISE_CERR_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CERR_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CIE_SIGEN   (0x00080000u)
#define MMC_ISE_CIE_SIGEN_SHIFT   (0x00000013u)
#define MMC_ISE_CIE_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CIE_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CINS_SIGEN   (0x00000040u)
#define MMC_ISE_CINS_SIGEN_SHIFT   (0x00000006u)
#define MMC_ISE_CINS_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CINS_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CIRQ_SIGEN   (0x00000100u)
#define MMC_ISE_CIRQ_SIGEN_SHIFT   (0x00000008u)
#define MMC_ISE_CIRQ_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CIRQ_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CREM_SIGEN   (0x00000080u)
#define MMC_ISE_CREM_SIGEN_SHIFT   (0x00000007u)
#define MMC_ISE_CREM_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CREM_SIGEN_MASKED   (0x0u)

#define MMC_ISE_CTO_SIGEN   (0x00010000u)
#define MMC_ISE_CTO_SIGEN_SHIFT   (0x00000010u)
#define MMC_ISE_CTO_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_CTO_SIGEN_MASKED   (0x0u)

#define MMC_ISE_DCRC_SIGEN   (0x00200000u)
#define MMC_ISE_DCRC_SIGEN_SHIFT   (0x00000015u)
#define MMC_ISE_DCRC_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_DCRC_SIGEN_MASKED   (0x0u)

#define MMC_ISE_DEB_SIGEN   (0x00400000u)
#define MMC_ISE_DEB_SIGEN_SHIFT   (0x00000016u)
#define MMC_ISE_DEB_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_DEB_SIGEN_MASKED   (0x0u)

#define MMC_ISE_DMA_SIGEN   (0x00000008u)
#define MMC_ISE_DMA_SIGEN_SHIFT   (0x00000003u)
#define MMC_ISE_DMA_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_DMA_SIGEN_MASKED   (0x0u)

#define MMC_ISE_DTO_SIGEN   (0x00100000u)
#define MMC_ISE_DTO_SIGEN_SHIFT   (0x00000014u)
#define MMC_ISE_DTO_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_DTO_SIGEN_MASKED   (0x0u)

#define MMC_ISE_NULL   (0x00008000u)
#define MMC_ISE_NULL_SHIFT   (0x0000000Fu)

#define MMC_ISE_OBI_SIGEN   (0x00000200u)
#define MMC_ISE_OBI_SIGEN_SHIFT   (0x00000009u)
#define MMC_ISE_OBI_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_OBI_SIGEN_MASKED   (0x0u)

#define MMC_ISE_TC_SIGEN   (0x00000002u)
#define MMC_ISE_TC_SIGEN_SHIFT   (0x00000001u)
#define MMC_ISE_TC_SIGEN_ENABLED   (0x1u)
#define MMC_ISE_TC_SIGEN_MASKED   (0x0u)


/* AC12 */
#define MMC_AC12_ACCE   (0x00000004u)
#define MMC_AC12_ACCE_SHIFT   (0x00000002u)
#define MMC_AC12_ACCE_ERR   (0x1u)
#define MMC_AC12_ACCE_NOERR   (0x0u)

#define MMC_AC12_ACEB   (0x00000008u)
#define MMC_AC12_ACEB_SHIFT   (0x00000003u)
#define MMC_AC12_ACEB_ERR   (0x1u)
#define MMC_AC12_ACEB_NOERR   (0x0u)

#define MMC_AC12_ACIE   (0x00000010u)
#define MMC_AC12_ACIE_SHIFT   (0x00000004u)
#define MMC_AC12_ACIE_ERR   (0x1u)
#define MMC_AC12_ACIE_NOERR   (0x0u)

#define MMC_AC12_ACNE   (0x00000001u)
#define MMC_AC12_ACNE_SHIFT   (0x00000000u)
#define MMC_AC12_ACNE_EXE   (0x0u)
#define MMC_AC12_ACNE_NOTEXE   (0x1u)

#define MMC_AC12_ACTO   (0x00000002u)
#define MMC_AC12_ACTO_SHIFT   (0x00000001u)
#define MMC_AC12_ACTO_NOERR   (0x0u)
#define MMC_AC12_ACTO_TIMEOUT   (0x1u)

#define MMC_AC12_CNI   (0x00000080u)
#define MMC_AC12_CNI_SHIFT   (0x00000007u)
#define MMC_AC12_CNI_CMDNI   (0x1u)
#define MMC_AC12_CNI_NOERR   (0x0u)


/* CAPA */
#define MMC_CAPA_AD2S   (0x00080000u)
#define MMC_CAPA_AD2S_SHIFT   (0x00000013u)
#define MMC_CAPA_AD2S_ADMA2NOTSUPPORTED   (0x0u)
#define MMC_CAPA_AD2S_ADMA2SUPPORTED   (0x1u)

#define MMC_CAPA_BCF   (0x00003F00u)
#define MMC_CAPA_BCF_SHIFT   (0x00000008u)
#define MMC_CAPA_BCF_OMETH   (0x0u)

#define MMC_CAPA_BIT64   (0x10000000u)
#define MMC_CAPA_BIT64_SHIFT   (0x0000001Cu)
#define MMC_CAPA_BIT64_SYSADDR32B   (0x0u)
#define MMC_CAPA_BIT64_SYSADDR64B   (0x1u)

#define MMC_CAPA_DS   (0x00400000u)
#define MMC_CAPA_DS_SHIFT   (0x00000016u)
#define MMC_CAPA_DS_NOTSUPPORTED   (0x0u)
#define MMC_CAPA_DS_SUPPORTED   (0x1u)

#define MMC_CAPA_HSS   (0x00200000u)
#define MMC_CAPA_HSS_SHIFT   (0x00000015u)
#define MMC_CAPA_HSS_NOTSUPPORTED   (0x0u)
#define MMC_CAPA_HSS_SUPPORTED   (0x1u)

#define MMC_CAPA_MBL   (0x00030000u)
#define MMC_CAPA_MBL_SHIFT   (0x00000010u)
#define MMC_CAPA_MBL_1024   (0x1u)
#define MMC_CAPA_MBL_2048   (0x2u)
#define MMC_CAPA_MBL_512   (0x0u)

#define MMC_CAPA_SRS   (0x00800000u)
#define MMC_CAPA_SRS_SHIFT   (0x00000017u)
#define MMC_CAPA_SRS_NOTSUPPORTED   (0x0u)
#define MMC_CAPA_SRS_SUPPORTED   (0x1u)

#define MMC_CAPA_TCF   (0x0000003Fu)
#define MMC_CAPA_TCF_SHIFT   (0x00000000u)
#define MMC_CAPA_TCF_OMETH   (0x0u)

#define MMC_CAPA_TCU   (0x00000080u)
#define MMC_CAPA_TCU_SHIFT   (0x00000007u)
#define MMC_CAPA_TCU_KHZ   (0x0u)
#define MMC_CAPA_TCU_MHZ   (0x1u)

#define MMC_CAPA_VS18   (0x04000000u)
#define MMC_CAPA_VS18_SHIFT   (0x0000001Au)
#define MMC_CAPA_VS18_1V8_NOTSUP   (0x0u)
#define MMC_CAPA_VS18_1V8_SUP   (0x1u)
#define MMC_CAPA_VS18_ST_1V8NOTSUP   (0x0u)
#define MMC_CAPA_VS18_ST_1V8SUP   (0x1u)

#define MMC_CAPA_VS30   (0x02000000u)
#define MMC_CAPA_VS30_SHIFT   (0x00000019u)
#define MMC_CAPA_VS30_3V0_NOTSUP   (0x0u)
#define MMC_CAPA_VS30_3V0_SUP   (0x1u)
#define MMC_CAPA_VS30_ST_3V0NOTSUP   (0x0u)
#define MMC_CAPA_VS30_ST_3V0SUP   (0x1u)

#define MMC_CAPA_VS33   (0x01000000u)
#define MMC_CAPA_VS33_SHIFT   (0x00000018u)
#define MMC_CAPA_VS33_3V3_NOTSUP   (0x0u)
#define MMC_CAPA_VS33_3V3_SUP   (0x1u)
#define MMC_CAPA_VS33_ST_3V3NOTSUP   (0x0u)
#define MMC_CAPA_VS33_ST_3V3SUP   (0x1u)


/* CUR_CAPA */
#define MMC_CUR_CAPA_CUR_1V8   (0x00FF0000u)
#define MMC_CUR_CAPA_CUR_1V8_SHIFT   (0x00000010u)
#define MMC_CUR_CAPA_CUR_1V8_OMETH   (0x0u)

#define MMC_CUR_CAPA_CUR_3V0   (0x0000FF00u)
#define MMC_CUR_CAPA_CUR_3V0_SHIFT   (0x00000008u)
#define MMC_CUR_CAPA_CUR_3V0_OMETH   (0x0u)

#define MMC_CUR_CAPA_CUR_3V3   (0x000000FFu)
#define MMC_CUR_CAPA_CUR_3V3_SHIFT   (0x00000000u)
#define MMC_CUR_CAPA_CUR_3V3_OMETH   (0x0u)


/* FE */
#define MMC_FE_FE_ACCE   (0x00000004u)
#define MMC_FE_FE_ACCE_SHIFT   (0x00000002u)
#define MMC_FE_FE_ACCE_INTFORCED   (0x1u)

#define MMC_FE_FE_ACE   (0x01000000u)
#define MMC_FE_FE_ACE_SHIFT   (0x00000018u)
#define MMC_FE_FE_ACE_INTFORCED   (0x1u)

#define MMC_FE_FE_ACEB   (0x00000008u)
#define MMC_FE_FE_ACEB_SHIFT   (0x00000003u)
#define MMC_FE_FE_ACEB_INTFORCED   (0x1u)

#define MMC_FE_FE_ACIE   (0x00000010u)
#define MMC_FE_FE_ACIE_SHIFT   (0x00000004u)
#define MMC_FE_FE_ACIE_INTFORCED   (0x1u)

#define MMC_FE_FE_ACNE   (0x00000001u)
#define MMC_FE_FE_ACNE_SHIFT   (0x00000000u)
#define MMC_FE_FE_ACNE_INTFORCED   (0x1u)

#define MMC_FE_FE_ACTO   (0x00000002u)
#define MMC_FE_FE_ACTO_SHIFT   (0x00000001u)
#define MMC_FE_FE_ACTO_INTFORCED   (0x1u)

#define MMC_FE_FE_ADMAE   (0x02000000u)
#define MMC_FE_FE_ADMAE_SHIFT   (0x00000019u)
#define MMC_FE_FE_ADMAE_INTFORCED   (0x1u)

#define MMC_FE_FE_BADA   (0x20000000u)
#define MMC_FE_FE_BADA_SHIFT   (0x0000001Du)
#define MMC_FE_FE_BADA_INTFORCED   (0x1u)

#define MMC_FE_FE_CCRC   (0x00020000u)
#define MMC_FE_FE_CCRC_SHIFT   (0x00000011u)
#define MMC_FE_FE_CCRC_INTFORCED   (0x1u)

#define MMC_FE_FE_CEB   (0x00040000u)
#define MMC_FE_FE_CEB_SHIFT   (0x00000012u)
#define MMC_FE_FE_CEB_INTFORCED   (0x1u)

#define MMC_FE_FE_CERR   (0x10000000u)
#define MMC_FE_FE_CERR_SHIFT   (0x0000001Cu)
#define MMC_FE_FE_CERR_INTFORCED   (0x1u)

#define MMC_FE_FE_CIE   (0x00080000u)
#define MMC_FE_FE_CIE_SHIFT   (0x00000013u)
#define MMC_FE_FE_CIE_INTFORCED   (0x1u)

#define MMC_FE_FE_CNI   (0x00000080u)
#define MMC_FE_FE_CNI_SHIFT   (0x00000007u)
#define MMC_FE_FE_CNI_INTFORCED   (0x1u)

#define MMC_FE_FE_CTO   (0x00010000u)
#define MMC_FE_FE_CTO_SHIFT   (0x00000010u)
#define MMC_FE_FE_CTO_ST_RST   (0x1u)

#define MMC_FE_FE_DCRC   (0x00200000u)
#define MMC_FE_FE_DCRC_SHIFT   (0x00000015u)
#define MMC_FE_FE_DCRC_INTFORCED   (0x1u)

#define MMC_FE_FE_DEB   (0x00400000u)
#define MMC_FE_FE_DEB_SHIFT   (0x00000016u)
#define MMC_FE_FE_DEB_INTFORCED   (0x1u)

#define MMC_FE_FE_DTO   (0x00100000u)
#define MMC_FE_FE_DTO_SHIFT   (0x00000014u)
#define MMC_FE_FE_DTO_INTFORCED   (0x1u)


/* ADMAES */
#define MMC_ADMAES_AES   (0x00000003u)
#define MMC_ADMAES_AES_SHIFT   (0x00000000u)
#define MMC_ADMAES_AES_LINKDESC   (0x1u)
#define MMC_ADMAES_AES_RESERVED   (0x2u)
#define MMC_ADMAES_AES_SYSSDR   (0x0u)
#define MMC_ADMAES_AES_TRANSDATA   (0x3u)

#define MMC_ADMAES_LME   (0x00000004u)
#define MMC_ADMAES_LME_SHIFT   (0x00000002u)
#define MMC_ADMAES_LME_ERROR   (0x1u)
#define MMC_ADMAES_LME_NOERROR   (0x0u)


/* ADMASAL */
#define MMC_ADMASAL_ADMA_A32B   (0xFFFFFFFFu)
#define MMC_ADMASAL_ADMA_A32B_SHIFT   (0x00000000u)

/* REV */
#define MMC_REV_SIS   (0x00000001u)
#define MMC_REV_SIS_SHIFT   (0x00000000u)

#define MMC_REV_SREV   (0x00FF0000u)
#define MMC_REV_SREV_SHIFT   (0x00000010u)
#define MMC_REV_SREV_VER_1   (0x0u)
#define MMC_REV_SREV_VER_2   (0x1u)

#define MMC_REV_VREV   (0xFF000000u)
#define MMC_REV_VREV_SHIFT   (0x00000018u)

#endif

