

#define FPGA_BASE 0x300000 // CS3 TMS320F377

MEMORY
{
/* Program Memory */
PAGE 0:
   DSR                 : origin = 0x300000, length = 0x000010      /* XINTF zone 7                                                 */
   Status              : origin = 0x300010, length = 0x000010      /* XINTF zone 7                                                 */
   ServoA              : origin = 0x300020, length = 0x000010      /* XINTF zone 7                                                 */
   ServoB              : origin = 0x300030, length = 0x000010      /* XINTF zone 7                                                 */
   Outputs             : origin = 0x300040, length = 0x000010      /* XINTF zone 7                                                 */
   BoardSerialNumber   : origin = 0x300050, length = 0x000010      /* XINTF zone 7                                                 */
   Inputs              : origin = 0x300060, length = 0x000010      /* XINTF zone 7                                                 */
   EncoderA            : origin = 0x300070, length = 0x000010      /* XINTF zone 7                                                 */
   EncoderB            : origin = 0x300080, length = 0x000010      /* XINTF zone 7                                                 */
   LEDPower            : origin = 0x3000B0, length = 0x00000d      /* XINTF zone 7                                                 */
   ResetMinMax         : origin = 0x3000BE, length = 0x000002      /* XINTF zone 7                                                 */
   DF7ToRTP            : origin = 0x3000C0, length = 0x000010      /* XINTF zone 7                                                 */
   DF7FromRTP          : origin = 0x3000D0, length = 0x000010      /* XINTF zone 7                                                 */
   DSPVersion          : origin = 0x3000E0, length = 0x000008      /* XINTF zone 7                                                 */
   MezzVersion         : origin = 0x3000E8, length = 0x000008      /* XINTF zone 7                                                 */
   FPGAVersion         : origin = 0x3000F0, length = 0x000008      /* XINTF zone 7                                                 */
   MezzBootVersion     : origin = 0x3000F8, length = 0x000008      /* XINTF zone 7                                                 */
   NotUsed1            : origin = 0x300100, length = 0x000080      /* XINTF zone 7                                                 */
   Analog12Bits        : origin = 0x300180, length = 0x000020      /* XINTF zone 7                                                 */
   Analog10Bits        : origin = 0x3001A0, length = 0x000020      /* XINTF zone 7                                                 */
   DefinedSignals      : origin = 0x3001C0, length = 0x000020      /* XINTF zone 7                                                 */
   QMMAnalogValues     : origin = 0x3001E0, length = 0x000010      /* XINTF zone 7                                                 */
   QMMLEDPower         : origin = 0x3001F0, length = 0x000010      /* XINTF zone 7                                                 */
   DataBlast           : origin = 0x300200, length = 0x000010      /* XINTF zone 7                                                 */
   Output7_8Mode       : origin = 0x300210, length = 0x000010      /* XINTF zone 7                                                 */
   HBridgePWMCfg       : origin = 0x300220, length = 0x000020      /* XINTF zone 7                                                 */
   SCIAFlowControl     : origin = 0x300240, length = 0x000010      /* XINTF zone 7                                                 */
   MezzanineControl    : origin = 0x300250, length = 0x000040      /* XINTF zone 7                                                 */
   EncoderLatch1       : origin = 0x300290, length = 0x000010      /* XINTF zone 7                                                 */
   EncoderLatch2       : origin = 0x3002A0, length = 0x000010      /* XINTF zone 7                                                 */
   EncoderLatch3       : origin = 0x3002B0, length = 0x000010      /* XINTF zone 7                                                 */
   EncoderLatch4       : origin = 0x3002C0, length = 0x000010      /* XINTF zone 7                                                 */
   SafetyChainCfg      : origin = 0x3002D0, length = 0x000010      /* XINTF zone 7                                                 */
   InputCfg            : origin = 0x3002E0, length = 0x00001f      /* XINTF zone 7 (more defined then used here)                   */
   ESTOPSandInterlocks : origin = 0x3002FF, length = 0x000001      /* XINTF zone 7                                                 */
   DebugPort           : origin = 0x300300, length = 0x000010      /* XINTF zone 7                                                 */
   IOScratchPad        : origin = 0x300310, length = 0x000030      /* XINTF zone 7                                                 */
   DebugRegisters      : origin = 0x300340, length = 0x000010      /* XINTF zone 7                                                 */
   NotUsed3            : origin = 0x300350, length = 0x0000B0      /* XINTF zone 7                                                 */
   FlashBlock          : origin = 0x300400, length = 0x000400      /* XINTF zone 7                                                 */
   ZONE8               : origin = 0x300800, length = 0x0f0000      /* XINTF zone 7 - program space                                 */

}

/*
** Allocate sections to memory blocks.
** Note:
**     codestart user defined section in DSP28_CodeStartBranch.asm used to redirect code
**     execution when booting to flash
**
**     ..RamFuncText  user defined section to store functions that will be copied from Flash into RAM
*/
SECTIONS
{
   /*
   ** FPGA DualPortRam
   */
   DP_DSRRegs          : > DSR                                     PAGE = 0
   DP_Status           : > Status                                  PAGE = 0
   DP_ServoA           : > ServoA                                  PAGE = 0
   DP_ServoB           : > ServoB                                  PAGE = 0
   DP_Outputs          : > Outputs                                 PAGE = 0
   DP_BoardSerialNumber : > BoardSerialNumber                      PAGE = 0
   DP_Inputs           : > Inputs                                  PAGE = 0
   DP_EncoderA         : > EncoderA                                PAGE = 0
   DP_EncoderB         : > EncoderB                                PAGE = 0
   DP_LEDPower         : > LEDPower                                PAGE = 0
   DP_ResetMinMax      : > ResetMinMax                             PAGE = 0
   DP_DF7ToRTP         : > DF7ToRTP                                PAGE = 0
   DP_DF7FromRTP       : > DF7FromRTP                              PAGE = 0
   DP_DSPVersion       : > DSPVersion                              PAGE = 0
   DP_MezzVersion      : > MezzVersion                             PAGE = 0
   DP_FPGAVersion      : > FPGAVersion                             PAGE = 0
   DP_MezzBootVersion  : > MezzBootVersion                         PAGE = 0
   DP_NotUsed1         : > NotUsed1                                PAGE = 0
   DP_Analog12Bits     : > Analog12Bits                            PAGE = 0
   DP_Analog10Bits     : > Analog10Bits                            PAGE = 0
   DP_DefinedSignals   : > DefinedSignals                          PAGE = 0
   DP_QMMAnalogValues  : > QMMAnalogValues                         PAGE = 0
   DP_QMMLEDPower      : > QMMLEDPower                             PAGE = 0
   DP_DataBlast        : > DataBlast                               PAGE = 0
   DP_Output7_8Mode    : > Output7_8Mode                           PAGE = 0
   DP_HBridgePWMCfg    : > HBridgePWMCfg                           PAGE = 0
   DP_SCIAFlowControl  : > SCIAFlowControl                         PAGE = 0
   DP_MezzanineControl : > MezzanineControl                        PAGE = 0
   DP_EncoderLatch1    : > EncoderLatch1                           PAGE = 0
   DP_EncoderLatch2    : > EncoderLatch2                           PAGE = 0
   DP_EncoderLatch3    : > EncoderLatch3                           PAGE = 0
   DP_EncoderLatch4    : > EncoderLatch4                           PAGE = 0
   DP_SafetyChainCfg   : > SafetyChainCfg                          PAGE = 0
   DP_InputCfg         : > InputCfg                                PAGE = 0
   DP_ESTOPSandInterlocks : > ESTOPSandInterlocks                  PAGE = 0
   DP_DebugPort        : > DebugPort                               PAGE = 0
   DP_IOScratchPad     : > IOScratchPad                            PAGE = 0
   DP_DebugRegisters   : > DebugRegisters                          PAGE = 0
   DP_NotUsed3         : > NotUsed3                                PAGE = 0
   DP_FlashBlock       : > FlashBlock                              PAGE = 0

}

