#!/bin/sh

# ******************************************************************************
# * FILE NAME: create_sd.sh
# *
# * DESCRIPTION:
# *  This script file parses the .out executables generated by the diagnostic
# *  makefile into SD card loadable files.
# *
# *  The script expects the board as a parameter. Out2rprc and MulitcoreImageGen
# *  can be set manually by environment variables $OUT2RPRC and 
# *  $MULTICOREIMAGEGEN, respectively. If not set, script will assume default
# *  location in $PDK_INSTALL_PATH/ti/boot/sbl/tools
# *
# *  Syntax:
# *      create_sd.sh [BOARD]
# *
# *  Example:
# *      create_sd.sh idkAM572x
#
# * Copyright (C) 2015, Texas Instruments, Inc.
# *****************************************************************************

board=$1

if [ $board = "evmAM335x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "evmAM437x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "idkAM437x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "skAM437x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "bbbAM335x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "icev2AM335x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

if [ $board = "skAM335x" ]
then
    echo Done! create_sd script not needed for $board!
    exit 0
fi

boarddir=$PDK_INSTALL_PATH/ti/board/
if [ -d "$boarddir/bin/$board/armv7" ]
then
	echo Creating SD files for $board...
else
	echo Missing folder/files under $boarddir/bin/$board/armv7
	echo Usage: ./create_sd.sh [BOARD]
	echo     Eg. ./create_sd.sh idkAM572x
	exit
fi

out2rprc=$OUT2RPRC
if [ -z $out2rprc ]
then
	out2rprc=$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
fi
if [ ! -f $out2rprc ]
then
	echo Missing out2rprc!
	echo     Not found in default location: \$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	echo     Override default location by setting OUT2RPRC, eg:
	echo         export OUT2RPRC=$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	exit
else
	echo Using out2prc: $out2rprc
fi

multigen=$MULTICOREIMAGEGEN
if [ -z $multigen ]
then
	multigen=$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
fi
if [ ! -f $multigen ]
then
	echo Missing multigen!
	echo     Not found in default location: \$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
	echo     Override default location by setting MULTICOREIMAGEGEN, eg:
	echo         export MULTICOREIMAGEGEN=$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
	exit
else
	echo Using multigen: $multigen
fi

sd_dir=$boarddir/bin/$board/sd
mkdir -p $sd_dir
outfiles=$boarddir/bin/$board/armv7/*.out
for out in $outfiles
do
	echo Parsing $out ...
	name=${out##*/}
	name=${name%%_*out}
	rprc=$sd_dir/${name}_rprc
	mono $out2rprc $out $rprc
	$multigen LE 55 $sd_dir/${name}_TEST 0 $rprc
	rm $rprc
done

if [ -e $sd_dir/framework_TEST ]
then
	if [ -e $sd_dir/frameworkLoader_TEST ]
	then
		mv $sd_dir/framework_TEST $sd_dir/framework
		mv $sd_dir/frameworkLoader_TEST $sd_dir/app
	else
		mv $sd_dir/framework_TEST $sd_dir/app
	fi
else
	echo Warning! Diagnostic framework not found!
fi

echo Done! Check $sd_dir for images to put onto SD card.
