@REM ******************************************************************************
@REM * FILE NAME: create_spi.bat
@REM *
@REM * DESCRIPTION:
@REM *  This script file parses the .out executables generated by the diagnostic
@REM *  makefile into SPI flash loadable files.
@REM *
@REM *  The script expects the board as a parameter. Out2rprc and MulitcoreImageGen
@REM *  can be set manually by environment variables %OUT2RPRC% and 
@REM *  %MULTICOREIMAGEGEN%, respectively. If not set, script will assume default
@REM *  location in %PDK_INSTALL_PATH%/ti/boot/sbl/tools
@REM *
@REM *  Syntax:
@REM *      create_spi.bat [BOARD]
@REM *
@REM *  Example:
@REM *      create_spi.bat idkAM572x
@REM
@REM * Copyright (C) 2015-2017, Texas Instruments, Inc.
@REM *****************************************************************************

@echo off
set board=%1

IF "%board%" == "iceAMIC110" (
echo Done! create_spi script not needed for %board%
goto :end
)

set boarddir=%PDK_INSTALL_PATH%/ti/board
IF EXIST %boarddir%/bin/%board%/armv7 (
echo Creating SPI files for %board%...
) ELSE (
echo Missing folder/files under %boarddir%/bin/%board%/armv7
echo Usage: create_spi.bat [BOARD]
echo     Eg. create_spi.bat idkAM572x
goto :err
)

set out2rprc=%OUT2RPRC%
IF [%out2rprc%] == [] (
	set out2rprc=%PDK_INSTALL_PATH%/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
)
IF NOT EXIST %out2rprc% (
	echo Missing out2rprc!
	echo     Not found in default location: %%PDK_INSTALL_PATH
%%/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	echo     Override default location by setting OUT2RPRC, eg:
	echo         set OUT2RPRC=%PDK_INSTALL_PATH%/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	goto :err
) ELSE (
	echo Using out2prc: %out2rprc%
)

set multigen=%MULTICOREIMAGEGEN%
IF [%multigen%] == [] (
	set multigen=%PDK_INSTALL_PATH%/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen.exe
)
IF NOT EXIST %multigen% (
	echo Missing multigen!
	echo     Not found in default location: %%PDK_INSTALL_PATH%%/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen.exe
	echo     Override default location by setting MULTICOREIMAGEGEN, eg:
	echo         set MULTICOREIMAGEGEN=%PDK_INSTALL_PATH%/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
	goto :err
) ELSE (
	echo Using multigen: %multigen%
)

set spi_dir=%boarddir%/bin/%board%/spi
md "%spi_dir:/=\%"
PUSHD  %CD%
cd %boarddir%/bin/%board%/armv7
for %%f in (*.out) do call :Parse %%f
goto :loopend
:Parse
set out=%1
echo Parsing %out%
for /f "tokens=1 delims=_" %%a in ("%out%") do set name=%%a
set rprc=%spi_dir%/%name%_rprc
%out2rprc% %out% %rprc%
%multigen% LE 55 %spi_dir%/%name%_TEST 0 %rprc%
goto :end
:loopend
cd %spi_dir%
IF EXIST framework_TEST (
	IF EXIST frameworkLoader_TEST (
		move framework_TEST framework
		move frameworkLoader_TEST app
	) ELSE (
		move framework_TEST app
	)
) ELSE (
	echo Warning! Diagnostic framework not found!
)
del *_rprc
POPD
goto :success

:err
echo Error encountered while running!
goto :end

:success
echo Done! Check %spi_dir% for images to flash onto SPI flash.

:end
