#!/bin/sh

# ******************************************************************************
# * FILE NAME: create_spi.sh
# *
# * DESCRIPTION:
# *  This script file parses the .out executables generated by the diagnostic
# *  makefile into SPI flash loadable files.
# *
# *  The script expects the board as a parameter. Out2rprc and MulitcoreImageGen
# *  can be set manually by environment variables $OUT2RPRC and 
# *  $MULTICOREIMAGEGEN, respectively. If not set, script will assume default
# *  location in $PDK_INSTALL_PATH/ti/boot/sbl/tools
# *
# *  Syntax:
# *      create_spi.sh [BOARD]
# *
# *  Example:
# *      create_spi.sh idkAM572x
#
# * Copyright (C) 2015, Texas Instruments, Inc.
# *****************************************************************************

board=$1

if [ $board = "iceAMIC110" ]
then
    echo Done! create_spi script not needed for $board!
    exit 0
fi

boarddir=$PDK_INSTALL_PATH/ti/board/
if [ -d "$boarddir/bin/$board/armv7" ]
then
	echo Creating SPI files for $board...
else
	echo Missing folder/files under $boarddir/bin/$board/armv7
	echo Usage: ./create_spi.sh [BOARD]
	echo     Eg. ./create_spi.sh idkAM572x
	exit
fi

out2rprc=$OUT2RPRC
if [ -z $out2rprc ]
then
	out2rprc=$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
fi
if [ ! -f $out2rprc ]
then
	echo Missing out2rprc!
	echo     Not found in default location: \$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	echo     Override default location by setting OUT2RPRC, eg:
	echo         export OUT2RPRC=$PDK_INSTALL_PATH/ti/boot/sbl/tools/out2rprc/bin/out2rprc.exe
	exit
else
	echo Using out2prc: $out2rprc
fi

multigen=$MULTICOREIMAGEGEN
if [ -z $multigen ]
then
	multigen=$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
fi
if [ ! -f $multigen ]
then
	echo Missing multigen!
	echo     Not found in default location: \$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
	echo     Override default location by setting MULTICOREIMAGEGEN, eg:
	echo         export MULTICOREIMAGEGEN=$PDK_INSTALL_PATH/ti/boot/sbl/tools/multicoreImageGen/bin/MulticoreImageGen
	exit
else
	echo Using multigen: $multigen
fi

spi_dir=$boarddir/bin/$board/spi
mkdir -p $spi_dir
outfiles=$boarddir/bin/$board/armv7/*.out
for out in $outfiles
do
	echo Parsing $out ...
	name=${out##*/}
	name=${name%%_*out}
	rprc=$spi_dir/${name}_rprc
	mono $out2rprc $out $rprc
	$multigen LE 55 $spi_dir/${name}_TEST 0 $rprc
	rm $rprc
done

if [ -e $spi_dir/framework_TEST ]
then
	if [ -e $spi_dir/frameworkLoader_TEST ]
	then
		mv $spi_dir/framework_TEST $spi_dir/framework
		mv $spi_dir/frameworkLoader_TEST $spi_dir/app
	else
		mv $spi_dir/framework_TEST $spi_dir/app
	fi
else
	echo Warning! Diagnostic framework not found!
fi

echo Done! Check $spi_dir for images to flash onto SPI flash.
