/*
 * Copyright (c) 2010-2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *
 *  \file    evmc66x_hw_dcan.h
 *
 *  This file contains DCAN module HW register definitions
 *
 */

#ifndef _EVMC66X_HW_DCAN_H_
#define _EVMC66X_HW_DCAN_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define DCAN_CTL   (0x0)
#define DCAN_PARITYERR_EOI   (0x04)
#define DCAN_ES   (0x4)
#define DCAN_ERRC   (0x8)
#define DCAN_BTR   (0xc)
#define DCAN_INT   (0x10)
#define DCAN_TEST   (0x14)
#define DCAN_PERR   (0x1c)
#define DCAN_ABOTR   (0x80)
#define DCAN_TXRQ_X   (0x84)
#define DCAN_TXRQ(n)   (0x88 + (n * 4))
#define DCAN_NWDAT_X   (0x98)
#define DCAN_NWDAT(n)   (0x9c + (n * 4))
#define DCAN_INTPND_X   (0xac)
#define DCAN_INTPND(n)   (0xB0 + (n * 4))
#define DCAN_MSGVAL_X   (0xc0)
#define DCAN_MSGVAL(n)   (0xC4 + (n * 4))
#define DCAN_INTMUX(n)   (0xD8 + (n * 4))
#define DCAN_IFCMD(n)   (0x100 + (((n) - 1) * 0x20))
#define DCAN_IFMSK(n)   (0x104 + (((n) - 1) * 0x20))
#define DCAN_IFARB(n)   (0x108 + (((n) - 1) * 0x20))
#define DCAN_IFMCTL(n)   (0x10c + (((n) - 1) * 0x20))
#define DCAN_IFDATA(n)   (0x110 + (((n) - 1) * 0x20))
#define DCAN_IFDATB(n)   (0x114 + (((n) - 1) * 0x20))
#define DCAN_IF3OBS   (0x140)
#define DCAN_IF3UPD(n)   (0x160 + (n * 4))
#define DCAN_TIOC   (0x1e0)
#define DCAN_RIOC   (0x1e4)

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* CTL */
#define DCAN_CTL_ABO   (0x00000200u)
#define DCAN_CTL_ABO_SHIFT   (0x00000009u)
#define DCAN_CTL_ABO_DISABLED   (0x0u)
#define DCAN_CTL_ABO_ENABLED   (0x1u)

#define DCAN_CTL_CCE   (0x00000040u)
#define DCAN_CTL_CCE_SHIFT   (0x00000006u)
#define DCAN_CTL_CCE_ACCESS   (0x1u)
#define DCAN_CTL_CCE_NOACCESS   (0x0u)

#define DCAN_CTL_DAR   (0x00000020u)
#define DCAN_CTL_DAR_SHIFT   (0x00000005u)
#define DCAN_CTL_DAR_DISABLED   (0x1u)
#define DCAN_CTL_DAR_ENABLED   (0x0u)

#define DCAN_CTL_DE1   (0x00040000u)
#define DCAN_CTL_DE1_SHIFT   (0x00000012u)
#define DCAN_CTL_DE1_DISABLED   (0x0u)
#define DCAN_CTL_DE1_ENABLED   (0x1u)

#define DCAN_CTL_DE2   (0x00080000u)
#define DCAN_CTL_DE2_SHIFT   (0x00000013u)
#define DCAN_CTL_DE2_DISABLED   (0x0u)
#define DCAN_CTL_DE2_ENABLED   (0x1u)

#define DCAN_CTL_DE3   (0x00100000u)
#define DCAN_CTL_DE3_SHIFT   (0x00000014u)
#define DCAN_CTL_DE3_DISABLED   (0x0u)
#define DCAN_CTL_DE3_ENABLED   (0x1u)

#define DCAN_CTL_EIE   (0x00000008u)
#define DCAN_CTL_EIE_SHIFT   (0x00000003u)
#define DCAN_CTL_EIE_DISABLED   (0x0u)
#define DCAN_CTL_EIE_ENABLED   (0x1u)

#define DCAN_CTL_IDS   (0x00000100u)
#define DCAN_CTL_IDS_SHIFT   (0x00000008u)
#define DCAN_CTL_IDS_INTERRUPT   (0x1u)
#define DCAN_CTL_IDS_WAIT   (0x0u)

#define DCAN_CTL_IE0   (0x00000002u)
#define DCAN_CTL_IE0_SHIFT   (0x00000001u)
#define DCAN_CTL_IE0_DISABLED   (0x0u)
#define DCAN_CTL_IE0_ENABLED   (0x1u)

#define DCAN_CTL_IE1   (0x00020000u)
#define DCAN_CTL_IE1_SHIFT   (0x00000011u)
#define DCAN_CTL_IE1_DISABLED   (0x0u)
#define DCAN_CTL_IE1_ENABLED   (0x1u)

#define DCAN_CTL_INIT   (0x00000001u)
#define DCAN_CTL_INIT_SHIFT   (0x00000000u)
#define DCAN_CTL_INIT_INITMODE   (0x1u)
#define DCAN_CTL_INIT_NORMAL   (0x0u)

#define DCAN_CTL_INITDBG   (0x00010000u)
#define DCAN_CTL_INITDBG_SHIFT   (0x00000010u)
#define DCAN_CTL_INITDBG_DISABLED   (0x0u)
#define DCAN_CTL_INITDBG_ENABLED   (0x1u)

#define DCAN_CTL_PDR   (0x01000000u)
#define DCAN_CTL_PDR_SHIFT   (0x00000018u)
#define DCAN_CTL_PDR_NOTPOWERDOWN   (0x0u)
#define DCAN_CTL_PDR_POWERDOWN   (0x1u)

#define DCAN_CTL_PMD   (0x00003C00u)
#define DCAN_CTL_PMD_SHIFT   (0x0000000Au)
#define DCAN_CTL_PMD_DISABLED   (0x5u)
#define DCAN_CTL_PMD_ENABLED   (0x1u)

#define DCAN_CTL_SIE   (0x00000004u)
#define DCAN_CTL_SIE_SHIFT   (0x00000002u)
#define DCAN_CTL_SIE_DISABLED   (0x0u)
#define DCAN_CTL_SIE_ENABLED   (0x1u)

#define DCAN_CTL_SWR   (0x00008000u)
#define DCAN_CTL_SWR_SHIFT   (0x0000000Fu)
#define DCAN_CTL_SWR_NORMAL   (0x0u)
#define DCAN_CTL_SWR_RESET   (0x1u)

#define DCAN_CTL_TEST   (0x00000080u)
#define DCAN_CTL_TEST_SHIFT   (0x00000007u)
#define DCAN_CTL_TEST_NORMALMODE   (0x0u)
#define DCAN_CTL_TEST_TESTMODE   (0x1u)

#define DCAN_CTL_WUBA   (0x02000000u)
#define DCAN_CTL_WUBA_SHIFT   (0x00000019u)
#define DCAN_CTL_WUBA_DETECTION   (0x1u)
#define DCAN_CTL_WUBA_NODETECTION   (0x0u)


/* PARITYERR_EOI */
#define DCAN_PARITYERR_EOI_PARITYERR_EOI   (0x00000100u)
#define DCAN_PARITYERR_EOI_PARITYERR_EOI_SHIFT   (0x00000008u)
#define DCAN_PARITYERR_EOI_PARITYERR_EOI_ENDOFINTERRUPT   (0x1u)
#define DCAN_PARITYERR_EOI_PARITYERR_EOI_NOEFFECT   (0x0u)


/* ES */
#define DCAN_ES_BOFF   (0x00000080u)
#define DCAN_ES_BOFF_SHIFT   (0x00000007u)
#define DCAN_ES_BOFF_ERROR   (0x1u)
#define DCAN_ES_BOFF_NOERROR   (0x0u)

#define DCAN_ES_EPASS   (0x00000020u)
#define DCAN_ES_EPASS_SHIFT   (0x00000005u)
#define DCAN_ES_EPASS_NOPASSIVE   (0x0u)
#define DCAN_ES_EPASS_PASSIVEERROR   (0x1u)

#define DCAN_ES_EWARN   (0x00000040u)
#define DCAN_ES_EWARN_SHIFT   (0x00000006u)
#define DCAN_ES_EWARN_ATLEAST1ERRORABOVE_96   (0x1u)
#define DCAN_ES_EWARN_ERRENCOUNTERBELOW_96   (0x0u)

#define DCAN_ES_LEC   (0x00000007u)
#define DCAN_ES_LEC_SHIFT   (0x00000000u)
#define DCAN_ES_LEC_ACKERROR   (0x3u)
#define DCAN_ES_LEC_BIT0ERROR   (0x5u)
#define DCAN_ES_LEC_BIT1ERROR   (0x4u)
#define DCAN_ES_LEC_CRCERROR   (0x6u)
#define DCAN_ES_LEC_FORMERROR   (0x2u)
#define DCAN_ES_LEC_NOERROR   (0x0u)
#define DCAN_ES_LEC_NOEVENT   (0x7u)
#define DCAN_ES_LEC_STUFFERROR   (0x1u)

#define DCAN_ES_PDA   (0x00000400u)
#define DCAN_ES_PDA_SHIFT   (0x0000000Au)
#define DCAN_ES_PDA_NOTPOWERDOWN   (0x0u)
#define DCAN_ES_PDA_POWERDOWN   (0x1u)

#define DCAN_ES_PER   (0x00000100u)
#define DCAN_ES_PER_SHIFT   (0x00000008u)
#define DCAN_ES_PER_ERROR   (0x1u)
#define DCAN_ES_PER_NOERROR   (0x0u)

#define DCAN_ES_RXOK   (0x00000010u)
#define DCAN_ES_RXOK_SHIFT   (0x00000004u)
#define DCAN_ES_RXOK_MESSAGERECIEVED   (0x1u)
#define DCAN_ES_RXOK_NOMESSAGE   (0x0u)

#define DCAN_ES_TXOK   (0x00000008u)
#define DCAN_ES_TXOK_SHIFT   (0x00000003u)
#define DCAN_ES_TXOK_MESSAGETRANSMITTED   (0x1u)
#define DCAN_ES_TXOK_NOMESSAGE   (0x0u)

#define DCAN_ES_WAKEUPPND   (0x00000200u)
#define DCAN_ES_WAKEUPPND_SHIFT   (0x00000009u)
#define DCAN_ES_WAKEUPPND_INITWAKEUP   (0x1u)
#define DCAN_ES_WAKEUPPND_NOWAKEUP   (0x0u)


/* ERRC */
#define DCAN_ERRC_REC   (0x00007F00u)
#define DCAN_ERRC_REC_SHIFT   (0x00000008u)

#define DCAN_ERRC_RP   (0x00008000u)
#define DCAN_ERRC_RP_SHIFT   (0x0000000Fu)
#define DCAN_ERRC_RP_BELOWERRORPASSIVELEVEL   (0x0u)
#define DCAN_ERRC_RP_REACHEDERRORPASSIVELEVEL   (0x1u)

#define DCAN_ERRC_TEC   (0x000000FFu)
#define DCAN_ERRC_TEC_SHIFT   (0x00000000u)


/* BTR */
#define DCAN_BTR_BRP   (0x0000003Fu)
#define DCAN_BTR_BRP_SHIFT   (0x00000000u)

#define DCAN_BTR_BRPE   (0x000F0000u)
#define DCAN_BTR_BRPE_SHIFT   (0x00000010u)

#define DCAN_BTR_DCAN_BTR   (0xFFFFFFFFu)
#define DCAN_BTR_DCAN_BTR_SHIFT   (0x00000000u)

#define DCAN_BTR_SJW   (0x000000C0u)
#define DCAN_BTR_SJW_SHIFT   (0x00000006u)

#define DCAN_BTR_TSEG1   (0x00000F00u)
#define DCAN_BTR_TSEG1_SHIFT   (0x00000008u)

#define DCAN_BTR_TSEG2   (0x00007000u)
#define DCAN_BTR_TSEG2_SHIFT   (0x0000000Cu)


/* INT */
#define DCAN_INT_INT0ID   (0x0000FFFFu)
#define DCAN_INT_INT0ID_SHIFT   (0x00000000u)

#define DCAN_INT_INT1ID   (0x00FF0000u)
#define DCAN_INT_INT1ID_SHIFT   (0x00000010u)


/* TEST */
#define DCAN_TEST_EXL   (0x00000100u)
#define DCAN_TEST_EXL_SHIFT   (0x00000008u)
#define DCAN_TEST_EXL_DISABLED   (0x0u)
#define DCAN_TEST_EXL_ENABLED   (0x1u)

#define DCAN_TEST_LBACK   (0x00000010u)
#define DCAN_TEST_LBACK_SHIFT   (0x00000004u)
#define DCAN_TEST_LBACK_DISABLED   (0x0u)
#define DCAN_TEST_LBACK_ENABLED   (0x1u)

#define DCAN_TEST_RDA   (0x00000200u)
#define DCAN_TEST_RDA_SHIFT   (0x00000009u)
#define DCAN_TEST_RDA_ACCESS   (0x1u)
#define DCAN_TEST_RDA_NORMAL   (0x0u)

#define DCAN_TEST_RX   (0x00000080u)
#define DCAN_TEST_RX_SHIFT   (0x00000007u)
#define DCAN_TEST_RX_DOMINANT   (0x0u)
#define DCAN_TEST_RX_RECESSIVE   (0x1u)

#define DCAN_TEST_TX   (0x00000060u)
#define DCAN_TEST_TX_SHIFT   (0x00000005u)
#define DCAN_TEST_TX_DOMINANT   (0x2u)
#define DCAN_TEST_TX_NORMAL   (0x0u)
#define DCAN_TEST_TX_RECESSIVE   (0x3u)
#define DCAN_TEST_TX_SAMPLEPOINT   (0x1u)

#define DCAN_TEST_SILENT   (0x00000008u)
#define DCAN_TEST_SILENT_SHIFT   (0x00000003u)
#define DCAN_TEST_SILENT_DISABLED   (0x0u)
#define DCAN_TEST_SILENT_ENABLED   (0x1u)


/* PERR */
#define DCAN_PERR_MESSAGE_NUMBER   (0x000000FFu)
#define DCAN_PERR_MESSAGE_NUMBER_SHIFT   (0x00000000u)

#define DCAN_PERR_WORD_NUMBER   (0x00000700u)
#define DCAN_PERR_WORD_NUMBER_SHIFT   (0x00000008u)


/* ABOTR */
#define DCAN_ABOTR_ABOTIME   (0xFFFFFFFFu)
#define DCAN_ABOTR_ABOTIME_SHIFT   (0x00000000u)


/* TXRQ_X */
#define DCAN_TXRQ_X_TXRQSTREG1   (0x00000003u)
#define DCAN_TXRQ_X_TXRQSTREG1_SHIFT   (0x00000000u)

#define DCAN_TXRQ_X_TXRQSTREG2   (0x0000000Cu)
#define DCAN_TXRQ_X_TXRQSTREG2_SHIFT   (0x00000002u)

#define DCAN_TXRQ_X_TXRQSTREG3   (0x00000030u)
#define DCAN_TXRQ_X_TXRQSTREG3_SHIFT   (0x00000004u)

#define DCAN_TXRQ_X_TXRQSTREG4   (0x000000C0u)
#define DCAN_TXRQ_X_TXRQSTREG4_SHIFT   (0x00000006u)

#define DCAN_TXRQ_X_TXRQSTREG5   (0x00000300u)
#define DCAN_TXRQ_X_TXRQSTREG5_SHIFT   (0x00000008u)

#define DCAN_TXRQ_X_TXRQSTREG6   (0x00000C00u)
#define DCAN_TXRQ_X_TXRQSTREG6_SHIFT   (0x0000000Au)

#define DCAN_TXRQ_X_TXRQSTREG7   (0x00003000u)
#define DCAN_TXRQ_X_TXRQSTREG7_SHIFT   (0x0000000Cu)

#define DCAN_TXRQ_X_TXRQSTREG8   (0x0000C000u)
#define DCAN_TXRQ_X_TXRQSTREG8_SHIFT   (0x0000000Eu)


/* TXRQ12 */
#define DCAN_TXRQ12_TXRQST_16_1   (0x0000FFFFu)
#define DCAN_TXRQ12_TXRQST_16_1_SHIFT   (0x00000000u)

#define DCAN_TXRQ12_TXRQST_32_17   (0xFFFF0000u)
#define DCAN_TXRQ12_TXRQST_32_17_SHIFT   (0x00000010u)


/* TXRQ34 */
#define DCAN_TXRQ34_TXRQST_48_33   (0x0000FFFFu)
#define DCAN_TXRQ34_TXRQST_48_33_SHIFT   (0x00000000u)

#define DCAN_TXRQ34_TXRQST_64_49   (0xFFFF0000u)
#define DCAN_TXRQ34_TXRQST_64_49_SHIFT   (0x00000010u)


/* TXRQ56 */
#define DCAN_TXRQ56_TXRQST_80_65   (0x0000FFFFu)
#define DCAN_TXRQ56_TXRQST_80_65_SHIFT   (0x00000000u)

#define DCAN_TXRQ56_TXRQST_96_81   (0xFFFF0000u)
#define DCAN_TXRQ56_TXRQST_96_81_SHIFT   (0x00000010u)


/* TXRQ78 */
#define DCAN_TXRQ78_TXRQST_112_97   (0x0000FFFFu)
#define DCAN_TXRQ78_TXRQST_112_97_SHIFT   (0x00000000u)

#define DCAN_TXRQ78_TXRQST_128_113   (0xFFFF0000u)
#define DCAN_TXRQ78_TXRQST_128_113_SHIFT   (0x00000010u)


/* NWDAT_X */
#define DCAN_NWDAT_X_NEWDATREG1   (0x00000003u)
#define DCAN_NWDAT_X_NEWDATREG1_SHIFT   (0x00000000u)

#define DCAN_NWDAT_X_NEWDATREG2   (0x0000000Cu)
#define DCAN_NWDAT_X_NEWDATREG2_SHIFT   (0x00000002u)

#define DCAN_NWDAT_X_NEWDATREG3   (0x00000030u)
#define DCAN_NWDAT_X_NEWDATREG3_SHIFT   (0x00000004u)

#define DCAN_NWDAT_X_NEWDATREG4   (0x000000C0u)
#define DCAN_NWDAT_X_NEWDATREG4_SHIFT   (0x00000006u)

#define DCAN_NWDAT_X_NEWDATREG5   (0x00000300u)
#define DCAN_NWDAT_X_NEWDATREG5_SHIFT   (0x00000008u)

#define DCAN_NWDAT_X_NEWDATREG6   (0x00000C00u)
#define DCAN_NWDAT_X_NEWDATREG6_SHIFT   (0x0000000Au)

#define DCAN_NWDAT_X_NEWDATREG7   (0x00003000u)
#define DCAN_NWDAT_X_NEWDATREG7_SHIFT   (0x0000000Cu)

#define DCAN_NWDAT_X_NEWDATREG8   (0x0000C000u)
#define DCAN_NWDAT_X_NEWDATREG8_SHIFT   (0x0000000Eu)


/* NWDAT12 */
#define DCAN_NWDAT12_NEWDAT_16_1   (0x0000FFFFu)
#define DCAN_NWDAT12_NEWDAT_16_1_SHIFT   (0x00000000u)

#define DCAN_NWDAT12_NEWDAT_32_17   (0xFFFF0000u)
#define DCAN_NWDAT12_NEWDAT_32_17_SHIFT   (0x00000010u)

#define DCAN_NWDAT12_NEWDAT_80_65   (0x0000FFFFu)
#define DCAN_NWDAT12_NEWDAT_80_65_SHIFT   (0x00000000u)


/* NWDAT34 */
#define DCAN_NWDAT34_NEWDAT_48_33   (0x0000FFFFu)
#define DCAN_NWDAT34_NEWDAT_48_33_SHIFT   (0x00000000u)

#define DCAN_NWDAT34_NEWDAT_64_49   (0xFFFF0000u)
#define DCAN_NWDAT34_NEWDAT_64_49_SHIFT   (0x00000010u)


/* NWDAT56 */

#define DCAN_NWDAT56_NEWDAT_96_81   (0xFFFF0000u)
#define DCAN_NWDAT56_NEWDAT_96_81_SHIFT   (0x00000000u)


/* NWDAT78 */
#define DCAN_NWDAT78_NEWDAT_112_97   (0x0000FFFFu)
#define DCAN_NWDAT78_NEWDAT_112_97_SHIFT   (0x00000000u)

#define DCAN_NWDAT78_NEWDAT_128_113   (0xFFFF0000u)
#define DCAN_NWDAT78_NEWDAT_128_113_SHIFT   (0x00000010u)


/* INTPND_X */
#define DCAN_INTPND_X_INTPNDREG1   (0x00000003u)
#define DCAN_INTPND_X_INTPNDREG1_SHIFT   (0x00000000u)

#define DCAN_INTPND_X_INTPNDREG2   (0x0000000Cu)
#define DCAN_INTPND_X_INTPNDREG2_SHIFT   (0x00000002u)

#define DCAN_INTPND_X_INTPNDREG3   (0x00000030u)
#define DCAN_INTPND_X_INTPNDREG3_SHIFT   (0x00000004u)

#define DCAN_INTPND_X_INTPNDREG4   (0x000000C0u)
#define DCAN_INTPND_X_INTPNDREG4_SHIFT   (0x00000006u)

#define DCAN_INTPND_X_INTPNDREG5   (0x00000300u)
#define DCAN_INTPND_X_INTPNDREG5_SHIFT   (0x00000008u)

#define DCAN_INTPND_X_INTPNDREG6   (0x00000C00u)
#define DCAN_INTPND_X_INTPNDREG6_SHIFT   (0x0000000Au)

#define DCAN_INTPND_X_INTPNDREG7   (0x00003000u)
#define DCAN_INTPND_X_INTPNDREG7_SHIFT   (0x0000000Cu)

#define DCAN_INTPND_X_INTPNDREG8   (0x0000C000u)
#define DCAN_INTPND_X_INTPNDREG8_SHIFT   (0x0000000Eu)


/* INTPND12 */
#define DCAN_INTPND12_INTPND_16_1   (0x0000FFFFu)
#define DCAN_INTPND12_INTPND_16_1_SHIFT   (0x00000001u)

#define DCAN_INTPND12_INTPND_32_17   (0xFFFF0000u)
#define DCAN_INTPND12_INTPND_32_17_SHIFT   (0x00000010u)


/* INTPND34 */
#define DCAN_INTPND34_INTPND_48_33   (0x0000FFFFu)
#define DCAN_INTPND34_INTPND_48_33_SHIFT   (0x00000001u)

#define DCAN_INTPND34_INTPND_64_49   (0xFFFF0000u)
#define DCAN_INTPND34_INTPND_64_49_SHIFT   (0x00000010u)


/* INTPND56 */
#define DCAN_INTPND56_INTPND_80_65   (0x0000FFFFu)
#define DCAN_INTPND56_INTPND_80_65_SHIFT   (0x00000001u)

#define DCAN_INTPND56_INTPND_96_81   (0xFFFF0000u)
#define DCAN_INTPND56_INTPND_96_81_SHIFT   (0x00000000u)



/* INTPND78 */

#define DCAN_INTPND78_INTPND_128_113   (0xFFFF0000u)
#define DCAN_INTPND78_INTPND_128_113_SHIFT   (0x00000010u)


/* MSGVAL_X */
#define DCAN_MSGVAL_X_MSGVALREG1   (0x00000003u)
#define DCAN_MSGVAL_X_MSGVALREG1_SHIFT   (0x00000000u)

#define DCAN_MSGVAL_X_MSGVALREG2   (0x0000000Cu)
#define DCAN_MSGVAL_X_MSGVALREG2_SHIFT   (0x00000002u)

#define DCAN_MSGVAL_X_MSGVALREG3   (0x00000030u)
#define DCAN_MSGVAL_X_MSGVALREG3_SHIFT   (0x00000004u)

#define DCAN_MSGVAL_X_MSGVALREG4   (0x000000C0u)
#define DCAN_MSGVAL_X_MSGVALREG4_SHIFT   (0x00000006u)

#define DCAN_MSGVAL_X_MSGVALREG5   (0x00000300u)
#define DCAN_MSGVAL_X_MSGVALREG5_SHIFT   (0x00000008u)

#define DCAN_MSGVAL_X_MSGVALREG6   (0x00000C00u)
#define DCAN_MSGVAL_X_MSGVALREG6_SHIFT   (0x0000000Au)

#define DCAN_MSGVAL_X_MSGVALREG7   (0x00003000u)
#define DCAN_MSGVAL_X_MSGVALREG7_SHIFT   (0x0000000Cu)

#define DCAN_MSGVAL_X_MSGVALREG8   (0x0000C000u)
#define DCAN_MSGVAL_X_MSGVALREG8_SHIFT   (0x00000000u)


/* MSGVAL12 */
#define DCAN_MSGVAL12_MSGVAL_16_1   (0x0000FFFFu)
#define DCAN_MSGVAL12_MSGVAL_16_1_SHIFT   (0x00000001u)

#define DCAN_MSGVAL12_MSGVAL_32_17   (0xFFFF0000u)
#define DCAN_MSGVAL12_MSGVAL_32_17_SHIFT   (0x00000010u)


/* MSGVAL34 */
#define DCAN_MSGVAL34_MSGVAL_48_33   (0x0000FFFFu)
#define DCAN_MSGVAL34_MSGVAL_48_33_SHIFT   (0x00000001u)

#define DCAN_MSGVAL34_MSGVAL_64_49   (0xFFFF0000u)
#define DCAN_MSGVAL34_MSGVAL_64_49_SHIFT   (0x00000010u)


/* MSGVAL56 */
#define DCAN_MSGVAL56_MSGVAL_80_65   (0x0000FFFFu)
#define DCAN_MSGVAL56_MSGVAL_80_65_SHIFT   (0x00000001u)

#define DCAN_MSGVAL56_MSGVAL_96_81   (0xFFFF0000u)
#define DCAN_MSGVAL56_MSGVAL_96_81_SHIFT   (0x00000010u)


/* MSGVAL78 */
#define DCAN_MSGVAL78_MSGVAL_112_97   (0x0000FFFFu)
#define DCAN_MSGVAL78_MSGVAL_112_97_SHIFT   (0x00000001u)

#define DCAN_MSGVAL78_MSGVAL_128_113   (0xFFFF0000u)
#define DCAN_MSGVAL78_MSGVAL_128_113_SHIFT   (0x00000010u)


/* INTMUX12 */
#define DCAN_INTMUX12_INTMUX_16_1   (0x0000FFFFu)
#define DCAN_INTMUX12_INTMUX_16_1_SHIFT   (0x00000001u)

#define DCAN_INTMUX12_INTMUX_32_17   (0xFFFF0000u)
#define DCAN_INTMUX12_INTMUX_32_17_SHIFT   (0x00000010u)


/* INTMUX34 */
#define DCAN_INTMUX34_INTMUX_48_33   (0x0000FFFFu)
#define DCAN_INTMUX34_INTMUX_48_33_SHIFT   (0x00000001u)

#define DCAN_INTMUX34_INTMUX_64_49   (0xFFFF0000u)
#define DCAN_INTMUX34_INTMUX_64_49_SHIFT   (0x00000010u)


/* INTMUX56 */
#define DCAN_INTMUX56_INTMUX_80_65   (0x0000FFFFu)
#define DCAN_INTMUX56_INTMUX_80_65_SHIFT   (0x00000001u)

#define DCAN_INTMUX56_INTMUX_96_81   (0xFFFF0000u)
#define DCAN_INTMUX56_INTMUX_96_81_SHIFT   (0x00000010u)


/* INTMUX78 */
#define DCAN_INTMUX78_INTMUX_112_95   (0x0000FFFFu)
#define DCAN_INTMUX78_INTMUX_112_95_SHIFT   (0x00000001u)

#define DCAN_INTMUX78_INTMUX_128_113   (0xFFFF0000u)
#define DCAN_INTMUX78_INTMUX_128_113_SHIFT   (0x00000010u)

/* IFxCMD mu */
#define DCAN_IFCMD_ARB   (0x00200000u)
#define DCAN_IFCMD_ARB_SHIFT   (0x00000015u)
#define DCAN_IFCMD_ARB_NOCHANGE   (0x0u)
#define DCAN_IFCMD_ARB_OBJTOREG   (0x1u)
#define DCAN_IFCMD_ARB_REGTOOBJ   (0x1u)

#define DCAN_IFCMD_BUSY   (0x00008000u)
#define DCAN_IFCMD_BUSY_SHIFT   (0x0000000Fu)
#define DCAN_IFCMD_BUSY_NOTRANSFER   (0x0u)
#define DCAN_IFCMD_BUSY_TRANSFER   (0x1u)

#define DCAN_IFCMD_CLRINTPND   (0x00080000u)
#define DCAN_IFCMD_CLRINTPND_SHIFT   (0x00000013u)
#define DCAN_IFCMD_CLRINTPND_CHANGE   (0x1u)
#define DCAN_IFCMD_CLRINTPND_NOCHANGE   (0x0u)

#define DCAN_IFCMD_CONTROL   (0x00100000u)
#define DCAN_IFCMD_CONTROL_SHIFT   (0x00000014u)

#define DCAN_IFCMD_DATAA   (0x00020000u)
#define DCAN_IFCMD_DATAA_SHIFT   (0x00000011u)

#define DCAN_IFCMD_DATAB   (0x00010000u)
#define DCAN_IFCMD_DATAB_SHIFT   (0x00000010u)

#define DCAN_IFCMD_DMAACTIVE   (0x00004000u)
#define DCAN_IFCMD_DMAACTIVE_SHIFT   (0x0000000Eu)
#define DCAN_IFCMD_DMAACTIVE_ACTIVE   (0x1u)
#define DCAN_IFCMD_DMAACTIVE_INACTIVE   (0x0u)

#define DCAN_IFCMD_MASK   (0x00400000u)
#define DCAN_IFCMD_MASK_SHIFT   (0x00000016u)

#define DCAN_IFCMD_MESSAGENUMBER   (0x000000FFu)
#define DCAN_IFCMD_MESSAGENUMBER_SHIFT   (0x00000000u)

#define DCAN_IFCMD_TXRQST_NEWDAT   (0x00040000u)
#define DCAN_IFCMD_TXRQST_NEWDAT_SHIFT   (0x00000012u)

#define DCAN_IFCMD_WR_RD   (0x00800000u)
#define DCAN_IFCMD_WR_RD_SHIFT   (0x00000017u)


/* IFxMSK mu */
#define DCAN_IFMSK_MDIR   (0x40000000u)
#define DCAN_IFMSK_MDIR_SHIFT   (0x00000001Eu)
#define DCAN_IFMSK_MDIR_NOTUSED   (0x0u)
#define DCAN_IFMSK_MDIR_USED   (0x1u)

#define DCAN_IFMSK_MSK   (0x1FFFFFFFu)
#define DCAN_IFMSK_MSK_SHIFT   (0x00000000u)
#define DCAN_IFMSK_MSK_NOTUSED   (0x0u)
#define DCAN_IFMSK_MSK_USED   (0x1u)

#define DCAN_IFMSK_MXTD   (0x80000000u)
#define DCAN_IFMSK_MXTD_SHIFT   (0x00000001Fu)
#define DCAN_IFMSK_MXTD_NOTUSED   (0x0u)
#define DCAN_IFMSK_MXTD_USED   (0x1u)


/* IFxARB mu */
#define DCAN_IFARB_DIR   (0x20000000u)
#define DCAN_IFARB_DIR_SHIFT   (0x0000001Du)
#define DCAN_IFARB_DIR_RECEIVE   (0x0u)
#define DCAN_IFARB_DIR_TRANSMIT   (0x1u)

#define DCAN_IFARB_MSGVAL   (0x80000000u)
#define DCAN_IFARB_MSGVAL_SHIFT   (0x0000001Fu)
#define DCAN_IFARB_MSGVAL_IGNORED   (0x0u)
#define DCAN_IFARB_MSGVAL_USED   (0x1u)

#define DCAN_IFARB_MSK   (0x1FFFFFFFu)
#define DCAN_IFARB_MSK_SHIFT   (0x000000000u)
#define DCAN_IFARB_MSK_RECEIVE   (0x0u)
#define DCAN_IFARB_MSK_TRANSMIT   (0x1u)

#define DCAN_IFARB_XTD   (0x40000000u)
#define DCAN_IFARB_XTD_SHIFT   (0x0000001Eu)
#define DCAN_IFARB_XTD_11_BIT   (0x0u)
#define DCAN_IFARB_XTD_29_BIT   (0x1u)

/* IFxMCTL mu */
#define DCAN_IFMCTL_DATALENGTHCODE   (0x0000000Fu)
#define DCAN_IFMCTL_DATALENGTHCODE_SHIFT   (0x00000000u)

#define DCAN_IFMCTL_EOB   (0x00000080u)
#define DCAN_IFMCTL_EOB_SHIFT   (0x00000007u)

#define DCAN_IFMCTL_INTPND   (0x00002000u)
#define DCAN_IFMCTL_INTPND_SHIFT   (0x0000000Du)
#define DCAN_IFMCTL_INTPND_INTERRUPT   (0x1u)
#define DCAN_IFMCTL_INTPND_NOINTERRUPT   (0x0u)

#define DCAN_IFMCTL_MSGLST   (0x00004000u)
#define DCAN_IFMCTL_MSGLST_SHIFT   (0x0000000Eu)
#define DCAN_IFMCTL_MSGLST_MSGLOST   (0x1u)
#define DCAN_IFMCTL_MSGLST_NOMSGLOST   (0x0u)

#define DCAN_IFMCTL_NEWDAT   (0x00008000u)
#define DCAN_IFMCTL_NEWDAT_SHIFT   (0x0000000Fu)
#define DCAN_IFMCTL_NEWDAT_NEWDATA   (0x1u)
#define DCAN_IFMCTL_NEWDAT_NONEWDATA   (0x0u)

#define DCAN_IFMCTL_RMTEN   (0x00000200u)
#define DCAN_IFMCTL_RMTEN_SHIFT   (0x00000009u)
#define DCAN_IFMCTL_RMTEN_DISABLE   (0x0u)
#define DCAN_IFMCTL_RMTEN_ENABLE   (0x1u)

#define DCAN_IFMCTL_RXIE   (0x00000400u)
#define DCAN_IFMCTL_RXIE_SHIFT   (0x0000000Au)
#define DCAN_IFMCTL_RXIE_NOTRIGGER   (0x0u)
#define DCAN_IFMCTL_RXIE_TRIGGER   (0x1u)

#define DCAN_IFMCTL_TXIE   (0x00000800u)
#define DCAN_IFMCTL_TXIE_SHIFT   (0x0000000Bu)
#define DCAN_IFMCTL_TXIE_NOTRIGGER   (0x0u)
#define DCAN_IFMCTL_TXIE_TRIGGER   (0x1u)

#define DCAN_IFMCTL_TXRQST   (0x00000100u)
#define DCAN_IFMCTL_TXRQST_SHIFT   (0x00000008u)
#define DCAN_IFMCTL_TXRQST_NOREQUESTED   (0x0u)
#define DCAN_IFMCTL_TXRQST_REQUESTED   (0x1u)

#define DCAN_IFMCTL_UMASK   (0x00001000u)
#define DCAN_IFMCTL_UMASK_SHIFT   (0x0000000Cu)
#define DCAN_IFMCTL_UMASK_IGNORED   (0x0u)
#define DCAN_IFMCTL_UMASK_MASKED   (0x1u)

/* IFxDATA mu */
#define DCAN_IFDATA_DCAN_IFDATA   (0xFFFFFFFFu)
#define DCAN_IFDATA_DCAN_IFDATA_SHIFT   (0x00000000u)


/* IFxDATB mu */
#define DCAN_IFDATB_DCAN_IFDATB   (0xFFFFFFFFu)
#define DCAN_IFDATB_DCAN_IFDATB_SHIFT   (0x00000000u)

/* IF1CMD */
#define DCAN_IF1CMD_ARB   (0x00200000u)
#define DCAN_IF1CMD_ARB_SHIFT   (0x00000015u)

#define DCAN_IF1CMD_BUSY   (0x00008000u)
#define DCAN_IF1CMD_BUSY_SHIFT   (0x0000000Fu)
#define DCAN_IF1CMD_BUSY_NOTRANSFER   (0x0u)
#define DCAN_IF1CMD_BUSY_TRANSFER   (0x1u)

#define DCAN_IF1CMD_CLRINTPND   (0x00080000u)
#define DCAN_IF1CMD_CLRINTPND_SHIFT   (0x00000013u)
#define DCAN_IF1CMD_CLRINTPND_CHANGE   (0x1u)
#define DCAN_IF1CMD_CLRINTPND_NOCHANGE   (0x0u)

#define DCAN_IF1CMD_CONTROL   (0x00100000u)
#define DCAN_IF1CMD_CONTROL_SHIFT   (0x00000014u)

#define DCAN_IF1CMD_DATAA   (0x00020000u)
#define DCAN_IF1CMD_DATAA_SHIFT   (0x00000011u)

#define DCAN_IF1CMD_DATAB   (0x00010000u)
#define DCAN_IF1CMD_DATAB_SHIFT   (0x00000010u)

#define DCAN_IF1CMD_DMAACTIVE   (0x00004000u)
#define DCAN_IF1CMD_DMAACTIVE_SHIFT   (0x0000000Eu)
#define DCAN_IF1CMD_DMAACTIVE_ACTIVE   (0x1u)
#define DCAN_IF1CMD_DMAACTIVE_INACTIVE   (0x0u)

#define DCAN_IF1CMD_MASK   (0x00400000u)
#define DCAN_IF1CMD_MASK_SHIFT   (0x00000016u)

#define DCAN_IF1CMD_MESSAGENUMBER   (0x0000000Fu)
#define DCAN_IF1CMD_MESSAGENUMBER_SHIFT   (0x00000000u)

#define DCAN_IF1CMD_TXRQST_NEWDAT   (0x00040000u)
#define DCAN_IF1CMD_TXRQST_NEWDAT_SHIFT   (0x00000012u)

#define DCAN_IF1CMD_WR_RD   (0x00800000u)
#define DCAN_IF1CMD_WR_RD_SHIFT   (0x00000017u)


/* IF1MSK */
#define DCAN_IF1MSK_MDIR   (0x40000000u)
#define DCAN_IF1MSK_MDIR_SHIFT   (0x00000001Eu)
#define DCAN_IF1MSK_MDIR_NOTUSED   (0x0u)
#define DCAN_IF1MSK_MDIR_USED   (0x1u)

#define DCAN_IF1MSK_MSK   (0x1FFFFFFFu)
#define DCAN_IF1MSK_MSK_SHIFT   (0x00000000u)
#define DCAN_IF1MSK_MSK_NOTUSED   (0x0u)
#define DCAN_IF1MSK_MSK_USED   (0x1u)

#define DCAN_IF1MSK_MXTD   (0x80000000u)
#define DCAN_IF1MSK_MXTD_SHIFT   (0x00000001Fu)
#define DCAN_IF1MSK_MXTD_NOTUSED   (0x0u)
#define DCAN_IF1MSK_MXTD_USED   (0x1u)


/* IF1ARB */
#define DCAN_IF1ARB_DIR   (0x20000000u)
#define DCAN_IF1ARB_DIR_SHIFT   (0x0000001Du)
#define DCAN_IF1ARB_DIR_RECEIVE   (0x0u)
#define DCAN_IF1ARB_DIR_TRANSMIT   (0x1u)

#define DCAN_IF1ARB_MSGVAL   (0x80000000u)
#define DCAN_IF1ARB_MSGVAL_SHIFT   (0x0000001Fu)
#define DCAN_IF1ARB_MSGVAL_IGNORED   (0x0u)
#define DCAN_IF1ARB_MSGVAL_USED   (0x1u)

#define DCAN_IF1ARB_MSK   (0x1FFFFFFFu)
#define DCAN_IF1ARB_MSK_SHIFT   (0x000000000u)
#define DCAN_IF1ARB_MSK_RECEIVE   (0x0u)
#define DCAN_IF1ARB_MSK_TRANSMIT   (0x1u)

#define DCAN_IF1ARB_XTD   (0x40000000u)
#define DCAN_IF1ARB_XTD_SHIFT   (0x0000001Eu)
#define DCAN_IF1ARB_XTD_11_BIT   (0x0u)
#define DCAN_IF1ARB_XTD_29_BIT   (0x1u)


/* IF1MCTL */
#define DCAN_IF1MCTL_DATALENGTHCODE   (0x0000000Fu)
#define DCAN_IF1MCTL_DATALENGTHCODE_SHIFT   (0x00000000u)

#define DCAN_IF1MCTL_EOB   (0x00000080u)
#define DCAN_IF1MCTL_EOB_SHIFT   (0x00000007u)

#define DCAN_IF1MCTL_INTPND   (0x00002000u)
#define DCAN_IF1MCTL_INTPND_SHIFT   (0x0000000Du)
#define DCAN_IF1MCTL_INTPND_INTERRUPT   (0x1u)
#define DCAN_IF1MCTL_INTPND_NOINTERRUPT   (0x0u)

#define DCAN_IF1MCTL_MSGLST   (0x00004000u)
#define DCAN_IF1MCTL_MSGLST_SHIFT   (0x0000000Eu)
#define DCAN_IF1MCTL_MSGLST_MSGLOST   (0x1u)
#define DCAN_IF1MCTL_MSGLST_NOMSGLOST   (0x0u)

#define DCAN_IF1MCTL_NEWDAT   (0x00008000u)
#define DCAN_IF1MCTL_NEWDAT_SHIFT   (0x0000000Fu)
#define DCAN_IF1MCTL_NEWDAT_NEWDATA   (0x1u)
#define DCAN_IF1MCTL_NEWDAT_NONEWDATA   (0x0u)

#define DCAN_IF1MCTL_RMTEN   (0x00000200u)
#define DCAN_IF1MCTL_RMTEN_SHIFT   (0x00000009u)
#define DCAN_IF1MCTL_RMTEN_DISABLE   (0x0u)
#define DCAN_IF1MCTL_RMTEN_ENABLE   (0x1u)

#define DCAN_IF1MCTL_RXIE   (0x00000400u)
#define DCAN_IF1MCTL_RXIE_SHIFT   (0x0000000Au)
#define DCAN_IF1MCTL_RXIE_NOTRIGGER   (0x0u)
#define DCAN_IF1MCTL_RXIE_TRIGGER   (0x1u)

#define DCAN_IF1MCTL_TXIE   (0x00000800u)
#define DCAN_IF1MCTL_TXIE_SHIFT   (0x0000000Bu)
#define DCAN_IF1MCTL_TXIE_NOTRIGGER   (0x0u)
#define DCAN_IF1MCTL_TXIE_TRIGGER   (0x1u)

#define DCAN_IF1MCTL_TXRQST   (0x00000100u)
#define DCAN_IF1MCTL_TXRQST_SHIFT   (0x00000008u)
#define DCAN_IF1MCTL_TXRQST_NOREQUESTED   (0x0u)
#define DCAN_IF1MCTL_TXRQST_REQUESTED   (0x1u)

#define DCAN_IF1MCTL_UMASK   (0x00001000u)
#define DCAN_IF1MCTL_UMASK_SHIFT   (0x0000000Cu)
#define DCAN_IF1MCTL_UMASK_IGNORED   (0x0u)
#define DCAN_IF1MCTL_UMASK_MASKED   (0x1u)


/* IF1DATA */
#define DCAN_IF1DATA_DCAN_IF1DATA   (0xFFFFFFFFu)
#define DCAN_IF1DATA_DCAN_IF1DATA_SHIFT   (0x00000000u)


/* IF1DATB */
#define DCAN_IF1DATB_DCAN_IF1DATB   (0xFFFFFFFFu)
#define DCAN_IF1DATB_DCAN_IF1DATB_SHIFT   (0x00000000u)


/* IF2CMD */
#define DCAN_IF2CMD_ARB   (0x00200000u)
#define DCAN_IF2CMD_ARB_SHIFT   (0x00000015u)

#define DCAN_IF2CMD_BUSY   (0x00008000u)
#define DCAN_IF2CMD_BUSY_SHIFT   (0x0000000Fu)
#define DCAN_IF2CMD_BUSY_NOTRANSFER   (0x0u)
#define DCAN_IF2CMD_BUSY_TRANSFER   (0x1u)

#define DCAN_IF2CMD_CLRINTPND   (0x00080000u)
#define DCAN_IF2CMD_CLRINTPND_SHIFT   (0x00000013u)
#define DCAN_IF2CMD_CLRINTPND_CHANGE   (0x1u)
#define DCAN_IF2CMD_CLRINTPND_NOCHANGE   (0x0u)

#define DCAN_IF2CMD_CONTROL   (0x00100000u)
#define DCAN_IF2CMD_CONTROL_SHIFT   (0x00000014u)

#define DCAN_IF2CMD_DATAA   (0x00020000u)
#define DCAN_IF2CMD_DATAA_SHIFT   (0x00000011u)

#define DCAN_IF2CMD_DATAB   (0x00010000u)
#define DCAN_IF2CMD_DATAB_SHIFT   (0x00000010u)

#define DCAN_IF2CMD_DMAACTIVE   (0x00004000u)
#define DCAN_IF2CMD_DMAACTIVE_SHIFT   (0x0000000Eu)
#define DCAN_IF2CMD_DMAACTIVE_ACTIVE   (0x1u)
#define DCAN_IF2CMD_DMAACTIVE_INACTIVE   (0x0u)

#define DCAN_IF2CMD_MASK   (0x00400000u)
#define DCAN_IF2CMD_MASK_SHIFT   (0x00000016u)

#define DCAN_IF2CMD_MESSAGENUMBER   (0x000000FFu)
#define DCAN_IF2CMD_MESSAGENUMBER_SHIFT   (0x00000000u)

#define DCAN_IF2CMD_TXRQST_NEWDAT   (0x00040000u)
#define DCAN_IF2CMD_TXRQST_NEWDAT_SHIFT   (0x00000012u)

#define DCAN_IF2CMD_WR_RD   (0x00800000u)
#define DCAN_IF2CMD_WR_RD_SHIFT   (0x00000017u)


/* IF2MSK */
#define DCAN_IF2MSK_MDIR   (0x40000000u)
#define DCAN_IF2MSK_MDIR_SHIFT   (0x00000001Eu)
#define DCAN_IF2MSK_MDIR_NOTUSED   (0x0u)
#define DCAN_IF2MSK_MDIR_USED   (0x1u)

#define DCAN_IF2MSK_MSK   (0x1FFFFFFFu)
#define DCAN_IF2MSK_MSK_SHIFT   (0x00000000u)
#define DCAN_IF2MSK_MSK_NOTUSED   (0x0u)
#define DCAN_IF2MSK_MSK_USED   (0x1u)

#define DCAN_IF2MSK_MXTD   (0x80000000u)
#define DCAN_IF2MSK_MXTD_SHIFT   (0x00000001Fu)
#define DCAN_IF2MSK_MXTD_NOTUSED   (0x0u)
#define DCAN_IF2MSK_MXTD_USED   (0x1u)


/* IF2ARB */
#define DCAN_IF2ARB_DIR   (0x20000000u)
#define DCAN_IF2ARB_DIR_SHIFT   (0x0000001Du)
#define DCAN_IF2ARB_DIR_RECEIVE   (0x0u)
#define DCAN_IF2ARB_DIR_TRANSMIT   (0x1u)

#define DCAN_IF2ARB_MSGVAL   (0x80000000u)
#define DCAN_IF2ARB_MSGVAL_SHIFT   (0x0000001Fu)
#define DCAN_IF2ARB_MSGVAL_IGNORED   (0x0u)
#define DCAN_IF2ARB_MSGVAL_USED   (0x1u)

#define DCAN_IF2ARB_MSK   (0x1FFFFFFFu)
#define DCAN_IF2ARB_MSK_SHIFT   (0x000000000u)
#define DCAN_IF2ARB_MSK_RECEIVE   (0x0u)
#define DCAN_IF2ARB_MSK_TRANSMIT   (0x1u)

#define DCAN_IF2ARB_XTD   (0x40000000u)
#define DCAN_IF2ARB_XTD_SHIFT   (0x0000001Eu)
#define DCAN_IF2ARB_XTD_11_BIT   (0x0u)
#define DCAN_IF2ARB_XTD_29_BIT   (0x1u)


/* IF2MCTL */
#define DCAN_IF2MCTL_DATALENGTHCODE   (0x0000000Fu)
#define DCAN_IF2MCTL_DATALENGTHCODE_SHIFT   (0x00000000u)

#define DCAN_IF2MCTL_EOB   (0x00000080u)
#define DCAN_IF2MCTL_EOB_SHIFT   (0x00000007u)

#define DCAN_IF2MCTL_INTPND   (0x00002000u)
#define DCAN_IF2MCTL_INTPND_SHIFT   (0x0000000Du)
#define DCAN_IF2MCTL_INTPND_INTERRUPT   (0x1u)
#define DCAN_IF2MCTL_INTPND_NOINTERRUPT   (0x0u)

#define DCAN_IF2MCTL_MSGLST   (0x00004000u)
#define DCAN_IF2MCTL_MSGLST_SHIFT   (0x0000000Eu)
#define DCAN_IF2MCTL_MSGLST_MSGLOST   (0x1u)
#define DCAN_IF2MCTL_MSGLST_NOMSGLOST   (0x0u)

#define DCAN_IF2MCTL_NEWDAT   (0x00008000u)
#define DCAN_IF2MCTL_NEWDAT_SHIFT   (0x0000000Fu)
#define DCAN_IF2MCTL_NEWDAT_NEWDATA   (0x1u)
#define DCAN_IF2MCTL_NEWDAT_NONEWDATA   (0x0u)

#define DCAN_IF2MCTL_RMTEN   (0x00000200u)
#define DCAN_IF2MCTL_RMTEN_SHIFT   (0x00000009u)
#define DCAN_IF2MCTL_RMTEN_DISABLE   (0x0u)
#define DCAN_IF2MCTL_RMTEN_ENABLE   (0x1u)

#define DCAN_IF2MCTL_RXIE   (0x00000400u)
#define DCAN_IF2MCTL_RXIE_SHIFT   (0x0000000Au)
#define DCAN_IF2MCTL_RXIE_NOTRIGGER   (0x0u)
#define DCAN_IF2MCTL_RXIE_TRIGGER   (0x1u)

#define DCAN_IF2MCTL_TXIE   (0x00000800u)
#define DCAN_IF2MCTL_TXIE_SHIFT   (0x0000000Bu)
#define DCAN_IF2MCTL_TXIE_NOTRIGGER   (0x0u)
#define DCAN_IF2MCTL_TXIE_TRIGGER   (0x1u)

#define DCAN_IF2MCTL_TXRQST   (0x00000100u)
#define DCAN_IF2MCTL_TXRQST_SHIFT   (0x00000008u)
#define DCAN_IF2MCTL_TXRQST_NOREQUESTED   (0x0u)
#define DCAN_IF2MCTL_TXRQST_REQUESTED   (0x1u)

#define DCAN_IF2MCTL_UMASK   (0x00001000u)
#define DCAN_IF2MCTL_UMASK_SHIFT   (0x0000000Cu)
#define DCAN_IF2MCTL_UMASK_IGNORED   (0x0u)
#define DCAN_IF2MCTL_UMASK_MASKED   (0x1u)


/* IF2DATA */
#define DCAN_IF2DATA_DCAN_IF2DATA   (0xFFFFFFFFu)
#define DCAN_IF2DATA_DCAN_IF2DATA_SHIFT   (0x00000000u)


/* IF2DATB */
#define DCAN_IF2DATB_DCAN_IF2DATB   (0xFFFFFFFFu)
#define DCAN_IF2DATB_DCAN_IF2DATB_SHIFT   (0x00000000u)


/* IF3OBS */
#define DCAN_IF3OBS_ARB   (0x00000002u)
#define DCAN_IF3OBS_ARB_SHIFT   (0x00000001u)
#define DCAN_IF3OBS_ARB_DATATOBEREAD   (0x1u)
#define DCAN_IF3OBS_ARB_NOTTOBEREAD   (0x0u)

#define DCAN_IF3OBS_CTRL   (0x00000004u)
#define DCAN_IF3OBS_CTRL_SHIFT   (0x00000002u)
#define DCAN_IF3OBS_CTRL_DATATOBEREAD   (0x1u)
#define DCAN_IF3OBS_CTRL_NOTTOBEREAD   (0x0u)

#define DCAN_IF3OBS_DATAA   (0x00000008u)
#define DCAN_IF3OBS_DATAA_SHIFT   (0x00000003u)
#define DCAN_IF3OBS_DATAA_DATATOBEREAD   (0x1u)
#define DCAN_IF3OBS_DATAA_NOTTOBEREAD   (0x0u)

#define DCAN_IF3OBS_DATAB   (0x00000010u)
#define DCAN_IF3OBS_DATAB_SHIFT   (0x00000004u)
#define DCAN_IF3OBS_DATAB_DATATOBEREAD   (0x1u)
#define DCAN_IF3OBS_DATAB_NOTTOBEREAD   (0x0u)

#define DCAN_IF3OBS_IF3SA   (0x00000200u)
#define DCAN_IF3OBS_IF3SA_SHIFT   (0x00000009u)
#define DCAN_IF3OBS_IF3SA_ALREADYREADOUT   (0x0u)
#define DCAN_IF3OBS_IF3SA_STILLTOBEREAD   (0x1u)

#define DCAN_IF3OBS_IF3SC   (0x00000400u)
#define DCAN_IF3OBS_IF3SC_SHIFT   (0x0000000Au)
#define DCAN_IF3OBS_IF3SC_ALREADYREADOUT   (0x0u)
#define DCAN_IF3OBS_IF3SC_STILLTOBEREAD   (0x1u)

#define DCAN_IF3OBS_IF3SDA   (0x00000800u)
#define DCAN_IF3OBS_IF3SDA_SHIFT   (0x0000000Bu)
#define DCAN_IF3OBS_IF3SDA_ALREADYREADOUT   (0x0u)
#define DCAN_IF3OBS_IF3SDA_STILLTOBEREAD   (0x1u)

#define DCAN_IF3OBS_IF3SDB   (0x00001000u)
#define DCAN_IF3OBS_IF3SDB_SHIFT   (0x0000000Cu)
#define DCAN_IF3OBS_IF3SDB_ALREADYREADOUT   (0x0u)
#define DCAN_IF3OBS_IF3SDB_STILLTOBEREAD   (0x1u)

#define DCAN_IF3OBS_IF3SM   (0x00000100u)
#define DCAN_IF3OBS_IF3SM_SHIFT   (0x00000008u)
#define DCAN_IF3OBS_IF3SM_ALREADYREADOUT   (0x0u)
#define DCAN_IF3OBS_IF3SM_STILLTOBEREAD   (0x1u)

#define DCAN_IF3OBS_IF3UPD   (0x00008000u)
#define DCAN_IF3OBS_IF3UPD_SHIFT   (0x0000000Fu)
#define DCAN_IF3OBS_IF3UPD_NEWDATALOAD   (0x1u)
#define DCAN_IF3OBS_IF3UPD_NONEWDATALOAD   (0x0u)

#define DCAN_IF3OBS_MASK   (0x00000001u)
#define DCAN_IF3OBS_MASK_SHIFT   (0x00000000u)
#define DCAN_IF3OBS_MASK_DATATOBEREAD   (0x1u)
#define DCAN_IF3OBS_MASK_NOTTOBEREAD   (0x0u)


/* IF3MSK */
#define DCAN_IF3MSK_MDIR   (0x40000000u)
#define DCAN_IF3MSK_MDIR_SHIFT   (0x00000001Eu)
#define DCAN_IF3MSK_MDIR_NOTUSED   (0x0u)
#define DCAN_IF3MSK_MDIR_USED   (0x1u)

#define DCAN_IF3MSK_MSK   (0x1FFFFFFFu)
#define DCAN_IF3MSK_MSK_SHIFT   (0x00000000u)
#define DCAN_IF3MSK_MSK_NOTUSED   (0x0u)
#define DCAN_IF3MSK_MSK_USED   (0x1u)

#define DCAN_IF3MSK_MXTD   (0x80000000u)
#define DCAN_IF3MSK_MXTD_SHIFT   (0x00000001Fu)
#define DCAN_IF3MSK_MXTD_NOTUSED   (0x0u)
#define DCAN_IF3MSK_MXTD_USED   (0x1u)


/* IF3ARB */
#define DCAN_IF3ARB_DIR   (0x20000000u)
#define DCAN_IF3ARB_DIR_SHIFT   (0x0000001Du)
#define DCAN_IF3ARB_DIR_RECEIVE   (0x0u)
#define DCAN_IF3ARB_DIR_TRANSMIT   (0x1u)

#define DCAN_IF3ARB_MSGVAL   (0x80000000u)
#define DCAN_IF3ARB_MSGVAL_SHIFT   (0x0000001Fu)
#define DCAN_IF3ARB_MSGVAL_IGNORED   (0x0u)
#define DCAN_IF3ARB_MSGVAL_USED   (0x1u)

#define DCAN_IF3ARB_MSK   (0x1FFFFFFFu)
#define DCAN_IF3ARB_MSK_SHIFT   (0x000000000u)
#define DCAN_IF3ARB_MSK_RECEIVE   (0x0u)
#define DCAN_IF3ARB_MSK_TRANSMIT   (0x1u)

#define DCAN_IF3ARB_XTD   (0x40000000u)
#define DCAN_IF3ARB_XTD_SHIFT   (0x0000001Eu)
#define DCAN_IF3ARB_XTD_11_BIT   (0x0u)
#define DCAN_IF3ARB_XTD_29_BIT   (0x1u)


/* IF3MCTL */
#define DCAN_IF3MCTL_DATALENGTHCODE   (0x0000000Fu)
#define DCAN_IF3MCTL_DATALENGTHCODE_SHIFT   (0x00000000u)

#define DCAN_IF3MCTL_EOB   (0x00000080u)
#define DCAN_IF3MCTL_EOB_SHIFT   (0x00000007u)

#define DCAN_IF3MCTL_INTPND   (0x00002000u)
#define DCAN_IF3MCTL_INTPND_SHIFT   (0x0000000Du)
#define DCAN_IF3MCTL_INTPND_INTERRUPT   (0x1u)
#define DCAN_IF3MCTL_INTPND_NOINTERRUPT   (0x0u)

#define DCAN_IF3MCTL_MSGLST   (0x00004000u)
#define DCAN_IF3MCTL_MSGLST_SHIFT   (0x0000000Eu)
#define DCAN_IF3MCTL_MSGLST_MSGLOST   (0x1u)
#define DCAN_IF3MCTL_MSGLST_NOMSGLOST   (0x0u)

#define DCAN_IF3MCTL_NEWDAT   (0x00008000u)
#define DCAN_IF3MCTL_NEWDAT_SHIFT   (0x0000000Fu)
#define DCAN_IF3MCTL_NEWDAT_NEWDATA   (0x1u)
#define DCAN_IF3MCTL_NEWDAT_NONEWDATA   (0x0u)

#define DCAN_IF3MCTL_RMTEN   (0x00000200u)
#define DCAN_IF3MCTL_RMTEN_SHIFT   (0x00000009u)
#define DCAN_IF3MCTL_RMTEN_DISABLE   (0x0u)
#define DCAN_IF3MCTL_RMTEN_ENABLE   (0x1u)

#define DCAN_IF3MCTL_RXIE   (0x00000400u)
#define DCAN_IF3MCTL_RXIE_SHIFT   (0x0000000Au)
#define DCAN_IF3MCTL_RXIE_NOTRIGGER   (0x0u)
#define DCAN_IF3MCTL_RXIE_TRIGGER   (0x1u)

#define DCAN_IF3MCTL_TXIE   (0x00000800u)
#define DCAN_IF3MCTL_TXIE_SHIFT   (0x0000000Bu)
#define DCAN_IF3MCTL_TXIE_NOTRIGGER   (0x0u)
#define DCAN_IF3MCTL_TXIE_TRIGGER   (0x1u)

#define DCAN_IF3MCTL_TXRQST   (0x00000100u)
#define DCAN_IF3MCTL_TXRQST_SHIFT   (0x00000008u)
#define DCAN_IF3MCTL_TXRQST_NOREQUESTED   (0x0u)
#define DCAN_IF3MCTL_TXRQST_REQUESTED   (0x1u)

#define DCAN_IF3MCTL_UMASK   (0x00001000u)
#define DCAN_IF3MCTL_UMASK_SHIFT   (0x0000000Cu)
#define DCAN_IF3MCTL_UMASK_IGNORED   (0x0u)
#define DCAN_IF3MCTL_UMASK_MASKED   (0x1u)


/* IF3DATA */
#define DCAN_IF3DATA_DCAN_IF3DATA   (0xFFFFFFFFu)
#define DCAN_IF3DATA_DCAN_IF3DATA_SHIFT   (0x00000000u)


/* IF3DATB */
#define DCAN_IF3DATB_DCAN_IF3DATB   (0xFFFFFFFFu)
#define DCAN_IF3DATB_DCAN_IF3DATB_SHIFT   (0x00000000u)


/* IF3UPD12 */
#define DCAN_IF3UPD12_IF3UPDEN_16_1   (0x0000FFFFu)
#define DCAN_IF3UPD12_IF3UPDEN_16_1_SHIFT   (0x00000001u)

#define DCAN_IF3UPD12_IF3UPDEN_32_17   (0xFFFF0000u)
#define DCAN_IF3UPD12_IF3UPDEN_32_17_SHIFT   (0x00000010u)


/* IF3UPD34 */
#define DCAN_IF3UPD34_IF3UPDEN_48_33   (0x0000FFFFu)
#define DCAN_IF3UPD34_IF3UPDEN_48_33_SHIFT   (0x00000001u)

#define DCAN_IF3UPD34_IF3UPDEN_64_49   (0xFFFF0000u)
#define DCAN_IF3UPD34_IF3UPDEN_64_49_SHIFT   (0x00000010u)


/* IF3UPD56 */
#define DCAN_IF3UPD56_IF3UPDEN_80_65   (0x0000FFFFu)
#define DCAN_IF3UPD56_IF3UPDEN_80_65_SHIFT   (0x00000001u)

#define DCAN_IF3UPD56_IF3UPDEN_96_81   (0xFFFF0000u)
#define DCAN_IF3UPD56_IF3UPDEN_96_81_SHIFT   (0x00000010u)


/* IF3UPD78 */
#define DCAN_IF3UPD78_IF3UPDEN_112_97   (0x0000FFFFu)
#define DCAN_IF3UPD78_IF3UPDEN_112_97_SHIFT   (0x00000001u)

#define DCAN_IF3UPD78_IF3UPDEN_128_113   (0xFFFF0000u)
#define DCAN_IF3UPD78_IF3UPDEN_128_113_SHIFT   (0x00000010u)


/* TIOC */
#define DCAN_TIOC_DIR   (0x00000004u)
#define DCAN_TIOC_DIR_SHIFT   (0x00000002u)
#define DCAN_TIOC_DIR_INPUT   (0x0u)
#define DCAN_TIOC_DIR_OUTPUT   (0x1u)

#define DCAN_TIOC_FUNC   (0x00000008u)
#define DCAN_TIOC_FUNC_SHIFT   (0x00000003u)
#define DCAN_TIOC_FUNC_FUNCTIONAL   (0x1u)
#define DCAN_TIOC_FUNC_GIO   (0x0u)

#define DCAN_TIOC_IN   (0x00000001u)
#define DCAN_TIOC_IN_SHIFT   (0x00000000u)
#define DCAN_TIOC_IN_HIGH   (0x1u)
#define DCAN_TIOC_IN_LOW   (0x0u)

#define DCAN_TIOC_OD   (0x00010000u)
#define DCAN_TIOC_OD_SHIFT   (0x00000010u)
#define DCAN_TIOC_OD_OPEN_DRAIN   (0x1u)
#define DCAN_TIOC_OD_PUSH_PULL   (0x0u)

#define DCAN_TIOC_OUT   (0x00000002u)
#define DCAN_TIOC_OUT_SHIFT   (0x00000001u)
#define DCAN_TIOC_OUT_HIGH   (0x1u)
#define DCAN_TIOC_OUT_LOW   (0x0u)

#define DCAN_TIOC_PD   (0x00020000u)
#define DCAN_TIOC_PD_SHIFT   (0x00000011u)
#define DCAN_TIOC_PD_ACTIVE   (0x0u)
#define DCAN_TIOC_PD_DISABLED   (0x1u)

#define DCAN_TIOC_PU   (0x00040000u)
#define DCAN_TIOC_PU_SHIFT   (0x00000011u)
#define DCAN_TIOC_PU_PULL_DOWN   (0x0u)
#define DCAN_TIOC_PU_PULL_UP   (0x1u)


/* RIOC */
#define DCAN_RIOC_DIR   (0x00000004u)
#define DCAN_RIOC_DIR_SHIFT   (0x00000002u)
#define DCAN_RIOC_DIR_INPUT   (0x0u)
#define DCAN_RIOC_DIR_OUTPUT   (0x1u)

#define DCAN_RIOC_FUNC   (0x00000008u)
#define DCAN_RIOC_FUNC_SHIFT   (0x00000003u)
#define DCAN_RIOC_FUNC_FUNCTIONAL   (0x1u)
#define DCAN_RIOC_FUNC_GIO   (0x0u)

#define DCAN_RIOC_IN   (0x00000001u)
#define DCAN_RIOC_IN_SHIFT   (0x00000000u)
#define DCAN_RIOC_IN_HIGH   (0x1u)
#define DCAN_RIOC_IN_LOW   (0x0u)

#define DCAN_RIOC_OD   (0x00010000u)
#define DCAN_RIOC_OD_SHIFT   (0x00000010u)
#define DCAN_RIOC_OD_OPEN_DRAIN   (0x1u)
#define DCAN_RIOC_OD_PUSH_PULL   (0x0u)

#define DCAN_RIOC_OUT   (0x00000002u)
#define DCAN_RIOC_OUT_SHIFT   (0x00000001u)
#define DCAN_RIOC_OUT_HIGH   (0x1u)
#define DCAN_RIOC_OUT_LOW   (0x0u)

#define DCAN_RIOC_PD   (0x00020000u)
#define DCAN_RIOC_PD_SHIFT   (0x00000011u)
#define DCAN_RIOC_PD_ACTIVE   (0x0u)
#define DCAN_RIOC_PD_DISABLED   (0x1u)

#define DCAN_RIOC_PU   (0x00020000u)
#define DCAN_RIOC_PU_SHIFT   (0x00000011u)
#define DCAN_RIOC_PU_PULL_DOWN   (0x0u)
#define DCAN_RIOC_PU_PULL_UP   (0x1u)



#ifdef __cplusplus
}
#endif

#endif   /* _EVMC66X_HW_DCAN_H_ */

