/******************************************************************************
*
* hw_ctrl_core_pad_io.h - register-level header file for CTRL_CORE
*
* Copyright (c) 2008-2015 Texas Instruments Incorporated.  All rights reserved.
* Software License Agreement
*
* Texas Instruments (TI) is supplying this software for use solely and
* exclusively on TI devices. The software is owned by TI and/or its
* suppliers, and is protected under applicable patent and copyright laws.
*
* You may not combine this software with any open-source software if such
* combination would cause this software to become subject to any of the
* license terms applicable to such open source software.
*
* THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
* NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT
* NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
* A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. TI SHALL NOT, UNDER ANY
* CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
* DAMAGES, FOR ANY REASON WHATSOEVER.
*
******************************************************************************
*/
#ifndef HW_CTRL_CORE_PAD_IO_H_
#define HW_CTRL_CORE_PAD_IO_H_

#ifdef __cplusplus
extern "C"
{
#endif

/****************************************************************************************************
* Register Definitions
****************************************************************************************************/
#define CTRL_CORE_PAD_GPMC_AD0                                                                              (0x0U)
#define CTRL_CORE_PAD_GPMC_AD1                                                                              (0x4U)
#define CTRL_CORE_PAD_GPMC_AD2                                                                              (0x8U)
#define CTRL_CORE_PAD_GPMC_AD3                                                                              (0xcU)
#define CTRL_CORE_PAD_GPMC_AD4                                                                              (0x10U)
#define CTRL_CORE_PAD_GPMC_AD5                                                                              (0x14U)
#define CTRL_CORE_PAD_GPMC_AD6                                                                              (0x18U)
#define CTRL_CORE_PAD_GPMC_AD7                                                                              (0x1cU)
#define CTRL_CORE_PAD_GPMC_AD8                                                                              (0x20U)
#define CTRL_CORE_PAD_GPMC_AD9                                                                              (0x24U)
#define CTRL_CORE_PAD_GPMC_AD10                                                                             (0x28U)
#define CTRL_CORE_PAD_GPMC_AD11                                                                             (0x2cU)
#define CTRL_CORE_PAD_GPMC_AD12                                                                             (0x30U)
#define CTRL_CORE_PAD_GPMC_AD13                                                                             (0x34U)
#define CTRL_CORE_PAD_GPMC_AD14                                                                             (0x38U)
#define CTRL_CORE_PAD_GPMC_AD15                                                                             (0x3cU)
#define CTRL_CORE_PAD_GPMC_A0                                                                               (0x40U)
#define CTRL_CORE_PAD_GPMC_A1                                                                               (0x44U)
#define CTRL_CORE_PAD_GPMC_A2                                                                               (0x48U)
#define CTRL_CORE_PAD_GPMC_A3                                                                               (0x4cU)
#define CTRL_CORE_PAD_GPMC_A4                                                                               (0x50U)
#define CTRL_CORE_PAD_GPMC_A5                                                                               (0x54U)
#define CTRL_CORE_PAD_GPMC_A6                                                                               (0x58U)
#define CTRL_CORE_PAD_GPMC_A7                                                                               (0x5cU)
#define CTRL_CORE_PAD_GPMC_A8                                                                               (0x60U)
#define CTRL_CORE_PAD_GPMC_A9                                                                               (0x64U)
#define CTRL_CORE_PAD_GPMC_A10                                                                              (0x68U)
#define CTRL_CORE_PAD_GPMC_A11                                                                              (0x6cU)
#define CTRL_CORE_PAD_GPMC_A12                                                                              (0x70U)
#define CTRL_CORE_PAD_GPMC_A13                                                                              (0x74U)
#define CTRL_CORE_PAD_GPMC_A14                                                                              (0x78U)
#define CTRL_CORE_PAD_GPMC_A15                                                                              (0x7cU)
#define CTRL_CORE_PAD_GPMC_A16                                                                              (0x80U)
#define CTRL_CORE_PAD_GPMC_A17                                                                              (0x84U)
#define CTRL_CORE_PAD_GPMC_A18                                                                              (0x88U)
#define CTRL_CORE_PAD_GPMC_A19                                                                              (0x8cU)
#define CTRL_CORE_PAD_GPMC_A20                                                                              (0x90U)
#define CTRL_CORE_PAD_GPMC_A21                                                                              (0x94U)
#define CTRL_CORE_PAD_GPMC_A22                                                                              (0x98U)
#define CTRL_CORE_PAD_GPMC_A23                                                                              (0x9cU)
#define CTRL_CORE_PAD_GPMC_A24                                                                              (0xa0U)
#define CTRL_CORE_PAD_GPMC_A25                                                                              (0xa4U)
#define CTRL_CORE_PAD_GPMC_A26                                                                              (0xa8U)
#define CTRL_CORE_PAD_GPMC_A27                                                                              (0xacU)
#define CTRL_CORE_PAD_GPMC_CS1                                                                              (0xb0U)
#define CTRL_CORE_PAD_GPMC_CS0                                                                              (0xb4U)
#define CTRL_CORE_PAD_GPMC_CS2                                                                              (0xb8U)
#define CTRL_CORE_PAD_GPMC_CS3                                                                              (0xbcU)
#define CTRL_CORE_PAD_GPMC_CLK                                                                              (0xc0U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE                                                                         (0xc4U)
#define CTRL_CORE_PAD_GPMC_OEN_REN                                                                          (0xc8U)
#define CTRL_CORE_PAD_GPMC_WEN                                                                              (0xccU)
#define CTRL_CORE_PAD_GPMC_BEN0                                                                             (0xd0U)
#define CTRL_CORE_PAD_GPMC_BEN1                                                                             (0xd4U)
#define CTRL_CORE_PAD_GPMC_WAIT0                                                                            (0xd8U)
#define CTRL_CORE_PAD_VIN1A_CLK0                                                                            (0xdcU)
#define CTRL_CORE_PAD_VIN1B_CLK1                                                                            (0xe0U)
#define CTRL_CORE_PAD_VIN1A_DE0                                                                             (0xe4U)
#define CTRL_CORE_PAD_VIN1A_FLD0                                                                            (0xe8U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0                                                                          (0xecU)
#define CTRL_CORE_PAD_VIN1A_VSYNC0                                                                          (0xf0U)
#define CTRL_CORE_PAD_VIN1A_D0                                                                              (0xf4U)
#define CTRL_CORE_PAD_VIN1A_D1                                                                              (0xf8U)
#define CTRL_CORE_PAD_VIN1A_D2                                                                              (0xfcU)
#define CTRL_CORE_PAD_VIN1A_D3                                                                              (0x100U)
#define CTRL_CORE_PAD_VIN1A_D4                                                                              (0x104U)
#define CTRL_CORE_PAD_VIN1A_D5                                                                              (0x108U)
#define CTRL_CORE_PAD_VIN1A_D6                                                                              (0x10cU)
#define CTRL_CORE_PAD_VIN1A_D7                                                                              (0x110U)
#define CTRL_CORE_PAD_VIN1A_D8                                                                              (0x114U)
#define CTRL_CORE_PAD_VIN1A_D9                                                                              (0x118U)
#define CTRL_CORE_PAD_VIN1A_D10                                                                             (0x11cU)
#define CTRL_CORE_PAD_VIN1A_D11                                                                             (0x120U)
#define CTRL_CORE_PAD_VIN1A_D12                                                                             (0x124U)
#define CTRL_CORE_PAD_VIN1A_D13                                                                             (0x128U)
#define CTRL_CORE_PAD_VIN1A_D14                                                                             (0x12cU)
#define CTRL_CORE_PAD_VIN1A_D15                                                                             (0x130U)
#define CTRL_CORE_PAD_VIN1A_D16                                                                             (0x134U)
#define CTRL_CORE_PAD_VIN1A_D17                                                                             (0x138U)
#define CTRL_CORE_PAD_VIN1A_D18                                                                             (0x13cU)
#define CTRL_CORE_PAD_VIN1A_D19                                                                             (0x140U)
#define CTRL_CORE_PAD_VIN1A_D20                                                                             (0x144U)
#define CTRL_CORE_PAD_VIN1A_D21                                                                             (0x148U)
#define CTRL_CORE_PAD_VIN1A_D22                                                                             (0x14cU)
#define CTRL_CORE_PAD_VIN1A_D23                                                                             (0x150U)
#define CTRL_CORE_PAD_VIN2A_CLK0                                                                            (0x154U)
#define CTRL_CORE_PAD_VIN2A_DE0                                                                             (0x158U)
#define CTRL_CORE_PAD_VIN2A_FLD0                                                                            (0x15cU)
#define CTRL_CORE_PAD_VIN2A_HSYNC0                                                                          (0x160U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0                                                                          (0x164U)
#define CTRL_CORE_PAD_VIN2A_D0                                                                              (0x168U)
#define CTRL_CORE_PAD_VIN2A_D1                                                                              (0x16cU)
#define CTRL_CORE_PAD_VIN2A_D2                                                                              (0x170U)
#define CTRL_CORE_PAD_VIN2A_D3                                                                              (0x174U)
#define CTRL_CORE_PAD_VIN2A_D4                                                                              (0x178U)
#define CTRL_CORE_PAD_VIN2A_D5                                                                              (0x17cU)
#define CTRL_CORE_PAD_VIN2A_D6                                                                              (0x180U)
#define CTRL_CORE_PAD_VIN2A_D7                                                                              (0x184U)
#define CTRL_CORE_PAD_VIN2A_D8                                                                              (0x188U)
#define CTRL_CORE_PAD_VIN2A_D9                                                                              (0x18cU)
#define CTRL_CORE_PAD_VIN2A_D10                                                                             (0x190U)
#define CTRL_CORE_PAD_VIN2A_D11                                                                             (0x194U)
#define CTRL_CORE_PAD_VIN2A_D12                                                                             (0x198U)
#define CTRL_CORE_PAD_VIN2A_D13                                                                             (0x19cU)
#define CTRL_CORE_PAD_VIN2A_D14                                                                             (0x1a0U)
#define CTRL_CORE_PAD_VIN2A_D15                                                                             (0x1a4U)
#define CTRL_CORE_PAD_VIN2A_D16                                                                             (0x1a8U)
#define CTRL_CORE_PAD_VIN2A_D17                                                                             (0x1acU)
#define CTRL_CORE_PAD_VIN2A_D18                                                                             (0x1b0U)
#define CTRL_CORE_PAD_VIN2A_D19                                                                             (0x1b4U)
#define CTRL_CORE_PAD_VIN2A_D20                                                                             (0x1b8U)
#define CTRL_CORE_PAD_VIN2A_D21                                                                             (0x1bcU)
#define CTRL_CORE_PAD_VIN2A_D22                                                                             (0x1c0U)
#define CTRL_CORE_PAD_VIN2A_D23                                                                             (0x1c4U)
#define CTRL_CORE_PAD_VOUT1_CLK                                                                             (0x1c8U)
#define CTRL_CORE_PAD_VOUT1_DE                                                                              (0x1ccU)
#define CTRL_CORE_PAD_VOUT1_FLD                                                                             (0x1d0U)
#define CTRL_CORE_PAD_VOUT1_HSYNC                                                                           (0x1d4U)
#define CTRL_CORE_PAD_VOUT1_VSYNC                                                                           (0x1d8U)
#define CTRL_CORE_PAD_VOUT1_D0                                                                              (0x1dcU)
#define CTRL_CORE_PAD_VOUT1_D1                                                                              (0x1e0U)
#define CTRL_CORE_PAD_VOUT1_D2                                                                              (0x1e4U)
#define CTRL_CORE_PAD_VOUT1_D3                                                                              (0x1e8U)
#define CTRL_CORE_PAD_VOUT1_D4                                                                              (0x1ecU)
#define CTRL_CORE_PAD_VOUT1_D5                                                                              (0x1f0U)
#define CTRL_CORE_PAD_VOUT1_D6                                                                              (0x1f4U)
#define CTRL_CORE_PAD_VOUT1_D7                                                                              (0x1f8U)
#define CTRL_CORE_PAD_VOUT1_D8                                                                              (0x1fcU)
#define CTRL_CORE_PAD_VOUT1_D9                                                                              (0x200U)
#define CTRL_CORE_PAD_VOUT1_D10                                                                             (0x204U)
#define CTRL_CORE_PAD_VOUT1_D11                                                                             (0x208U)
#define CTRL_CORE_PAD_VOUT1_D12                                                                             (0x20cU)
#define CTRL_CORE_PAD_VOUT1_D13                                                                             (0x210U)
#define CTRL_CORE_PAD_VOUT1_D14                                                                             (0x214U)
#define CTRL_CORE_PAD_VOUT1_D15                                                                             (0x218U)
#define CTRL_CORE_PAD_VOUT1_D16                                                                             (0x21cU)
#define CTRL_CORE_PAD_VOUT1_D17                                                                             (0x220U)
#define CTRL_CORE_PAD_VOUT1_D18                                                                             (0x224U)
#define CTRL_CORE_PAD_VOUT1_D19                                                                             (0x228U)
#define CTRL_CORE_PAD_VOUT1_D20                                                                             (0x22cU)
#define CTRL_CORE_PAD_VOUT1_D21                                                                             (0x230U)
#define CTRL_CORE_PAD_VOUT1_D22                                                                             (0x234U)
#define CTRL_CORE_PAD_VOUT1_D23                                                                             (0x238U)
#define CTRL_CORE_PAD_MDIO_MCLK                                                                             (0x23cU)
#define CTRL_CORE_PAD_MDIO_D                                                                                (0x240U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK                                                                       (0x244U)
#define CTRL_CORE_PAD_UART3_RXD                                                                             (0x248U)
#define CTRL_CORE_PAD_UART3_TXD                                                                             (0x24cU)
#define CTRL_CORE_PAD_RGMII0_TXC                                                                            (0x250U)
#define CTRL_CORE_PAD_RGMII0_TXCTL                                                                          (0x254U)
#define CTRL_CORE_PAD_RGMII0_TXD3                                                                           (0x258U)
#define CTRL_CORE_PAD_RGMII0_TXD2                                                                           (0x25cU)
#define CTRL_CORE_PAD_RGMII0_TXD1                                                                           (0x260U)
#define CTRL_CORE_PAD_RGMII0_TXD0                                                                           (0x264U)
#define CTRL_CORE_PAD_RGMII0_RXC                                                                            (0x268U)
#define CTRL_CORE_PAD_RGMII0_RXCTL                                                                          (0x26cU)
#define CTRL_CORE_PAD_RGMII0_RXD3                                                                           (0x270U)
#define CTRL_CORE_PAD_RGMII0_RXD2                                                                           (0x274U)
#define CTRL_CORE_PAD_RGMII0_RXD1                                                                           (0x278U)
#define CTRL_CORE_PAD_RGMII0_RXD0                                                                           (0x27cU)
#define CTRL_CORE_PAD_USB1_DRVVBUS                                                                          (0x280U)
#define CTRL_CORE_PAD_USB2_DRVVBUS                                                                          (0x284U)
#define CTRL_CORE_PAD_GPIO6_14                                                                              (0x288U)
#define CTRL_CORE_PAD_GPIO6_15                                                                              (0x28cU)
#define CTRL_CORE_PAD_GPIO6_16                                                                              (0x290U)
#define CTRL_CORE_PAD_XREF_CLK0                                                                             (0x294U)
#define CTRL_CORE_PAD_XREF_CLK1                                                                             (0x298U)
#define CTRL_CORE_PAD_XREF_CLK2                                                                             (0x29cU)
#define CTRL_CORE_PAD_XREF_CLK3                                                                             (0x2a0U)
#define CTRL_CORE_PAD_MCASP1_ACLKX                                                                          (0x2a4U)
#define CTRL_CORE_PAD_MCASP1_FSX                                                                            (0x2a8U)
#define CTRL_CORE_PAD_MCASP1_ACLKR                                                                          (0x2acU)
#define CTRL_CORE_PAD_MCASP1_FSR                                                                            (0x2b0U)
#define CTRL_CORE_PAD_MCASP1_AXR0                                                                           (0x2b4U)
#define CTRL_CORE_PAD_MCASP1_AXR1                                                                           (0x2b8U)
#define CTRL_CORE_PAD_MCASP1_AXR2                                                                           (0x2bcU)
#define CTRL_CORE_PAD_MCASP1_AXR3                                                                           (0x2c0U)
#define CTRL_CORE_PAD_MCASP1_AXR4                                                                           (0x2c4U)
#define CTRL_CORE_PAD_MCASP1_AXR5                                                                           (0x2c8U)
#define CTRL_CORE_PAD_MCASP1_AXR6                                                                           (0x2ccU)
#define CTRL_CORE_PAD_MCASP1_AXR7                                                                           (0x2d0U)
#define CTRL_CORE_PAD_MCASP1_AXR8                                                                           (0x2d4U)
#define CTRL_CORE_PAD_MCASP1_AXR9                                                                           (0x2d8U)
#define CTRL_CORE_PAD_MCASP1_AXR10                                                                          (0x2dcU)
#define CTRL_CORE_PAD_MCASP1_AXR11                                                                          (0x2e0U)
#define CTRL_CORE_PAD_MCASP1_AXR12                                                                          (0x2e4U)
#define CTRL_CORE_PAD_MCASP1_AXR13                                                                          (0x2e8U)
#define CTRL_CORE_PAD_MCASP1_AXR14                                                                          (0x2ecU)
#define CTRL_CORE_PAD_MCASP1_AXR15                                                                          (0x2f0U)
#define CTRL_CORE_PAD_MCASP2_ACLKX                                                                          (0x2f4U)
#define CTRL_CORE_PAD_MCASP2_FSX                                                                            (0x2f8U)
#define CTRL_CORE_PAD_MCASP2_ACLKR                                                                          (0x2fcU)
#define CTRL_CORE_PAD_MCASP2_FSR                                                                            (0x300U)
#define CTRL_CORE_PAD_MCASP2_AXR0                                                                           (0x304U)
#define CTRL_CORE_PAD_MCASP2_AXR1                                                                           (0x308U)
#define CTRL_CORE_PAD_MCASP2_AXR2                                                                           (0x30cU)
#define CTRL_CORE_PAD_MCASP2_AXR3                                                                           (0x310U)
#define CTRL_CORE_PAD_MCASP2_AXR4                                                                           (0x314U)
#define CTRL_CORE_PAD_MCASP2_AXR5                                                                           (0x318U)
#define CTRL_CORE_PAD_MCASP2_AXR6                                                                           (0x31cU)
#define CTRL_CORE_PAD_MCASP2_AXR7                                                                           (0x320U)
#define CTRL_CORE_PAD_MCASP3_ACLKX                                                                          (0x324U)
#define CTRL_CORE_PAD_MCASP3_FSX                                                                            (0x328U)
#define CTRL_CORE_PAD_MCASP3_AXR0                                                                           (0x32cU)
#define CTRL_CORE_PAD_MCASP3_AXR1                                                                           (0x330U)
#define CTRL_CORE_PAD_MCASP4_ACLKX                                                                          (0x334U)
#define CTRL_CORE_PAD_MCASP4_FSX                                                                            (0x338U)
#define CTRL_CORE_PAD_MCASP4_AXR0                                                                           (0x33cU)
#define CTRL_CORE_PAD_MCASP4_AXR1                                                                           (0x340U)
#define CTRL_CORE_PAD_MCASP5_ACLKX                                                                          (0x344U)
#define CTRL_CORE_PAD_MCASP5_FSX                                                                            (0x348U)
#define CTRL_CORE_PAD_MCASP5_AXR0                                                                           (0x34cU)
#define CTRL_CORE_PAD_MCASP5_AXR1                                                                           (0x350U)
#define CTRL_CORE_PAD_MMC1_CLK                                                                              (0x354U)
#define CTRL_CORE_PAD_MMC1_CMD                                                                              (0x358U)
#define CTRL_CORE_PAD_MMC1_DAT0                                                                             (0x35cU)
#define CTRL_CORE_PAD_MMC1_DAT1                                                                             (0x360U)
#define CTRL_CORE_PAD_MMC1_DAT2                                                                             (0x364U)
#define CTRL_CORE_PAD_MMC1_DAT3                                                                             (0x368U)
#define CTRL_CORE_PAD_MMC1_SDCD                                                                             (0x36cU)
#define CTRL_CORE_PAD_MMC1_SDWP                                                                             (0x370U)
#define CTRL_CORE_PAD_GPIO6_10                                                                              (0x374U)
#define CTRL_CORE_PAD_GPIO6_11                                                                              (0x378U)
#define CTRL_CORE_PAD_MMC3_CLK                                                                              (0x37cU)
#define CTRL_CORE_PAD_MMC3_CMD                                                                              (0x380U)
#define CTRL_CORE_PAD_MMC3_DAT0                                                                             (0x384U)
#define CTRL_CORE_PAD_MMC3_DAT1                                                                             (0x388U)
#define CTRL_CORE_PAD_MMC3_DAT2                                                                             (0x38cU)
#define CTRL_CORE_PAD_MMC3_DAT3                                                                             (0x390U)
#define CTRL_CORE_PAD_MMC3_DAT4                                                                             (0x394U)
#define CTRL_CORE_PAD_MMC3_DAT5                                                                             (0x398U)
#define CTRL_CORE_PAD_MMC3_DAT6                                                                             (0x39cU)
#define CTRL_CORE_PAD_MMC3_DAT7                                                                             (0x3a0U)
#define CTRL_CORE_PAD_SPI1_SCLK                                                                             (0x3a4U)
#define CTRL_CORE_PAD_SPI1_D1                                                                               (0x3a8U)
#define CTRL_CORE_PAD_SPI1_D0                                                                               (0x3acU)
#define CTRL_CORE_PAD_SPI1_CS0                                                                              (0x3b0U)
#define CTRL_CORE_PAD_SPI1_CS1                                                                              (0x3b4U)
#define CTRL_CORE_PAD_SPI1_CS2                                                                              (0x3b8U)
#define CTRL_CORE_PAD_SPI1_CS3                                                                              (0x3bcU)
#define CTRL_CORE_PAD_SPI2_SCLK                                                                             (0x3c0U)
#define CTRL_CORE_PAD_SPI2_D1                                                                               (0x3c4U)
#define CTRL_CORE_PAD_SPI2_D0                                                                               (0x3c8U)
#define CTRL_CORE_PAD_SPI2_CS0                                                                              (0x3ccU)
#define CTRL_CORE_PAD_DCAN1_TX                                                                              (0x3d0U)
#define CTRL_CORE_PAD_DCAN1_RX                                                                              (0x3d4U)
#define CTRL_CORE_PAD_DCAN2_TX                                                                              (0x3d8U)
#define CTRL_CORE_PAD_DCAN2_RX                                                                              (0x3dcU)
#define CTRL_CORE_PAD_UART1_RXD                                                                             (0x3e0U)
#define CTRL_CORE_PAD_UART1_TXD                                                                             (0x3e4U)
#define CTRL_CORE_PAD_UART1_CTSN                                                                            (0x3e8U)
#define CTRL_CORE_PAD_UART1_RTSN                                                                            (0x3ecU)
#define CTRL_CORE_PAD_UART2_RXD                                                                             (0x3f0U)
#define CTRL_CORE_PAD_UART2_TXD                                                                             (0x3f4U)
#define CTRL_CORE_PAD_UART2_CTSN                                                                            (0x3f8U)
#define CTRL_CORE_PAD_UART2_RTSN                                                                            (0x3fcU)
#define CTRL_CORE_PAD_I2C1_SDA                                                                              (0x400U)
#define CTRL_CORE_PAD_I2C1_SCL                                                                              (0x404U)
#define CTRL_CORE_PAD_I2C2_SDA                                                                              (0x408U)
#define CTRL_CORE_PAD_I2C2_SCL                                                                              (0x40cU)
#define CTRL_CORE_PAD_I2C3_SDA                                                                              (0x410U)
#define CTRL_CORE_PAD_I2C3_SCL                                                                              (0x414U)
#define CTRL_CORE_PAD_WAKEUP0                                                                               (0x418U)
#define CTRL_CORE_PAD_WAKEUP1                                                                               (0x41cU)
#define CTRL_CORE_PAD_WAKEUP2                                                                               (0x420U)
#define CTRL_CORE_PAD_WAKEUP3                                                                               (0x424U)
#define CTRL_CORE_PAD_ON_OFF                                                                                (0x428U)
#define CTRL_CORE_PAD_RTC_PORZ                                                                              (0x42cU)
#define CTRL_CORE_PAD_TMS                                                                                   (0x430U)
#define CTRL_CORE_PAD_TDI                                                                                   (0x434U)
#define CTRL_CORE_PAD_TDO                                                                                   (0x438U)
#define CTRL_CORE_PAD_TCLK                                                                                  (0x43cU)
#define CTRL_CORE_PAD_TRSTN                                                                                 (0x440U)
#define CTRL_CORE_PAD_RTCK                                                                                  (0x444U)
#define CTRL_CORE_PAD_EMU0                                                                                  (0x448U)
#define CTRL_CORE_PAD_EMU1                                                                                  (0x44cU)
#define CTRL_CORE_PAD_EMU2                                                                                  (0x450U)
#define CTRL_CORE_PAD_EMU3                                                                                  (0x454U)
#define CTRL_CORE_PAD_EMU4                                                                                  (0x458U)
#define CTRL_CORE_PAD_RESETN                                                                                (0x45cU)
#define CTRL_CORE_PAD_NMIN                                                                                  (0x460U)
#define CTRL_CORE_PAD_RSTOUTN                                                                               (0x464U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_0                                                                     (0x468U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_1                                                                     (0x46cU)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_2                                                                     (0x470U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_3                                                                     (0x474U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_4                                                                     (0x478U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_5                                                                     (0x47cU)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_6                                                                     (0x480U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_7                                                                     (0x484U)
#define CTRL_CORE_PADCONF_WAKEUPEVENT_8                                                                     (0x488U)

/****************************************************************************************************
* Field Definition Macros
****************************************************************************************************/

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_GPMC_AD0_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_VIN3A_D0_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_VOUT3_D0_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_GPIO1_6_14                                                   (14U)
#define CTRL_CORE_PAD_GPMC_AD0_GPMC_AD0_MUXMODE_SYSBOOT0_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD0_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_GPMC_AD1_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_VIN3A_D1_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_VOUT3_D1_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_GPIO1_7_14                                                   (14U)
#define CTRL_CORE_PAD_GPMC_AD1_GPMC_AD1_MUXMODE_SYSBOOT1_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD1_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_GPMC_AD2_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_VIN3A_D2_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_VOUT3_D2_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_GPIO1_8_14                                                   (14U)
#define CTRL_CORE_PAD_GPMC_AD2_GPMC_AD2_MUXMODE_SYSBOOT2_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD2_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_GPMC_AD3_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_VIN3A_D3_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_VOUT3_D3_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_GPIO1_9_14                                                   (14U)
#define CTRL_CORE_PAD_GPMC_AD3_GPMC_AD3_MUXMODE_SYSBOOT3_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD3_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_GPMC_AD4_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_VIN3A_D4_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_VOUT3_D4_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_GPIO1_10_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD4_GPMC_AD4_MUXMODE_SYSBOOT4_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD4_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_GPMC_AD5_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_VIN3A_D5_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_VOUT3_D5_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_GPIO1_11_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD5_GPMC_AD5_MUXMODE_SYSBOOT5_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD5_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_GPMC_AD6_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_VIN3A_D6_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_VOUT3_D6_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_GPIO1_12_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD6_GPMC_AD6_MUXMODE_SYSBOOT6_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD6_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_GPMC_AD7_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_VIN3A_D7_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_VOUT3_D7_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_GPIO1_13_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD7_GPMC_AD7_MUXMODE_SYSBOOT7_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD7_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_GPMC_AD8_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_VIN3A_D8_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_VOUT3_D8_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_GPIO7_18_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD8_GPMC_AD8_MUXMODE_SYSBOOT8_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD8_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_GPMC_AD9_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_VIN3A_D9_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_VOUT3_D9_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_GPIO7_19_14                                                  (14U)
#define CTRL_CORE_PAD_GPMC_AD9_GPMC_AD9_MUXMODE_SYSBOOT9_15                                                  (15U)

#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_AD9_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_GPMC_AD10_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_VIN3A_D10_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_VOUT3_D10_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_GPIO7_28_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD10_GPMC_AD10_MUXMODE_SYSBOOT10_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD10_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_GPMC_AD11_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_VIN3A_D11_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_VOUT3_D11_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_GPIO7_29_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD11_GPMC_AD11_MUXMODE_SYSBOOT11_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD11_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_GPMC_AD12_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_VIN3A_D12_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_VOUT3_D12_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_GPIO1_18_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD12_GPMC_AD12_MUXMODE_SYSBOOT12_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD12_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_GPMC_AD13_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_VIN3A_D13_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_VOUT3_D13_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_GPIO1_19_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD13_GPMC_AD13_MUXMODE_SYSBOOT13_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD13_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_GPMC_AD14_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_VIN3A_D14_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_VOUT3_D14_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_GPIO1_20_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD14_GPMC_AD14_MUXMODE_SYSBOOT14_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD14_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_GPMC_AD15_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_VIN3A_D15_2                                                (2U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_VOUT3_D15_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_GPIO1_21_14                                                (14U)
#define CTRL_CORE_PAD_GPMC_AD15_GPMC_AD15_MUXMODE_SYSBOOT15_15                                               (15U)

#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_AD15_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A0_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A0_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A0_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A0_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_GPMC_A0_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_VIN3A_D16_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_VOUT3_D16_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_VIN4A_D0_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_USB4_ULPI_D7_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_VIN4B_D0_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_I2C4_SCL_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_UART5_RXD_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A0_GPMC_A0_MUXMODE_GPIO7_3_14                                                     (14U)

#define CTRL_CORE_PAD_GPMC_A0_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A0_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A0_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A0_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A0_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A0_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A1_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A1_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A1_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A1_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_GPMC_A1_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_VIN3A_D17_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_VOUT3_D17_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_VIN4A_D1_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_USB4_ULPI_D6_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_VIN4B_D1_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_I2C4_SDA_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_UART5_TXD_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A1_GPMC_A1_MUXMODE_GPIO7_4_14                                                     (14U)

#define CTRL_CORE_PAD_GPMC_A1_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A1_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A1_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A1_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A1_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A1_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A2_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A2_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A2_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A2_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_GPMC_A2_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_VIN3A_D18_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_VOUT3_D18_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_VIN4A_D2_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_USB4_ULPI_D5_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_VIN4B_D2_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_UART7_RXD_7                                                    (7U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_UART5_CTSN_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A2_GPMC_A2_MUXMODE_GPIO7_5_14                                                     (14U)

#define CTRL_CORE_PAD_GPMC_A2_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A2_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A2_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A2_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A2_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A2_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A3_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A3_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A3_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A3_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_GPMC_A3_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_QSPI1_CS2_1                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_VIN3A_D19_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_VOUT3_D19_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_VIN4A_D3_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_USB4_ULPI_D4_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_VIN4B_D3_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_UART7_TXD_7                                                    (7U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_UART5_RTSN_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A3_GPMC_A3_MUXMODE_GPIO7_6_14                                                     (14U)

#define CTRL_CORE_PAD_GPMC_A3_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A3_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A3_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A3_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A3_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A3_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A4_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A4_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A4_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A4_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_GPMC_A4_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_QSPI1_CS3_1                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_VIN3A_D20_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_VOUT3_D20_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_VIN4A_D4_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_USB4_ULPI_D3_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_VIN4B_D4_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_I2C5_SCL_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_UART6_RXD_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A4_GPMC_A4_MUXMODE_GPIO1_26_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A4_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A4_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A4_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A4_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A4_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A4_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A5_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A5_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A5_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A5_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_GPMC_A5_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_QSPI2_CS2_1                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_VIN3A_D21_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_VOUT3_D21_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_VIN4A_D5_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_USB4_ULPI_D2_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_VIN4B_D5_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_I2C5_SDA_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_UART6_TXD_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A5_GPMC_A5_MUXMODE_GPIO1_27_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A5_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A5_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A5_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A5_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A5_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A5_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A6_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A6_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A6_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A6_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_GPMC_A6_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_QSPI2_CS3_1                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_VIN3A_D22_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_VOUT3_D22_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_VIN4A_D6_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_USB4_ULPI_D1_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_VIN4B_D6_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_UART8_RXD_7                                                    (7U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_UART6_CTSN_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A6_GPMC_A6_MUXMODE_GPIO1_28_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A6_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A6_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A6_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A6_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A6_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A6_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A7_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A7_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A7_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A7_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_GPMC_A7_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_QSPI2_RTCLK_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_VIN3A_D23_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_VOUT3_D23_3                                                    (3U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_VIN4A_D7_4                                                     (4U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_USB4_ULPI_D0_5                                                 (5U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_VIN4B_D7_6                                                     (6U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_UART8_TXD_7                                                    (7U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_UART6_RTSN_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A7_GPMC_A7_MUXMODE_GPIO1_29_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A7_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A7_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A7_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A7_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A7_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A7_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A8_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A8_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A8_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A8_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_GPMC_A8_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_QSPI2_D3_1                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_VIN3A_HSYNC0_2                                                 (2U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_VOUT3_HSYNC_3                                                  (3U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_USB4_ULPI_NXT_5                                                (5U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_VIN4B_HSYNC1_6                                                 (6U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_TIMER12_7                                                      (7U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_SPI4_SCLK_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A8_GPMC_A8_MUXMODE_GPIO1_30_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A8_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A8_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A8_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A8_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A8_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A8_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPEVENT_SHIFT                                                     (25U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPEVENT_MASK                                                      (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPEVENT_NOWAKEUP                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPEVENT_WAKEUP                                                     (1U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPENABLE_SHIFT                                                    (24U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPENABLE_MASK                                                     (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_WAKEUPENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_SLEWCONTROL_SHIFT                                                     (19U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_SLEWCONTROL_MASK                                                      (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_SLEWCONTROL_SLOW_SLEW                                                  (0U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_SLEWCONTROL_FAST_SLEW                                                  (1U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_INPUTENABLE_SHIFT                                                     (18U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_INPUTENABLE_MASK                                                      (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_INPUTENABLE_ENABLE                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_INPUTENABLE_DISABLE                                                    (0U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLTYPESELECT_SHIFT                                                  (17U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLTYPESELECT_MASK                                                   (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLTYPESELECT_PULL_UP                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLTYPESELECT_PULL_DOWN                                               (0U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLUDENABLE_SHIFT                                                    (16U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLUDENABLE_MASK                                                     (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLUDENABLE_ENABLE                                                    (1U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_PULLUDENABLE_DISABLE                                                   (0U)

#define CTRL_CORE_PAD_GPMC_A9_RESERVED_3_SHIFT                                                              (8U)
#define CTRL_CORE_PAD_GPMC_A9_RESERVED_3_MASK                                                               (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A9_RESERVED_4_SHIFT                                                              (4U)
#define CTRL_CORE_PAD_GPMC_A9_RESERVED_4_MASK                                                               (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_SHIFT                                                         (0U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_MASK                                                          (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_GPMC_A9_0                                                      (0U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_QSPI2_D2_1                                                     (1U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_VIN3A_VSYNC0_2                                                 (2U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_VOUT3_VSYNC_3                                                  (3U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_USB4_ULPI_DIR_5                                                (5U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_VIN4B_VSYNC1_6                                                 (6U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_TIMER11_7                                                      (7U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_SPI4_D1_8                                                      (8U)
#define CTRL_CORE_PAD_GPMC_A9_GPMC_A9_MUXMODE_GPIO1_31_14                                                    (14U)

#define CTRL_CORE_PAD_GPMC_A9_RESERVED_0_SHIFT                                                              (9U)
#define CTRL_CORE_PAD_GPMC_A9_RESERVED_0_MASK                                                               (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A9_RESERVED_1_SHIFT                                                              (20U)
#define CTRL_CORE_PAD_GPMC_A9_RESERVED_1_MASK                                                               (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A9_RESERVED_2_SHIFT                                                              (26U)
#define CTRL_CORE_PAD_GPMC_A9_RESERVED_2_MASK                                                               (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A10_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A10_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A10_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A10_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_GPMC_A10_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_QSPI2_D1_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_VIN3A_DE0_2                                                  (2U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_VOUT3_DE_3                                                   (3U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_USB4_ULPI_STP_5                                              (5U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_VIN4B_CLK1_6                                                 (6U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_TIMER10_7                                                    (7U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_SPI4_D0_8                                                    (8U)
#define CTRL_CORE_PAD_GPMC_A10_GPMC_A10_MUXMODE_GPIO2_0_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A10_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A10_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A10_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A10_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A10_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A10_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A11_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A11_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A11_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A11_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_GPMC_A11_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_QSPI2_D0_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_VIN3A_FLD0_2                                                 (2U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_VOUT3_FLD_3                                                  (3U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_VIN4A_FLD0_4                                                 (4U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_USB4_ULPI_CLK_5                                              (5U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_VIN4B_DE1_6                                                  (6U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_TIMER9_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_SPI4_CS0_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A11_GPMC_A11_MUXMODE_GPIO2_1_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A11_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A11_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A11_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A11_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A11_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A11_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A12_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A12_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A12_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A12_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_GPMC_A12_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_QSPI2_SCLK_1                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_VIN4A_CLK0_4                                                 (4U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_GPMC_A0_5                                                    (5U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_VIN4B_FLD1_6                                                 (6U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_TIMER8_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_SPI4_CS1_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_DMA_EVT1_9                                                   (9U)
#define CTRL_CORE_PAD_GPMC_A12_GPMC_A12_MUXMODE_GPIO2_2_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A12_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A12_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A12_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A12_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A12_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A12_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A13_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A13_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A13_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A13_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_GPMC_A13_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_QSPI1_RTCLK_1                                                (1U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_VIN4A_HSYNC0_4                                               (4U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_TIMER7_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_SPI4_CS2_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_DMA_EVT2_9                                                   (9U)
#define CTRL_CORE_PAD_GPMC_A13_GPMC_A13_MUXMODE_GPIO2_3_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A13_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A13_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A13_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A13_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A13_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A13_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A14_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A14_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A14_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A14_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_GPMC_A14_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_QSPI1_D3_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_VIN4A_VSYNC0_4                                               (4U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_TIMER6_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_SPI4_CS3_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_A14_GPMC_A14_MUXMODE_GPIO2_4_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A14_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A14_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A14_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A14_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A14_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A14_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A15_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A15_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A15_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A15_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_GPMC_A15_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_QSPI1_D2_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_VIN4A_D8_4                                                   (4U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_TIMER5_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_A15_GPMC_A15_MUXMODE_GPIO2_5_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A15_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A15_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A15_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A15_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A15_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A15_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A16_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A16_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A16_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A16_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_GPMC_A16_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_QSPI1_D1_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_VIN4A_D9_4                                                   (4U)
#define CTRL_CORE_PAD_GPMC_A16_GPMC_A16_MUXMODE_GPIO2_6_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A16_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A16_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A16_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A16_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A16_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A16_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A17_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A17_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A17_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A17_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_GPMC_A17_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_QSPI1_D0_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_VIN4A_D10_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A17_GPMC_A17_MUXMODE_GPIO2_7_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A17_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A17_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A17_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A17_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A17_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A17_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A18_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A18_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A18_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A18_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_GPMC_A18_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_QSPI1_SCLK_1                                                 (1U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_VIN4A_D11_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A18_GPMC_A18_MUXMODE_GPIO2_8_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A18_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A18_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A18_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A18_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A18_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A18_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A19_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A19_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A19_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A19_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_GPMC_A19_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_MMC2_DAT4_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_GPMC_A13_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_VIN4A_D12_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_VIN3B_D0_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A19_GPMC_A19_MUXMODE_GPIO2_9_14                                                   (14U)

#define CTRL_CORE_PAD_GPMC_A19_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A19_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A19_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A19_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A19_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A19_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A20_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A20_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A20_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A20_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_GPMC_A20_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_MMC2_DAT5_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_GPMC_A14_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_VIN4A_D13_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_VIN3B_D1_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A20_GPMC_A20_MUXMODE_GPIO2_10_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A20_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A20_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A20_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A20_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A20_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A20_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A21_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A21_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A21_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A21_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_GPMC_A21_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_MMC2_DAT6_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_GPMC_A15_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_VIN4A_D14_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_VIN3B_D2_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A21_GPMC_A21_MUXMODE_GPIO2_11_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A21_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A21_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A21_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A21_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A21_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A21_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A22_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A22_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A22_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A22_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_GPMC_A22_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_MMC2_DAT7_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_GPMC_A16_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_VIN4A_D15_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_VIN3B_D3_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A22_GPMC_A22_MUXMODE_GPIO2_12_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A22_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A22_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A22_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A22_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A22_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A22_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A23_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A23_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A23_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A23_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_GPMC_A23_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_MMC2_CLK_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_GPMC_A17_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_VIN4A_FLD0_4                                                 (4U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_VIN3B_D4_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A23_GPMC_A23_MUXMODE_GPIO2_13_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A23_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A23_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A23_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A23_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A23_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A23_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A24_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A24_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A24_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A24_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_GPMC_A24_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_MMC2_DAT0_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_GPMC_A18_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_VIN4A_D8_4                                                   (4U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_VIN3B_D5_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A24_GPMC_A24_MUXMODE_GPIO2_14_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A24_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A24_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A24_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A24_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A24_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A24_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A25_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A25_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A25_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A25_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_GPMC_A25_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_MMC2_DAT1_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_GPMC_A19_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_VIN4A_D9_4                                                   (4U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_VIN3B_D6_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A25_GPMC_A25_MUXMODE_GPIO2_15_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A25_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A25_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A25_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A25_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A25_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A25_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A26_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A26_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A26_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A26_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_GPMC_A26_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_MMC2_DAT2_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_GPMC_A20_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_VIN4A_D10_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_VIN3B_D7_6                                                   (6U)
#define CTRL_CORE_PAD_GPMC_A26_GPMC_A26_MUXMODE_GPIO2_16_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A26_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A26_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A26_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A26_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A26_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A26_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_A27_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_A27_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_A27_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_A27_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_GPMC_A27_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_MMC2_DAT3_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_GPMC_A21_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_VIN4A_D11_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_VIN3B_HSYNC1_6                                               (6U)
#define CTRL_CORE_PAD_GPMC_A27_GPMC_A27_MUXMODE_GPIO2_17_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_A27_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_A27_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_A27_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_A27_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_A27_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_A27_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_GPMC_CS1_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_MMC2_CMD_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_GPMC_A22_2                                                   (2U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_VIN4A_DE0_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_VIN3B_VSYNC1_6                                               (6U)
#define CTRL_CORE_PAD_GPMC_CS1_GPMC_CS1_MUXMODE_GPIO2_18_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_CS1_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_MUXMODE_GPMC_CS0_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_MUXMODE_QSPI2_CS1_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_CS0_GPMC_CS0_MUXMODE_GPIO2_19_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_CS0_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_MUXMODE_GPMC_CS2_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_MUXMODE_QSPI1_CS0_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS2_GPMC_CS2_MUXMODE_GPIO2_20_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_CS2_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_GPMC_CS3_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_QSPI1_CS1_1                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_VIN3A_CLK0_2                                                 (2U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_VOUT3_CLK_3                                                  (3U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_QSPI2_CS0_4                                                  (4U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_GPMC_A1_5                                                    (5U)
#define CTRL_CORE_PAD_GPMC_CS3_GPMC_CS3_MUXMODE_GPIO2_21_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_CS3_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_GPMC_CLK_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_GPMC_CS7_1                                                   (1U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_CLKOUT1_2                                                    (2U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_GPMC_WAIT1_3                                                 (3U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_VIN4A_HSYNC0_4                                               (4U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_VIN4A_DE0_5                                                  (5U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_VIN3B_CLK1_6                                                 (6U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_TIMER4_7                                                     (7U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_I2C3_SCL_8                                                   (8U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_DMA_EVT1_9                                                   (9U)
#define CTRL_CORE_PAD_GPMC_CLK_GPMC_CLK_MUXMODE_GPIO2_22_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_CLK_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPEVENT_SHIFT                                         (25U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPEVENT_MASK                                          (0x02000000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPEVENT_NOWAKEUP                                       (0U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPEVENT_WAKEUP                                         (1U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPENABLE_SHIFT                                        (24U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPENABLE_MASK                                         (0x01000000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPENABLE_ENABLE                                        (1U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_WAKEUPENABLE_DISABLE                                       (0U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_SLEWCONTROL_SHIFT                                         (19U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_SLEWCONTROL_MASK                                          (0x00080000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_SLEWCONTROL_SLOW_SLEW                                      (0U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_SLEWCONTROL_FAST_SLEW                                      (1U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_INPUTENABLE_SHIFT                                         (18U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_INPUTENABLE_MASK                                          (0x00040000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_INPUTENABLE_ENABLE                                         (1U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_INPUTENABLE_DISABLE                                        (0U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLTYPESELECT_SHIFT                                      (17U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLTYPESELECT_MASK                                       (0x00020000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLTYPESELECT_PULL_UP                                     (1U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLTYPESELECT_PULL_DOWN                                   (0U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLUDENABLE_SHIFT                                        (16U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLUDENABLE_MASK                                         (0x00010000U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLUDENABLE_ENABLE                                        (1U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_PULLUDENABLE_DISABLE                                       (0U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_3_SHIFT                                                        (8U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_3_MASK                                                         (0x00000100U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_4_SHIFT                                                        (4U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_4_MASK                                                         (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_SHIFT                                             (0U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_MASK                                              (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPMC_ADVN_ALE_0                                    (0U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPMC_CS6_1                                         (1U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_CLKOUT2_2                                          (2U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPMC_WAIT1_3                                       (3U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_VIN4A_VSYNC0_4                                     (4U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPMC_A2_5                                          (5U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPMC_A23_6                                         (6U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_TIMER3_7                                           (7U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_I2C3_SDA_8                                         (8U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_DMA_EVT2_9                                         (9U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_GPMC_ADVN_ALE_MUXMODE_GPIO2_23_14                                        (14U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_0_SHIFT                                                        (9U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_0_MASK                                                         (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_1_SHIFT                                                        (20U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_1_MASK                                                         (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_2_SHIFT                                                        (26U)
#define CTRL_CORE_PAD_GPMC_ADVN_ALE_RESERVED_2_MASK                                                         (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_MUXMODE_GPMC_OEN_REN_0                                       (0U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_GPMC_OEN_REN_MUXMODE_GPIO2_24_14                                          (14U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_GPMC_OEN_REN_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_MUXMODE_GPMC_WEN_0                                                   (0U)
#define CTRL_CORE_PAD_GPMC_WEN_GPMC_WEN_MUXMODE_GPIO2_25_14                                                  (14U)

#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPMC_WEN_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_GPMC_BEN0_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_GPMC_CS4_1                                                 (1U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_VIN1B_HSYNC1_3                                             (3U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_VIN3B_DE1_6                                                (6U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_TIMER2_7                                                   (7U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_DMA_EVT3_9                                                 (9U)
#define CTRL_CORE_PAD_GPMC_BEN0_GPMC_BEN0_MUXMODE_GPIO2_26_14                                                (14U)

#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_BEN0_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_GPMC_BEN1_0                                                (0U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_GPMC_CS5_1                                                 (1U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_VIN1B_DE1_3                                                (3U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_VIN3B_CLK1_4                                               (4U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_GPMC_A3_5                                                  (5U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_VIN3B_FLD1_6                                               (6U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_TIMER1_7                                                   (7U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_DMA_EVT4_9                                                 (9U)
#define CTRL_CORE_PAD_GPMC_BEN1_GPMC_BEN1_MUXMODE_GPIO2_27_14                                                (14U)

#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_GPMC_BEN1_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_MUXMODE_GPMC_WAIT0_0                                             (0U)
#define CTRL_CORE_PAD_GPMC_WAIT0_GPMC_WAIT0_MUXMODE_GPIO2_28_14                                              (14U)

#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_GPMC_WAIT0_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_VIN1A_CLK0_0                                             (0U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_VOUT3_D16_3                                              (3U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_VOUT3_FLD_4                                              (4U)
#define CTRL_CORE_PAD_VIN1A_CLK0_VIN1A_CLK0_MUXMODE_GPIO2_30_14                                              (14U)

#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_VIN1A_CLK0_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_MUXMODE_VIN1B_CLK1_0                                             (0U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_MUXMODE_VIN3A_CLK0_6                                             (6U)
#define CTRL_CORE_PAD_VIN1B_CLK1_VIN1B_CLK1_MUXMODE_GPIO2_31_14                                              (14U)

#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_VIN1B_CLK1_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_VIN1A_DE0_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_VIN1B_HSYNC1_1                                             (1U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_VOUT3_D17_3                                                (3U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_VOUT3_DE_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_UART7_RXD_5                                                (5U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_TIMER16_7                                                  (7U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_SPI3_SCLK_8                                                (8U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_KBD_ROW0_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_EQEP1A_IN_10                                               (10U)
#define CTRL_CORE_PAD_VIN1A_DE0_VIN1A_DE0_MUXMODE_GPIO3_0_14                                                 (14U)

#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_DE0_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_VIN1A_FLD0_0                                             (0U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_VIN1B_VSYNC1_1                                           (1U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_VOUT3_CLK_4                                              (4U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_UART7_TXD_5                                              (5U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_TIMER15_7                                                (7U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_SPI3_D1_8                                                (8U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_KBD_ROW1_9                                               (9U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_EQEP1B_IN_10                                             (10U)
#define CTRL_CORE_PAD_VIN1A_FLD0_VIN1A_FLD0_MUXMODE_GPIO3_1_14                                               (14U)

#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_VIN1A_FLD0_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_VIN1A_HSYNC0_0                                       (0U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_VIN1B_FLD1_1                                         (1U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_VOUT3_HSYNC_4                                        (4U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_UART7_CTSN_5                                         (5U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_TIMER14_7                                            (7U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_SPI3_D0_8                                            (8U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_EQEP1_INDEX_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_VIN1A_HSYNC0_MUXMODE_GPIO3_2_14                                           (14U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_VIN1A_HSYNC0_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_VIN1A_VSYNC0_0                                       (0U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_VIN1B_DE1_1                                          (1U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_VOUT3_VSYNC_4                                        (4U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_UART7_RTSN_5                                         (5U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_TIMER13_7                                            (7U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_SPI3_CS0_8                                           (8U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_EQEP1_STROBE_10                                      (10U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_VIN1A_VSYNC0_MUXMODE_GPIO3_3_14                                           (14U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_VIN1A_VSYNC0_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_VIN1A_D0_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_VOUT3_D7_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_VOUT3_D23_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_UART8_RXD_5                                                  (5U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_GMII0_TXCLK_7                                                (7U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_EHRPWM1A_10                                                  (10U)
#define CTRL_CORE_PAD_VIN1A_D0_VIN1A_D0_MUXMODE_GPIO3_4_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D0_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_VIN1A_D1_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_VOUT3_D6_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_VOUT3_D22_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_UART8_TXD_5                                                  (5U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_GMII0_COL_7                                                  (7U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_EHRPWM1B_10                                                  (10U)
#define CTRL_CORE_PAD_VIN1A_D1_VIN1A_D1_MUXMODE_GPIO3_5_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D1_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_VIN1A_D2_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_VOUT3_D5_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_VOUT3_D21_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_UART8_CTSN_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_GMII0_CRS_7                                                  (7U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_EHRPWM1_TRIPZONE_INPUT_10                                    (10U)
#define CTRL_CORE_PAD_VIN1A_D2_VIN1A_D2_MUXMODE_GPIO3_6_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D2_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_VIN1A_D3_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_VOUT3_D4_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_VOUT3_D20_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_UART8_RTSN_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_GMII0_RXER_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_ECAP1_IN_PWM1_OUT_10                                         (10U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_PR1_PRU0_PRU_R310_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_PR1_PRU0_PRU_R300_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D3_VIN1A_D3_MUXMODE_GPIO3_7_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D3_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_VIN1A_D4_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_VOUT3_D3_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_VOUT3_D19_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_GMII0_RXCLK_7                                                (7U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_EHRPWM1_SYNCI_10                                             (10U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_PR1_PRU0_PRU_R311_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_PR1_PRU0_PRU_R301_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D4_VIN1A_D4_MUXMODE_GPIO3_8_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D4_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_VIN1A_D5_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_VOUT3_D2_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_VOUT3_D18_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_GMII0_RXD0_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_EHRPWM1_SYNCO_10                                             (10U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_PR1_PRU0_PRU_R312_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_PR1_PRU0_PRU_R302_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D5_VIN1A_D5_MUXMODE_GPIO3_9_14                                                   (14U)

#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D5_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_VIN1A_D6_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_VOUT3_D1_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_VOUT3_D17_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_GMII0_RXD1_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_EQEP2A_IN_10                                                 (10U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_PR1_PRU0_PRU_R313_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_PR1_PRU0_PRU_R303_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D6_VIN1A_D6_MUXMODE_GPIO3_10_14                                                  (14U)

#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D6_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_VIN1A_D7_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_VOUT3_D0_3                                                   (3U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_VOUT3_D16_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_GMII0_RXD2_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_EQEP2B_IN_10                                                 (10U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_PR1_PRU0_PRU_R314_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_PR1_PRU0_PRU_R304_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D7_VIN1A_D7_MUXMODE_GPIO3_11_14                                                  (14U)

#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D7_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_VIN1A_D8_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_VIN1B_D7_1                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_VOUT3_D15_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_GMII0_RXD3_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_KBD_ROW2_9                                                   (9U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_EQEP2_INDEX_10                                               (10U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_PR1_PRU0_PRU_R315_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_PR1_PRU0_PRU_R305_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D8_VIN1A_D8_MUXMODE_GPIO3_12_14                                                  (14U)

#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D8_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_VIN1A_D9_0                                                   (0U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_VIN1B_D6_1                                                   (1U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_VOUT3_D14_4                                                  (4U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_GMII0_RXD4_7                                                 (7U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_KBD_ROW3_9                                                   (9U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_EQEP2_STROBE_10                                              (10U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_PR1_PRU0_PRU_R316_12                                         (12U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_PR1_PRU0_PRU_R306_13                                         (13U)
#define CTRL_CORE_PAD_VIN1A_D9_VIN1A_D9_MUXMODE_GPIO3_13_14                                                  (14U)

#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN1A_D9_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_VIN1A_D10_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_VIN1B_D5_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_VOUT3_D13_4                                                (4U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_GMII0_RXD5_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_KBD_ROW4_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_PR1_EDC_LATCH0_IN_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_PR1_PRU0_PRU_R317_12                                       (12U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_PR1_PRU0_PRU_R307_13                                       (13U)
#define CTRL_CORE_PAD_VIN1A_D10_VIN1A_D10_MUXMODE_GPIO3_14_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D10_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_VIN1A_D11_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_VIN1B_D4_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_VOUT3_D12_4                                                (4U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_GPMC_A23_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_GMII0_RXD6_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_KBD_ROW5_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_PR1_EDC_LATCH1_IN_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_PR1_PRU0_PRU_R318_12                                       (12U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_PR1_PRU0_PRU_R308_13                                       (13U)
#define CTRL_CORE_PAD_VIN1A_D11_VIN1A_D11_MUXMODE_GPIO3_15_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D11_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_VIN1A_D12_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_VIN1B_D3_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_USB3_ULPI_D7_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_VOUT3_D11_4                                                (4U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_GPMC_A24_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_GMII0_RXD7_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_KBD_ROW6_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_PR1_EDC_SYNC0_OUT_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_PR1_PRU0_PRU_R319_12                                       (12U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_PR1_PRU0_PRU_R309_13                                       (13U)
#define CTRL_CORE_PAD_VIN1A_D12_VIN1A_D12_MUXMODE_GPIO3_16_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D12_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_VIN1A_D13_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_VIN1B_D2_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_USB3_ULPI_D6_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_VOUT3_D10_4                                                (4U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_GPMC_A25_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_GMII0_RXDV_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_KBD_ROW7_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_PR1_EDC_SYNC1_OUT_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_PR1_PRU0_PRU_R3110_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_PR1_PRU0_PRU_R3010_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D13_VIN1A_D13_MUXMODE_GPIO3_17_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D13_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_VIN1A_D14_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_VIN1B_D1_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_USB3_ULPI_D5_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_VOUT3_D9_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_GPMC_A26_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_GMII0_GTXCLK_7                                             (7U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_KBD_ROW8_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_PR1_EDIO_LATCH_IN_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_PR1_PRU0_PRU_R3111_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_PR1_PRU0_PRU_R3011_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D14_VIN1A_D14_MUXMODE_GPIO3_18_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D14_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_VIN1A_D15_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_VIN1B_D0_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_USB3_ULPI_D4_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_VOUT3_D8_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_GPMC_A27_5                                                 (5U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_GMII0_TXD0_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_KBD_COL0_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_PR1_EDIO_SOF_10                                            (10U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_PR1_PRU0_PRU_R3112_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_PR1_PRU0_PRU_R3012_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D15_VIN1A_D15_MUXMODE_GPIO3_19_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D15_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_VIN1A_D16_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_VIN1B_D7_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_USB3_ULPI_D3_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_VOUT3_D7_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_VIN3A_D0_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_GMII0_TXD1_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_KBD_COL1_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_PR1_EDIO_DATA_IN0_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_PR1_EDIO_DATA_OUT0_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_PR1_PRU0_PRU_R3113_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_PR1_PRU0_PRU_R3013_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D16_VIN1A_D16_MUXMODE_GPIO3_20_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D16_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_VIN1A_D17_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_VIN1B_D6_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_USB3_ULPI_D2_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_VOUT3_D6_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_VIN3A_D1_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_GMII0_TXD2_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_KBD_COL2_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_PR1_EDIO_DATA_IN1_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_PR1_EDIO_DATA_OUT1_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_PR1_PRU0_PRU_R3114_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_PR1_PRU0_PRU_R3014_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D17_VIN1A_D17_MUXMODE_GPIO3_21_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D17_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_VIN1A_D18_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_VIN1B_D5_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_USB3_ULPI_D1_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_VOUT3_D5_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_VIN3A_D2_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_GMII0_TXD3_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_KBD_COL3_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_PR1_EDIO_DATA_IN2_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_PR1_EDIO_DATA_OUT2_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_PR1_PRU0_PRU_R3115_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_PR1_PRU0_PRU_R3015_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D18_VIN1A_D18_MUXMODE_GPIO3_22_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D18_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_VIN1A_D19_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_VIN1B_D4_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_USB3_ULPI_D0_2                                             (2U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_VOUT3_D4_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_VIN3A_D3_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_GMII0_TXD4_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_KBD_COL4_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_PR1_EDIO_DATA_IN3_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_PR1_EDIO_DATA_OUT3_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_PR1_PRU0_PRU_R3116_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_PR1_PRU0_PRU_R3016_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D19_VIN1A_D19_MUXMODE_GPIO3_23_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D19_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_VIN1A_D20_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_VIN1B_D3_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_USB3_ULPI_NXT_2                                            (2U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_VOUT3_D3_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_VIN3A_D4_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_GMII0_TXD5_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_KBD_COL5_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_PR1_EDIO_DATA_IN4_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_PR1_EDIO_DATA_OUT4_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_PR1_PRU0_PRU_R3117_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_PR1_PRU0_PRU_R3017_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D20_VIN1A_D20_MUXMODE_GPIO3_24_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D20_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_VIN1A_D21_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_VIN1B_D2_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_USB3_ULPI_DIR_2                                            (2U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_VOUT3_D2_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_VIN3A_D5_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_GMII0_TXD6_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_KBD_COL6_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_PR1_EDIO_DATA_IN5_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_PR1_EDIO_DATA_OUT5_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_PR1_PRU0_PRU_R3118_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_PR1_PRU0_PRU_R3018_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D21_VIN1A_D21_MUXMODE_GPIO3_25_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D21_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_VIN1A_D22_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_VIN1B_D1_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_USB3_ULPI_STP_2                                            (2U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_VOUT3_D1_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_VIN3A_D6_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_GMII0_TXD7_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_KBD_COL7_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_PR1_EDIO_DATA_IN6_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_PR1_EDIO_DATA_OUT6_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_PR1_PRU0_PRU_R3119_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_PR1_PRU0_PRU_R3019_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D22_VIN1A_D22_MUXMODE_GPIO3_26_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D22_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_VIN1A_D23_0                                                (0U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_VIN1B_D0_1                                                 (1U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_USB3_ULPI_CLK_2                                            (2U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_VOUT3_D0_4                                                 (4U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_VIN3A_D7_6                                                 (6U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_GMII0_TXEN_7                                               (7U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_KBD_COL8_9                                                 (9U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_PR1_EDIO_DATA_IN7_10                                       (10U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_PR1_EDIO_DATA_OUT7_11                                      (11U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_PR1_PRU0_PRU_R3120_12                                      (12U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_PR1_PRU0_PRU_R3020_13                                      (13U)
#define CTRL_CORE_PAD_VIN1A_D23_VIN1A_D23_MUXMODE_GPIO3_27_14                                                (14U)

#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN1A_D23_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_VIN2A_CLK0_0                                             (0U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_VOUT2_FLD_4                                              (4U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_EMU5_5                                                   (5U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_KBD_ROW0_9                                               (9U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_EQEP1A_IN_10                                             (10U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_PR1_EDIO_DATA_IN0_12                                     (12U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_PR1_EDIO_DATA_OUT0_13                                    (13U)
#define CTRL_CORE_PAD_VIN2A_CLK0_VIN2A_CLK0_MUXMODE_GPIO3_28_14                                              (14U)

#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_VIN2A_CLK0_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_VIN2A_DE0_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_VIN2A_FLD0_1                                               (1U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_VIN2B_FLD1_2                                               (2U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_VIN2B_DE1_3                                                (3U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_VOUT2_DE_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_EMU6_5                                                     (5U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_GMII1_TXCLK_7                                              (7U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_KBD_ROW1_9                                                 (9U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_EQEP1B_IN_10                                               (10U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_PR1_EDIO_DATA_IN1_12                                       (12U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_PR1_EDIO_DATA_OUT1_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_DE0_VIN2A_DE0_MUXMODE_GPIO3_29_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_DE0_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_VIN2A_FLD0_0                                             (0U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_VIN2B_CLK1_2                                             (2U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_VOUT2_CLK_4                                              (4U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_EMU7_5                                                   (5U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_GMII1_COL_7                                              (7U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_EQEP1_INDEX_10                                           (10U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_PR1_EDIO_DATA_IN2_12                                     (12U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_PR1_EDIO_DATA_OUT2_13                                    (13U)
#define CTRL_CORE_PAD_VIN2A_FLD0_VIN2A_FLD0_MUXMODE_GPIO3_30_14                                              (14U)

#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_VIN2A_FLD0_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_VIN2A_HSYNC0_0                                       (0U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_VIN2B_HSYNC1_3                                       (3U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_VOUT2_HSYNC_4                                        (4U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_EMU8_5                                               (5U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_UART9_RXD_7                                          (7U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_SPI4_SCLK_8                                          (8U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_KBD_ROW2_9                                           (9U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_EQEP1_STROBE_10                                      (10U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_PR1_UART0_CTS_N_11                                   (11U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_PR1_EDIO_DATA_IN3_12                                 (12U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_PR1_EDIO_DATA_OUT3_13                                (13U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_VIN2A_HSYNC0_MUXMODE_GPIO3_31_14                                          (14U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_VIN2A_HSYNC0_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_VIN2A_VSYNC0_0                                       (0U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_VIN2B_VSYNC1_3                                       (3U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_VOUT2_VSYNC_4                                        (4U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_EMU9_5                                               (5U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_UART9_TXD_7                                          (7U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_SPI4_D1_8                                            (8U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_KBD_ROW3_9                                           (9U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_EHRPWM1A_10                                          (10U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_PR1_UART0_RTS_N_11                                   (11U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_PR1_EDIO_DATA_IN4_12                                 (12U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_PR1_EDIO_DATA_OUT4_13                                (13U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_VIN2A_VSYNC0_MUXMODE_GPIO4_0_14                                           (14U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_VIN2A_VSYNC0_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_VIN2A_D0_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_VOUT2_D23_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_EMU10_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_UART9_CTSN_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_SPI4_D0_8                                                    (8U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_KBD_ROW4_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_EHRPWM1B_10                                                  (10U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_PR1_UART0_RXD_11                                             (11U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_PR1_EDIO_DATA_IN5_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_PR1_EDIO_DATA_OUT5_13                                        (13U)
#define CTRL_CORE_PAD_VIN2A_D0_VIN2A_D0_MUXMODE_GPIO4_1_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D0_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_VIN2A_D1_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_VOUT2_D22_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_EMU11_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_UART9_RTSN_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_SPI4_CS0_8                                                   (8U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_KBD_ROW5_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_EHRPWM1_TRIPZONE_INPUT_10                                    (10U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_PR1_UART0_TXD_11                                             (11U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_PR1_EDIO_DATA_IN6_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_PR1_EDIO_DATA_OUT6_13                                        (13U)
#define CTRL_CORE_PAD_VIN2A_D1_VIN2A_D1_MUXMODE_GPIO4_2_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D1_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_VIN2A_D2_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_VOUT2_D21_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_EMU12_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_GMII1_CRS_7                                                  (7U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_UART10_RXD_8                                                 (8U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_KBD_ROW6_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_ECAP1_IN_PWM1_OUT_10                                         (10U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_PR1_ECAP0_ECAP_CAPIN_APWM_O_11                               (11U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_PR1_EDIO_DATA_IN7_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_PR1_EDIO_DATA_OUT7_13                                        (13U)
#define CTRL_CORE_PAD_VIN2A_D2_VIN2A_D2_MUXMODE_GPIO4_3_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D2_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_VIN2A_D3_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_VOUT2_D20_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_EMU13_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_GMII1_RXER_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_UART10_TXD_8                                                 (8U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_KBD_COL0_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_EHRPWM1_SYNCI_10                                             (10U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_PR1_EDC_LATCH0_IN_11                                         (11U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_PR1_PRU1_PRU_R310_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_PR1_PRU1_PRU_R300_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D3_VIN2A_D3_MUXMODE_GPIO4_4_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D3_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_VIN2A_D4_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_VOUT2_D19_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_EMU14_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_GMII1_RXCLK_7                                                (7U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_UART10_CTSN_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_KBD_COL1_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_EHRPWM1_SYNCO_10                                             (10U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_PR1_EDC_SYNC0_OUT_11                                         (11U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_PR1_PRU1_PRU_R311_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_PR1_PRU1_PRU_R301_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D4_VIN2A_D4_MUXMODE_GPIO4_5_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D4_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_VIN2A_D5_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_VOUT2_D18_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_EMU15_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_GMII1_RXD0_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_UART10_RTSN_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_KBD_COL2_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_EQEP2A_IN_10                                                 (10U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_PR1_EDIO_SOF_11                                              (11U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_PR1_PRU1_PRU_R312_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_PR1_PRU1_PRU_R302_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D5_VIN2A_D5_MUXMODE_GPIO4_6_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D5_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_VIN2A_D6_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_VOUT2_D17_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_EMU16_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_GMII1_RXD1_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_MII1_RXD1_8                                                  (8U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_KBD_COL3_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_EQEP2B_IN_10                                                 (10U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_PR1_MII_MT1_CLK_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_PR1_PRU1_PRU_R313_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_PR1_PRU1_PRU_R303_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D6_VIN2A_D6_MUXMODE_GPIO4_7_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D6_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_VIN2A_D7_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_VOUT2_D16_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_EMU17_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_GMII1_RXD2_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_MII1_RXD2_8                                                  (8U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_KBD_COL4_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_EQEP2_INDEX_10                                               (10U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_PR1_MII1_TXEN_11                                             (11U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_PR1_PRU1_PRU_R314_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_PR1_PRU1_PRU_R304_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D7_VIN2A_D7_MUXMODE_GPIO4_8_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D7_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_VIN2A_D8_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_VOUT2_D15_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_EMU18_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_GMII1_RXD3_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_MII1_RXD3_8                                                  (8U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_KBD_COL5_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_EQEP2_STROBE_10                                              (10U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_PR1_MII1_TXD3_11                                             (11U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_PR1_PRU1_PRU_R315_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_PR1_PRU1_PRU_R305_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D8_VIN2A_D8_MUXMODE_GPIO4_9_14                                                   (14U)

#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D8_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_VIN2A_D9_0                                                   (0U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_VOUT2_D14_4                                                  (4U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_EMU19_5                                                      (5U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_GMII1_RXD4_7                                                 (7U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_MII1_RXD0_8                                                  (8U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_KBD_COL6_9                                                   (9U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_EHRPWM2A_10                                                  (10U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_PR1_MII1_TXD2_11                                             (11U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_PR1_PRU1_PRU_R316_12                                         (12U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_PR1_PRU1_PRU_R306_13                                         (13U)
#define CTRL_CORE_PAD_VIN2A_D9_VIN2A_D9_MUXMODE_GPIO4_10_14                                                  (14U)

#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VIN2A_D9_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_VIN2A_D10_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_MDIO_MCLK_3                                                (3U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_VOUT2_D13_4                                                (4U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_GMII1_RXD5_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_KBD_COL7_9                                                 (9U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_EHRPWM2B_10                                                (10U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_PR1_MDIO_MDCLK_11                                          (11U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_PR1_PRU1_PRU_R317_12                                       (12U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_PR1_PRU1_PRU_R307_13                                       (13U)
#define CTRL_CORE_PAD_VIN2A_D10_VIN2A_D10_MUXMODE_GPIO4_11_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D10_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_VIN2A_D11_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_MDIO_D_3                                                   (3U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_VOUT2_D12_4                                                (4U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_GMII1_RXD6_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_KBD_ROW7_9                                                 (9U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_EHRPWM2_TRIPZONE_INPUT_10                                  (10U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_PR1_MDIO_DATA_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_PR1_PRU1_PRU_R318_12                                       (12U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_PR1_PRU1_PRU_R308_13                                       (13U)
#define CTRL_CORE_PAD_VIN2A_D11_VIN2A_D11_MUXMODE_GPIO4_12_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D11_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_VIN2A_D12_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_RGMII1_TXC_3                                               (3U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_VOUT2_D11_4                                                (4U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_GMII1_RXD7_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_MII1_RXCLK_8                                               (8U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_KBD_COL8_9                                                 (9U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_ECAP2_IN_PWM2_OUT_10                                       (10U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_PR1_MII1_TXD1_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_PR1_PRU1_PRU_R319_12                                       (12U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_PR1_PRU1_PRU_R309_13                                       (13U)
#define CTRL_CORE_PAD_VIN2A_D12_VIN2A_D12_MUXMODE_GPIO4_13_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D12_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_VIN2A_D13_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_RGMII1_TXCTL_3                                             (3U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_VOUT2_D10_4                                                (4U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_GMII1_RXDV_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_MII1_RXDV_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_KBD_ROW8_9                                                 (9U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_EQEP3A_IN_10                                               (10U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_PR1_MII1_TXD0_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_PR1_PRU1_PRU_R3110_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_PR1_PRU1_PRU_R3010_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D13_VIN2A_D13_MUXMODE_GPIO4_14_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D13_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_VIN2A_D14_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_RGMII1_TXD3_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_VOUT2_D9_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_GMII1_GTXCLK_7                                             (7U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_MII1_TXCLK_8                                               (8U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_EQEP3B_IN_10                                               (10U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_PR1_MII_MR1_CLK_11                                         (11U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_PR1_PRU1_PRU_R3111_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_PR1_PRU1_PRU_R3011_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D14_VIN2A_D14_MUXMODE_GPIO4_15_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D14_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_VIN2A_D15_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_RGMII1_TXD2_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_VOUT2_D8_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_GMII1_TXD0_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_MII1_TXD0_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_EQEP3_INDEX_10                                             (10U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_PR1_MII1_RXDV_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_PR1_PRU1_PRU_R3112_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_PR1_PRU1_PRU_R3012_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D15_VIN2A_D15_MUXMODE_GPIO4_16_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D15_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_VIN2A_D16_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_VIN2B_D7_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_RGMII1_TXD1_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_VOUT2_D7_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_VIN3A_D8_6                                                 (6U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_GMII1_TXD1_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_MII1_TXD1_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_EQEP3_STROBE_10                                            (10U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_PR1_MII1_RXD3_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_PR1_PRU1_PRU_R3113_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_PR1_PRU1_PRU_R3013_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D16_VIN2A_D16_MUXMODE_GPIO4_24_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D16_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_VIN2A_D17_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_VIN2B_D6_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_RGMII1_TXD0_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_VOUT2_D6_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_VIN3A_D9_6                                                 (6U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_GMII1_TXD2_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_MII1_TXD2_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_EHRPWM3A_10                                                (10U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_PR1_MII1_RXD2_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_PR1_PRU1_PRU_R3114_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_PR1_PRU1_PRU_R3014_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D17_VIN2A_D17_MUXMODE_GPIO4_25_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D17_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_VIN2A_D18_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_VIN2B_D5_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_RGMII1_RXC_3                                               (3U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_VOUT2_D5_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_VIN3A_D10_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_GMII1_TXD3_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_MII1_TXD3_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_EHRPWM3B_10                                                (10U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_PR1_MII1_RXD1_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_PR1_PRU1_PRU_R3115_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_PR1_PRU1_PRU_R3015_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D18_VIN2A_D18_MUXMODE_GPIO4_26_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D18_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_VIN2A_D19_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_VIN2B_D4_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_RGMII1_RXCTL_3                                             (3U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_VOUT2_D4_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_VIN3A_D11_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_GMII1_TXD4_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_MII1_TXER_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_EHRPWM3_TRIPZONE_INPUT_10                                  (10U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_PR1_MII1_RXD0_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_PR1_PRU1_PRU_R3116_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_PR1_PRU1_PRU_R3016_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D19_VIN2A_D19_MUXMODE_GPIO4_27_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D19_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_VIN2A_D20_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_VIN2B_D3_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_RGMII1_RXD3_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_VOUT2_D3_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_VIN3A_DE0_5                                                (5U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_VIN3A_D12_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_GMII1_TXD5_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_MII1_RXER_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_ECAP3_IN_PWM3_OUT_10                                       (10U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_PR1_MII1_RXER_11                                           (11U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_PR1_PRU1_PRU_R3117_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_PR1_PRU1_PRU_R3017_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D20_VIN2A_D20_MUXMODE_GPIO4_28_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D20_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_VIN2A_D21_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_VIN2B_D2_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_RGMII1_RXD2_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_VOUT2_D2_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_VIN3A_FLD0_5                                               (5U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_VIN3A_D13_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_GMII1_TXD6_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_MII1_COL_8                                                 (8U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_PR1_MII1_RXLINK_11                                         (11U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_PR1_PRU1_PRU_R3118_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_PR1_PRU1_PRU_R3018_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D21_VIN2A_D21_MUXMODE_GPIO4_29_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D21_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_VIN2A_D22_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_VIN2B_D1_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_RGMII1_RXD1_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_VOUT2_D1_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_VIN3A_HSYNC0_5                                             (5U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_VIN3A_D14_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_GMII1_TXD7_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_MII1_CRS_8                                                 (8U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_PR1_MII1_COL_11                                            (11U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_PR1_PRU1_PRU_R3119_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_PR1_PRU1_PRU_R3019_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D22_VIN2A_D22_MUXMODE_GPIO4_30_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D22_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_VIN2A_D23_0                                                (0U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_VIN2B_D0_2                                                 (2U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_RGMII1_RXD0_3                                              (3U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_VOUT2_D0_4                                                 (4U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_VIN3A_VSYNC0_5                                             (5U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_VIN3A_D15_6                                                (6U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_GMII1_TXEN_7                                               (7U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_MII1_TXEN_8                                                (8U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_PR1_MII1_CRS_11                                            (11U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_PR1_PRU1_PRU_R3120_12                                      (12U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_PR1_PRU1_PRU_R3020_13                                      (13U)
#define CTRL_CORE_PAD_VIN2A_D23_VIN2A_D23_MUXMODE_GPIO4_31_14                                                (14U)

#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VIN2A_D23_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_VOUT1_CLK_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_VIN4A_FLD0_3                                               (3U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_VIN3A_FLD0_4                                               (4U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_SPI3_CS0_8                                                 (8U)
#define CTRL_CORE_PAD_VOUT1_CLK_VOUT1_CLK_MUXMODE_GPIO4_19_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_CLK_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_VOUT1_DE_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_VIN4A_DE0_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_VIN3A_DE0_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_SPI3_D1_8                                                    (8U)
#define CTRL_CORE_PAD_VOUT1_DE_VOUT1_DE_MUXMODE_GPIO4_20_14                                                  (14U)

#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_DE_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_VOUT1_FLD_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_VIN4A_CLK0_3                                               (3U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_VIN3A_CLK0_4                                               (4U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_SPI3_CS1_8                                                 (8U)
#define CTRL_CORE_PAD_VOUT1_FLD_VOUT1_FLD_MUXMODE_GPIO4_21_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_FLD_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_VOUT1_HSYNC_0                                          (0U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_VIN4A_HSYNC0_3                                         (3U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_VIN3A_HSYNC0_4                                         (4U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_SPI3_D0_8                                              (8U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_VOUT1_HSYNC_MUXMODE_GPIO4_22_14                                            (14U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_VOUT1_HSYNC_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_VOUT1_VSYNC_0                                          (0U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_VIN4A_VSYNC0_3                                         (3U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_VIN3A_VSYNC0_4                                         (4U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_SPI3_SCLK_8                                            (8U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_PR2_PRU1_PRU_R3117_12                                  (12U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_PR2_PRU1_PRU_R3017_13                                  (13U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_VOUT1_VSYNC_MUXMODE_GPIO4_23_14                                            (14U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_VOUT1_VSYNC_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_VOUT1_D0_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_UART5_RXD_2                                                  (2U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_VIN4A_D16_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_VIN3A_D16_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_SPI3_CS2_8                                                   (8U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_PR1_UART0_CTS_N_10                                           (10U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_PR2_PRU1_PRU_R3118_12                                        (12U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_PR2_PRU1_PRU_R3018_13                                        (13U)
#define CTRL_CORE_PAD_VOUT1_D0_VOUT1_D0_MUXMODE_GPIO8_0_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D0_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_VOUT1_D1_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_UART5_TXD_2                                                  (2U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_VIN4A_D17_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_VIN3A_D17_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_PR1_UART0_RTS_N_10                                           (10U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_PR2_PRU1_PRU_R3119_12                                        (12U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_PR2_PRU1_PRU_R3019_13                                        (13U)
#define CTRL_CORE_PAD_VOUT1_D1_VOUT1_D1_MUXMODE_GPIO8_1_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D1_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_VOUT1_D2_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_EMU2_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_VIN4A_D18_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_VIN3A_D18_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_OBS0_5                                                       (5U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_OBS16_6                                                      (6U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_OBS_IRQ1_7                                                   (7U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_PR1_UART0_RXD_10                                             (10U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_PR2_PRU1_PRU_R3120_12                                        (12U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_PR2_PRU1_PRU_R3020_13                                        (13U)
#define CTRL_CORE_PAD_VOUT1_D2_VOUT1_D2_MUXMODE_GPIO8_2_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D2_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_VOUT1_D3_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_EMU5_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_VIN4A_D19_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_VIN3A_D19_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_OBS1_5                                                       (5U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_OBS17_6                                                      (6U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_OBS_DMARQ1_7                                                 (7U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_PR1_UART0_TXD_10                                             (10U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_PR2_PRU0_PRU_R310_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_PR2_PRU0_PRU_R300_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D3_VOUT1_D3_MUXMODE_GPIO8_3_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D3_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_VOUT1_D4_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_EMU6_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_VIN4A_D20_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_VIN3A_D20_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_OBS2_5                                                       (5U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_OBS18_6                                                      (6U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_PR1_ECAP0_ECAP_CAPIN_APWM_O_10                               (10U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_PR2_PRU0_PRU_R311_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_PR2_PRU0_PRU_R301_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D4_VOUT1_D4_MUXMODE_GPIO8_4_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D4_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_VOUT1_D5_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_EMU7_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_VIN4A_D21_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_VIN3A_D21_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_OBS3_5                                                       (5U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_OBS19_6                                                      (6U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_PR2_EDC_LATCH0_IN_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_PR2_PRU0_PRU_R312_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_PR2_PRU0_PRU_R302_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D5_VOUT1_D5_MUXMODE_GPIO8_5_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D5_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_VOUT1_D6_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_EMU8_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_VIN4A_D22_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_VIN3A_D22_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_OBS4_5                                                       (5U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_OBS20_6                                                      (6U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_PR2_EDC_LATCH1_IN_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_PR2_PRU0_PRU_R313_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_PR2_PRU0_PRU_R303_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D6_VOUT1_D6_MUXMODE_GPIO8_6_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D6_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_VOUT1_D7_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_EMU9_2                                                       (2U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_VIN4A_D23_3                                                  (3U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_VIN3A_D23_4                                                  (4U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_PR2_EDC_SYNC0_OUT_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_PR2_PRU0_PRU_R314_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_PR2_PRU0_PRU_R304_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D7_VOUT1_D7_MUXMODE_GPIO8_7_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D7_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_VOUT1_D8_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_UART6_RXD_2                                                  (2U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_VIN4A_D8_3                                                   (3U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_VIN3A_D8_4                                                   (4U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_PR2_EDC_SYNC1_OUT_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_PR2_PRU0_PRU_R315_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_PR2_PRU0_PRU_R305_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D8_VOUT1_D8_MUXMODE_GPIO8_8_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D8_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_VOUT1_D9_0                                                   (0U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_UART6_TXD_2                                                  (2U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_VIN4A_D9_3                                                   (3U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_VIN3A_D9_4                                                   (4U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_PR2_EDIO_LATCH_IN_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_PR2_PRU0_PRU_R316_12                                         (12U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_PR2_PRU0_PRU_R306_13                                         (13U)
#define CTRL_CORE_PAD_VOUT1_D9_VOUT1_D9_MUXMODE_GPIO8_9_14                                                   (14U)

#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_VOUT1_D9_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_VOUT1_D10_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_EMU3_2                                                     (2U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_VIN4A_D10_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_VIN3A_D10_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_OBS5_5                                                     (5U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_OBS21_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_OBS_IRQ2_7                                                 (7U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_PR2_EDIO_SOF_10                                            (10U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_PR2_PRU0_PRU_R317_12                                       (12U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_PR2_PRU0_PRU_R307_13                                       (13U)
#define CTRL_CORE_PAD_VOUT1_D10_VOUT1_D10_MUXMODE_GPIO8_10_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D10_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_VOUT1_D11_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_EMU10_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_VIN4A_D11_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_VIN3A_D11_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_OBS6_5                                                     (5U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_OBS22_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_OBS_DMARQ2_7                                               (7U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_PR2_UART0_CTS_N_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_PR2_PRU0_PRU_R318_12                                       (12U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_PR2_PRU0_PRU_R308_13                                       (13U)
#define CTRL_CORE_PAD_VOUT1_D11_VOUT1_D11_MUXMODE_GPIO8_11_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D11_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_VOUT1_D12_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_EMU11_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_VIN4A_D12_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_VIN3A_D12_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_OBS7_5                                                     (5U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_OBS23_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_PR2_UART0_RTS_N_10                                         (10U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_PR2_PRU0_PRU_R319_12                                       (12U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_PR2_PRU0_PRU_R309_13                                       (13U)
#define CTRL_CORE_PAD_VOUT1_D12_VOUT1_D12_MUXMODE_GPIO8_12_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D12_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_VOUT1_D13_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_EMU12_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_VIN4A_D13_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_VIN3A_D13_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_OBS8_5                                                     (5U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_OBS24_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_PR2_UART0_RXD_10                                           (10U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_PR2_PRU0_PRU_R3110_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_PR2_PRU0_PRU_R3010_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D13_VOUT1_D13_MUXMODE_GPIO8_13_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D13_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_VOUT1_D14_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_EMU13_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_VIN4A_D14_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_VIN3A_D14_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_OBS9_5                                                     (5U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_OBS25_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_PR2_UART0_TXD_10                                           (10U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_PR2_PRU0_PRU_R3111_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_PR2_PRU0_PRU_R3011_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D14_VOUT1_D14_MUXMODE_GPIO8_14_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D14_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_VOUT1_D15_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_EMU14_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_VIN4A_D15_3                                                (3U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_VIN3A_D15_4                                                (4U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_OBS10_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_OBS26_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_PR2_ECAP0_ECAP_CAPIN_APWM_O_10                             (10U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_PR2_PRU0_PRU_R3112_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_PR2_PRU0_PRU_R3012_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D15_VOUT1_D15_MUXMODE_GPIO8_15_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D15_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_VOUT1_D16_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_UART7_RXD_2                                                (2U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_VIN4A_D0_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_VIN3A_D0_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_PR2_EDIO_DATA_IN0_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_PR2_EDIO_DATA_OUT0_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_PR2_PRU0_PRU_R3113_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_PR2_PRU0_PRU_R3013_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D16_VOUT1_D16_MUXMODE_GPIO8_16_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D16_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_VOUT1_D17_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_UART7_TXD_2                                                (2U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_VIN4A_D1_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_VIN3A_D1_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_PR2_EDIO_DATA_IN1_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_PR2_EDIO_DATA_OUT1_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_PR2_PRU0_PRU_R3114_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_PR2_PRU0_PRU_R3014_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D17_VOUT1_D17_MUXMODE_GPIO8_17_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D17_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_VOUT1_D18_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_EMU4_2                                                     (2U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_VIN4A_D2_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_VIN3A_D2_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_OBS11_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_OBS27_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_PR2_EDIO_DATA_IN2_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_PR2_EDIO_DATA_OUT2_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_PR2_PRU0_PRU_R3115_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_PR2_PRU0_PRU_R3015_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D18_VOUT1_D18_MUXMODE_GPIO8_18_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D18_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_VOUT1_D19_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_EMU15_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_VIN4A_D3_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_VIN3A_D3_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_OBS12_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_OBS28_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_PR2_EDIO_DATA_IN3_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_PR2_EDIO_DATA_OUT3_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_PR2_PRU0_PRU_R3116_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_PR2_PRU0_PRU_R3016_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D19_VOUT1_D19_MUXMODE_GPIO8_19_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D19_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_VOUT1_D20_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_EMU16_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_VIN4A_D4_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_VIN3A_D4_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_OBS13_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_OBS29_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_PR2_EDIO_DATA_IN4_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_PR2_EDIO_DATA_OUT4_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_PR2_PRU0_PRU_R3117_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_PR2_PRU0_PRU_R3017_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D20_VOUT1_D20_MUXMODE_GPIO8_20_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D20_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_VOUT1_D21_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_EMU17_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_VIN4A_D5_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_VIN3A_D5_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_OBS14_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_OBS30_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_PR2_EDIO_DATA_IN5_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_PR2_EDIO_DATA_OUT5_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_PR2_PRU0_PRU_R3118_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_PR2_PRU0_PRU_R3018_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D21_VOUT1_D21_MUXMODE_GPIO8_21_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D21_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_VOUT1_D22_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_EMU18_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_VIN4A_D6_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_VIN3A_D6_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_OBS15_5                                                    (5U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_OBS31_6                                                    (6U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_PR2_EDIO_DATA_IN6_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_PR2_EDIO_DATA_OUT6_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_PR2_PRU0_PRU_R3119_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_PR2_PRU0_PRU_R3019_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D22_VOUT1_D22_MUXMODE_GPIO8_22_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D22_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_VOUT1_D23_0                                                (0U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_EMU19_2                                                    (2U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_VIN4A_D7_3                                                 (3U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_VIN3A_D7_4                                                 (4U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_SPI3_CS3_8                                                 (8U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_PR2_EDIO_DATA_IN7_10                                       (10U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_PR2_EDIO_DATA_OUT7_11                                      (11U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_PR2_PRU0_PRU_R3120_12                                      (12U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_PR2_PRU0_PRU_R3020_13                                      (13U)
#define CTRL_CORE_PAD_VOUT1_D23_VOUT1_D23_MUXMODE_GPIO8_23_14                                                (14U)

#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_VOUT1_D23_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_MDIO_MCLK_0                                                (0U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_UART3_RTSN_1                                               (1U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_MII0_COL_3                                                 (3U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_VIN2A_CLK0_4                                               (4U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_VIN4B_CLK1_5                                               (5U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_PR1_MII0_COL_11                                            (11U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_PR2_PRU1_PRU_R310_12                                       (12U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_PR2_PRU1_PRU_R300_13                                       (13U)
#define CTRL_CORE_PAD_MDIO_MCLK_MDIO_MCLK_MUXMODE_GPIO5_15_14                                                (14U)

#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_MDIO_MCLK_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPEVENT_SHIFT                                                       (25U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPEVENT_MASK                                                        (0x02000000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPEVENT_NOWAKEUP                                                     (0U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPEVENT_WAKEUP                                                       (1U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPENABLE_SHIFT                                                      (24U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPENABLE_MASK                                                       (0x01000000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPENABLE_ENABLE                                                      (1U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_WAKEUPENABLE_DISABLE                                                     (0U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_SLEWCONTROL_SHIFT                                                       (19U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_SLEWCONTROL_MASK                                                        (0x00080000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_SLEWCONTROL_SLOW_SLEW                                                    (0U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_SLEWCONTROL_FAST_SLEW                                                    (1U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_INPUTENABLE_SHIFT                                                       (18U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_INPUTENABLE_MASK                                                        (0x00040000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_INPUTENABLE_ENABLE                                                       (1U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_INPUTENABLE_DISABLE                                                      (0U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLTYPESELECT_SHIFT                                                    (17U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLTYPESELECT_MASK                                                     (0x00020000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLTYPESELECT_PULL_UP                                                   (1U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLTYPESELECT_PULL_DOWN                                                 (0U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLUDENABLE_SHIFT                                                      (16U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLUDENABLE_MASK                                                       (0x00010000U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLUDENABLE_ENABLE                                                      (1U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_PULLUDENABLE_DISABLE                                                     (0U)

#define CTRL_CORE_PAD_MDIO_D_RESERVED_3_SHIFT                                                               (8U)
#define CTRL_CORE_PAD_MDIO_D_RESERVED_3_MASK                                                                (0x00000100U)

#define CTRL_CORE_PAD_MDIO_D_RESERVED_4_SHIFT                                                               (4U)
#define CTRL_CORE_PAD_MDIO_D_RESERVED_4_MASK                                                                (0x000000f0U)

#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_SHIFT                                                           (0U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_MASK                                                            (0x0000000fU)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_MDIO_D_0                                                         (0U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_UART3_CTSN_1                                                     (1U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_MII0_TXER_3                                                      (3U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_VIN2A_D0_4                                                       (4U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_VIN4B_D0_5                                                       (5U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_PR1_MII0_RXLINK_11                                               (11U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_PR2_PRU1_PRU_R311_12                                             (12U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_PR2_PRU1_PRU_R301_13                                             (13U)
#define CTRL_CORE_PAD_MDIO_D_MDIO_D_MUXMODE_GPIO5_16_14                                                      (14U)

#define CTRL_CORE_PAD_MDIO_D_RESERVED_0_SHIFT                                                               (9U)
#define CTRL_CORE_PAD_MDIO_D_RESERVED_0_MASK                                                                (0x0000fe00U)

#define CTRL_CORE_PAD_MDIO_D_RESERVED_1_SHIFT                                                               (20U)
#define CTRL_CORE_PAD_MDIO_D_RESERVED_1_MASK                                                                (0x00f00000U)

#define CTRL_CORE_PAD_MDIO_D_RESERVED_2_SHIFT                                                               (26U)
#define CTRL_CORE_PAD_MDIO_D_RESERVED_2_MASK                                                                (0xfc000000U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPEVENT_SHIFT                                     (25U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPEVENT_MASK                                      (0x02000000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPEVENT_NOWAKEUP                                   (0U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPEVENT_WAKEUP                                     (1U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPENABLE_SHIFT                                    (24U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPENABLE_MASK                                     (0x01000000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPENABLE_ENABLE                                    (1U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_WAKEUPENABLE_DISABLE                                   (0U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_SLEWCONTROL_SHIFT                                     (19U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_SLEWCONTROL_MASK                                      (0x00080000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_SLEWCONTROL_SLOW_SLEW                                  (0U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_SLEWCONTROL_FAST_SLEW                                  (1U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_INPUTENABLE_SHIFT                                     (18U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_INPUTENABLE_MASK                                      (0x00040000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_INPUTENABLE_ENABLE                                     (1U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_INPUTENABLE_DISABLE                                    (0U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLTYPESELECT_SHIFT                                  (17U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLTYPESELECT_MASK                                   (0x00020000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLTYPESELECT_PULL_UP                                 (1U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLTYPESELECT_PULL_DOWN                               (0U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLUDENABLE_SHIFT                                    (16U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLUDENABLE_MASK                                     (0x00010000U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLUDENABLE_ENABLE                                    (1U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_PULLUDENABLE_DISABLE                                   (0U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_3_SHIFT                                                      (8U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_3_MASK                                                       (0x00000100U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_4_SHIFT                                                      (4U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_4_MASK                                                       (0x000000f0U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_SHIFT                                         (0U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_MASK                                          (0x0000000fU)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_RMII_MHZ_50_CLK_0                              (0U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_VIN2A_D11_4                                    (4U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_PR2_PRU1_PRU_R312_12                           (12U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_PR2_PRU1_PRU_R302_13                           (13U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RMII_MHZ_50_CLK_MUXMODE_GPIO5_17_14                                    (14U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_0_SHIFT                                                      (9U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_0_MASK                                                       (0x0000fe00U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_1_SHIFT                                                      (20U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_1_MASK                                                       (0x00f00000U)

#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_2_SHIFT                                                      (26U)
#define CTRL_CORE_PAD_RMII_MHZ_50_CLK_RESERVED_2_MASK                                                       (0xfc000000U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_UART3_RXD_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_UART3_RXD_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_UART3_RXD_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_UART3_RXD_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_UART3_RXD_0                                                (0U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_RMII1_CRS_2                                                (2U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_MII0_RXDV_3                                                (3U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_VIN2A_D1_4                                                 (4U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_VIN4B_D1_5                                                 (5U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_SPI3_SCLK_7                                                (7U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_PR1_MII0_RXDV_11                                           (11U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_PR2_PRU1_PRU_R313_12                                       (12U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_PR2_PRU1_PRU_R303_13                                       (13U)
#define CTRL_CORE_PAD_UART3_RXD_UART3_RXD_MUXMODE_GPIO5_18_14                                                (14U)

#define CTRL_CORE_PAD_UART3_RXD_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_UART3_RXD_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_UART3_RXD_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_UART3_RXD_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_UART3_RXD_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_UART3_RXD_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_UART3_TXD_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_UART3_TXD_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_UART3_TXD_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_UART3_TXD_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_UART3_TXD_0                                                (0U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_RMII1_RXER_2                                               (2U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_MII0_RXCLK_3                                               (3U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_VIN2A_D2_4                                                 (4U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_VIN4B_D2_5                                                 (5U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_SPI3_D1_7                                                  (7U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_SPI4_CS1_8                                                 (8U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_PR1_MII_MR0_CLK_11                                         (11U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_PR2_PRU1_PRU_R314_12                                       (12U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_PR2_PRU1_PRU_R304_13                                       (13U)
#define CTRL_CORE_PAD_UART3_TXD_UART3_TXD_MUXMODE_GPIO5_19_14                                                (14U)

#define CTRL_CORE_PAD_UART3_TXD_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_UART3_TXD_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_UART3_TXD_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_UART3_TXD_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_UART3_TXD_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_UART3_TXD_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_RGMII0_TXC_0                                             (0U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_UART3_CTSN_1                                             (1U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_RMII1_RXD1_2                                             (2U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_MII0_RXD3_3                                              (3U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_VIN2A_D3_4                                               (4U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_VIN4B_D3_5                                               (5U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_USB4_ULPI_CLK_6                                          (6U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_SPI3_D0_7                                                (7U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_SPI4_CS2_8                                               (8U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_PR1_MII0_RXD3_11                                         (11U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_PR2_PRU1_PRU_R315_12                                     (12U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_PR2_PRU1_PRU_R305_13                                     (13U)
#define CTRL_CORE_PAD_RGMII0_TXC_RGMII0_TXC_MUXMODE_GPIO5_20_14                                              (14U)

#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_RGMII0_TXC_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_RGMII0_TXCTL_0                                       (0U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_UART3_RTSN_1                                         (1U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_RMII1_RXD0_2                                         (2U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_MII0_RXD2_3                                          (3U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_VIN2A_D4_4                                           (4U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_VIN4B_D4_5                                           (5U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_USB4_ULPI_STP_6                                      (6U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_SPI3_CS0_7                                           (7U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_SPI4_CS3_8                                           (8U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_PR1_MII0_RXD2_11                                     (11U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_PR2_PRU1_PRU_R316_12                                 (12U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_PR2_PRU1_PRU_R306_13                                 (13U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RGMII0_TXCTL_MUXMODE_GPIO5_21_14                                          (14U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_RGMII0_TXCTL_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_RGMII0_TXD3_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_RMII0_CRS_1                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_MII0_CRS_3                                             (3U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_VIN2A_DE0_4                                            (4U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_VIN4B_DE1_5                                            (5U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_USB4_ULPI_DIR_6                                        (6U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_SPI4_SCLK_7                                            (7U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_UART4_RXD_8                                            (8U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_PR1_MII0_CRS_11                                        (11U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_PR2_PRU1_PRU_R317_12                                   (12U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_PR2_PRU1_PRU_R307_13                                   (13U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RGMII0_TXD3_MUXMODE_GPIO5_22_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_TXD3_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_RGMII0_TXD2_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_RMII0_RXER_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_MII0_RXER_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_VIN2A_HSYNC0_4                                         (4U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_VIN4B_HSYNC1_5                                         (5U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_USB4_ULPI_NXT_6                                        (6U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_SPI4_D1_7                                              (7U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_UART4_TXD_8                                            (8U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_PR1_MII0_RXER_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_PR2_PRU1_PRU_R318_12                                   (12U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_PR2_PRU1_PRU_R308_13                                   (13U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RGMII0_TXD2_MUXMODE_GPIO5_23_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_TXD2_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_RGMII0_TXD1_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_RMII0_RXD1_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_MII0_RXD1_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_VIN2A_VSYNC0_4                                         (4U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_VIN4B_VSYNC1_5                                         (5U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_USB4_ULPI_D0_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_SPI4_D0_7                                              (7U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_UART4_CTSN_8                                           (8U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_PR1_MII0_RXD1_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_PR2_PRU1_PRU_R319_12                                   (12U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_PR2_PRU1_PRU_R309_13                                   (13U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RGMII0_TXD1_MUXMODE_GPIO5_24_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_TXD1_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_RGMII0_TXD0_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_RMII0_RXD0_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_MII0_RXD0_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_VIN2A_D10_4                                            (4U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_USB4_ULPI_D1_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_SPI4_CS0_7                                             (7U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_UART4_RTSN_8                                           (8U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_PR1_MII0_RXD0_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_PR2_PRU1_PRU_R3110_12                                  (12U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_PR2_PRU1_PRU_R3010_13                                  (13U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RGMII0_TXD0_MUXMODE_GPIO5_25_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_TXD0_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_RGMII0_RXC_0                                             (0U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_RMII1_TXEN_2                                             (2U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_MII0_TXCLK_3                                             (3U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_VIN2A_D5_4                                               (4U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_VIN4B_D5_5                                               (5U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_USB4_ULPI_D2_6                                           (6U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_PR1_MII_MT0_CLK_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_PR2_PRU1_PRU_R3111_12                                    (12U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_PR2_PRU1_PRU_R3011_13                                    (13U)
#define CTRL_CORE_PAD_RGMII0_RXC_RGMII0_RXC_MUXMODE_GPIO5_26_14                                              (14U)

#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_RGMII0_RXC_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_RGMII0_RXCTL_0                                       (0U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_RMII1_TXD1_2                                         (2U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_MII0_TXD3_3                                          (3U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_VIN2A_D6_4                                           (4U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_VIN4B_D6_5                                           (5U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_USB4_ULPI_D3_6                                       (6U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_PR1_MII0_TXD3_11                                     (11U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_PR2_PRU1_PRU_R3112_12                                (12U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_PR2_PRU1_PRU_R3012_13                                (13U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RGMII0_RXCTL_MUXMODE_GPIO5_27_14                                          (14U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_RGMII0_RXCTL_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_RGMII0_RXD3_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_RMII1_TXD0_2                                           (2U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_MII0_TXD2_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_VIN2A_D7_4                                             (4U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_VIN4B_D7_5                                             (5U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_USB4_ULPI_D4_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_PR1_MII0_TXD2_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_PR2_PRU1_PRU_R3113_12                                  (12U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_PR2_PRU1_PRU_R3013_13                                  (13U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RGMII0_RXD3_MUXMODE_GPIO5_28_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_RXD3_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_RGMII0_RXD2_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_RMII0_TXEN_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_MII0_TXEN_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_VIN2A_D8_4                                             (4U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_USB4_ULPI_D5_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_PR1_MII0_TXEN_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_PR2_PRU1_PRU_R3114_12                                  (12U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_PR2_PRU1_PRU_R3014_13                                  (13U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RGMII0_RXD2_MUXMODE_GPIO5_29_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_RXD2_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_RGMII0_RXD1_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_RMII0_TXD1_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_MII0_TXD1_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_VIN2A_D9_4                                             (4U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_USB4_ULPI_D6_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_PR1_MII0_TXD1_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_PR2_PRU1_PRU_R3115_12                                  (12U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_PR2_PRU1_PRU_R3015_13                                  (13U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RGMII0_RXD1_MUXMODE_GPIO5_30_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_RXD1_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_RGMII0_RXD0_0                                          (0U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_RMII0_TXD0_1                                           (1U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_MII0_TXD0_3                                            (3U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_VIN2A_FLD0_4                                           (4U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_VIN4B_FLD1_5                                           (5U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_USB4_ULPI_D7_6                                         (6U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_PR1_MII0_TXD0_11                                       (11U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_PR2_PRU1_PRU_R3116_12                                  (12U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_PR2_PRU1_PRU_R3016_13                                  (13U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RGMII0_RXD0_MUXMODE_GPIO5_31_14                                            (14U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_RGMII0_RXD0_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_MUXMODE_USB1_DRVVBUS_0                                       (0U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_MUXMODE_TIMER16_7                                            (7U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_USB1_DRVVBUS_MUXMODE_GPIO6_12_14                                          (14U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_USB1_DRVVBUS_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_MUXMODE_USB2_DRVVBUS_0                                       (0U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_MUXMODE_TIMER15_7                                            (7U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_USB2_DRVVBUS_MUXMODE_GPIO6_13_14                                          (14U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_USB2_DRVVBUS_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_14_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPIO6_14_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPIO6_14_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPIO6_14_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_GPIO6_14_0                                                   (0U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_MCASP1_AXR8_1                                                (1U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_DCAN2_TX_2                                                   (2U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_UART10_RXD_3                                                 (3U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_VOUT2_HSYNC_6                                                (6U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_VIN4A_HSYNC0_8                                               (8U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_I2C3_SDA_9                                                   (9U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_TIMER1_10                                                    (10U)
#define CTRL_CORE_PAD_GPIO6_14_GPIO6_14_MUXMODE_GPIO6_14_14                                                  (14U)

#define CTRL_CORE_PAD_GPIO6_14_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPIO6_14_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPIO6_14_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPIO6_14_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPIO6_14_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPIO6_14_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_15_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPIO6_15_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPIO6_15_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPIO6_15_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_GPIO6_15_0                                                   (0U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_MCASP1_AXR9_1                                                (1U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_DCAN2_RX_2                                                   (2U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_UART10_TXD_3                                                 (3U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_VOUT2_VSYNC_6                                                (6U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_VIN4A_VSYNC0_8                                               (8U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_I2C3_SCL_9                                                   (9U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_TIMER2_10                                                    (10U)
#define CTRL_CORE_PAD_GPIO6_15_GPIO6_15_MUXMODE_GPIO6_15_14                                                  (14U)

#define CTRL_CORE_PAD_GPIO6_15_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPIO6_15_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPIO6_15_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPIO6_15_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPIO6_15_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPIO6_15_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPEVENT_SHIFT                                                   (25U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPEVENT_MASK                                                    (0x02000000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPEVENT_NOWAKEUP                                                 (0U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPEVENT_WAKEUP                                                   (1U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPENABLE_SHIFT                                                  (24U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPENABLE_MASK                                                   (0x01000000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_WAKEUPENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_SLEWCONTROL_SHIFT                                                   (19U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_SLEWCONTROL_MASK                                                    (0x00080000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_SLEWCONTROL_SLOW_SLEW                                                (0U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_SLEWCONTROL_FAST_SLEW                                                (1U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_INPUTENABLE_SHIFT                                                   (18U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_INPUTENABLE_MASK                                                    (0x00040000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_INPUTENABLE_ENABLE                                                   (1U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_INPUTENABLE_DISABLE                                                  (0U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLTYPESELECT_SHIFT                                                (17U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLTYPESELECT_MASK                                                 (0x00020000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLTYPESELECT_PULL_UP                                               (1U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLTYPESELECT_PULL_DOWN                                             (0U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLUDENABLE_SHIFT                                                  (16U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLUDENABLE_MASK                                                   (0x00010000U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLUDENABLE_ENABLE                                                  (1U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_PULLUDENABLE_DISABLE                                                 (0U)

#define CTRL_CORE_PAD_GPIO6_16_RESERVED_3_SHIFT                                                             (8U)
#define CTRL_CORE_PAD_GPIO6_16_RESERVED_3_MASK                                                              (0x00000100U)

#define CTRL_CORE_PAD_GPIO6_16_RESERVED_4_SHIFT                                                             (4U)
#define CTRL_CORE_PAD_GPIO6_16_RESERVED_4_MASK                                                              (0x000000f0U)

#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_SHIFT                                                       (0U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_MASK                                                        (0x0000000fU)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_GPIO6_16_0                                                   (0U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_MCASP1_AXR10_1                                               (1U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_VOUT2_FLD_6                                                  (6U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_VIN4A_FLD0_8                                                 (8U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_CLKOUT1_9                                                    (9U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_TIMER3_10                                                    (10U)
#define CTRL_CORE_PAD_GPIO6_16_GPIO6_16_MUXMODE_GPIO6_16_14                                                  (14U)

#define CTRL_CORE_PAD_GPIO6_16_RESERVED_0_SHIFT                                                             (9U)
#define CTRL_CORE_PAD_GPIO6_16_RESERVED_0_MASK                                                              (0x0000fe00U)

#define CTRL_CORE_PAD_GPIO6_16_RESERVED_1_SHIFT                                                             (20U)
#define CTRL_CORE_PAD_GPIO6_16_RESERVED_1_MASK                                                              (0x00f00000U)

#define CTRL_CORE_PAD_GPIO6_16_RESERVED_2_SHIFT                                                             (26U)
#define CTRL_CORE_PAD_GPIO6_16_RESERVED_2_MASK                                                              (0xfc000000U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_XREF_CLK0_0                                                (0U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_MCASP2_AXR8_1                                              (1U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_MCASP1_AXR4_2                                              (2U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_MCASP1_AHCLKX_3                                            (3U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_MCASP5_AHCLKX_4                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_ATL_CLK0_5                                                 (5U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_VIN6A_D0_7                                                 (7U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_HDQ0_8                                                     (8U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_CLKOUT2_9                                                  (9U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_TIMER13_10                                                 (10U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_PR2_MII1_COL_11                                            (11U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_PR2_PRU1_PRU_R315_12                                       (12U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_PR2_PRU1_PRU_R305_13                                       (13U)
#define CTRL_CORE_PAD_XREF_CLK0_XREF_CLK0_MUXMODE_GPIO6_17_14                                                (14U)

#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_XREF_CLK0_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_XREF_CLK1_0                                                (0U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_MCASP2_AXR9_1                                              (1U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_MCASP1_AXR5_2                                              (2U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_MCASP2_AHCLKX_3                                            (3U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_MCASP6_AHCLKX_4                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_ATL_CLK1_5                                                 (5U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_VIN6A_CLK0_7                                               (7U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_TIMER14_10                                                 (10U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_PR2_MII1_CRS_11                                            (11U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_PR2_PRU1_PRU_R316_12                                       (12U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_PR2_PRU1_PRU_R306_13                                       (13U)
#define CTRL_CORE_PAD_XREF_CLK1_XREF_CLK1_MUXMODE_GPIO6_18_14                                                (14U)

#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_XREF_CLK1_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_XREF_CLK2_0                                                (0U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_MCASP2_AXR10_1                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_MCASP1_AXR6_2                                              (2U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_MCASP3_AHCLKX_3                                            (3U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_MCASP7_AHCLKX_4                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_ATL_CLK2_5                                                 (5U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_VOUT2_CLK_6                                                (6U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_VIN4A_CLK0_8                                               (8U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_TIMER15_10                                                 (10U)
#define CTRL_CORE_PAD_XREF_CLK2_XREF_CLK2_MUXMODE_GPIO6_19_14                                                (14U)

#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_XREF_CLK2_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPEVENT_SHIFT                                                 (25U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPEVENT_MASK                                                  (0x02000000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPEVENT_NOWAKEUP                                               (0U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPEVENT_WAKEUP                                                 (1U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPENABLE_SHIFT                                                (24U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPENABLE_MASK                                                 (0x01000000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_WAKEUPENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_SLEWCONTROL_SHIFT                                                 (19U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_SLEWCONTROL_MASK                                                  (0x00080000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_SLEWCONTROL_SLOW_SLEW                                              (0U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_SLEWCONTROL_FAST_SLEW                                              (1U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_INPUTENABLE_SHIFT                                                 (18U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_INPUTENABLE_MASK                                                  (0x00040000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_INPUTENABLE_ENABLE                                                 (1U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_INPUTENABLE_DISABLE                                                (0U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLTYPESELECT_SHIFT                                              (17U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLTYPESELECT_MASK                                               (0x00020000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLTYPESELECT_PULL_UP                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLTYPESELECT_PULL_DOWN                                           (0U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLUDENABLE_SHIFT                                                (16U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLUDENABLE_MASK                                                 (0x00010000U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLUDENABLE_ENABLE                                                (1U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_PULLUDENABLE_DISABLE                                               (0U)

#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_3_SHIFT                                                            (8U)
#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_3_MASK                                                             (0x00000100U)

#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_4_SHIFT                                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_4_MASK                                                             (0x000000f0U)

#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_SHIFT                                                     (0U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_MASK                                                      (0x0000000fU)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_XREF_CLK3_0                                                (0U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_MCASP2_AXR11_1                                             (1U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_MCASP1_AXR7_2                                              (2U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_MCASP4_AHCLKX_3                                            (3U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_MCASP8_AHCLKX_4                                            (4U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_ATL_CLK3_5                                                 (5U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_VOUT2_DE_6                                                 (6U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_HDQ0_7                                                     (7U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_VIN4A_DE0_8                                                (8U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_CLKOUT3_9                                                  (9U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_TIMER16_10                                                 (10U)
#define CTRL_CORE_PAD_XREF_CLK3_XREF_CLK3_MUXMODE_GPIO6_20_14                                                (14U)

#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_0_SHIFT                                                            (9U)
#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_0_MASK                                                             (0x0000fe00U)

#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_1_SHIFT                                                            (20U)
#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_1_MASK                                                             (0x00f00000U)

#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_2_SHIFT                                                            (26U)
#define CTRL_CORE_PAD_XREF_CLK3_RESERVED_2_MASK                                                             (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_MCASP1_ACLKX_0                                       (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_VIN6A_FLD0_7                                         (7U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_I2C3_SDA_10                                          (10U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_PR2_MDIO_MDCLK_11                                    (11U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_PR2_PRU1_PRU_R317_12                                 (12U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_PR2_PRU1_PRU_R307_13                                 (13U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_MCASP1_ACLKX_MUXMODE_GPIO7_31_14                                          (14U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_MCASP1_ACLKX_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_MCASP1_FSX_0                                             (0U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_VIN6A_DE0_7                                              (7U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_I2C3_SCL_10                                              (10U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_PR2_MDIO_DATA_11                                         (11U)
#define CTRL_CORE_PAD_MCASP1_FSX_MCASP1_FSX_MUXMODE_GPIO7_30_14                                              (14U)

#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_MCASP1_FSX_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_MCASP1_ACLKR_0                                       (0U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_MCASP7_AXR2_1                                        (1U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_VOUT2_D0_6                                           (6U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_VIN4A_D0_8                                           (8U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_I2C4_SDA_10                                          (10U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_MCASP1_ACLKR_MUXMODE_GPIO5_0_14                                           (14U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_MCASP1_ACLKR_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPEVENT_SHIFT                                               (25U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPEVENT_MASK                                                (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPEVENT_NOWAKEUP                                             (0U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPEVENT_WAKEUP                                               (1U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPENABLE_SHIFT                                              (24U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPENABLE_MASK                                               (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_WAKEUPENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_SLEWCONTROL_SHIFT                                               (19U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_SLEWCONTROL_MASK                                                (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_SLEWCONTROL_SLOW_SLEW                                            (0U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_SLEWCONTROL_FAST_SLEW                                            (1U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_INPUTENABLE_SHIFT                                               (18U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_INPUTENABLE_MASK                                                (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_INPUTENABLE_ENABLE                                               (1U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_INPUTENABLE_DISABLE                                              (0U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLTYPESELECT_SHIFT                                            (17U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLTYPESELECT_MASK                                             (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLTYPESELECT_PULL_UP                                           (1U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLTYPESELECT_PULL_DOWN                                         (0U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLUDENABLE_SHIFT                                              (16U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLUDENABLE_MASK                                               (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLUDENABLE_ENABLE                                              (1U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_PULLUDENABLE_DISABLE                                             (0U)

#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_3_SHIFT                                                           (8U)
#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_3_MASK                                                            (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_4_SHIFT                                                           (4U)
#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_4_MASK                                                            (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_SHIFT                                                   (0U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_MASK                                                    (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_MCASP1_FSR_0                                             (0U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_MCASP7_AXR3_1                                            (1U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_VOUT2_D1_6                                               (6U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_VIN4A_D1_8                                               (8U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_I2C4_SCL_10                                              (10U)
#define CTRL_CORE_PAD_MCASP1_FSR_MCASP1_FSR_MUXMODE_GPIO5_1_14                                               (14U)

#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_0_SHIFT                                                           (9U)
#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_0_MASK                                                            (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_1_SHIFT                                                           (20U)
#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_1_MASK                                                            (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_2_SHIFT                                                           (26U)
#define CTRL_CORE_PAD_MCASP1_FSR_RESERVED_2_MASK                                                            (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_MCASP1_AXR0_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_UART6_RXD_3                                            (3U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_VIN6A_VSYNC0_7                                         (7U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_I2C5_SDA_10                                            (10U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_PR2_MII0_RXER_11                                       (11U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_PR2_PRU1_PRU_R318_12                                   (12U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_PR2_PRU1_PRU_R308_13                                   (13U)
#define CTRL_CORE_PAD_MCASP1_AXR0_MCASP1_AXR0_MUXMODE_GPIO5_2_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR0_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_MCASP1_AXR1_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_UART6_TXD_3                                            (3U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_VIN6A_HSYNC0_7                                         (7U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_I2C5_SCL_10                                            (10U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_PR2_MII_MT0_CLK_11                                     (11U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_PR2_PRU1_PRU_R319_12                                   (12U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_PR2_PRU1_PRU_R309_13                                   (13U)
#define CTRL_CORE_PAD_MCASP1_AXR1_MCASP1_AXR1_MUXMODE_GPIO5_3_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR1_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_MCASP1_AXR2_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_MCASP6_AXR2_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_UART6_CTSN_3                                           (3U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_VOUT2_D2_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_VIN4A_D2_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR2_MCASP1_AXR2_MUXMODE_GPIO5_4_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR2_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_MCASP1_AXR3_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_MCASP6_AXR3_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_UART6_RTSN_3                                           (3U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_VOUT2_D3_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_VIN4A_D3_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR3_MCASP1_AXR3_MUXMODE_GPIO5_5_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR3_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_MCASP1_AXR4_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_MCASP4_AXR2_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_VOUT2_D4_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_VIN4A_D4_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR4_MCASP1_AXR4_MUXMODE_GPIO5_6_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR4_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_MCASP1_AXR5_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_MCASP4_AXR3_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_VOUT2_D5_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_VIN4A_D5_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR5_MCASP1_AXR5_MUXMODE_GPIO5_7_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR5_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_MCASP1_AXR6_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_MCASP5_AXR2_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_VOUT2_D6_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_VIN4A_D6_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR6_MCASP1_AXR6_MUXMODE_GPIO5_8_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR6_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_MCASP1_AXR7_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_MCASP5_AXR3_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_VOUT2_D7_6                                             (6U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_VIN4A_D7_8                                             (8U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_TIMER4_10                                              (10U)
#define CTRL_CORE_PAD_MCASP1_AXR7_MCASP1_AXR7_MUXMODE_GPIO5_9_14                                             (14U)

#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR7_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_MCASP1_AXR8_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_MCASP6_AXR0_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_SPI3_SCLK_3                                            (3U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_VIN6A_D15_7                                            (7U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_TIMER5_10                                              (10U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_PR2_MII0_TXEN_11                                       (11U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_PR2_PRU1_PRU_R3110_12                                  (12U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_PR2_PRU1_PRU_R3010_13                                  (13U)
#define CTRL_CORE_PAD_MCASP1_AXR8_MCASP1_AXR8_MUXMODE_GPIO5_10_14                                            (14U)

#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR8_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPEVENT_SHIFT                                             (25U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPEVENT_MASK                                              (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPEVENT_NOWAKEUP                                           (0U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPEVENT_WAKEUP                                             (1U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPENABLE_SHIFT                                            (24U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPENABLE_MASK                                             (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_WAKEUPENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_SLEWCONTROL_SHIFT                                             (19U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_SLEWCONTROL_MASK                                              (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_SLEWCONTROL_SLOW_SLEW                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_SLEWCONTROL_FAST_SLEW                                          (1U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_INPUTENABLE_SHIFT                                             (18U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_INPUTENABLE_MASK                                              (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_INPUTENABLE_ENABLE                                             (1U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_INPUTENABLE_DISABLE                                            (0U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLTYPESELECT_SHIFT                                          (17U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLTYPESELECT_MASK                                           (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLTYPESELECT_PULL_UP                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLTYPESELECT_PULL_DOWN                                       (0U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLUDENABLE_SHIFT                                            (16U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLUDENABLE_MASK                                             (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLUDENABLE_ENABLE                                            (1U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_PULLUDENABLE_DISABLE                                           (0U)

#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_3_SHIFT                                                          (8U)
#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_3_MASK                                                           (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_4_SHIFT                                                          (4U)
#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_4_MASK                                                           (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_SHIFT                                                 (0U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_MASK                                                  (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_MCASP1_AXR9_0                                          (0U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_MCASP6_AXR1_1                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_SPI3_D1_3                                              (3U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_VIN6A_D14_7                                            (7U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_TIMER6_10                                              (10U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_PR2_MII0_TXD3_11                                       (11U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_PR2_PRU1_PRU_R3111_12                                  (12U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_PR2_PRU1_PRU_R3011_13                                  (13U)
#define CTRL_CORE_PAD_MCASP1_AXR9_MCASP1_AXR9_MUXMODE_GPIO5_11_14                                            (14U)

#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_0_SHIFT                                                          (9U)
#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_0_MASK                                                           (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_1_SHIFT                                                          (20U)
#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_1_MASK                                                           (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_2_SHIFT                                                          (26U)
#define CTRL_CORE_PAD_MCASP1_AXR9_RESERVED_2_MASK                                                           (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_MCASP1_AXR10_0                                       (0U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_MCASP6_ACLKX_1                                       (1U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_MCASP6_ACLKR_2                                       (2U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_SPI3_D0_3                                            (3U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_VIN6A_D13_7                                          (7U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_TIMER7_10                                            (10U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_PR2_MII0_TXD2_11                                     (11U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_PR2_PRU1_PRU_R3112_12                                (12U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_PR2_PRU1_PRU_R3012_13                                (13U)
#define CTRL_CORE_PAD_MCASP1_AXR10_MCASP1_AXR10_MUXMODE_GPIO5_12_14                                          (14U)

#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_MCASP1_AXR10_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_MCASP1_AXR11_0                                       (0U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_MCASP6_FSX_1                                         (1U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_MCASP6_FSR_2                                         (2U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_SPI3_CS0_3                                           (3U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_VIN6A_D12_7                                          (7U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_TIMER8_10                                            (10U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_PR2_MII0_TXD1_11                                     (11U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_PR2_PRU1_PRU_R3113_12                                (12U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_PR2_PRU1_PRU_R3013_13                                (13U)
#define CTRL_CORE_PAD_MCASP1_AXR11_MCASP1_AXR11_MUXMODE_GPIO4_17_14                                          (14U)

#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_1_SHIFT                                                         (20U)
#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_1_MASK                                                          (0x00f00000U)

#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_2_SHIFT                                                         (26U)
#define CTRL_CORE_PAD_MCASP1_AXR11_RESERVED_2_MASK                                                          (0xfc000000U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPEVENT_SHIFT                                           (25U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPEVENT_MASK                                            (0x02000000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPEVENT_NOWAKEUP                                         (0U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPEVENT_WAKEUP                                           (1U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPENABLE_SHIFT                                          (24U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPENABLE_MASK                                           (0x01000000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_WAKEUPENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_SLEWCONTROL_SHIFT                                           (19U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_SLEWCONTROL_MASK                                            (0x00080000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_SLEWCONTROL_SLOW_SLEW                                        (0U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_SLEWCONTROL_FAST_SLEW                                        (1U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_INPUTENABLE_SHIFT                                           (18U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_INPUTENABLE_MASK                                            (0x00040000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_INPUTENABLE_ENABLE                                           (1U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_INPUTENABLE_DISABLE                                          (0U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLTYPESELECT_SHIFT                                        (17U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLTYPESELECT_MASK                                         (0x00020000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLTYPESELECT_PULL_UP                                       (1U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLTYPESELECT_PULL_DOWN                                     (0U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLUDENABLE_SHIFT                                          (16U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLUDENABLE_MASK                                           (0x00010000U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLUDENABLE_ENABLE                                          (1U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_PULLUDENABLE_DISABLE                                         (0U)

#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_3_SHIFT                                                         (8U)
#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_3_MASK                                                          (0x00000100U)

#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_4_SHIFT                                                         (4U)
#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_4_MASK                                                          (0x000000f0U)

#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_SHIFT                                               (0U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_MASK                                                (0x0000000fU)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_MCASP1_AXR12_0                                       (0U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_MCASP7_AXR0_1                                        (1U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_SPI3_CS1_3                                           (3U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_VIN6A_D11_7                                          (7U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_TIMER9_10                                            (10U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_PR2_MII0_TXD0_11                                     (11U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_PR2_PRU1_PRU_R3114_12                                (12U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_PR2_PRU1_PRU_R3014_13                                (13U)
#define CTRL_CORE_PAD_MCASP1_AXR12_MCASP1_AXR12_MUXMODE_GPIO4_18_14                                          (14U)

#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_0_SHIFT                                                         (9U)
#define CTRL_CORE_PAD_MCASP1_AXR12_RESERVED_0_MASK                                                          (0x0000fe00U)

#define CTRL_CORE_PAD_MCASP1_AXR12_RESERV