/**
 * Note: This file was auto-generated by TI PinMux on 5/1/2017 at 5:27:09 PM.
 *
 * \file  66AK2G0x_pinmux_data.c
 *
 * \brief  This file contains the pin mux configurations for the boards.
 *         These are prepared based on how the peripherals are extended on
 *         the boards.
 *
 * \copyright Copyright (CU) 2017 Texas Instruments Incorporated -
 *             http://www.ti.com/
 */

/**
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
/* #include "csl_types.h" */
#include "types.h"
#include "pinmux.h"
#include "66AK2G0x_pinmux.h"

/** Peripheral Pin Configurations */

#ifndef BUILDCFG_MOD_CPTS
#define BUILDCFG_MOD_CPTS
#endif /* BUILDCFG_MOD_CPTS */

#ifndef BUILDCFG_MOD_PWMSS
#define BUILDCFG_MOD_PWMSS
#endif /* BUILDCFG_MOD_PWMSS */

#ifndef BUILDCFG_MOD_MCASP
#define BUILDCFG_MOD_MCASP
#endif /* BUILDCFG_MOD_MCASP */

#ifndef BUILDCFG_MOD_DSS
#define BUILDCFG_MOD_DSS
#endif /* BUILDCFG_MOD_DSS */

#ifndef BUILDCFG_MOD_TIMER
#define BUILDCFG_MOD_TIMER
#endif /* BUILDCFG_MOD_TIMER */

#ifndef BUILDCFG_MOD_DCAN
#define BUILDCFG_MOD_DCAN
#endif /* BUILDCFG_MOD_DCAN */

#ifndef BUILDCFG_MOD_GPIO
#define BUILDCFG_MOD_GPIO
#endif /* BUILDCFG_MOD_GPIO */

#ifndef BUILDCFG_MOD_MCBSP
#define BUILDCFG_MOD_MCBSP
#endif /* BUILDCFG_MOD_MCBSP */

#ifndef BUILDCFG_MOD_UART
#define BUILDCFG_MOD_UART
#endif /* BUILDCFG_MOD_UART */

#ifndef BUILDCFG_MOD_PCIE
#define BUILDCFG_MOD_PCIE
#endif /* BUILDCFG_MOD_PCIE */

#ifndef BUILDCFG_MOD_MMCSD
#define BUILDCFG_MOD_MMCSD
#endif /* BUILDCFG_MOD_MMCSD */

#ifndef BUILDCFG_MOD_DEBUGSS
#define BUILDCFG_MOD_DEBUGSS
#endif /* BUILDCFG_MOD_DEBUGSS */

#ifndef BUILDCFG_MOD_GPMC
#define BUILDCFG_MOD_GPMC
#endif /* BUILDCFG_MOD_GPMC */

#ifndef BUILDCFG_MOD_EMAC
#define BUILDCFG_MOD_EMAC
#endif /* BUILDCFG_MOD_EMAC */

#ifndef BUILDCFG_MOD_CPSW
#define BUILDCFG_MOD_CPSW
#endif /* BUILDCFG_MOD_CPSW */

#ifndef BUILDCFG_MOD_DDR
#define BUILDCFG_MOD_DDR
#endif /* BUILDCFG_MOD_DDR */

#ifndef BUILDCFG_MOD_MCSPI
#define BUILDCFG_MOD_MCSPI
#endif /* BUILDCFG_MOD_MCSPI */

#ifndef BUILDCFG_MOD_USB
#define BUILDCFG_MOD_USB
#endif /* BUILDCFG_MOD_USB */

#ifndef BUILDCFG_MOD_SYSTEM
#define BUILDCFG_MOD_SYSTEM
#endif /* BUILDCFG_MOD_SYSTEM */

#ifndef BUILDCFG_MOD_I2C
#define BUILDCFG_MOD_I2C
#endif /* BUILDCFG_MOD_I2C */

#ifndef BUILDCFG_MOD_QSPI
#define BUILDCFG_MOD_QSPI
#endif /* BUILDCFG_MOD_QSPI */

#ifndef BUILDCFG_MOD_MLB
#define BUILDCFG_MOD_MLB
#endif /* BUILDCFG_MOD_MLB */


#if defined(BUILDCFG_MOD_CPTS)

static pinmuxPerCfg_t gCpts0PinCfg[] =
{
    {
       /* CPTS -> CPTS_TS_COMP -> C21 */
       PIN_UART2_RTSN, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gCptsPinCfg[] =
{
    {0, TRUE, gCpts0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_CPTS) */

#if defined(BUILDCFG_MOD_PWMSS)

static pinmuxPerCfg_t gPwmss3PinCfg[] =
{
    {
       /* eHRPWM3 -> eHRPWM3_A -> A23 */
       PIN_EHRPWM3_A, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM3 -> eHRPWM3_B -> B22 */
       PIN_EHRPWM3_B, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM3 -> eHRPWM3_SYNCI -> C22 */
       PIN_EHRPWM3_SYNCI, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM3 -> eHRPWM3_SYNCO -> D23 */
       PIN_EHRPWM3_SYNCO, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM3 -> eHRPWM_TZn3 -> H24 */
       PIN_MII_TXER, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gPwmss4PinCfg[] =
{
    {
       /* eHRPWM4 -> eHRPWM4_A -> D12 */
       PIN_PR1_PRU0_GPO18, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM4 -> eHRPWM4_B -> D13 */
       PIN_PR1_PRU0_GPO19, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gPwmss5PinCfg[] =
{
    {
       /* eHRPWM5 -> eHRPWM5_A -> E17 */
       PIN_PR1_PRU1_GPO18, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* eHRPWM5 -> eHRPWM5_B -> E16 */
       PIN_PR1_PRU1_GPO19, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gPwmss0PinCfg[] =
{
    {
       /* eCAP0 -> eCAP0_IN_APWM0_OUT -> E18 */
       PIN_PR1_MDIO_DATA, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gPwmss1PinCfg[] =
{
    {
       /* eCAP1 -> eCAP1_IN_APWM1_OUT -> D18 */
       PIN_PR1_MDIO_MDCLK, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPwmssPinCfg[] =
{
    {3, TRUE, gPwmss3PinCfg},
    {4, TRUE, gPwmss4PinCfg},
    {5, TRUE, gPwmss5PinCfg},
    {0, TRUE, gPwmss0PinCfg},
    {1, TRUE, gPwmss1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PWMSS) */

#if defined(BUILDCFG_MOD_MCASP)

static pinmuxPerCfg_t gMcasp0PinCfg[] =
{
    {
       /* McASP0 -> MCASP0_AHCLKX -> C9 */
       PIN_PR0_PRU1_GPO16, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_ACLKX -> D9 */
       PIN_PR0_PRU1_GPO14, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AFSX -> C8 */
       PIN_PR0_PRU1_GPO15, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AHCLKR -> B8 */
       PIN_PR0_PRU1_GPO13, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_ACLKR -> E9 */
       PIN_PR0_PRU1_GPO11, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AFSR -> A8 */
       PIN_PR0_PRU1_GPO12, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR0 -> B9 */
       PIN_PR0_PRU1_GPO17, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR1 -> A9 */
       PIN_PR0_PRU1_GPO18, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR2 -> B10 */
       PIN_PR0_PRU1_GPO19, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR3 -> A10 */
       PIN_PR0_MDIO_DATA, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR4 -> C10 */
       PIN_PR0_MDIO_MDCLK, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR5 -> E10 */
       PIN_PR1_PRU0_GPO0, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR6 -> D10 */
       PIN_PR1_PRU0_GPO1, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR7 -> F10 */
       PIN_PR1_PRU0_GPO2, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR12 -> E12 */
       PIN_PR1_PRU0_GPO7, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR13 -> C12 */
       PIN_PR1_PRU0_GPO8, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR14 -> B11 */
       PIN_PR1_PRU0_GPO9, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AXR15 -> B12 */
       PIN_PR1_PRU0_GPO10, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP0 -> MCASP0_AMUTE -> C7 */
       PIN_PR0_PRU1_GPO10, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcasp1PinCfg[] =
{
    {
       /* McASP1 -> MCASP1_AHCLKR -> E7 */
       PIN_PR0_PRU0_GPO15, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_ACLKR -> B4 */
       PIN_PR0_PRU0_GPO13, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_AFSR -> A4 */
       PIN_PR0_PRU0_GPO14, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_AXR0 -> B5 */
       PIN_PR0_PRU1_GPO0, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_AXR1 -> B6 */
       PIN_PR0_PRU1_GPO1, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_AXR2 -> D7 */
       PIN_PR0_PRU1_GPO2, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McASP1 -> MCASP1_AXR3 -> A6 */
       PIN_PR0_PRU1_GPO3, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcasp2PinCfg[] =
{
    {
       /* HDMI_COM8_CODEC -> MCASP2_AHCLKX -> D5 */
       PIN_PR0_PRU0_GPO11, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_ACLKX -> B3 */
       PIN_PR0_PRU0_GPO12, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AFSX -> C3 */
       PIN_PR0_PRU0_GPO10, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AHCLKR -> E6 */
       PIN_PR0_PRU0_GPO8, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_ACLKR -> B2 */
       PIN_PR0_PRU0_GPO6, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AFSR -> D4 */
       PIN_PR0_PRU0_GPO7, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AXR1 -> A2 */
       PIN_PR0_PRU0_GPO1, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AXR2 -> E4 */
       PIN_PR0_PRU0_GPO2, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AXR3 -> B1 */
       PIN_PR0_PRU0_GPO3, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AXR4 -> A3 */
       PIN_PR0_PRU0_GPO4, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AXR5 -> E5 */
       PIN_PR0_PRU0_GPO5, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* HDMI_COM8_CODEC -> MCASP2_AMUTE -> C2 */
       PIN_PR0_PRU0_GPO9, 0, \
       ( \
           PIN_MODE(4) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMcaspPinCfg[] =
{
    {0, TRUE, gMcasp0PinCfg},
    {1, TRUE, gMcasp1PinCfg},
    {2, TRUE, gMcasp2PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MCASP) */

#if defined(BUILDCFG_MOD_DSS)

static pinmuxPerCfg_t gDss0PinCfg[] =
{
    {
       /* LCD -> DSS_VSYNC -> R25 */
       PIN_DSS_VSYNC, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_HSYNC -> P22 */
       PIN_DSS_HSYNC, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_PCLK -> N25 */
       PIN_DSS_PCLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DE -> M25 */
       PIN_DSS_DE, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_FID -> L25 */
       PIN_DSS_FID, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA0 -> V22 */
       PIN_DSS_DATA0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA1 -> U21 */
       PIN_DSS_DATA1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA2 -> W22 */
       PIN_DSS_DATA2, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA3 -> V23 */
       PIN_DSS_DATA3, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA4 -> U23 */
       PIN_DSS_DATA4, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA5 -> V24 */
       PIN_DSS_DATA5, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA6 -> T21 */
       PIN_DSS_DATA6, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA7 -> U22 */
       PIN_DSS_DATA7, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA8 -> T22 */
       PIN_DSS_DATA8, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA9 -> R21 */
       PIN_DSS_DATA9, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA10 -> U24 */
       PIN_DSS_DATA10, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA11 -> V25 */
       PIN_DSS_DATA11, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA12 -> T24 */
       PIN_DSS_DATA12, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA13 -> P21 */
       PIN_DSS_DATA13, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA14 -> U25 */
       PIN_DSS_DATA14, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA15 -> R22 */
       PIN_DSS_DATA15, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA16 -> P23 */
       PIN_DSS_DATA16, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA17 -> R24 */
       PIN_DSS_DATA17, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA18 -> N22 */
       PIN_DSS_DATA18, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA19 -> T25 */
       PIN_DSS_DATA19, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA20 -> N24 */
       PIN_DSS_DATA20, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA21 -> P24 */
       PIN_DSS_DATA21, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA22 -> P25 */
       PIN_DSS_DATA22, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* LCD -> DSS_DATA23 -> N23 */
       PIN_DSS_DATA23, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDssPinCfg[] =
{
    {0, TRUE, gDss0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DSS) */

#if defined(BUILDCFG_MOD_TIMER)

static pinmuxPerCfg_t gTimer1PinCfg[] =
{
    {
       /* TIMER1 -> TIMI1 -> W23 */
       PIN_GPMC_CSN2, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* TIMER1 -> TIMO1 -> Y25 */
       PIN_GPMC_CSN3, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gTimerPinCfg[] =
{
    {1, TRUE, gTimer1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_TIMER) */

#if defined(BUILDCFG_MOD_DCAN)

static pinmuxPerCfg_t gDcan0PinCfg[] =
{
    {
       /* DCAN0 -> DCAN0_RX -> R5 */
       PIN_DCAN0_RX, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* DCAN0 -> DCAN0_TX -> P5 */
       PIN_DCAN0_TX, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gDcan1PinCfg[] =
{
    {
       /* DCAN1 -> DCAN1_RX -> H21 */
       PIN_QSPI_CSN3, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* DCAN1 -> DCAN1_TX -> H22 */
       PIN_QSPI_CSN2, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDcanPinCfg[] =
{
    {0, TRUE, gDcan0PinCfg},
    {1, TRUE, gDcan1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DCAN) */

#if defined(BUILDCFG_MOD_GPIO)

static pinmuxPerCfg_t gGpio0PinCfg[] =
{
    {
       /* GPIO0 -> GPIO0_16 -> AB23 */
       PIN_GPMC_CLK, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_21 -> AB24 */
       PIN_GPMC_BEN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_69 -> J3 */
       PIN_MMC1_SDCD, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_70 -> K3 */
       PIN_MMC1_SDWP, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_82 -> F23 */
       PIN_MII_RXER, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_83 -> B25 */
       PIN_MII_COL, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_84 -> G22 */
       PIN_MII_CRS, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_87 -> E25 */
       PIN_SPI3_SCSN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_100 -> N3 */
       PIN_SPI1_SCSN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_102 -> P4 */
       PIN_SPI2_SCSN1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_108 -> D3 */
       PIN_PR0_PRU0_GPO0, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_124 -> D6 */
       PIN_PR0_PRU0_GPO16, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_125 -> C4 */
       PIN_PR0_PRU0_GPO17, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_126 -> C5 */
       PIN_PR0_PRU0_GPO18, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_132 -> C6 */
       PIN_PR0_PRU1_GPO4, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_133 -> E8 */
       PIN_PR0_PRU1_GPO5, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_134 -> A7 */
       PIN_PR0_PRU1_GPO6, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_135 -> D8 */
       PIN_PR0_PRU1_GPO7, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_136 -> F9 */
       PIN_PR0_PRU1_GPO8, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO0 -> GPIO0_137 -> B7 */
       PIN_PR0_PRU1_GPO9, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gGpio1PinCfg[] =
{
    {
       /* GPIO1 -> GPIO1_10 -> D11 */
       PIN_PR1_PRU0_GPO4, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_11 -> E11 */
       PIN_PR1_PRU0_GPO5, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_26 -> A14 */
       PIN_PR1_PRU1_GPO0, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_27 -> B14 */
       PIN_PR1_PRU1_GPO1, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_28 -> C14 */
       PIN_PR1_PRU1_GPO2, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_29 -> E14 */
       PIN_PR1_PRU1_GPO3, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_30 -> D14 */
       PIN_PR1_PRU1_GPO4, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_31 -> A15 */
       PIN_PR1_PRU1_GPO5, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_32 -> F14 */
       PIN_PR1_PRU1_GPO6, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_33 -> B15 */
       PIN_PR1_PRU1_GPO7, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_34 -> C15 */
       PIN_PR1_PRU1_GPO8, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_41 -> C18 */
       PIN_PR1_PRU1_GPO15, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_42 -> D16 */
       PIN_PR1_PRU1_GPO16, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_54 -> D22 */
       PIN_UART2_CTSN, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* GPIO1 -> GPIO1_09 -> C11 */
       PIN_PR1_PRU0_GPO3, 0, \
       ( \
           PIN_MODE(3) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gGpioPinCfg[] =
{
    {0, TRUE, gGpio0PinCfg},
    {1, TRUE, gGpio1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_GPIO) */

#if defined(BUILDCFG_MOD_MCBSP)

static pinmuxPerCfg_t gMcbsp0PinCfg[] =
{
    {
       /* McBSP -> MCBSP_CLKR -> D17 */
       PIN_PR1_PRU1_GPO14, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McBSP -> MCBSP_CLKX -> B16 */
       PIN_PR1_PRU1_GPO12, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McBSP -> MCBSP_DR -> D15 */
       PIN_PR1_PRU1_GPO9, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McBSP -> MCBSP_DX -> A16 */
       PIN_PR1_PRU1_GPO10, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McBSP -> MCBSP_FSR -> C16 */
       PIN_PR1_PRU1_GPO13, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* McBSP -> MCBSP_FSX -> E15 */
       PIN_PR1_PRU1_GPO11, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMcbspPinCfg[] =
{
    {0, TRUE, gMcbsp0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MCBSP) */

#if defined(BUILDCFG_MOD_UART)

static pinmuxPerCfg_t gUart0PinCfg[] =
{
    {
       /* UART0_SYSTEM -> UART0_RXD -> T4 */
       PIN_UART0_RXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART0_SYSTEM -> UART0_TXD -> T1 */
       PIN_UART0_TXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART0_SYSTEM -> UART0_CTSn -> T2 */
       PIN_UART0_CTSN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART0_SYSTEM -> UART0_RTSn -> U1 */
       PIN_UART0_RTSN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUart1PinCfg[] =
{
    {
       /* UART1_COM8 -> UART1_RXD -> T3 */
       PIN_UART1_RXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART1_COM8 -> UART1_TXD -> T5 */
       PIN_UART1_TXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART1_COM8 -> UART1_CTSn -> U2 */
       PIN_UART1_CTSN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART1_COM8 -> UART1_RTSn -> U4 */
       PIN_UART1_RTSN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUart2PinCfg[] =
{
    {
       /* UART2_BMC -> UART2_RXD -> E21 */
       PIN_UART2_RXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* UART2_BMC -> UART2_TXD -> D21 */
       PIN_UART2_TXD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gUartPinCfg[] =
{
    {0, TRUE, gUart0PinCfg},
    {1, TRUE, gUart1PinCfg},
    {2, TRUE, gUart2PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_UART) */

#if defined(BUILDCFG_MOD_PCIE)

static pinmuxPerCfg_t gPcie0PinCfg[] =
{
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gPciePinCfg[] =
{
    {0, TRUE, gPcie0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_PCIE) */

#if defined(BUILDCFG_MOD_MMCSD)

static pinmuxPerCfg_t gMmcsd0PinCfg[] =
{
    {
       /* MMC0_uSD -> MMC0_CLK -> F13 */
       PIN_PR1_PRU0_GPO15, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_CMD -> C13 */
       PIN_PR1_PRU0_GPO16, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_DAT0 -> B13 */
       PIN_PR1_PRU0_GPO14, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_DAT1 -> A13 */
       PIN_PR1_PRU0_GPO13, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_DAT2 -> A11 */
       PIN_PR1_PRU0_GPO12, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_DAT3 -> A12 */
       PIN_PR1_PRU0_GPO11, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC0_uSD -> MMC0_SDCD -> F12 */
       PIN_PR1_PRU0_GPO6, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMmcsd1PinCfg[] =
{
    {
       /* MMC1_eMMC -> MMC1_CLK -> J4 */
       PIN_MMC1_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_CMD -> J2 */
       PIN_MMC1_CMD, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT0 -> H3 */
       PIN_MMC1_DAT0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT1 -> F5 */
       PIN_MMC1_DAT1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT2 -> J5 */
       PIN_MMC1_DAT2, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT3 -> H4 */
       PIN_MMC1_DAT3, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT4 -> E3 */
       PIN_MMC1_DAT4, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT5 -> G4 */
       PIN_MMC1_DAT5, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT6 -> F4 */
       PIN_MMC1_DAT6, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MMC1_eMMC -> MMC1_DAT7 -> G5 */
       PIN_MMC1_DAT7, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMmcsdPinCfg[] =
{
    {0, TRUE, gMmcsd0PinCfg},
    {1, TRUE, gMmcsd1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MMCSD) */

#if defined(BUILDCFG_MOD_DEBUGSS)

static pinmuxPerCfg_t gDebugss0PinCfg[] =
{
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDebugssPinCfg[] =
{
    {0, TRUE, gDebugss0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DEBUGSS) */

#if defined(BUILDCFG_MOD_GPMC)

static pinmuxPerCfg_t gGpmc0PinCfg[] =
{
    {
       /* NAND_FLASH -> GPMC_AD15 -> AA22 */
       PIN_GPMC_AD15, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD14 -> AB22 */
       PIN_GPMC_AD14, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD13 -> AB21 */
       PIN_GPMC_AD13, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD12 -> AA21 */
       PIN_GPMC_AD12, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD11 -> AD23 */
       PIN_GPMC_AD11, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD10 -> AA20 */
       PIN_GPMC_AD10, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD9 -> AB20 */
       PIN_GPMC_AD9, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD8 -> AE23 */
       PIN_GPMC_AD8, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD7 -> AD21 */
       PIN_GPMC_AD7, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD6 -> AC20 */
       PIN_GPMC_AD6, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD5 -> AE22 */
       PIN_GPMC_AD5, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD4 -> AE21 */
       PIN_GPMC_AD4, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD3 -> AD20 */
       PIN_GPMC_AD3, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD2 -> AD22 */
       PIN_GPMC_AD2, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD1 -> AE20 */
       PIN_GPMC_AD1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_AD0 -> AC21 */
       PIN_GPMC_AD0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_WAIT0 -> Y24 */
       PIN_GPMC_WAIT0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_BEn0_CLE -> AC24 */
       PIN_GPMC_BEN0_CLE, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_CSn0 -> AB25 */
       PIN_GPMC_CSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_WPn -> W25 */
       PIN_GPMC_WPN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_ADVn_ALE -> AC23 */
       PIN_GPMC_ADVN_ALE, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_OEn_REn -> AC22 */
       PIN_GPMC_OEN_REN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* NAND_FLASH -> GPMC_WEn -> Y22 */
       PIN_GPMC_WEN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gGpmcPinCfg[] =
{
    {0, TRUE, gGpmc0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_GPMC) */

#if defined(BUILDCFG_MOD_EMAC)

static pinmuxPerCfg_t gEmac0PinCfg[] =
{
    {
       /* ETHERNET -> RGMII_RXD1 -> C23 */
       PIN_MII_RXD1, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_RXD2 -> B23 */
       PIN_MII_RXD2, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_RXD3 -> F22 */
       PIN_MII_RXD3, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_RXD0 -> B24 */
       PIN_MII_RXD0, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXD0 -> G23 */
       PIN_MII_TXD0, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXD1 -> G24 */
       PIN_MII_TXD1, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXD2 -> G25 */
       PIN_MII_TXD2, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXD3 -> D25 */
       PIN_MII_TXD3, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXC -> C25 */
       PIN_MII_TXCLK, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_TXCTL -> H25 */
       PIN_MII_TXEN, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_RXC -> A22 */
       PIN_MII_RXCLK, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* ETHERNET -> RGMII_RXCTL -> A24 */
       PIN_MII_RXDV, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gEmacPinCfg[] =
{
    {0, TRUE, gEmac0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_EMAC) */

#if defined(BUILDCFG_MOD_CPSW)

static pinmuxPerCfg_t gCpsw0PinCfg[] =
{
    {
       /* MDIO -> MDIO_CLK -> U3 */
       PIN_MDIO_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MDIO -> MDIO_DATA -> V3 */
       PIN_MDIO_DATA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gCpswPinCfg[] =
{
    {0, TRUE, gCpsw0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_CPSW) */

#if defined(BUILDCFG_MOD_DDR)

static pinmuxPerCfg_t gDdr0PinCfg[] =
{
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gDdrPinCfg[] =
{
    {0, TRUE, gDdr0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_DDR) */

#if defined(BUILDCFG_MOD_MCSPI)

static pinmuxPerCfg_t gMcspi0PinCfg[] =
{
    {
       /* SPI0_SERIAL_HEADER -> SPI0_CLK -> M2 */
       PIN_SPI0_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0_SERIAL_HEADER -> SPI0_SOMI -> M1 */
       PIN_SPI0_SOMI, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0_SERIAL_HEADER -> SPI0_SIMO -> N4 */
       PIN_SPI0_SIMO, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0_SERIAL_HEADER -> SPI0_SCSn0 -> M3 */
       PIN_SPI0_SCSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI0_SERIAL_HEADER -> SPI0_SCSn1 -> M4 */
       PIN_SPI0_SCSN1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcspi1PinCfg[] =
{
    {
       /* SPI1_NOR_FLASH -> SPI1_CLK -> N2 */
       PIN_SPI1_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1_NOR_FLASH -> SPI1_SOMI -> N1 */
       PIN_SPI1_SOMI, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1_NOR_FLASH -> SPI1_SIMO -> P2 */
       PIN_SPI1_SIMO, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI1_NOR_FLASH -> SPI1_SCSn0 -> P1 */
       PIN_SPI1_SCSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcspi2PinCfg[] =
{
    {
       /* SPI2_AUDIO_HEADER -> SPI2_CLK -> R2 */
       PIN_SPI2_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI2_AUDIO_HEADER -> SPI2_SOMI -> R4 */
       PIN_SPI2_SOMI, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI2_AUDIO_HEADER -> SPI2_SIMO -> R3 */
       PIN_SPI2_SIMO, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI2_AUDIO_HEADER -> SPI2_SCSn0 -> P3 */
       PIN_SPI2_SCSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gMcspi3PinCfg[] =
{
    {
       /* SPI3 -> SPI3_CLK -> E24 */
       PIN_SPI3_CLK, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI3 -> SPI3_SOMI -> F25 */
       PIN_SPI3_SOMI, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI3 -> SPI3_SIMO -> F24 */
       PIN_SPI3_SIMO, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI3 -> SPI3_SCSn0 -> C24 */
       PIN_SPI3_SCSN0, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMcspiPinCfg[] =
{
    {0, TRUE, gMcspi0PinCfg},
    {1, TRUE, gMcspi1PinCfg},
    {2, TRUE, gMcspi2PinCfg},
    {3, TRUE, gMcspi3PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MCSPI) */

#if defined(BUILDCFG_MOD_USB)

static pinmuxPerCfg_t gUsb0PinCfg[] =
{
    {
       /* USB0_HOST -> USB0_DRVVBUS -> E19 */
       PIN_USB0_DRVVBUS, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gUsb1PinCfg[] =
{
    {
       /* USB1_DUAL_ROLE -> USB1_DRVVBUS -> B21 */
       PIN_USB1_DRVVBUS, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gUsbPinCfg[] =
{
    {0, TRUE, gUsb0PinCfg},
    {1, TRUE, gUsb1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_USB) */

#if defined(BUILDCFG_MOD_SYSTEM)

static pinmuxPerCfg_t gSystem0PinCfg[] =
{
    {
       /* SYSTEM -> CLKOUT -> H23 */
       PIN_QSPI_CSN1, 0, \
       ( \
           PIN_MODE(1) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> SYSCLKOUT -> M21 */
       PIN_SYSCLKOUT, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> LRESETn -> V2 */
       PIN_LRESETN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> LRESETNMIENn -> V1 */
       PIN_LRESETNMIENN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> RESETSTATn -> Y2 */
       PIN_RESETSTATN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> NMIn -> W1 */
       PIN_NMIN, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> BOOTCOMPLETE -> Y3 */
       PIN_BOOTCOMPLETE, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SYSTEM -> OBSPLL_LOCK -> N5 */
       PIN_OBSPLL_LOCK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gSystemPinCfg[] =
{
    {0, TRUE, gSystem0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_SYSTEM) */

#if defined(BUILDCFG_MOD_I2C)

static pinmuxPerCfg_t gI2c0PinCfg[] =
{
    {
       /* I2C0_BMC_&_HEADER -> I2C0_SCL -> U5 */
       PIN_I2C0_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C0_BMC_&_HEADER -> I2C0_SDA -> W5 */
       PIN_I2C0_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gI2c2PinCfg[] =
{
    {
       /* I2C2_PMIC -> I2C2_SCL -> V5 */
       PIN_I2C2_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C2_PMIC -> I2C2_SDA -> V4 */
       PIN_I2C2_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxPerCfg_t gI2c1PinCfg[] =
{
    {
       /* I2C1_PERIPH -> I2C1_SCL -> V6 */
       PIN_I2C1_SCL, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {
       /* I2C1_PERIPH -> I2C1_SDA -> W4 */
       PIN_I2C1_SDA, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_TYPE_SEL) & (~PIN_PULL_UD_EN)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gI2cPinCfg[] =
{
    {0, TRUE, gI2c0PinCfg},
    {2, TRUE, gI2c2PinCfg},
    {1, TRUE, gI2c1PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_I2C) */

#if defined(BUILDCFG_MOD_QSPI)

static pinmuxPerCfg_t gQspi0PinCfg[] =
{
    {
       /* SPI_FLASH -> QSPI_CLK -> K25 */
       PIN_QSPI_CLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_RCLK -> K24 */
       PIN_QSPI_RCLK, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_CSn0 -> J25 */
       PIN_QSPI_CSN0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_D0 -> J23 */
       PIN_QSPI_D0, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_D1 -> J22 */
       PIN_QSPI_D1, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_D2 -> J21 */
       PIN_QSPI_D2, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* SPI_FLASH -> QSPI_D3 -> J24 */
       PIN_QSPI_D3, 0, \
       ( \
           PIN_MODE(0) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gQspiPinCfg[] =
{
    {0, TRUE, gQspi0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_QSPI) */

#if defined(BUILDCFG_MOD_MLB)

static pinmuxPerCfg_t gMlb0PinCfg[] =
{
    {
       /* MLB -> MLB_CLK -> AA24 */
       PIN_GPMC_WAIT1, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MLB -> MLB_DAT -> W24 */
       PIN_GPMC_CSN1, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {
       /* MLB -> MLB_SIG -> AA25 */
       PIN_GPMC_DIR, 0, \
       ( \
           PIN_MODE(2) | \
           ((PIN_PULL_UD_EN) & (~PIN_PULL_TYPE_SEL)) \
       ) \
    },
    {PINMUX_INVALID_PIN}
};

static pinmuxModuleCfg_t gMlbPinCfg[] =
{
    {0, TRUE, gMlb0PinCfg},
    {CHIPDB_INVALID_INSTANCE_NUM}
};

#endif /* if defined(BUILDCFG_MOD_MLB) */



pinmuxBoardCfg_t gK2G0xPinmuxData[] =
{
#if defined(BUILDCFG_MOD_CPTS)
    {CHIPDB_MOD_ID_CPTS, gCptsPinCfg},
#endif /* if defined(BUILDCFG_MOD_CPTS) */
#if defined(BUILDCFG_MOD_PWMSS)
    {CHIPDB_MOD_ID_PWMSS, gPwmssPinCfg},
#endif /* if defined(BUILDCFG_MOD_PWMSS) */
#if defined(BUILDCFG_MOD_MCASP)
    {CHIPDB_MOD_ID_MCASP, gMcaspPinCfg},
#endif /* if defined(BUILDCFG_MOD_MCASP) */
#if defined(BUILDCFG_MOD_DSS)
    {CHIPDB_MOD_ID_DSS, gDssPinCfg},
#endif /* if defined(BUILDCFG_MOD_DSS) */
#if defined(BUILDCFG_MOD_TIMER)
    {CHIPDB_MOD_ID_TIMER, gTimerPinCfg},
#endif /* if defined(BUILDCFG_MOD_TIMER) */
#if defined(BUILDCFG_MOD_DCAN)
    {CHIPDB_MOD_ID_DCAN, gDcanPinCfg},
#endif /* if defined(BUILDCFG_MOD_DCAN) */
#if defined(BUILDCFG_MOD_GPIO)
    {CHIPDB_MOD_ID_GPIO, gGpioPinCfg},
#endif /* if defined(BUILDCFG_MOD_GPIO) */
#if defined(BUILDCFG_MOD_MCBSP)
    {CHIPDB_MOD_ID_MCBSP, gMcbspPinCfg},
#endif /* if defined(BUILDCFG_MOD_MCBSP) */
#if defined(BUILDCFG_MOD_UART)
    {CHIPDB_MOD_ID_UART, gUartPinCfg},
#endif /* if defined(BUILDCFG_MOD_UART) */
#if defined(BUILDCFG_MOD_PCIE)
    {CHIPDB_MOD_ID_PCIE, gPciePinCfg},
#endif /* if defined(BUILDCFG_MOD_PCIE) */
#if defined(BUILDCFG_MOD_MMCSD)
    {CHIPDB_MOD_ID_MMCSD, gMmcsdPinCfg},
#endif /* if defined(BUILDCFG_MOD_MMCSD) */
#if defined(BUILDCFG_MOD_DEBUGSS)
    {CHIPDB_MOD_ID_DEBUGSS, gDebugssPinCfg},
#endif /* if defined(BUILDCFG_MOD_DEBUGSS) */
#if defined(BUILDCFG_MOD_GPMC)
    {CHIPDB_MOD_ID_GPMC, gGpmcPinCfg},
#endif /* if defined(BUILDCFG_MOD_GPMC) */
#if defined(BUILDCFG_MOD_EMAC)
    {CHIPDB_MOD_ID_EMAC, gEmacPinCfg},
#endif /* if defined(BUILDCFG_MOD_EMAC) */
#if defined(BUILDCFG_MOD_CPSW)
    {CHIPDB_MOD_ID_CPSW, gCpswPinCfg},
#endif /* if defined(BUILDCFG_MOD_CPSW) */
#if defined(BUILDCFG_MOD_DDR)
    {CHIPDB_MOD_ID_DDR, gDdrPinCfg},
#endif /* if defined(BUILDCFG_MOD_DDR) */
#if defined(BUILDCFG_MOD_MCSPI)
    {CHIPDB_MOD_ID_MCSPI, gMcspiPinCfg},
#endif /* if defined(BUILDCFG_MOD_MCSPI) */
#if defined(BUILDCFG_MOD_USB)
    {CHIPDB_MOD_ID_USB, gUsbPinCfg},
#endif /* if defined(BUILDCFG_MOD_USB) */
#if defined(BUILDCFG_MOD_SYSTEM)
    {CHIPDB_MOD_ID_SYSTEM, gSystemPinCfg},
#endif /* if defined(BUILDCFG_MOD_SYSTEM) */
#if defined(BUILDCFG_MOD_I2C)
    {CHIPDB_MOD_ID_I2C, gI2cPinCfg},
#endif /* if defined(BUILDCFG_MOD_I2C) */
#if defined(BUILDCFG_MOD_QSPI)
    {CHIPDB_MOD_ID_QSPI, gQspiPinCfg},
#endif /* if defined(BUILDCFG_MOD_QSPI) */
#if defined(BUILDCFG_MOD_MLB)
    {CHIPDB_MOD_ID_MLB, gMlbPinCfg},
#endif /* if defined(BUILDCFG_MOD_MLB) */
    {CHIPDB_MOD_ID_INVALID}
};
